
<?php $__env->startSection('content'); ?>
<header class="g-header md:pb-32">
    <div class="container">

        <div class="border-b border-gray-700">
            <div class="flex items-center justify-between h-16 px-4 sm:px-0">
                <div class="flex items-center">
                    <div class="flex-shrink-0">
                        <a href="javascript:void(0)" style="text-decoration: none;" class="font-light block text-center text-white text-2xl">Klyre<span class="font-bold">Payments</span></a>
                    </div>
                    <div class="hidden md:block">
                        <div class="ml-10 flex items-baseline space-x-4">
                            <nav>
                                <ul class="mainmenu">
                                    <li>
                                        <a href="javascript:void(0)" class="menuitem"style="text-decoration: none;">Dashboard</a>
                                    </li>
                                    <li>
                                        <a href="<?php echo e(route('dashboard')); ?>" class="menuitem"style="text-decoration: none;">EDI Files</a>
                                    </li>
                                    
                                </ul>
                            </nav>
                        </div>
                    </div>
                </div>
                <?php echo $__env->make('message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="hidden md:block text-right">
                    <div class="flex divide-x divide-gray-500">
                        <div class="text-white text-right text-sm ml-auto pr-6">
                            <p id="clock" class="font-medium">Thu, Sep 19 2024, 05:17:34</p>
                            <p class="text-gray-400 text-xs">New York</p>
                        </div>
                        <div class="text-sm pl-6">
                            <p class="text-white font-medium">Super User</p>
                            <form method="POST" action="<?php echo e(route('logout')); ?>">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="text-gray-400 text-xs hover:underline hover:text-white focus:text-white focus:ring-offset-2">Log out</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
    document.addEventListener('DOMContentLoaded', function () {
    var dropdownItems = document.querySelectorAll('.menu-item-has-children');
    var dropdowns = document.querySelectorAll('.menu-item-has-children .mainmenu-sub-menu');
    var delay = 2000;
    if (dropdownItems) {
    dropdownItems.forEach((dropdownItem, count) => {
    dropdownItem.addEventListener('mouseenter', function (e) {
    dropdowns[count].classList.add('dropdown-show');
    });
    dropdownItem.addEventListener('mouseleave', function () {
    dropdowns[count].classList.remove('dropdown-show');
    });
    });
    }
    })
    </script>
    <div class="container btn-container">
        
        <div class="md:py-10 py-5 md:flex md:items-end md:justify-between w-full">
                <h1 class="text-3xl font-bold md:text-white">Details</h1>
                <div class="flex flex-wrap items-center gap-1">
                    
                   
                    
                
                    
                    <?php if($file->status == "P"): ?>
                    <a href="<?php echo e(route('generate.sftp.999', $file->id)); ?>"
                        class=" btn text-white bg-indigo-600 hover:bg-indigo-700 ">
                        Generate 999
                    </a>
                    <?php elseif($file->status == "G"): ?>
                    <a href="<?php echo e(route('send.sftp.999', $file->id)); ?>"
                        class=" btn text-white bg-indigo-600 hover:bg-indigo-700 ">
                        Send 999 Ack
                    </a>
                    <?php endif; ?>
                    <?php if($file->file_string): ?>
                    <a href="<?php echo e(route('downlode.sftp.file', $file->id)); ?>"
                        class=" btn text-white bg-indigo-600 hover:bg-indigo-700 ">
                        Download <?php echo e($file->file_type == "837" ? '837 - Claims' : '275 - Attachments'); ?>

                    </a>
                    <?php endif; ?>
                    <?php if($file->ack_file_string): ?>
                    <a href="<?php echo e(route('downlode.ack.file', $file->id)); ?>"
                        class=" btn text-white bg-indigo-600 hover:bg-indigo-700 ">
                        Download Ack
                    </a>
                    <?php endif; ?>
                </div>
        </div>
    </div>
</header>
<div class="flex gap-2">  </div>

<main class="md:-mt-32 mt-5">
    <div class="container">
        
        <form id="myform" name="myform" method="POST">
            <div class="md:flex items-start space-x-6 mb-6">
                <!-- Left Column - Patient/Subscriber Information -->
                <div class="bg-white w-1/2 shadow overflow-hidden sm:rounded-lg">
                    <div class="px-4 py-5 sm:px-6 border-b">
                        <div class="md:flex justify-between">
                            <div>
                                <h3 class="text-lg leading-6 font-medium text-gray-900">Patient Information</h3>
                                
                            </div>
                        </div>
                    </div>
                    
                    <div>
                        
                        <div id="tab-primary" class="g-tab-content2 current">
                            <?php if(isset($data['subscriber'])): ?>
                            <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Subscriber Name</label>
                                <span class="w-3/4">
                                    <?php echo e($data['subscriber']['last_name'] ?? ''); ?>,
                                    <?php echo e($data['subscriber']['first_name'] ?? ''); ?>

                                </span>
                            </div>
                            <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Member ID</label>
                                <span class="w-3/4"><?php echo e($data['subscriber']['member_id'] ?? 'N/A'); ?></span>
                            </div>
                            <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Address</label>
                                <span class="w-3/4">
                                    <?php echo e($data['subscriber']['address']['street'] ?? 'N/A'); ?><br>
                                    <?php if(isset($data['subscriber']['address']['street2'])): ?>
                                    <?php echo e($data['subscriber']['address']['street2']); ?><br>
                                    <?php endif; ?>
                                    <?php echo e($data['subscriber']['location']['city'] ?? ''); ?>,
                                    <?php echo e($data['subscriber']['location']['state'] ?? ''); ?>

                                    <?php echo e($data['subscriber']['location']['zip'] ?? ''); ?>

                                </span>
                            </div>
                            <?php else: ?>
                            <div class="p-4 text-center text-gray-500">No subscriber data available</div>
                            <?php endif; ?>
                            
                            <?php if(isset($data['patient'])): ?>
                            <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Patient Name</label>
                                <span class="w-3/4">
                                    <?php echo e($data['patient']['last_name'] ?? ''); ?>,
                                    <?php echo e($data['patient']['first_name'] ?? ''); ?>

                                </span>
                            </div>
                            <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Patient ID</label>
                                <span class="w-3/4"><?php echo e($data['patient']['member_id'] ?? 'N/A'); ?></span>
                            </div>
                            <?php endif; ?>
                        </div>
                        
                    </div>
                </div>
                
                <!-- Right Column - Transmission & System Info -->
                <div class="w-1/2">
                    <div class="bg-white shadow overflow-hidden sm:rounded-lg">
                        <div class="px-4 py-5 sm:px-6 border-b">
                            <div class="md:flex justify-between">
                                <div>
                                    <h3 class="text-lg leading-6 font-medium text-gray-900">Transmission Details</h3>
                                    
                                </div>
                            </div>
                        </div>
                        
                        <div class="pt-3 border-b">
                            
                            
                            <div id="tab-1" class="g-tab-content current">
                                <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Transaction Set ID</label>
                                    <span class="w-3/4"><?php echo e($data['st']['transaction_set_id'] ?? 'N/A'); ?></span>
                                </div>
                                <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Functional ID Code</label>
                                    <span class="w-3/4"><?php echo e($data['gs']['functional_id_code'] ?? 'N/A'); ?></span>
                                </div>
                                <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Control Number</label>
                                    <span class="w-3/4"><?php echo e($data['st']['control_number'] ?? 'N/A'); ?></span>
                                </div>
                                <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Segment Count</label>
                                    <span class="w-3/4"><?php echo e($data['se']['segment_count'] ?? 'N/A'); ?></span>
                                </div>
                            </div>
                            
                        </div>
                    </div>
                </div>
            </div>
        </form>
        
        <form id="myform" name="myform" method="POST">
            <div class="md:flex items-start space-x-6 mb-6">
                <!-- Left Column - Patient/Subscriber Information -->
                <div class="bg-white w-1/2 shadow overflow-hidden sm:rounded-lg">
                    <div class="px-4 py-5 sm:px-6 border-b">
                        <div class="md:flex justify-between">
                            <div>
                                <h3 class="text-lg leading-6 font-medium text-gray-900">Interchange Info</h3>
                                
                            </div>
                        </div>
                    </div>
                    
                    <div>
                        
                        
                        <div id="tab-primary" class="g-tab-content2 current">
                            <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Sender ID</label>
                                <span class="w-3/4"><?php echo e($data['isa']['sender_id'] ?? 'N/A'); ?></span>
                            </div>
                            <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Receiver ID</label>
                                <span class="w-3/4"><?php echo e($data['isa']['receiver_id'] ?? 'N/A'); ?></span>
                            </div>
                            <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Transmission Date</label>
                                <span class="w-3/4">
                                    <?php if(isset($data['isa']['transmission_date'])): ?>
                                    <?php echo e(substr($data['isa']['transmission_date'], 0, 2)); ?>/<?php echo e(substr($data['isa']['transmission_date'], 2, 2)); ?>/<?php echo e(substr($data['isa']['transmission_date'], 4, 2)); ?>

                                    <?php else: ?>
                                    N/A
                                    <?php endif; ?>
                                </span>
                            </div>
                            <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Transmission Time</label>
                                <span class="w-3/4">
                                    <?php if(isset($data['isa']['transmission_time'])): ?>
                                    <?php echo e(substr($data['isa']['transmission_time'], 0, 2)); ?>:<?php echo e(substr($data['isa']['transmission_time'], 2, 2)); ?>

                                    <?php else: ?>
                                    N/A
                                    <?php endif; ?>
                                </span>
                            </div>
                            <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Interchange Control #</label>
                                <span class="w-3/4"><?php echo e($data['isa']['control_number'] ?? 'N/A'); ?></span>
                            </div>
                        </div>
                        
                    </div>
                </div>
                
                <!-- Right Column - Transmission & System Info -->
                <div class="w-1/2">
                    <div class="bg-white shadow overflow-hidden sm:rounded-lg">
                        <div class="px-4 py-5 sm:px-6 border-b">
                            <div class="md:flex justify-between">
                                <div>
                                    <h3 class="text-lg leading-6 font-medium text-gray-900">Functional Group Info</h3>
                                    
                                </div>
                            </div>
                        </div>
                        
                        <div class="pt-3 border-b">
                            
                            
                            <div id="tab-1" class="g-tab-content current">
                                <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Functional Group Code</label>
                                    <span class="w-3/4"><?php echo e($data['gs']['functional_id_code'] ?? 'N/A'); ?></span>
                                </div>
                                <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">GS Date</label>
                                    <span class="w-3/4">
                                        <?php if(isset($data['gs']['date'])): ?>
                                        <?php echo e(substr($data['gs']['date'], 0, 4)); ?>-<?php echo e(substr($data['gs']['date'], 4, 2)); ?>-<?php echo e(substr($data['gs']['date'], 6, 2)); ?>

                                        <?php else: ?>
                                        N/A
                                        <?php endif; ?>
                                    </span>
                                </div>
                                <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">GS Time</label>
                                    <span class="w-3/4">
                                        <?php if(isset($data['gs']['time'])): ?>
                                        <?php echo e(substr($data['gs']['time'], 0, 2)); ?>:<?php echo e(substr($data['gs']['time'], 2, 2)); ?>:<?php echo e(substr($data['gs']['time'], 4, 2)); ?>

                                        <?php else: ?>
                                        N/A
                                        <?php endif; ?>
                                    </span>
                                </div>
                                <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Responsible Agency</label>
                                    <span class="w-3/4"><?php echo e($data['gs']['responsible_agency'] ?? 'N/A'); ?></span>
                                </div>
                                <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Version/Release</label>
                                    <span class="w-3/4"><?php echo e($data['gs']['version'] ?? 'N/A'); ?></span>
                                </div>
                                <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Transaction Sets</label>
                                    <span class="w-3/4"><?php echo e($data['ge']['number_of_transaction_sets'] ?? 'N/A'); ?></span>
                                </div>
                            </div>
                            
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</main>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
window.onload = displayClock();
function displayClock() {
const currentDate = new Date(new Date().toLocaleString("en-US", {
timeZone: "America/New_York"
}));
var timestamp = currentDate.toString().split('GMT');
var splitstring = timestamp[0].split(" ");
var final_string = splitstring[0] + ', ' + splitstring[1] + ' ' + splitstring[2] + ' ' + splitstring[3] +
', ' + splitstring[4];
$("#clock").text(final_string);
setTimeout(displayClock, 1000);
}
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/klyretmp/public_html/edi/resources/views/sftp/view_sftp_275_file_data.blade.php ENDPATH**/ ?>