

<?php $__env->startSection('content'); ?>
<style>
.btn.text-white {
padding: 4px 14px;
font-size: 13px;
font-weight: 600;
border-radius: 6px;
line-height: 1.5;
display: inline-block;
text-align: center;
white-space: nowrap;
vertical-align: middle;
transition: background-color 0.2s ease-in-out;
background-color: rgb(79 70 229);
}
.form-group{
margin-bottom: 20px;
}

.step { display: none; }
.active { display: block; }
.next, .prev {
padding: 6px 16px;       /* good horizontal and vertical padding */
font-size: 14px;
border-radius: 6px;
border: none;
cursor: pointer;
width: auto;
height: auto;
display: inline-block;
text-align: center;
line-height: normal;
background-color: #0d6efd;  /* for .next */
color: white;
margin-right: 10px;
margin-bottom: 10px;
margin-top: 10px;
}
.prev {
background-color: orange;
}
#multiStepForm {
width: 50%;
background: white;
padding: 20px;
margin: 50px auto;
border-radius: 10px;
box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
}
/*  .step {
display: none;
}
.active {
display: block;
}*/
.step {
display: none;
}
.step.active {
display: flex; /* or block, but flex works better for columns */
flex-wrap: wrap;
}
h2 {
color: #333;
}
input {
width: 30%;
padding: 10px;
/*margin: 10px 0;*/
border: 1px solid #ccc;
border-radius: 5px;
font-size: 16px;
}
button {
background-color: #007bff;
color: white;
border: none;
padding: 10px 15px;
font-size: 16px;
cursor: pointer;
border-radius: 5px;
transition: 0.3s;
}
button:hover {
background-color: #0056b3;
}
.prev {
background-color: #6c757d;
}
.prev:hover {
background-color: #5a6268;
}
.submit {
background-color: #28a745;
}
.submit:hover {
background-color: #218838;
}
.form-control{
width: 30%;
}
.g-header{
padding-bottom: 0 !important;
}
.btn-container>div{
padding: 2.5rem 0 !important;
}
.mb-n10{
margin-bottom: -10px!important;
}
.mainmenu{
margin-bottom: 0!important;
}
.g-header .divide-x{
align-items: center;
}
.g-header  .divide-x p{
margin-bottom: 0;
}
.g-header .divide-x button{
padding: 0!important;
}
.fa-solid.fa-xmark{
    display: none;
}
</style>
<style>
input:read-only {
    background-color: #f5f5f5;  /* Light grey background */
    color: #555;               /* Text color */
    border: 1px solid #ccc;    /* Optional: border style */
    cursor: not-allowed;       /* Optional: indicate it's non-editable */
}
</style>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<?php echo $__env->make('message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<div class="container">
    
    <form method="POST" action="<?php echo e(route('multiple.edip.generate.new')); ?>">
        <?php echo csrf_field(); ?>
        <!-- Transmission Information (Single Instance) -->
        <div class="card mb-4 mt-4">
            <div class="card-header bg-primary text-white">Transmission Information</div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="sender_id">Sender ID</label>
                            <input type="text" class="form-control" id="sender_id" name="sender_id" value="<?php echo e(old('sender_id', '581651222')); ?>" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="receiver_id">Receiver ID</label>
                            <input type="text" class="form-control" id="receiver_id" name="receiver_id" value="<?php echo e(old('receiver_id', 'REC789101')); ?>" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="control_number">Control Number</label>
                            <input type="text" class="form-control" id="control_number" name="control_number" value="<?php echo e(old('control_number', '123500377')); ?>" required>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="sender_code">Sender Code</label>
                            <input type="text" class="form-control" id="sender_code" name="sender_code" value="<?php echo e(old('sender_code', 'SENDER123')); ?>" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="receiver_code">Receiver Code</label>
                            <input type="text" class="form-control" id="receiver_code" name="receiver_code" value="<?php echo e(old('receiver_code', 'RECEIVER456')); ?>" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="submitter_id">Submitter ID</label>
                            <input type="text" class="form-control" id="submitter_id" name="submitter_id" value="<?php echo e(old('submitter_id', 'SUB123456')); ?>" required>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="submitter_name">Submitter Name</label>
                            <input type="text" class="form-control" id="submitter_name" name="submitter_name" value="<?php echo e(old('submitter_name', 'ABC Health')); ?>" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="submitter_contact">Submitter contact</label>
                            <input type="text" class="form-control" id="submitter_contact" name="submitter_contact" value="<?php echo e(old('submitter_contact', 'BILLING DEPARTMENT')); ?>" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="submitter_phone">Submitter phone</label>
                            <input type="text" class="form-control" id="submitter_phone" name="submitter_phone" value="<?php echo e(old('submitter_phone', '8005551234')); ?>" pattern="[0-9]{10}" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="receiver_name">Receiver Name</label>
                            <input type="text" class="form-control" id="receiver_name" name="receiver_name" value="<?php echo e(old('receiver_name', 'XYZ Payer')); ?>" required>
                        </div>
                    </div>
                </div>
            </div>
        </div>







<?php if(@Auth::user()->user_type=="A"): ?>

        <!-- Provider Information (Single Instance) -->
        <div class="card mb-4">
            <div class="card-header bg-primary text-white">Provider Information</div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="provider_name">Provider Name</label>
                            <input type="text" class="form-control" id="provider_name" name="provider_name" value="<?php echo e(old('provider_name', 'ABC Healthcare')); ?>" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="provider_npi">Provider NPI</label>
                            <input type="text" class="form-control" id="provider_npi" name="provider_npi" value="<?php echo e(old('provider_npi', '1234567890')); ?>" required>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="provider_tax_id">Provider Tax ID</label>
                            <input type="text" class="form-control" id="provider_tax_id" name="provider_tax_id" value="<?php echo e(old('provider_tax_id', '123456789')); ?>" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="facility_npi">Facility NPI</label>
                            <input type="text" class="form-control" id="facility_npi" name="facility_npi" value="<?php echo e(old('facility_npi', '1234567890')); ?>" required>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="facility_name">Facility Name</label>
                            <input type="text" class="form-control" id="facility_name" name="facility_name" value="<?php echo e(old('facility_name', 'ABC Healthcare Center')); ?>" required>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                   
                        <h5>Provider Address</h5>
                   
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="provider_street">Street</label>
                            <input type="text" class="form-control" id="provider_street" name="provider_street" value="<?php echo e(old('provider_street', '123 Main St')); ?>" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="provider_city">City</label>
                            <input type="text" class="form-control" id="provider_city" name="provider_city" value="<?php echo e(old('provider_city', 'New York')); ?>" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="provider_state">State</label>
                            <input type="text" class="form-control" id="provider_state" name="provider_state" value="<?php echo e(old('provider_state', 'NY')); ?>" required>
                        </div>
                    </div>
                    <div class="col-md-1">
                        <div class="form-group">
                            <label for="provider_zip">ZIP</label>
                            <input type="text" class="form-control" id="provider_zip" name="provider_zip" value="<?php echo e(old('provider_zip', '100010000')); ?>" required>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php else: ?>
         <div class="card mb-4">
            <div class="card-header bg-primary text-white">Provider Information</div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="provider_name">Provider Name</label>
                            <input type="text" class="form-control" id="provider_name" name="provider_name" value="<?php echo e(@Auth::user()->providerDetails->provider_clinic_name); ?>" required readonly>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="provider_npi">Provider NPI</label>
                            <input type="text" class="form-control" id="provider_npi" name="provider_npi" value="<?php echo e(@Auth::user()->providerDetails->npi); ?>"  required readonly>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="provider_tax_id">Provider Tax ID</label>
                            <input type="text" class="form-control" id="provider_tax_id" name="provider_tax_id" value="<?php echo e(@Auth::user()->providerDetails->tax_id); ?>"  required readonly>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="facility_npi">Facility NPI</label>
                            <input type="text" class="form-control" id="facility_npi" name="facility_npi" value="<?php echo e(@Auth::user()->providerDetails->f_npi); ?>" required >
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="facility_name">Facility Name</label>
                            <input type="text" class="form-control" id="facility_name" name="facility_name" value="<?php echo e(@Auth::user()->providerDetails->f_name); ?>" required >
                        </div>
                    </div>
                </div>
                
                <div class="row">
                   
                        <h5>Provider Address</h5>
                   
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="provider_street">Street</label>
                            <input type="text" class="form-control" id="provider_street" name="provider_street" value="<?php echo e(@Auth::user()->providerDetails->service_street); ?>" required readonly>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="provider_city">City</label>
                            <input type="text" class="form-control" id="provider_city" name="provider_city" value="<?php echo e(@Auth::user()->providerDetails->service_city); ?>" required readonly>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="provider_state">State</label>
                            <input type="text" class="form-control" id="provider_state" name="provider_state" value="<?php echo e(@Auth::user()->providerDetails->service_state); ?>" required readonly>
                        </div>
                    </div>
                    <div class="col-md-1">
                        <div class="form-group">
                            <label for="provider_zip">ZIP</label>
                            <input type="text" class="form-control" id="provider_zip" name="provider_zip" value="<?php echo e(@Auth::user()->providerDetails->service_zip_code); ?>" required readonly>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php endif; ?>
        <!-- Subscriber Information (Single Instance) -->
        
        <!-- Payer Information (Single Instance) -->
        <div class="card mb-4">
            <div class="card-header bg-primary text-white">Payer Information</div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="payer_name">Payer Name</label>
                            <input type="text" class="form-control" id="payer_name" name="payer_name" value="<?php echo e(old('payer_name', 'ABC Insurance')); ?>" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="payer_id">Payer ID</label>
                            <input type="text" class="form-control" id="payer_id" name="payer_id" value="<?php echo e(old('payer_id', '987654')); ?>" required>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    
                        <h5>Payer Address</h5>
                    
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="payer_street">Street</label>
                            <input type="text" class="form-control" id="payer_street" name="payer_street" value="<?php echo e(old('payer_street', '789 Main St')); ?>" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="payer_city">City</label>
                            <input type="text" class="form-control" id="payer_city" name="payer_city" value="<?php echo e(old('payer_city', 'New York')); ?>" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="payer_state">State</label>
                            <input type="text" class="form-control" id="payer_state" name="payer_state" value="<?php echo e(old('payer_state', 'NY')); ?>" required>
                        </div>
                    </div>
                    <div class="col-md-1">
                        <div class="form-group">
                            <label for="payer_zip">ZIP</label>
                            <input type="text" class="form-control" id="payer_zip" name="payer_zip" value="<?php echo e(old('payer_zip', '100019999')); ?>" required>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <input type="hidden" name="claimType" value="<?php echo e($claim_type); ?>">






















        <!-- Claims Section (Repeatable) -->
        <div id="claims-container">
            <div class="card mb-4 claim-section">
                <div class="card-header bg-info text-white d-flex justify-content-between align-items-center">
                    <span>Claim #1</span>
                    <button type="button" class="btn btn-danger btn-sm remove-claim" data-claim-index="0">Remove</button>
                </div>
                <div class="card-body">
                    <!-- PATIENT/SUBSCRIBER INFO PER CLAIM -->
                    <div class="card mb-3">
                        <div class="card-header">Patient/Subscriber Information</div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Last Name</label>
                                        <input type="text" class="form-control" name="claims[0][subscriber_last_name]" value="Doe" required>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>First Name</label>
                                        <input type="text" class="form-control" name="claims[0][subscriber_first_name]" value="John" required>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Member ID</label>
                                        <input type="text" class="form-control" name="claims[0][member_id]" value="123456789" required>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Date of Birth</label>
                                        <input type="date" class="form-control" name="claims[0][subscriber_dob]" value="1985-01-15" required>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Gender</label>
                                        <select class="form-control" name="claims[0][subscriber_gender]" required>
                                            <option value="M" selected>Male</option>
                                            <option value="F">Female</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                
                                    <h5>Patient Address</h5>
                                
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Street</label>
                                        <input type="text" class="form-control" name="claims[0][subscriber_street]" value="456 Elm Street" required>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>City</label>
                                        <input type="text" class="form-control" name="claims[0][subscriber_city]" value="Los Angeles" required>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>State</label>
                                        <input type="text" class="form-control" name="claims[0][subscriber_state]" value="CA" required>
                                    </div>
                                </div>
                                <div class="col-md-1">
                                    <div class="form-group">
                                        <label>ZIP</label>
                                        <input type="text" class="form-control" name="claims[0][subscriber_zip]" value="900019999" required>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Group Number</label>
                                        <input type="text" class="form-control" name="claims[0][group_number]" value="GROUP1" required>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Insurance Type</label>
                                        <select class="form-control" name="claims[0][insurance_type]" required>
                                            <option value="MC">Medicare</option>
                                            <option value="CI"  <?php if($claim_type == '12'): ?> selected <?php endif; ?>>Commercial</option>
                                            <option value="BL">Blue Cross</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

















                    
                    <br>
                    <br>

                     <!-- CLAIM TYPE SPECIFIC FIELDS -->
    <?php if($claim_type == '12'): ?> <!-- Commercial Insurance -->
    <div class="card mb-3">
        <div class="card-header">Commercial Insurance Details</div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Employer Name</label>
                        <input type="text" class="form-control" name="claims[0][employer_name]" value="Default Employer Inc.">
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="form-group">
                        <label>Employer Id</label>
                        <input type="text" class="form-control" name="claims[0][employer_id]" value="EMP12345">
                    </div>
                </div>

            </div>
        </div>
    </div>
    <?php elseif($claim_type == 'EN0'): ?> <!-- Encounter -->
    <div class="card mb-3">
        <div class="card-header">Encounter Details</div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Encounter ID</label>
                        <input type="text" class="form-control" name="claims[0][encounter_id]" value="ENC123456" required>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Reference Identification Qualifier</label>
                        <input type="text" class="form-control" name="claims[0][capitation_indicator]" value="ENC123456" required>
                        
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php elseif($claim_type == 'A1'): ?> <!-- COB (Primary) -->
    <div class="card mb-3">
        <div class="card-header">Coordination of Benefits (Primary)</div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Other Insurance Policy Number</label>
                        <input type="text" class="form-control" name="claims[0][other_insurance_policy]" required value="POL987654">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Other Insurance Group Number</label>
                        <input type="text" class="form-control" name="claims[0][other_insurance_group]" required value="GRP123">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Other Payer Name</label>
                        <input type="text" value="XYZ Insurance" class="form-control" required name="claims[0][other_payer_name]">
                    </div>
                </div>
                <div class="col-md-4" style="display:none">
                    <div class="form-group">
                        <label>Other Payer Paid Amount</label>
                        <input type="text" class="form-control" value="100.00" required name="claims[0][other_payer_paid_amount]">
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php elseif($claim_type == 'A2'): ?> <!-- Medicare Secondary -->
    <div class="card mb-3">
        <div class="card-header">Medicare Secondary Payer Details</div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Medicare Beneficiary Identifier</label>
                        <input type="text" class="form-control" value="MBI1234567" name="claims[0][medicare_id]" required>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>MSP Type Code</label>
                        <select class="form-control" name="claims[0][msp_type_code]">
                            <option value="12" selected>Working Aged</option>
                            <option value="13">ESRD</option>
                        </select>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php elseif($claim_type == 'A3'): ?> <!-- Ambulance -->
    <div class="card mb-3">
        <div class="card-header">Ambulance Transport Details</div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Transport Reason Code</label>
                        <select class="form-control" name="claims[0][transport_reason]" required>
                            <option value="A" selected>Emergency</option>
                            <option value="B">Non-Emergency</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Pickup ZIP Code</label>
                        <input type="text" class="form-control" value="12345" name="claims[0][pickup_zip]" required>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Mileage</label>
                        <input type="number" value="15.5" class="form-control" required name="claims[0][mileage]">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Pickup Address</label>
                        <input type="text" value="123 Main St" class="form-control" name="claims[0][pickup_address]" required>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Dropoff Address</label>
                        <input type="text" value="456 Hospital Rd" required class="form-control" name="claims[0][dropoff_address]">
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php elseif($claim_type == 'CH'): ?> <!-- Chiropractic -->
    <div class="card mb-3">
        <div class="card-header">Chiropractic Details</div>
        <div class="card-body">
            <div class="row">
               <div class="col-md-4">
                    <div class="form-group">
                        <label>Spinal Region</label>
                        <select class="form-control" name="claims[0][spinal_region]">
                            <option value="A">All Regions</option>
                            <option value="C" selected>Cervical</option>
                            <option value="D">Dorsal (Thoracic)</option>
                            <option value="E">Lumbar</option>
                            <option value="F">Sacroiliac</option>
                            <option value="G">Coccygeal</option>
                            <option value="M">Multiple Regions</option>
                        </select>
                    </div>
                </div>

                <div class="col-md-4" style="display:none">
                    <div class="form-group">
                        <label>Number of Adjustments</label>
                        <input type="number" required value="3" class="form-control" name="claims[0][adjustment_count]">
                    </div>
                </div>
            </div>
        </div>
    </div>




<?php elseif($claim_type == 'O2'): ?> <!-- Oxygen -->
<div class="card mb-3">
    <div class="card-header">Oxygen Therapy Details</div>
    <div class="card-body">
        <div class="row">

            <!-- Oxygen Details -->
            <div class="col-md-4" style="display:none">
                <div class="form-group">
                    <label>Oxygen Flow Rate (L/min)</label>
                    <input type="number" step="0.1" value="<?php echo e(old('claims.0.flow_rate', '2.5')); ?>" class="form-control" name="claims[0][flow_rate]" required>
                </div>
            </div>
            <div class="col-md-4" style="display:none">
                <div class="form-group">
                    <label>Therapy Duration (Hours/Day)</label>
                    <input type="number" value="<?php echo e(old('claims.0.therapy_duration', '8')); ?>" class="form-control" name="claims[0][therapy_duration]" required>
                </div>
            </div>

            <!-- Certification Dates -->
            <div class="col-md-4">
                <div class="form-group">
                    <label>Certification Start Date</label>
                    <input type="date" value="<?php echo e(old('claims.0.certification_start_date', '2024-01-01')); ?>" class="form-control" name="claims[0][certification_start_date]" required>
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label>Recertification Date</label>
                    <input type="date" value="<?php echo e(old('claims.0.recertification_date', '2025-01-01')); ?>" class="form-control" name="claims[0][recertification_date]">
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label>Last Certification Date</label>
                    <input type="date" value="<?php echo e(old('claims.0.last_certification_date', '2023-01-01')); ?>" class="form-control" name="claims[0][last_certification_date]">
                </div>
            </div>

            <!-- Ordering Provider -->
            <div class="col-md-4">
                <div class="form-group">
                    <label>Ordering Provider Name</label>
                    <input type="text" value="<?php echo e(old('claims.0.ordering_provider_name', 'Dr. John Doe')); ?>" class="form-control" name="claims[0][ordering_provider_name]" required>
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label>Ordering Provider NPI</label>
                    <input type="text" value="<?php echo e(old('claims.0.ordering_provider_npi', '1234567890')); ?>" class="form-control" name="claims[0][ordering_provider_npi]" required>
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label>Ordering Provider Phone</label>
                    <input type="text" value="<?php echo e(old('claims.0.ordering_provider_phone', '555-1234')); ?>" class="form-control" name="claims[0][ordering_provider_phone]">
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label>Ordering Provider Street</label>
                    <input type="text" value="<?php echo e(old('claims.0.ordering_provider_street', '1234 Elm St')); ?>" class="form-control" name="claims[0][ordering_provider_street]">
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label>City</label>
                    <input type="text" value="<?php echo e(old('claims.0.ordering_provider_city', 'Springfield')); ?>" class="form-control" name="claims[0][ordering_provider_city]">
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label>State</label>
                    <input type="text" value="<?php echo e(old('claims.0.ordering_provider_state', 'IL')); ?>" class="form-control" name="claims[0][ordering_provider_state]">
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label>ZIP Code</label>
                    <input type="text" value="<?php echo e(old('claims.0.ordering_provider_zip', '62701')); ?>" class="form-control" name="claims[0][ordering_provider_zip]">
                </div>
            </div>

            <!-- Ordering Provider Contact -->
            <div class="col-md-4">
                <div class="form-group">
                    <label>Contact Name</label>
                    <input type="text" value="<?php echo e(old('claims.0.ordering_provider_contact_name', 'Jane Smith')); ?>" class="form-control" name="claims[0][ordering_provider_contact_name]">
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label>Contact Phone</label>
                    <input type="text" value="<?php echo e(old('claims.0.ordering_provider_contact_phone', '555-5678')); ?>" class="form-control" name="claims[0][ordering_provider_contact_phone]">
                </div>
            </div>

            <!-- Documentation Indicator (PWK) -->
            <div class="col-md-4">
                <div class="form-group">
                    <label>Documentation Type Code (e.g., CT)</label>
                    <input type="text" value="<?php echo e(old('claims.0.documentation_type_code', 'CT')); ?>" class="form-control" name="claims[0][documentation_type_code]">
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label>Documentation Transmission Code (e.g., AD)</label>
                    <input type="text" value="<?php echo e(old('claims.0.documentation_transmission_code', 'AD')); ?>" class="form-control" name="claims[0][documentation_transmission_code]">
                </div>
            </div>

            <!-- CR3 Segment -->
            <div class="col-md-4">
                <div class="form-group">
                    <label>Certification Type Code (e.g., R)</label>
                    <input type="text" value="<?php echo e(old('claims.0.certification_type_code', 'R')); ?>" class="form-control" name="claims[0][certification_type_code]">
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label>Oxygen Equipment Type Code (e.g., MO)</label>
                    <input type="text" value="<?php echo e(old('claims.0.oxygen_equipment_type_code', 'MO')); ?>" class="form-control" name="claims[0][oxygen_equipment_type_code]">
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label>Oxygen Test Result</label>
                    <input type="text" value="<?php echo e(old('claims.0.oxygen_test_result', 'Normal')); ?>" class="form-control" name="claims[0][oxygen_test_result]">
                </div>
            </div>

            <!-- FRM Fields -->
            <?php for($i = 1; $i <= 2; $i++): ?>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>FRM <?php echo e($i); ?></label>
                        <input type="text" value="<?php echo e(old('claims.0.frm_' . $i, 'Value ' . $i)); ?>" class="form-control" name="claims[0][frm_<?php echo e($i); ?>]">
                    </div>
                </div>
            <?php endfor; ?>

            <!-- Diagnosis Codes -->
            <div class="col-md-4">
                <div class="form-group">
                    <label>Diagnosis Type</label>
                    <input type="text" value="<?php echo e(old('claims.0.diagnosis_type_1', 'Primary')); ?>" class="form-control" name="claims[0][diagnosis_type_1]">
                </div>
            </div>
            <?php for($j = 1; $j <= 3; $j++): ?>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Diagnosis Code <?php echo e($j); ?></label>
                        <input type="text" value="<?php echo e(old('claims.0.diagnosis_code_' . $j, 'D001' . $j)); ?>" class="form-control" name="claims[0][diagnosis_code_<?php echo e($j); ?>]">
                    </div>
                </div>
            <?php endfor; ?>

            <!-- Service Date Format -->
            <div class="col-md-4">
                <div class="form-group">
                    <label>Service Date (Format: YYYYMMDD-YYYYMMDD)</label>
                    <input type="text" value="<?php echo e(old('claims.0.service_date_format', '20240101-20241231')); ?>" class="form-control" name="claims[0][service_date_format]">
                </div>
            </div>

        </div>
    </div>
</div>



   <?php elseif($claim_type == 'WC'): ?> <!-- Wheelchair -->
<div class="card mb-3">
    <div class="card-header">DME (Wheelchair) Details</div>
    <div class="card-body">
        <div class="row">
            <!-- HCPCS Code -->
            <div class="col-md-4">
                <div class="form-group">
                    <label>HCPCS Code</label>
                    <input type="text" value="E1234" class="form-control" name="claims[0][hcpcs_code]" placeholder="E1234" required>
                </div>
            </div>

            <!-- Rental Months -->
            <div class="col-md-4" style="display:none">
                <div class="form-group">
                    <label>Rental Months</label>
                    <input type="number" value="6" class="form-control" name="claims[0][rental_months]" required>
                </div>
            </div>

            <!-- Purchase/Rental Indicator -->
            <div class="col-md-4">
                <div class="form-group">
                    <label>Purchase/Rental Indicator</label>
                    <select class="form-control" required name="claims[0][purchase_rental_indicator]">
                        <option value="">Select</option>
                        <option value="RR" selected>Rental (RR)</option>
                        <option value="NU">New Purchase (NU)</option>
                    </select>
                </div>
            </div>
        </div>

        <hr>

        <!-- PER Segment -->
        <div class="row">
            <div class="col-md-4">
                <div class="form-group">
                    <label>Ordering Contact Name</label>
                    <input type="text" class="form-control" name="claims[0][ordering_contact_name]" value="LEE" required>
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label>Ordering Contact Phone</label>
                    <input type="text" class="form-control" name="claims[0][ordering_contact_phone]" value="7659259999" required>
                </div>
            </div>
        </div>

        <!-- LQ Segment -->
        <div class="row">
            <div class="col-md-4">
                <div class="form-group">
                    <label>Form Identifier Code</label>
                    <input type="text" class="form-control" name="claims[0][form_id]" value="02.03B" required>
                </div>
            </div>
        </div>

        <!-- FRM Segments -->
        <div class="row">
            <?php for($i = 1; $i <= 2; $i++): ?>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>FRM <?php echo e($i); ?></label>
                        <input type="text" class="form-control" name="claims[0][frm][<?php echo e($i); ?>]"
                            value="<?php echo e($i == 1 ? 'Y' : ($i == 5 ? '8' : 'N')); ?>" required>
                    </div>
                </div>
            <?php endfor; ?>
        </div>
    </div>
</div>







    <?php elseif($claim_type == 'AN'): ?> <!-- Anesthesia -->
    <div class="card mb-3">
        <div class="card-header">Anesthesia Details</div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Anesthesia Minutes</label>
                        <input type="number" class="form-control" value="90" name="claims[0][anesthesia_minutes]" required>
                    </div>
                </div>
                <div class="col-md-4" style="display:none;">
                    <div class="form-group">
                        <label>Base Units</label>
                        <input type="number" class="form-control" value="5" name="claims[0][base_units]" required>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php elseif($claim_type == 'RX'): ?> <!-- Drugs -->
    <div class="card mb-3">
        <div class="card-header">Prescription Drug Details</div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        <label>NDC Code</label>
                        <input type="text" value="12345678901" class="form-control" name="claims[0][ndc_code]" placeholder="12345-6789-01" required>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Quantity</label>
                        <input type="number" value="1.5" step="0.01" class="form-control" name="claims[0][drug_quantity]" required>
                    </div>
                </div>
                

                 <div class="col-md-4">
                        <div class="form-group">
                            <label>Unit of Measure</label>
                            <select class="form-control"  name="claims[0][drug_unit_of_measure]">
                                <option value="ML" selected >Milliliters (ML)</option>
                                <option value="GR">Grams (GR)</option>
                                <option value="UN">Units (UN)</option>
                            </select>
                        </div>
                    </div>
            </div>
        </div>
    </div>
    <?php elseif($claim_type == 'PP'): ?> <!-- PPO Repriced -->
    <div class="card mb-3">
        <div class="card-header">PPO Repricing Details</div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        <label>PPO Network ID</label>
                        <input type="text" class="form-control" name="claims[0][ppo_network_id]" value="PPO12345" required>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Repriced Amount</label>
                        <input type="number" step="0.01" class="form-control" value="500.00" required name="claims[0][repriced_amount]">
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php elseif($claim_type == 'ON'): ?> <!-- Out-of-Network -->
    <div class="card mb-3">
        <div class="card-header">Out-of-Network Details</div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Authorization Number</label>
                        <input type="text" class="form-control" value="AUTH67890" name="claims[0][auth_number]">
                    </div>
                </div>
                <div class="col-md-4"  style="display:none">
                    <div class="form-group">
                        <label>Reason for OON Service</label>
                        <select class="form-control" name="claims[0][oon_reason]">
                            <option value="1">Emergency Care</option>
                            <option value="2">No In-Network Provider Available</option>
                             <option value="3">Patient Request</option>
                        </select>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>



                    <br>
                    <br>


                    














                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims[0][claim_number]">Claim Number</label>
                                <input type="text" class="form-control" id="claims[0][claim_number]" name="claims[0][claim_number]" value="<?php echo e(old('claims.0.claim_number', 'CLM123456')); ?>" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims[0][claim_amount]">Claim Amount</label>
                                <input type="number" step="0.01" class="form-control" id="claims[0][claim_amount]" name="claims[0][claim_amount]" value="<?php echo e(old('claims.0.claim_amount', '500.25')); ?>" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims[0][place_of_service]">Place of Service</label>
                                <input type="text" class="form-control" id="claims[0][place_of_service]" name="claims[0][place_of_service]" value="<?php echo e(old('claims.0.place_of_service', '11')); ?>" required>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims[0][claim_frequency]">Claim Frequency</label>
                                <select class="form-control" id="claims[0][claim_frequency]" name="claims[0][claim_frequency]" required>
                                    <option value="1" <?php echo e(old('claims.0.claim_frequency', '1') == '1' ? 'selected' : ''); ?>>Original</option>
                                    <option value="7" <?php echo e(old('claims.0.claim_frequency', '1') == '7' ? 'selected' : ''); ?>>Replacement</option>
                                    <option value="8" <?php echo e(old('claims.0.claim_frequency', '1') == '8' ? 'selected' : ''); ?>>Void/Cancel</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims[0][primary_diagnosis]">Primary Diagnosis</label>
                                <input type="text" class="form-control" id="claims[0][primary_diagnosis]" name="claims[0][primary_diagnosis]" value="<?php echo e(old('claims.0.primary_diagnosis', 'J45.909')); ?>" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims[0][additional_diagnosis]">Additional Diagnosis (comma separated)</label>
                                <input type="text" class="form-control" id="claims[0][additional_diagnosis]" name="claims[0][additional_diagnosis]" value="<?php echo e(old('claims.0.additional_diagnosis')); ?>">
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims[0][date_of_service]">Date of Service</label>
                                <input type="date" class="form-control" id="claims[0][date_of_service]" name="claims[0][date_of_service]" value="<?php echo e(old('claims.0.date_of_service', '2024-03-10')); ?>" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims[0][condition_codes]">Condition Codes (comma separated)</label>
                                <input type="text" class="form-control" id="claims[0][condition_codes]" name="claims[0][condition_codes]" value="<?php echo e(old('claims.0.condition_codes')); ?>">
                            </div>
                        </div>
                    </div>
                    



                    <!-- Service Lines (Repeatable within each claim) -->
                    <div class="service-lines-container" data-claim-index="0">
                        <div class="card mb-3 service-line">
                            <div class="card-header bg-info text-white d-flex justify-content-between align-items-center">
                                <span>Service Line </span>
                                <div style="display:none;">
                                    <button type="button" class="btn btn-danger btn-sm remove-service-line" data-claim-index="0" data-service-line-index="0">Remove</button>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="claims[0][service_lines][0][service_line_number]">Line Number</label>
                                            <input type="text" class="form-control" id="claims[0][service_lines][0][service_line_number]" name="claims[0][service_lines][0][service_line_number]" value="<?php echo e(old('claims.0.service_lines.0.service_line_number', '1')); ?>" required>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="claims[0][service_lines][0][procedure_code]">Procedure Code</label>
                                            <input type="text" class="form-control" id="claims[0][service_lines][0][procedure_code]" name="claims[0][service_lines][0][procedure_code]" value="<?php echo e(old('claims.0.service_lines.0.procedure_code', '99213')); ?>" required>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="claims[0][service_lines][0][charge_amount]">Charge Amount</label>
                                            <input type="number" step="0.01" class="form-control" id="claims[0][service_lines][0][charge_amount]" name="claims[0][service_lines][0][charge_amount]" value="<?php echo e(old('claims.0.service_lines.0.charge_amount', '150.00')); ?>" required>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="claims[0][service_lines][0][date_of_service]">date of service</label>
                                            <input type="date" step="0.01" class="form-control" id="claims[0][service_lines][0][date_of_service]" name="claims[0][service_lines][0][date_of_service]"  required>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="claims[0][service_lines][0][unit_count]">Unit Count</label>
                                            <input type="number" class="form-control" id="claims[0][service_lines][0][unit_count]" name="claims[0][service_lines][0][unit_count]" value="<?php echo e(old('claims.0.service_lines.0.unit_count', '1')); ?>" required>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="claims[0][service_lines][0][diagnosis_pointer]">Diagnosis Pointer</label>
                                            <input type="text" class="form-control" id="claims[0][service_lines][0][diagnosis_pointer]" name="claims[0][service_lines][0][diagnosis_pointer]" value="<?php echo e(old('claims.0.service_lines.0.diagnosis_pointer', '1')); ?>" required>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div style="display:none;">
                        <button type="button" class="btn btn-secondary btn-sm add-service-line" data-claim-index="0">Add Service Line</button>
                    </div>





                    <!-- Provider References -->
                    <div class="service-lines-container" data-claim-index="0">
                        <div class="card mb-3 service-line">

                     <div class="card-body">
                         <div class="row">
                    <div class="row mt-3">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims[0][referring_provider_name]">Referring Provider Name</label>
                                <input type="text" class="form-control" id="claims[0][referring_provider_name]" name="claims[0][referring_provider_name]" value="<?php echo e(old('claims.0.referring_provider_name', 'Dr. John Doe')); ?>">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims[0][referring_npi]">Referring NPI</label>
                                <input type="text" class="form-control" id="claims[0][referring_npi]" name="claims[0][referring_npi]" value="<?php echo e(old('claims.0.referring_npi', '1234567890')); ?>">
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims[0][rendering_provider_name]">Rendering Provider Name</label>
                                <input type="text" class="form-control" id="claims[0][rendering_provider_name]" name="claims[0][rendering_provider_name]" value="<?php echo e(old('claims.0.rendering_provider_name', 'Dr. Jane Smith')); ?>">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims[0][rendering_npi]">Rendering NPI</label>
                                <input type="text" class="form-control" id="claims[0][rendering_npi]" name="claims[0][rendering_npi]" value="<?php echo e(old('claims.0.rendering_npi', '9876543210')); ?>">
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims[0][supervising_provider_name]">Supervising Provider Name</label>
                                <input type="text" class="form-control" id="claims[0][supervising_provider_name]" name="claims[0][supervising_provider_name]" value="<?php echo e(old('claims.0.supervising_provider_name', 'Dr. Robert Johnson')); ?>">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims[0][supervising_npi]">Supervising NPI</label>
                                <input type="text" class="form-control" id="claims[0][supervising_npi]" name="claims[0][supervising_npi]" value="<?php echo e(old('claims.0.supervising_npi', '1231231234')); ?>">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
  
                    </div>
                </div>
            </div>
        </div>
        
        <button type="button" id="add-claim" class="btn btn-primary mb-4">Add Another Claim</button>
        
        <!-- Control Numbers -->
        <div class="card mb-4">
            <div class="card-header bg-primary text-white">Control Numbers</div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="se01">SE01</label>
                            <input type="text" class="form-control" id="se01" name="se01" value="<?php echo e(old('se01', '34')); ?>" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="ge_control_number">GE Control Number</label>
                            <input type="text" class="form-control" id="ge_control_number" name="ge_control_number" value="<?php echo e(old('ge_control_number', '123096815')); ?>" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            
                            <input type="hidden" class="form-control" id="se02" name="se02" value="<?php echo e(old('se02', mt_rand(1000, 999999999))); ?>" required>
                        </div>
                    </div>
                    
                </div>
            </div>
        </div>
        
        <button type="submit" class="btn btn-success">Generate EDI</button>
    </form>
</div>

<script type="text/javascript">
	document.addEventListener('DOMContentLoaded', function() {
    // Add New Claim
    document.getElementById('add-claim').addEventListener('click', function() {
    	 const claimType = "<?php echo e($claim_type); ?>";
    	 console.log(claimType)
        const container = document.getElementById('claims-container');
        const claimCount = container.querySelectorAll('.claim-section').length;
        const newClaimIndex = claimCount;
        const today = new Date().toISOString().split('T')[0];
        
        var newClaimHTML = `
        <div class="card mb-4 claim-section">
            <div class="card-header bg-info text-white d-flex justify-content-between align-items-center">
                <span>Claim #${newClaimIndex + 1}</span>
               
                <button type="button" class="btn btn-danger btn-sm remove-claim">Remove</button>
               
            </div>
            <div class="card-body">
                <!-- Patient/Subscriber Information -->
                <div class="card mb-3">
                    <div class="card-header">Patient/Subscriber Information</div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Last Name</label>
                                    <input type="text" class="form-control" name="claims[${newClaimIndex}][subscriber_last_name]" value="Doe" required>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>First Name</label>
                                    <input type="text" class="form-control" name="claims[${newClaimIndex}][subscriber_first_name]" value="John" required>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Member ID</label>
                                    <input type="text" class="form-control" name="claims[${newClaimIndex}][member_id]" value="M${Math.floor(100000000 + Math.random() * 900000000)}" required>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Date of Birth</label>
                                    <input type="date" class="form-control" name="claims[${newClaimIndex}][subscriber_dob]" value="1985-01-15" required>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Gender</label>
                                    <select class="form-control" name="claims[${newClaimIndex}][subscriber_gender]" required>
                                        <option value="M" selected>Male</option>
                                        <option value="F">Female</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                          
                                <h5>Patient Address</h5>
                           
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Street</label>
                                    <input type="text" class="form-control" name="claims[${newClaimIndex}][subscriber_street]" value="456 Elm Street" required>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>City</label>
                                    <input type="text" class="form-control" name="claims[${newClaimIndex}][subscriber_city]" value="Los Angeles" required>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>State</label>
                                    <input type="text" class="form-control" name="claims[${newClaimIndex}][subscriber_state]" value="CA" required>
                                </div>
                            </div>
                            <div class="col-md-1">
                                <div class="form-group">
                                    <label>ZIP</label>
                                    <input type="text" class="form-control" name="claims[${newClaimIndex}][subscriber_zip]" value="90001" required>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Group Number</label>
                                    <input type="text" class="form-control" name="claims[${newClaimIndex}][group_number]" value="GROUP${newClaimIndex + 1}" required>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Insurance Type</label>
                                    <select class="form-control" name="claims[${newClaimIndex}][insurance_type]" required>
                                        <option value="MC">Medicare</option>
                                        <option value="CI">Commercial</option>
                                        <option value="BL">Blue Cross</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>`;
















    // Add type-specific fields
    if (claimType == '12') { // Commercial Insurance
        newClaimHTML += `
        <div class="card mb-3">
            <div class="card-header">Commercial Insurance Details</div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Employer Name</label>
                            <input type="text" value="ABC Corp" class="form-control" name="claims[${newClaimIndex}][employer_name]" required>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Employer Id</label>
                            <input type="text" class="form-control" name="claims[${newClaimIndex}][employer_id]" value="EMP12345">>
                        </div>
                    </div>
                    
                </div>
            </div>
        </div>`;
    }
    else if (claimType === 'EN0') { // Encounter
        newClaimHTML += `
        <div class="card mb-3">
            <div class="card-header">Encounter Details</div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Encounter ID</label>
                            <input type="text" value="ENC123456" class="form-control" name="claims[${newClaimIndex}][encounter_id]" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Reference Identification Qualifier</label>
                            <input type="text" value="ENC123456" class="form-control" name="claims[${newClaimIndex}][capitation_indicator]" required>
                        </div>
                    </div>
                </div>
            </div>
        </div>`;
    }
    else if (claimType === 'A1') { // COB Primary
        newClaimHTML += `
        <div class="card mb-3">
            <div class="card-header">Coordination of Benefits</div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Other Payer Name</label>
                            <input type="text" class="form-control" name="claims[${newClaimIndex}][other_payer_name]" value="XYZ Insurance" required>
                        </div>
                    </div>
                    <div class="col-md-4" style="style="display:none"">
                        <div class="form-group">
                            <label>Other Payer Paid Amount</label>
                            <input type="number" step="0.01" class="form-control" name="claims[${newClaimIndex}][other_payer_paid_amount]"  value="100.00">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Other Insurance Policy Number</label>
                            <input type="text"  class="form-control" name="claims[${newClaimIndex}][other_insurance_policy]"value="POL987654"  required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Other Insurance Group Number</label>
                            <input type="text" class="form-control" name="claims[${newClaimIndex}][other_insurance_group]" value="GRP123" required>
                        </div>
                    </div>
                </div>
            </div>
        </div>`;
    }
    else if (claimType === 'A2') { // Medicare Secondary
        newClaimHTML += `
        <div class="card mb-3">
            <div class="card-header">Medicare Secondary Details</div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Medicare Beneficiary Identifier</label>
                            <input type="text" class="form-control" name="claims[${newClaimIndex}][medicare_id]" required value="MBI1234567">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>MSP Type Code</label>
                            <select class="form-control" name="claims[${newClaimIndex}][msp_type_code]" required>
                                <option selected value="12">Working Aged</option>
                                <option value="13">ESRD</option>
                                <option value="14">No-Fault</option>
                                <option value="15">Worker's Comp</option>
                            </select>
                        </div>
                    </div>
                </div>
            </div>
        </div>`;
    }
    else if (claimType === 'A3') { // Ambulance
        newClaimHTML += `
        <div class="card mb-3">
            <div class="card-header">Ambulance Details</div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Pickup Address</label>
                            <input type="text" class="form-control" value="123 Main St" name="claims[${newClaimIndex}][pickup_address]" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Dropoff Address</label>
                            <input type="text" class="form-control" name="claims[${newClaimIndex}][dropoff_address]" value="456 Hospital Rd" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Transport Reason Code</label>
                            <select class="form-control" name="claims[${newClaimIndex}][transport_reason]" required>
                                 <option value="A" selected>Patient's condition requires transport</option>
                                 <option value="B">Other</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Pickup ZIP Code</label>
                            <input type="text" class="form-control" name="claims[${newClaimIndex}][pickup_zip]" value="12345" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Mileage</label>
                            <input type="number" class="form-control" name="claims[${newClaimIndex}][mileage]" value="15.5" required>
                        </div>
                    </div>
                </div>
            </div>
        </div>`;
    }
    else if (claimType === 'CH') { // Chiropractic
        newClaimHTML += `
        <div class="card mb-3">
            <div class="card-header">Chiropractic Details</div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Spinal Region</label>
                            <select class="form-control" name="claims[${newClaimIndex}][spinal_region]" required>
                               <option value="A">All Regions</option>
                                <option value="C" selected>Cervical</option>
                                <option value="D">Dorsal (Thoracic)</option>
                                <option value="E">Lumbar</option>
                                <option value="F">Sacroiliac</option>
                                <option value="G">Coccygeal</option>
                                <option value="M">Multiple Regions</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4" style="display:none">
                        <div class="form-group">
                            <label>Number of Adjustments</label>
                            <input type="number" class="form-control" name="claims[${newClaimIndex}][adjustment_count]" value="3" required>
                        </div>
                    </div>
                </div>
            </div>
        </div>`;
    }



else if (claimType === 'O2') { // Oxygen
    newClaimHTML += `
    <div class="card mb-3">
        <div class="card-header">Oxygen Therapy Details</div>
        <div class="card-body">
            <div class="row">

                <!-- Oxygen Details -->
                <div class="col-md-4" style="display:none">
                    <div class="form-group">
                        <label>Oxygen Flow Rate (L/min)</label>
                        <input type="number" step="0.1" value="2.5" class="form-control" name="claims[${newClaimIndex}][flow_rate]" required>
                    </div>
                </div>
                <div class="col-md-4" style="display:none">
                    <div class="form-group">
                        <label>Therapy Duration (Hours/Day)</label>
                        <input type="number" value="8" class="form-control" name="claims[${newClaimIndex}][therapy_duration]" required>
                    </div>
                </div>

                <!-- Certification Dates -->
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Certification Start Date</label>
                        <input type="date" value="2024-01-01" class="form-control" name="claims[${newClaimIndex}][certification_start_date]" required>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Recertification Date</label>
                        <input type="date" value="2024-12-31" class="form-control" name="claims[${newClaimIndex}][recertification_date]">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Last Certification Date</label>
                        <input type="date" value="2023-12-31" class="form-control" name="claims[${newClaimIndex}][last_certification_date]">
                    </div>
                </div>

                <!-- Ordering Provider -->
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Ordering Provider Name</label>
                        <input type="text" value="Dr. Smith" class="form-control" name="claims[${newClaimIndex}][ordering_provider_name]" required>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Ordering Provider NPI</label>
                        <input type="text" value="1234567890" class="form-control" name="claims[${newClaimIndex}][ordering_provider_npi]" required>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Ordering Provider Phone</label>
                        <input type="text" value="123-456-7890" class="form-control" name="claims[${newClaimIndex}][ordering_provider_phone]">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Ordering Provider Street</label>
                        <input type="text" value="123 Main St" class="form-control" name="claims[${newClaimIndex}][ordering_provider_street]">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>City</label>
                        <input type="text" value="Anytown" class="form-control" name="claims[${newClaimIndex}][ordering_provider_city]">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>State</label>
                        <input type="text" value="CA" class="form-control" name="claims[${newClaimIndex}][ordering_provider_state]">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>ZIP Code</label>
                        <input type="text" value="12345" class="form-control" name="claims[${newClaimIndex}][ordering_provider_zip]">
                    </div>
                </div>

                <!-- Provider Contact -->
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Contact Name</label>
                        <input type="text" value="John Doe" class="form-control" name="claims[${newClaimIndex}][ordering_provider_contact_name]">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Contact Phone</label>
                        <input type="text" value="987-654-3210" class="form-control" name="claims[${newClaimIndex}][ordering_provider_contact_phone]">
                    </div>
                </div>

                <!-- PWK Segment -->
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Documentation Type Code (e.g., CT)</label>
                        <input type="text" value="CT" class="form-control" name="claims[${newClaimIndex}][documentation_type_code]">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Documentation Transmission Code (e.g., AD)</label>
                        <input type="text" value="AD" class="form-control" name="claims[${newClaimIndex}][documentation_transmission_code]">
                    </div>
                </div>

                <!-- CR3 Segment -->
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Certification Type Code (e.g., R)</label>
                        <input type="text" value="R" class="form-control" name="claims[${newClaimIndex}][certification_type_code]">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Oxygen Equipment Type Code (e.g., MO)</label>
                        <input type="text" value="MO" class="form-control" name="claims[${newClaimIndex}][oxygen_equipment_type_code]">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Oxygen Test Result</label>
                        <input type="text" value="Positive" class="form-control" name="claims[${newClaimIndex}][oxygen_test_result]">
                    </div>
                </div>

                <!-- FRM Fields -->
                ${[...Array(2)].map((_, i) => `
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>FRM ${i + 1}</label>
                            <input type="text" value="Value ${i + 1}" class="form-control" name="claims[${newClaimIndex}][frm_${i + 1}]">
                        </div>
                    </div>
                `).join('')}

                <!-- Diagnosis -->
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Diagnosis Type</label>
                        <input type="text" value="Primary" class="form-control" name="claims[${newClaimIndex}][diagnosis_type_1]">
                    </div>
                </div>
                ${[1, 2, 3].map(j => `
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Diagnosis Code ${j}</label>
                            <input type="text" value="Code ${j}" class="form-control" name="claims[${newClaimIndex}][diagnosis_code_${j}]">
                        </div>
                    </div>
                `).join('')}

                <!-- Service Date Format -->
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Service Date (Format: YYYYMMDD-YYYYMMDD)</label>
                        <input type="text" value="20240101-20241231" class="form-control" name="claims[${newClaimIndex}][service_date_format]">
                    </div>
                </div>

            </div>
        </div>
    </div>`;
}


   







   else if (claimType === 'WC') { // Wheelchair
    newClaimHTML += `
    <div class="card mb-3">
        <div class="card-header">DME (Wheelchair) Details</div>
        <div class="card-body">
            <div class="row">
                <!-- Purchase/Rental Indicator -->
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Purchase/Rental Indicator</label>
                        <select class="form-control" name="claims[${newClaimIndex}][purchase_rental_indicator]" required>
                            <option value="RR" selected>Rental (RR)</option>
                            <option value="NU">Purchase (NU)</option>
                        </select>
                    </div>
                </div>

                <!-- HCPCS Code -->
                <div class="col-md-4">
                    <div class="form-group">
                        <label>HCPCS Code</label>
                        <input type="text" class="form-control" name="claims[${newClaimIndex}][hcpcs_code]" placeholder="E1234" value="E1234" required>
                    </div>
                </div>

                <!-- Rental Months -->
                <div class="col-md-4" style="display:none">
                    <div class="form-group">
                        <label>Rental Months</label>
                        <input type="number" class="form-control" value="6" required name="claims[${newClaimIndex}][rental_months]">
                    </div>
                </div>
            </div>

            <hr>

            <!-- PER Segment -->
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Ordering Contact Name</label>
                        <input type="text" class="form-control" name="claims[${newClaimIndex}][ordering_contact_name]" value="LEE" required>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Ordering Contact Phone</label>
                        <input type="text" class="form-control" name="claims[${newClaimIndex}][ordering_contact_phone]" value="7659259999" required>
                    </div>
                </div>
            </div>

            <!-- LQ Segment -->
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Form Identifier Code</label>
                        <input type="text" class="form-control" name="claims[${newClaimIndex}][form_id]" value="02.03B" required>
                    </div>
                </div>
            </div>

            <!-- FRM Segments -->
            <div class="row">
                ${[1, 2].map(i => `
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>FRM ${i}</label>
                            <input type="text" class="form-control" name="claims[${newClaimIndex}][frm][${i}]" value="${i === 1 ? 'Y' : i === 5 ? '8' : 'N'}" required>
                        </div>
                    </div>
                `).join('')}
            </div>
        </div>
    </div>`;
}

    else if (claimType === 'AN') { // Anesthesia
        newClaimHTML += `
        <div class="card mb-3">
            <div class="card-header">Anesthesia Details</div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Anesthesia Minutes</label>
                            <input type="number" class="form-control" name="claims[${newClaimIndex}][anesthesia_minutes]" value="90" required>
                        </div>
                    </div>
                    <div class="col-md-4" style="display:none;">
                        <div class="form-group">
                            <label>Base Units</label>
                            <input type="number" value="5" class="form-control" name="claims[${newClaimIndex}][base_units]" required>
                        </div>
                    </div>
                </div>
            </div>
        </div>`;
    }
    else if (claimType === 'RX') { // Drugs
        newClaimHTML += `
        <div class="card mb-3">
            <div class="card-header">Prescription Drug Details</div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>NDC Code</label>
                            <input type="text" class="form-control" name="claims[${newClaimIndex}][ndc_code]" placeholder="12345-6789-01" value="12345678901" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Quantity</label>
                            <input type="number" step="0.01" class="form-control" name="claims[${newClaimIndex}][drug_quantity]" value="1.5" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Unit of Measure</label>
                            <select class="form-control" name="claims[${newClaimIndex}][drug_unit_of_measure]">
                                <option value="ML" selected >Milliliters (ML)</option>
                                <option value="GR">Grams (GR)</option>
                                <option value="UN">Units (UN)</option>
                            </select>
                        </div>
                    </div>
                </div>
            </div>
        </div>`;
    }
    else if (claimType === 'PP') { // PPO Repriced
        newClaimHTML += `
        <div class="card mb-3">
            <div class="card-header">PPO Repricing Details</div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>PPO Network ID</label>
                            <input type="text" class="form-control" value="PPO12345" name="claims[${newClaimIndex}][ppo_network_id]" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Repriced Amount</label>
                            <input type="number" value="500.00" step="0.01" class="form-control" name="claims[${newClaimIndex}][repriced_amount]" required>
                        </div>
                    </div>
                </div>
            </div>
        </div>`;
    }
    else if (claimType === 'ON') { // Out-of-Network
        newClaimHTML += `
        <div class="card mb-3">
            <div class="card-header">Out-of-Network Details</div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Authorization Number</label>
                            <input type="text" class="form-control" name="claims[${newClaimIndex}][auth_number]" value="AUTH67890" required>
                        </div>
                    </div>
                    <div class="col-md-4" style="display:none">
                        <div class="form-group">
                            <label>Reason for OON Service</label>
                            <select class="form-control" name="claims[${newClaimIndex}][oon_reason]">
                                <option value="1" selected >Emergency Care</option>
                                <option value="2">No In-Network Provider Available</option>
                                <option value="3">Patient Request</option>
                            </select>
                        </div>
                    </div>
                </div>
            </div>
        </div>`;
    }




















               newClaimHTML += `  <!-- Claim Information -->
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Claim Number</label>
                            <input type="text" class="form-control" name="claims[${newClaimIndex}][claim_number]" value="CLM${Math.floor(100000 + Math.random() * 900000)}" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Claim Amount</label>
                            <input type="number" step="0.01" class="form-control" name="claims[${newClaimIndex}][claim_amount]" value="100.00" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Place of Service</label>
                            <input type="text" class="form-control" name="claims[${newClaimIndex}][place_of_service]" value="11" required>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Claim Frequency</label>
                            <select class="form-control" name="claims[${newClaimIndex}][claim_frequency]" required>
                                <option value="1" selected>Original</option>
                                <option value="7">Replacement</option>
                                <option value="8">Void/Cancel</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Primary Diagnosis</label>
                            <input type="text" class="form-control" name="claims[${newClaimIndex}][primary_diagnosis]" value="J45.909" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Additional Diagnosis (comma separated)</label>
                            <input type="text" class="form-control" name="claims[${newClaimIndex}][additional_diagnosis]">
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Date of Service</label>
                            <input type="date" class="form-control" name="claims[${newClaimIndex}][date_of_service]" value="${today}" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Condition Codes (comma separated)</label>
                            <input type="text" class="form-control" name="claims[${newClaimIndex}][condition_codes]">
                        </div>
                    </div>
                </div>
                
                <!-- Service Lines -->
                <div class="service-lines-container" data-claim-index="${newClaimIndex}">
                    <div class="card mb-3 service-line">
                        <div class="card-header bg-info text-white d-flex justify-content-between align-items-center">
                            <span>Service Line</span>
                             <div style="display:none;">
                            <button type="button" class="btn btn-danger btn-sm remove-service-line" data-claim-index="${newClaimIndex}" data-service-line-index="0">Remove</button>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Line Number</label>
                                        <input type="text" class="form-control" name="claims[${newClaimIndex}][service_lines][0][service_line_number]" value="1" required>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Procedure Code</label>
                                        <input type="text" class="form-control" name="claims[${newClaimIndex}][service_lines][0][procedure_code]" value="99213" required>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Charge Amount</label>
                                        <input type="number" step="0.01" class="form-control" name="claims[${newClaimIndex}][service_lines][0][charge_amount]" value="100.00" required>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Date of Service</label>
                                        <input type="date" class="form-control" name="claims[${newClaimIndex}][service_lines][0][date_of_service]" value="${today}" required>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Unit Count</label>
                                        <input type="number" class="form-control" name="claims[${newClaimIndex}][service_lines][0][unit_count]" value="1" required>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Diagnosis Pointer</label>
                                        <input type="text" class="form-control" name="claims[${newClaimIndex}][service_lines][0][diagnosis_pointer]" value="1" required>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div style="display:none;">
                <button type="button" class="btn btn-secondary btn-sm add-service-line" data-claim-index="${newClaimIndex}">Add Service Line</button>
                </div>
                
                <!-- Provider References -->
                 <div class="service-lines-container" data-claim-index="0">
                        <div class="card mb-3 service-line">

                     <div class="card-body">
                         <div class="row">
                <div class="row mt-3">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Referring Provider Name</label>
                            <input type="text" class="form-control" name="claims[${newClaimIndex}][referring_provider_name]" value="Dr. John Doe">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Referring NPI</label>
                            <input type="text" class="form-control" name="claims[${newClaimIndex}][referring_npi]" value="1234567890">
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Rendering Provider Name</label>
                            <input type="text" class="form-control" name="claims[${newClaimIndex}][rendering_provider_name]" value="Dr. Jane Smith">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Rendering NPI</label>
                            <input type="text" class="form-control" name="claims[${newClaimIndex}][rendering_npi]" value="9876543210">
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Supervising Provider Name</label>
                            <input type="text" class="form-control" name="claims[${newClaimIndex}][supervising_provider_name]" value="Dr. Robert Johnson">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Supervising NPI</label>
                            <input type="text" class="form-control" name="claims[${newClaimIndex}][supervising_npi]" value="1231231234">
                        </div>
                    </div>
                </div>
                </div>
                </div>
                </div>
                </div>
            </div>
        </div>`;
        
        container.insertAdjacentHTML('beforeend', newClaimHTML);
    });

    // Remove Claim
    document.addEventListener('click', function(e) {
        if (e.target.classList.contains('remove-claim')) {
            const claimSection = e.target.closest('.claim-section');
            if (document.querySelectorAll('.claim-section').length > 1) {
                claimSection.remove();
                // Renumber remaining claims
                document.querySelectorAll('.claim-section').forEach((section, index) => {
                    section.querySelector('.card-header span').textContent = `Claim #${index + 1}`;
                });
            } else {
                alert('You must have at least one claim.');
            }
        }
    });

    // Add Service Line
    document.addEventListener('click', function(e) {
        if (e.target.classList.contains('add-service-line')) {
            const claimIndex = e.target.getAttribute('data-claim-index');
            const container = e.target.previousElementSibling;
            const lineIndex = container.querySelectorAll('.service-line').length;
            const today = new Date().toISOString().split('T')[0];
            
            const newLineHTML = `
            <div class="card mb-3 service-line">
                <div class="card-header bg-info text-white d-flex justify-content-between align-items-center">
                    <span>Service Line #${lineIndex + 1}</span>
                    <button type="button" class="btn btn-danger btn-sm remove-service-line" data-claim-index="${claimIndex}" data-service-line-index="${lineIndex}">Remove</button>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Line Number</label>
                                <input type="text" class="form-control" name="claims[${claimIndex}][service_lines][${lineIndex}][service_line_number]" value="${lineIndex + 1}" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Procedure Code</label>
                                <input type="text" class="form-control" name="claims[${claimIndex}][service_lines][${lineIndex}][procedure_code]" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Charge Amount</label>
                                <input type="number" step="0.01" class="form-control" name="claims[${claimIndex}][service_lines][${lineIndex}][charge_amount]" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Date of Service</label>
                                <input type="date" class="form-control" name="claims[${claimIndex}][service_lines][${lineIndex}][date_of_service]" value="${today}" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Unit Count</label>
                                <input type="number" class="form-control" name="claims[${claimIndex}][service_lines][${lineIndex}][unit_count]" value="1" required>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Diagnosis Pointer</label>
                                <input type="text" class="form-control" name="claims[${claimIndex}][service_lines][${lineIndex}][diagnosis_pointer]" value="1" required>
                            </div>
                        </div>
                    </div>
                </div>
            </div>`;
            
            container.insertAdjacentHTML('beforeend', newLineHTML);
        }
    });

    // Remove Service Line
    document.addEventListener('click', function(e) {
        if (e.target.classList.contains('remove-service-line')) {
            const serviceLine = e.target.closest('.service-line');
            if (serviceLine.parentElement.querySelectorAll('.service-line').length > 1) {
                serviceLine.remove();
                // Renumber remaining service lines
                const remainingLines = serviceLine.parentElement.querySelectorAll('.service-line');
                remainingLines.forEach((line, index) => {
                    line.querySelector('.card-header span').textContent = `Service Line #${index + 1}`;
                    line.querySelector('[name*="service_line_number"]').value = index + 1;
                });
            } else {
                alert('You must have at least one service line per claim.');
            }
        }
    });

    // Initialize with one claim if empty
    if (document.querySelectorAll('.claim-section').length === 0) {
        document.getElementById('add-claim').click();
    }
});
	
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/klyretmp/public_html/edi/resources/views/multiple/create_multiple_edip_12_form.blade.php ENDPATH**/ ?>