
<header class="g-header md:pb-32">
    <div class="container">
        <div class="border-b border-gray-700">
            <div class="flex items-center justify-between h-16 px-4 sm:px-0">
                <div class="flex items-center">
                    <div class="flex-shrink-0">
                        <a href="javascript:void(0)" style="text-decoration: none;" class="font-light block text-center text-white text-2xl">Klyre<span class="font-bold">Payments</span></a>
                    </div>
                    <div class="hidden md:block">
                        <div class="ml-10 flex items-baseline space-x-4">
                            <nav>
                                <ul class="mainmenu">
                                    <li>
                                        <a href="javascript:void(0)" class="menuitem"style="text-decoration: none;">Dashboard</a>
                                    </li>
                                    <li>
                                        <a href="<?php echo e(route('dashboard')); ?>" class="menuitem"style="text-decoration: none;">EDI Files</a>
                                    </li>
                                    
                                </ul>
                            </nav>
                        </div>
                    </div>
                </div>
                <?php echo $__env->make('message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="hidden md:block text-right">
                    <div class="flex divide-x divide-gray-500">
                        <div class="text-white text-right text-sm ml-auto pr-6">
                            <p id="clock" class="font-medium">Thu, Sep 19 2024, 05:17:34</p>
                            <p class="text-gray-400 text-xs">New York</p>
                        </div>
                        <div class="text-sm pl-6">
                            <p class="text-white font-medium">Super User</p>
                            <form method="POST" action="<?php echo e(route('logout')); ?>">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="text-gray-400 text-xs hover:underline hover:text-white focus:text-white focus:ring-offset-2">Log out</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
    document.addEventListener('DOMContentLoaded', function () {
    var dropdownItems = document.querySelectorAll('.menu-item-has-children');
    var dropdowns = document.querySelectorAll('.menu-item-has-children .mainmenu-sub-menu');
    var delay = 2000;
    if (dropdownItems) {
    dropdownItems.forEach((dropdownItem, count) => {
    dropdownItem.addEventListener('mouseenter', function (e) {
    dropdowns[count].classList.add('dropdown-show');
    });
    dropdownItem.addEventListener('mouseleave', function () {
    dropdowns[count].classList.remove('dropdown-show');
    });
    });
    }
    })
    </script>
    <div class="container btn-container">
        
        <div class="md:py-10 py-5 md:flex md:items-end md:justify-between w-full">
                <h1 class="text-3xl font-bold md:text-white">Details</h1> 
                <div class="flex flex-wrap items-center gap-1">
                            
                            
                            
                            <?php if($file->status == "P"): ?>
                            <?php if($file->type === 'P'): ?>
                            <a href="<?php echo e(route('generate.999.edip', $file->id)); ?>"
                                class=" btn text-white bg-indigo-600 hover:bg-indigo-700">
                                Generate 999 (P)
                            </a>
                            <?php elseif($file->type === 'I'): ?>
                            <a href="<?php echo e(route('generate.999.edii', $file->id)); ?>"
                                class=" btn text-white bg-indigo-600 hover:bg-indigo-700">
                                Generate 999 (I)
                            </a>
                            <?php else: ?>
                            <a href="<?php echo e(route('generate.999.edid', $file->id)); ?>"
                                class=" btn text-white bg-indigo-600 hover:bg-indigo-700">
                                Generate 999 (D)
                            </a>
                            <?php endif; ?>
                            <?php endif; ?>
                            
                            <a href="<?php echo e(route('download.edi', $file->id)); ?>"
                                class=" btn text-white bg-indigo-600 hover:bg-indigo-700">
                                Download 837 - Claims
                            </a>
                            
                            <?php if($file->find_837_to_999): ?>
                            <a href="<?php echo e(route('download.999', $file->find_837_to_999->file_name)); ?>"
                                class=" btn text-white bg-indigo-600 hover:bg-indigo-700">
                                Download Ack
                            </a>
                            <?php endif; ?>
                        </div>
        </div>
    </div>
</header>
<?php $__env->startSection('content'); ?>
<main class="md:-mt-32 mt-5">
    <div class="container">
        
        <form id="myform" name="myform" method="POST">
            <div class="md:flex items-start space-x-6 mb-6">
                <!-- Left Column - Patient Information -->
                <div class="bg-white w-1/2 shadow overflow-hidden sm:rounded-lg">
                    <div class="px-4 py-5 sm:px-6 border-b">
                        <div class="md:flex justify-between">
                            <div>
                                <h3 class="text-lg leading-6 font-medium text-gray-900">Claim Information</h3>
                            </div>
                        </div>
                    </div>
                    
                    <div>
                        
                        
                        <div id="tab-primary" class="g-tab-content2 current">
                            <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Claim Number</label>
                                <span class="w-3/4"><?= $data->claim_number ?></span>
                            </div>
                            <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Claim Amount</label>
                                <span class="w-3/4">$<?= number_format($data->claim_amount, 2) ?></span>
                            </div>
                            <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Authorization #</label>
                                <span class="w-3/4"><?= $data->authorization_number ?? 'N/A' ?></span>
                            </div>
                            <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Date of Service</label>
                                <span class="w-3/4"><?= date('m/d/Y', strtotime($data->date_of_service)) ?></span>
                            </div>
                            <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Primary Diagnosis</label>
                                <span class="w-3/4"><?= $data->primary_diagnosis ?></span>
                            </div>
                            <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Additional Diagnosis</label>
                                <span class="w-3/4"><?= $data->additional_diagnosis ?? 'None' ?></span>
                            </div>
                            <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Procedure Code</label>
                                <span class="w-3/4"><?= $data->procedure_code ?></span>
                            </div>
                            <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Service Location</label>
                                <span class="w-3/4"><?= $data->facility_name ?></span>
                            </div>
                        </div>
                        
                    </div>
                </div>
                
                <!-- Right Column - Provider & Transmission Info -->
                <div class="bg-white w-1/2 shadow overflow-hidden sm:rounded-lg">
                    <div class="px-4 py-5 sm:px-6 border-b">
                        <div class="md:flex justify-between">
                            <div>
                                <h3 class="text-lg leading-6 font-medium text-gray-900">Patient Information</h3>
                            </div>
                        </div>
                    </div>
                    
                    <div>
                        
                        
                        <div id="tab-primary" class="g-tab-content2 current">
                            <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Patient Name</label>
                                <span class="w-3/4">
                                    <?= $data->subscriber_first_name ?>
                                    <?= !empty($data->subscriber_middle_name) ? $data->subscriber_middle_name . ' ' : '' ?>
                                    <?= $data->subscriber_last_name ?>
                                    <?= !empty($data->subscriber_suffix) ? ', ' . $data->subscriber_suffix : '' ?>
                                </span>
                            </div>
                            <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Member ID</label>
                                <span class="w-3/4"><?= $data->member_id ?></span>
                            </div>
                            <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Patient Account #</label>
                                <span class="w-3/4"><?= $data->patient_account_number ?? 'N/A' ?></span>
                            </div>
                            <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Date of Birth</label>
                                <span class="w-3/4"><?= date('m/d/Y', strtotime($data->subscriber_dob)) ?></span>
                            </div>
                            <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Gender</label>
                                <span class="w-3/4">
                                    <?= $data->subscriber_gender == 'M' ? 'Male' : ($data->subscriber_gender == 'F' ? 'Female' : 'Other') ?>
                                </span>
                            </div>
                            <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Relationship</label>
                                <span class="w-3/4">
                                    <?= match($data->patient_relationship ?? 'self') {
                                    'self' => 'Self',
                                    'spouse' => 'Spouse',
                                    'child' => 'Child',
                                    'other' => 'Other',
                                    default => 'Self'
                                    } ?>
                                </span>
                            </div>
                            <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Address</label>
                                <span class="w-3/4">
                                    <?= $data->subscriber_street ?><br>
                                    <?= $data->subscriber_city ?>, <?= $data->subscriber_state ?> <?= substr($data->subscriber_zip, 0, 5) ?>
                                </span>
                            </div>
                            <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Phone</label>
                                <span class="w-3/4"><?= $data->subscriber_phone ?? 'N/A' ?></span>
                            </div>
                            <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Payer</label>
                                <span class="w-3/4"><?= $data->payer_name ?> (<?= $data->payer_id ?>)</span>
                            </div>
                        </div>
                        
                    </div>
                </div>
            </div>
        </form>
        
        <form id="myform" name="myform" method="POST">
            <div class="md:flex items-start space-x-6 mb-6">
                <!-- Left Column - Patient Information -->
                <div class="w-1/2">
                    <div class="bg-white shadow overflow-hidden sm:rounded-lg">
                        <div class="px-4 py-5 sm:px-6 border-b">
                            <div class="md:flex justify-between">
                                <div>
                                    <h3 class="text-lg leading-6 font-medium text-gray-900">Provider  Details</h3>
                                    
                                </div>
                            </div>
                        </div>
                        
                        <div class="pt-3 border-b">
                            
                            
                            <div id="tab-1" class="g-tab-content current">
                                <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Provider Name</label>
                                    <span class="w-3/4"><?= $data->provider_name ?></span>
                                </div>
                                <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">NPI</label>
                                    <span class="w-3/4"><?= $data->provider_npi ?></span>
                                </div>
                                <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Tax ID</label>
                                    <span class="w-3/4"><?= $data->provider_tax_id ?></span>
                                </div>
                                <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Billing Provider</label>
                                    <span class="w-3/4"><?= $data->billing_provider_name ?? $data->provider_name ?></span>
                                </div>
                                <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Facility</label>
                                    <span class="w-3/4"><?= $data->facility_name ?></span>
                                </div>
                                <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Facility Address</label>
                                    <span class="w-3/4">
                                        <?= $data->facility_street ?><br>
                                        <?= $data->facility_city ?>, <?= $data->facility_state ?> <?= substr($data->facility_zip, 0, 5) ?>
                                    </span>
                                </div>
                                <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Rendering Provider</label>
                                    <span class="w-3/4"><?= $data->rendering_provider_name ?> (<?= $data->rendering_npi ?>)</span>
                                </div>
                                <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Referring Provider</label>
                                    <span class="w-3/4">
                                        <?= $data->referring_provider_name ?? 'N/A' ?>
                                        <?= !empty($data->referring_npi) ? '(' . $data->referring_npi . ')' : '' ?>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Right Column - Provider & Transmission Info -->
                <div class="w-1/2">
                    <div class="bg-white shadow overflow-hidden sm:rounded-lg">
                        <div class="px-4 py-5 sm:px-6 border-b">
                            <div class="md:flex justify-between">
                                <div>
                                    <h3 class="text-lg leading-6 font-medium text-gray-900"> Transmission Details</h3>
                                    <p class="mt-1 max-w-2xl text-sm text-gray-500">Service provider and submission information</p>
                                </div>
                            </div>
                        </div>
                        
                        <div class="pt-3 border-b">
                            
                            
                            <div id="tab-1" class="g-tab-content current">
                                <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Submitter</label>
                                    <span class="w-3/4"><?= $data->submitter_name ?> (<?= $data->submitter_id ?>)</span>
                                </div>
                                <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Receiver</label>
                                    <span class="w-3/4"><?= $data->receiver_name ?> (<?= $data->receiver_code ?>)</span>
                                </div>
                                <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Transmission Date</label>
                                    <span class="w-3/4"><?= date('m/d/Y', strtotime($data->transmission_date)) ?></span>
                                </div>
                                <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Transmission Time</label>
                                    <span class="w-3/4"><?= date('h:i A', strtotime($data->transmission_time)) ?></span>
                                </div>
                                <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Control Number</label>
                                    <span class="w-3/4"><?= $data->control_number ?></span>
                                </div>
                                <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Sender Code</label>
                                    <span class="w-3/4"><?= $data->sender_code ?></span>
                                </div>
                                <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Receiver Code</label>
                                    <span class="w-3/4"><?= $data->receiver_code ?></span>
                                </div>
                            </div>
                            
                            
                        </div>
                    </div>
                </div>
            </div>
        </form>
        
        <form id="myform" name="myform" method="POST">
            <div class="md:flex items-start space-x-6 mb-6">
                <!-- Left Column - Patient Information -->
                <div class="bg-white w-1/2 shadow overflow-hidden sm:rounded-lg">
                    <div class="px-4 py-5 sm:px-6 border-b">
                        <div class="md:flex justify-between">
                            <div>
                                <h3 class="text-lg leading-6 font-medium text-gray-900">Service Information</h3>
                            </div>
                        </div>
                    </div>
                    
                    <div>
                        
                        
                        <div id="tab-primary" class="g-tab-content2 current">
                            <div class="border-b mb-4">
                                <h4 class="px-4 py-2 bg-gray-100 font-medium">Service Line 1</h4>
                                <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Procedure Code</label>
                                    <span class="w-3/4"><?= $data->procedure_code ?? 'N/A' ?></span>
                                </div>
                                <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Modifier</label>
                                    <span class="w-3/4"><?= $data->modifier ?? 'N/A' ?></span>
                                </div>
                                <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Charge Amount</label>
                                    <span class="w-3/4">$<?= number_format($data->charge_amount ?? 0, 2) ?></span>
                                </div>
                                <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Units</label>
                                    <span class="w-3/4"><?= $data->unit_count ?? 'N/A' ?></span>
                                </div>
                                <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Date of Service</label>
                                    <span class="w-3/4">
                                        <?php
                                        $date = $data->date_of_service ?? null;
                                        echo $date ? date('m/d/Y', strtotime($date)) : 'N/A';
                                        ?>
                                    </span>
                                </div>
                                <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Diagnosis Pointer</label>
                                    <span class="w-3/4"><?= $data->diagnosis_pointer ?? 'N/A' ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                
            </div>
        </form>
    </div>
</main>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
window.onload = displayClock();
function displayClock() {
const currentDate = new Date(new Date().toLocaleString("en-US", {
timeZone: "America/New_York"
}));
var timestamp = currentDate.toString().split('GMT');
var splitstring = timestamp[0].split(" ");
var final_string = splitstring[0] + ', ' + splitstring[1] + ' ' + splitstring[2] + ' ' + splitstring[3] +
', ' + splitstring[4];
$("#clock").text(final_string);
setTimeout(displayClock, 1000);
}
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/klyretmp/public_html/edi/resources/views/system_file_details.blade.php ENDPATH**/ ?>