
<?php $__env->startSection('content'); ?>
<header class="g-header md:pb-32">
    <div class="container">

        <div class="border-b border-gray-700">
            <div class="flex items-center justify-between h-16 px-4 sm:px-0">
                <div class="flex items-center">
                    <div class="flex-shrink-0">
                        <a href="javascript:void(0)" style="text-decoration: none;" class="font-light block text-center text-white text-2xl">Klyre<span class="font-bold">Payments</span></a>
                    </div>
                    <div class="hidden md:block">
                        <div class="ml-10 flex items-baseline space-x-4">
                            <nav>
                                <ul class="mainmenu">
                                    <li>
                                        <a href="javascript:void(0)" class="menuitem"style="text-decoration: none;">Dashboard</a>
                                    </li>
                                    <li>
                                        <a href="<?php echo e(route('dashboard')); ?>" class="menuitem"style="text-decoration: none;">EDI Files</a>
                                    </li>
                                    
                                </ul>
                            </nav>
                        </div>
                    </div>
                </div>
                <?php echo $__env->make('message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="hidden md:block text-right">
                    <div class="flex divide-x divide-gray-500">
                        <div class="text-white text-right text-sm ml-auto pr-6">
                            <p id="clock" class="font-medium">Thu, Sep 19 2024, 05:17:34</p>
                            <p class="text-gray-400 text-xs">New York</p>
                        </div>
                        <div class="text-sm pl-6">
                            <p class="text-white font-medium">Super User</p>
                            <form method="POST" action="<?php echo e(route('logout')); ?>">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="text-gray-400 text-xs hover:underline hover:text-white focus:text-white focus:ring-offset-2">Log out</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
    document.addEventListener('DOMContentLoaded', function () {
    var dropdownItems = document.querySelectorAll('.menu-item-has-children');
    var dropdowns = document.querySelectorAll('.menu-item-has-children .mainmenu-sub-menu');
    var delay = 2000;
    if (dropdownItems) {
    dropdownItems.forEach((dropdownItem, count) => {
    dropdownItem.addEventListener('mouseenter', function (e) {
    dropdowns[count].classList.add('dropdown-show');
    });
    dropdownItem.addEventListener('mouseleave', function () {
    dropdowns[count].classList.remove('dropdown-show');
    });
    });
    }
    })
    </script>
    <div class="container btn-container">
        
        <div class="md:py-10 py-5 md:flex md:items-end md:justify-between w-full">
                <h1 class="text-3xl font-bold md:text-white">Details</h1>
                <div class="flex flex-wrap items-center gap-1">
                    
                   
                    
                
                    
                    <?php if($file->status == "P"): ?>
                    <a href="<?php echo e(route('generate.sftp.999', $file->id)); ?>"
                        class=" btn text-white bg-indigo-600 hover:bg-indigo-700 ">
                        Generate 999
                    </a>
                    <?php elseif($file->status == "G"): ?>
                    <a href="<?php echo e(route('send.sftp.999', $file->id)); ?>"
                        class=" btn text-white bg-indigo-600 hover:bg-indigo-700 ">
                        Send 999 Ack
                    </a>
                    <?php endif; ?>
                    <?php if($file->file_string): ?>
                    <a href="<?php echo e(route('downlode.sftp.file', $file->id)); ?>"
                        class=" btn text-white bg-indigo-600 hover:bg-indigo-700 ">
                        Download <?php echo e($file->file_type == "837" ? '837 - Claims' : '275 - Attachments'); ?>

                    </a>
                    <?php endif; ?>
                    <?php if($file->ack_file_string): ?>
                    <a href="<?php echo e(route('downlode.ack.file', $file->id)); ?>"
                        class=" btn text-white bg-indigo-600 hover:bg-indigo-700 ">
                        Download Ack
                    </a>
                    <?php endif; ?>
                </div>
        </div>
    </div>
</header>
<?php $__env->startSection('content'); ?>







<main class="md:-mt-32 mt-5">
    <div class="container">
        
        <?php
        $startIndex=1;
        ?>
        <?php if(count($data['claims']) > 1): ?>
        <div class="mb-6 bg-white p-4 rounded-lg shadow">
            <h3 class="text-lg font-medium mb-2">Claims in this File</h3>
            <div class="flex flex-wrap gap-2">
                <?php $__currentLoopData = $data['claims']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $claim): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if(count($claim['services'])>0): ?>
                <a href="#claim-<?php echo e($index); ?>" class="px-3 py-1 bg-blue-100 text-blue-800 rounded hover:bg-blue-200">
                    Claim #<?php echo e($startIndex); ?> (<?php echo e($claim['claim_info']['number'] ?? 'N/A'); ?>)
                </a>
                <?php
                $startIndex+=1;
                ?>
                <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
        <?php endif; ?>


        <?php
        $startIndex=1;
        ?>
        <?php $__currentLoopData = $data['claims']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $claimIndex => $claim): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
        // dd(count($claim['services']));
        ?>
        <?php if(count($claim['services'])>0): ?>
        <div id="claim-<?php echo e($startIndex); ?>" class="mb-10 border-b pb-10">
            
            <form id="myform" name="myform" method="POST">
                <div class="md:flex items-start space-x-6 mb-6">
                    <!-- Left Column - Claim Information -->
                    <div class="bg-white w-1/2 shadow overflow-hidden sm:rounded-lg">
                        <div class="px-4 py-5 sm:px-6 border-b">
                            <div class="md:flex justify-between">
                                <div>
                                    <h3 class="text-lg leading-6 font-medium text-gray-900">
                                    Claim Information
                                    <?php if(count($data['claims']) > 1): ?>
                                    <span class="text-sm text-gray-500">(Claim #<?php echo e($startIndex); ?>)</span>
                                    <?php endif; ?>
                                    </h3>
                                </div>
                            </div>
                        </div>
                        
                        <div>
                            <div id="tab-primary" class="g-tab-content2 current">
                                <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Claim Number</label>
                                    <span class="w-3/4"><?php echo e($claim['claim_info']['number'] ?? 'N/A'); ?></span>
                                </div>
                                <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Claim Amount</label>
                                    <span class="w-3/4">$<?php echo e(number_format($claim['claim_info']['amount'] ?? 0, 2)); ?></span>
                                </div>
                                <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Place of Service</label>
                                    <?php
                                    $code = $claim['claim_info']['place_of_service'] ?? 'N/A';
                                    $posText = '';
                                    if ($code === '11') {
                                    $posText = 'Office';
                                    } elseif ($code === '12') {
                                    $posText = 'Home';
                                    } elseif ($code === '21') {
                                    $posText = 'Inpatient Hospital';
                                    } elseif ($code === '22') {
                                    $posText = 'Outpatient Hospital';
                                    } elseif ($code === '23') {
                                    $posText = 'Emergency Room';
                                    } elseif ($code === '24') {
                                    $posText = 'Ambulatory Surgical Center';
                                    } elseif ($code === '31') {
                                    $posText = 'Skilled Nursing Facility';
                                    } elseif ($code === '32') {
                                    $posText = 'Nursing Facility';
                                    } elseif ($code === '33') {
                                    $posText = 'Custodial Care Facility';
                                    } elseif ($code === '34') {
                                    $posText = 'Hospice';
                                    } elseif ($code === '41') {
                                    $posText = 'Ambulance - Land';
                                    } elseif ($code === '42') {
                                    $posText = 'Ambulance - Air or Water';
                                    } elseif ($code === '49') {
                                    $posText = 'Independent Clinic';
                                    } elseif ($code === '50') {
                                    $posText = 'Federally Qualified Health Center';
                                    } elseif ($code === '71') {
                                    $posText = 'State or Local Public Health Clinic';
                                    } elseif ($code === '72') {
                                    $posText = 'Rural Health Clinic';
                                    } else {
                                    $posText = "Office";
                                    }
                                    ?>
                                    <span class="w-3/4">
                                        <?php echo e($posText); ?>

                                    </span>
                                </div>
                                <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Claim Type</label>
                                    <span class="w-3/4">
                                        <?php echo e($data['meta']['edi_type'] == 'I' ? 'Institutional' :
                                        ($data['meta']['edi_type'] == 'D' ? 'Dental' : 'Professional')); ?>

                                    </span>
                                </div>
                                <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Primary Diagnosis</label>
                                    <span class="w-3/4">
                                        <?php if(!empty($claim['diagnosis_codes'])): ?>
                                        <?php echo e($claim['diagnosis_codes'][0]['code'] ?? 'N/A'); ?>

                                        <?php else: ?>
                                        N/A
                                        <?php endif; ?>
                                    </span>
                                </div>
                                
                                <?php if($data['meta']['edi_type'] == 'I' && isset($claim['institutional_info'])): ?>
                                <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Admission Type</label>
                                    <span class="w-3/4"><?php echo e($claim['institutional_info']['admission_type'] ?? 'N/A'); ?></span>
                                </div>
                                <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Patient Status</label>
                                    <span class="w-3/4"><?php echo e($claim['institutional_info']['patient_status'] ?? 'N/A'); ?></span>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Right Column - Patient Info -->
                    <div class="bg-white w-1/2 shadow overflow-hidden sm:rounded-lg">
                        <div class="px-4 py-5 sm:px-6 border-b">
                            <div class="md:flex justify-between">
                                <div>
                                    <h3 class="text-lg leading-6 font-medium text-gray-900">Patient Information</h3>
                                </div>
                            </div>
                        </div>
                        
                        <div>
                            <div id="tab-primary" class="g-tab-content2 current">
                                <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Patient Name</label>
                                    <span class="w-3/4">
                                        <?php echo e($claim['patient']['first_name'] ?? ''); ?>

                                        <?php echo e($claim['patient']['last_name'] ?? ''); ?>

                                    </span>
                                </div>
                                <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Member ID</label>
                                    <span class="w-3/4"><?php echo e($claim['patient']['id_code'] ?? 'N/A'); ?></span>
                                </div>
                                <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Date of Birth</label>
                                    <span class="w-3/4">
                                        <?php if(!empty($claim['patientnew']['dob'])): ?>
                                        <?php echo e(date('m/d/Y', strtotime($claim['patientnew']['dob']))); ?>

                                        <?php else: ?>
                                        N/A
                                        <?php endif; ?>
                                    </span>
                                </div>
                                <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Gender</label>
                                    <span class="w-3/4">
                                        <?php if(isset($claim['patientnew']['gender'])): ?>
                                        <?php echo e($claim['patientnew']['gender'] == 'M' ? 'Male' : 'Female'); ?>

                                        <?php else: ?>
                                        N/A
                                        <?php endif; ?>
                                    </span>
                                </div>
                                <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Address</label>
                                    <span class="w-3/4">
                                        <?php if(isset($claim['patient']['address']['street1'])): ?>
                                        <?php echo e($claim['patient']['address']['street1']); ?>

                                        <?php echo e($claim['patient']['address']['street2'] ?? ''); ?><br>
                                        <?php echo e($claim['patient']['address']['city'] ?? ''); ?>,
                                        <?php echo e($claim['patient']['address']['state'] ?? ''); ?>

                                        <?php echo e(isset($claim['patient']['address']['zip']) ? substr($claim['patient']['address']['zip'], 0, 5) : ''); ?>

                                        <?php else: ?>
                                        N/A
                                        <?php endif; ?>
                                    </span>
                                </div>
                                <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Payer</label>
                                    <span class="w-3/4">
                                        <?php echo e($data['payers'][0]['last_name'] ?? 'N/A'); ?>

                                        (<?php echo e($data['payers'][0]['id_code'] ?? ''); ?>)
                                    </span>
                                </div>
                                <?php if(isset($claim['subscriber_info'])): ?>
                                <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Subscriber</label>
                                    <span class="w-3/4">
                                        <?php echo e($claim['subscriber_info']['group_number'] ?? 'N/A'); ?>

                                        (<?php echo e($claim['subscriber_info']['insurance_type'] ?? ''); ?>)
                                    </span>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
            
            
            <form id="myform" name="myform" method="POST">
                <div class="md:flex items-start space-x-6 mb-6">
                    <!-- left Column - Provider & Transmission Info -->
                    <div class="w-1/2">
                        <div class="bg-white shadow overflow-hidden sm:rounded-lg">
                            <div class="px-4 py-5 sm:px-6 border-b">
                                <div class="md:flex justify-between">
                                    <div>
                                        <h3 class="text-lg leading-6 font-medium text-gray-900">Provider Details</h3>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="pt-3 border-b">
                                <div id="tab-1" class="g-tab-content current">
                                    <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                        <label class="c-label w-1/3">Provider Name</label>
                                        <span class="w-3/4"><?php echo e($data['providers'][0]['last_name'] ?? 'N/A'); ?></span>
                                    </div>
                                    <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                        <label class="c-label w-1/3">NPI</label>
                                        <span class="w-3/4"><?php echo e($data['providers'][0]['id_code'] ?? 'N/A'); ?></span>
                                    </div>
                                    <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                        <label class="c-label w-1/3">Tax ID</label>
                                        <span class="w-3/4"><?php echo e($data['providers'][0]['tax_id'] ?? 'N/A'); ?></span>
                                    </div>
                                    <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                        <label class="c-label w-1/3">Address</label>
                                        <span class="w-3/4">
                                            <?php if(isset($data['providers'][0]['address']['street1'])): ?>
                                            <?php echo e($data['providers'][0]['address']['street1']); ?><br>
                                            <?php echo e($data['providers'][0]['address']['city'] ?? ''); ?>,
                                            <?php echo e($data['providers'][0]['address']['state'] ?? ''); ?>

                                            <?php echo e($data['providers'][0]['address']['zip'] ?? ''); ?>

                                            <?php else: ?>
                                            N/A
                                            <?php endif; ?>
                                        </span>
                                    </div>
                                    
                                    <!-- Service Lines -->
                                    <?php if(!empty($claim['services'])): ?>
                                    <div class="bg-white px-4 py-5">
                                        <h4 class="font-medium mb-3">Service Lines</h4>
                                        <?php $__currentLoopData = $claim['services']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="mb-4 border-b pb-4">
                                            <div class="font-medium">Line #<?php echo e($service['line_number'] ?? ''); ?></div>
                                            <div class="mt-2">
                                                <span class="block">
                                                    <strong>Procedure:</strong>
                                                    <?php echo e($service['service']['code'] ?? 'N/A'); ?>

                                                    <?php if(!empty($service['service']['modifier'])): ?>
                                                    (Modifier: <?php echo e($service['service']['modifier']); ?>)
                                                    <?php endif; ?>
                                                </span>
                                                <span class="block">
                                                    <strong>Amount:</strong> $<?php echo e(number_format($service['service']['amount'] ?? 0, 2)); ?>

                                                </span>
                                                <span class="block">
                                                    <strong>Units:</strong> <?php echo e($service['service']['units'] ?? 1); ?>

                                                </span>
                                                <?php if(!empty($service['dates'])): ?>
                                                <?php $__currentLoopData = $service['dates']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $date): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <span class="block">
                                                    <strong>DOS:</strong> <?php echo e(date('m/d/Y', strtotime($date['date']))); ?>

                                                </span>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                                <?php if($data['meta']['edi_type'] == 'D' && isset($service['tooth_info'])): ?>
                                                <span class="block">
                                                    <strong>Tooth:</strong> <?php echo e($service['tooth_info']['number'] ?? ''); ?>

                                                    (<?php echo e($service['tooth_info']['code'] ?? ''); ?>)
                                                </span>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    
                    <div class="w-1/2">
                        <div class="bg-white shadow overflow-hidden sm:rounded-lg">
                            <div class="px-4 py-5 sm:px-6 border-b">
                                <div class="md:flex justify-between">
                                    <div>
                                        <h3 class="text-lg leading-6 font-medium text-gray-900">Transmission Details</h3>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="pt-3 border-b">
                                <div id="tab-1" class="g-tab-content current">
                                    <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                        <label class="c-label w-1/3">Submitter</label>
                                        <span class="w-3/4">
                                            <?php echo e($data['submitters'][0]['last_name'] ?? 'N/A'); ?>

                                            (<?php echo e($data['submitters'][0]['id_code'] ?? ''); ?>)
                                        </span>
                                    </div>
                                    <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                        <label class="c-label w-1/3">Receiver</label>
                                        <span class="w-3/4">
                                            <?php echo e($data['payers'][0]['last_name'] ?? 'N/A'); ?>

                                            (<?php echo e($data['payers'][0]['id_code'] ?? ''); ?>)
                                        </span>
                                    </div>
                                    <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                        <label class="c-label w-1/3">Transmission Date/Time</label>
                                        <span class="w-3/4">
                                            <?php echo e(date('m/d/Y', strtotime($data['meta']['interchange']['date']))); ?>

                                            <?php echo e($data['meta']['interchange']['time'] ?? ''); ?>

                                        </span>
                                    </div>
                                    <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                        <label class="c-label w-1/3">File Type</label>
                                        <span class="w-3/4">
                                            Health Care Claim -
                                            <?php if($data['meta']['edi_type'] == 'I'): ?> Institutional (837I)
                                            <?php elseif($data['meta']['edi_type'] == 'D'): ?> Dental (837D)
                                            <?php else: ?> Professional (837P)
                                            <?php endif; ?>
                                        </span>
                                    </div>
                                    <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                        <label class="c-label w-1/3">Version</label>
                                        <span class="w-3/4"><?php echo e($data['meta']['functional_group']['version'] ?? 'N/A'); ?></span>
                                    </div>
                                    <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                        <label class="c-label w-1/3">Control Number</label>
                                        <span class="w-3/4"><?php echo e($data['meta']['interchange']['control_number'] ?? 'N/A'); ?></span>
                                    </div>
                                    <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                        <label class="c-label w-1/3">Sender ID</label>
                                        <span class="w-3/4"><?php echo e($data['meta']['interchange']['sender_id'] ?? 'N/A'); ?></span>
                                    </div>
                                    <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                        <label class="c-label w-1/3">Receiver ID</label>
                                        <span class="w-3/4"><?php echo e($data['meta']['interchange']['receiver_id'] ?? 'N/A'); ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>














            
            
            
            <form id="myform" name="myform" method="POST">
    <div class="md:flex items-start space-x-6 mb-6">
        <!-- Left Column - other Information -->
        <div class="w-full">
            <div class="bg-white shadow overflow-hidden sm:rounded-lg">
                <div class="px-4 py-5 sm:px-6 border-b">
                    <div class="md:flex justify-between">
                        <div>
                            <h3 class="text-lg leading-6 font-medium text-gray-900">Diagnosis & Additional Information</h3>
                        </div>
                    </div>
                </div>
                
                <div class="pt-3 border-b">
                    <div id="tab-1" class="g-tab-content current">
                        <?php if(!empty($claim['diagnosis_codes'])): ?>
                        <div class="bg-white px-4 py-5">
                            <h4 class="font-medium mb-3">Diagnosis Codes</h4>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <?php $__currentLoopData = $claim['diagnosis_codes']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $diag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="border p-3 rounded">
                                    <span class="font-medium"><?php echo e($diag['type']); ?>:</span>
                                    <?php echo e($diag['code']); ?>

                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                        <?php endif; ?>
                        
                        <?php if(!empty($claim['dates'])): ?>
                        <div class="bg-gray-50 px-4 py-5">
                            <h4 class="font-medium mb-3">Important Dates</h4>
                            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                                <?php $__currentLoopData = $claim['dates']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $date): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="border p-3 rounded bg-white">
                                    <span class="font-medium"><?php echo e($date['type']); ?>:</span>
                                    <?php echo e(date('m/d/Y', strtotime($date['date']))); ?>

                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                        <?php endif; ?>

                        <!-- Employee Information -->
                        <?php if(!empty($data['additional']['36'][$claimIndex-1]['emp_name']) || !empty($data['additional']['36'][$claimIndex-1]['id'])): ?>
                        <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                            <div class="w-full">
                                <h4 class="font-medium mb-3">Employee Information</h4>
                                <?php if(!empty($data['additional']['36'][$claimIndex-1]['emp_name'])): ?>
                                <div class="flex items-start mb-2">
                                    <label class="c-label w-1/3">Employee Name</label>
                                    <span class="w-3/4"><?php echo e($data['additional']['36'][$claimIndex-1]['emp_name']); ?></span>
                                </div>
                                <?php endif; ?>
                                <?php if(!empty($data['additional']['36'][$claimIndex-1]['id'])): ?>
                                <div class="flex items-start">
                                    <label class="c-label w-1/3">Employee ID</label>
                                    <span class="w-3/4"><?php echo e($data['additional']['36'][$claimIndex-1]['id']); ?></span>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php endif; ?>

                        <!-- Payer Information -->
                        <?php if(!empty($data['additional']['PR'][$claimIndex]['other_payer_name']) || !empty($data['additional']['PR'][$claimIndex]['policy_number'])): ?>
                        <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                            <div class="w-full">
                                <h4 class="font-medium mb-3">Payer Information</h4>
                                <?php if(!empty($data['additional']['PR'][$claimIndex]['other_payer_name'])): ?>
                                <div class="flex items-start mb-2">
                                    <label class="c-label w-1/3">Payer Name</label>
                                    <span class="w-3/4"><?php echo e($data['additional']['PR'][$claimIndex]['other_payer_name']); ?></span>
                                </div>
                                <?php endif; ?>
                                <?php if(!empty($data['additional']['PR'][$claimIndex]['policy_number'])): ?>
                                <div class="flex items-start">
                                    <label class="c-label w-1/3">Policy Number</label>
                                    <span class="w-3/4"><?php echo e($data['additional']['PR'][$claimIndex]['policy_number']); ?></span>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php endif; ?>

                        <!-- Location Information -->
                        <?php
                            $pickup = $data['additional']['pickup_location'][$startIndex-1] ?? [];
                            $dropoff = $data['additional']['dropoff_location'][$startIndex-1] ?? [];
                        ?>

                        <?php if(!empty($pickup) || !empty($dropoff)): ?>
                        <div class="bg-gray-50 px-4 py-5">
                            <h4 class="font-medium mb-3">Location Information</h4>
                            
                            <?php if(!empty($pickup)): ?>
                            <div class="mb-4">
                                <h5 class="font-medium mb-2">Pickup Location</h5>
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                    <?php $__currentLoopData = $pickup; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(!empty($value)): ?>
                                        <div class="flex items-start">
                                            <label class="c-label w-1/3"><?php echo e(ucfirst($key)); ?></label>
                                            <span class="w-3/4"><?php echo e($value); ?></span>
                                        </div>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                            <?php endif; ?>
                            
                            <?php if(!empty($dropoff)): ?>
                            <div>
                                <h5 class="font-medium mb-2">Dropoff Location</h5>
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                    <?php $__currentLoopData = $dropoff; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(!empty($value)): ?>
                                        <div class="flex items-start">
                                            <label class="c-label w-1/3"><?php echo e(ucfirst($key)); ?></label>
                                            <span class="w-3/4"><?php echo e($value); ?></span>
                                        </div>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                            <?php endif; ?>
                        </div>
                        <?php endif; ?>

                        <!-- Chiropractic Information -->
                        <?php
                            $chiropractic = $data['additional']['chiropractic'][$startIndex] ?? [];
                        ?>

                        <?php if(!empty($chiropractic)): ?>
                        <div class="bg-white px-4 py-5">
                            <h4 class="font-medium mb-3">Chiropractic Information</h4>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <?php $__currentLoopData = $chiropractic; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if(!empty($value)): ?>
                                    <div class="flex items-start">
                                        <label class="c-label w-1/3"><?php echo e(ucfirst($key)); ?></label>
                                        <span class="w-3/4">
                                            <?php if($key == 'spinal_region'): ?>
                                                <?php switch($value):
                                                    case ('A'): ?> All Regions <?php break; ?>
                                                    <?php case ('C'): ?> Cervical <?php break; ?>
                                                    <?php case ('D'): ?> Dorsal (Thoracic) <?php break; ?>
                                                    <?php case ('E'): ?> Lumbar <?php break; ?>
                                                    <?php case ('F'): ?> Sacroiliac <?php break; ?>
                                                    <?php case ('G'): ?> Coccygeal <?php break; ?>
                                                    <?php case ('M'): ?> Multiple Regions <?php break; ?>
                                                    <?php default: ?> Unknown Region
                                                <?php endswitch; ?>
                                            <?php else: ?>
                                                <?php echo e($value); ?>

                                            <?php endif; ?>
                                        </span>
                                    </div>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                        <?php endif; ?>

                        <!-- DME Information -->
                        <?php
                            $dme_certification = $data['additional']['dme_certification'][$startIndex] ?? [];
                            $dme_dates = $data['additional']['dme_dates'][$startIndex] ?? [];
                            $group_info = $data['additional']['group_info'][$startIndex] ?? [];
                            $forms = $data['additional']['forms'][$startIndex] ?? [];
                            $dme_documentation = $data['additional']['dme_documentation'][$startIndex] ?? [];
                            $provider_contact = $data['additional']['provider_contacts'][$startIndex] ?? [];
                        ?>

                        <?php if(!empty($dme_certification) || !empty($dme_documentation)): ?>
                        <div class="bg-gray-50 px-4 py-5">
                            <h4 class="font-medium mb-3">DME Details</h4>
                            
                            <?php if(!empty($dme_documentation)): ?>
                            <div class="mb-4">
                                <h5 class="font-medium mb-2">Documentation</h5>
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                    <?php if(!empty($dme_documentation['documentation_type'])): ?>
                                    <div class="flex items-start">
                                        <label class="c-label w-1/3">Documentation Type</label>
                                        <span class="w-3/4"><?php echo e($dme_documentation['documentation_type']); ?></span>
                                    </div>
                                    <?php endif; ?>
                                    
                                    <?php if(!empty($dme_documentation['transmission_code'])): ?>
                                    <div class="flex items-start">
                                        <label class="c-label w-1/3">Transmission Code</label>
                                        <span class="w-3/4"><?php echo e($dme_documentation['transmission_code']); ?></span>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <?php endif; ?>
                            
                            <?php if(!empty($provider_contact)): ?>
                            <div class="mb-4">
                                <h5 class="font-medium mb-2">Provider Contact</h5>
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                    <?php if(!empty($provider_contact['name'])): ?>
                                    <div class="flex items-start">
                                        <label class="c-label w-1/3">Name</label>
                                        <span class="w-3/4"><?php echo e($provider_contact['name']); ?></span>
                                    </div>
                                    <?php endif; ?>
                                    
                                    <?php if(!empty($provider_contact['phone'])): ?>
                                    <div class="flex items-start">
                                        <label class="c-label w-1/3">Phone</label>
                                        <span class="w-3/4">
                                            <?php echo e($provider_contact['phone']); ?>

                                            <?php if(!empty($provider_contact['communication_method'])): ?>
                                            (<?php echo e($provider_contact['communication_method']); ?>)
                                            <?php endif; ?>
                                        </span>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <?php endif; ?>
                            
                            <?php if(!empty($dme_certification)): ?>
                            <div class="mb-4">
                                <h5 class="font-medium mb-2">Certification Details</h5>
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                    <?php if(!empty($dme_certification['certification_type'])): ?>
                                    <div class="flex items-start">
                                        <label class="c-label w-1/3">Certification Type</label>
                                        <span class="w-3/4"><?php echo e($dme_certification['certification_type']); ?></span>
                                    </div>
                                    <?php endif; ?>
                                    
                                    <?php if(!empty($dme_certification['equipment_type'])): ?>
                                    <div class="flex items-start">
                                        <label class="c-label w-1/3">Equipment Type</label>
                                        <span class="w-3/4"><?php echo e($dme_certification['equipment_type']); ?></span>
                                    </div>
                                    <?php endif; ?>
                                    
                                    <?php if(!empty($dme_certification['quantity'])): ?>
                                    <div class="flex items-start">
                                        <label class="c-label w-1/3">Quantity</label>
                                        <span class="w-3/4"><?php echo e($dme_certification['quantity']); ?></span>
                                    </div>
                                    <?php endif; ?>
                                    
                                    <?php if(!empty($group_info['group_number'])): ?>
                                    <div class="flex items-start">
                                        <label class="c-label w-1/3">Group Number</label>
                                        <span class="w-3/4"><?php echo e($group_info['group_number']); ?></span>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            
                            <div class="mb-4">
                                <h5 class="font-medium mb-2">Dates</h5>
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                    <?php if(!empty($dme_dates['service_date'])): ?>
                                    <div class="flex items-start">
                                        <label class="c-label w-1/3">Service Date</label>
                                        <span class="w-3/4"><?php echo e($dme_dates['service_date']); ?></span>
                                    </div>
                                    <?php endif; ?>
                                    
                                    <?php if(!empty($dme_dates['certification_start_date'])): ?>
                                    <div class="flex items-start">
                                        <label class="c-label w-1/3">Certification Start</label>
                                        <span class="w-3/4"><?php echo e($dme_dates['certification_start_date']); ?></span>
                                    </div>
                                    <?php endif; ?>
                                    
                                    <?php if(!empty($dme_dates['last_certification_date'])): ?>
                                    <div class="flex items-start">
                                        <label class="c-label w-1/3">Last Certification</label>
                                        <span class="w-3/4"><?php echo e($dme_dates['last_certification_date']); ?></span>
                                    </div>
                                    <?php endif; ?>
                                    
                                    <?php if(!empty($dme_dates['recertification_date'])): ?>
                                    <div class="flex items-start">
                                        <label class="c-label w-1/3">Recertification Due</label>
                                        <span class="w-3/4"><?php echo e($dme_dates['recertification_date']); ?></span>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <?php endif; ?>
                            
                            <?php if(!empty($forms)): ?>
                            <div>
                                <h5 class="font-medium mb-2">Forms</h5>
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                    <?php if(!empty($forms['form_identifier'])): ?>
                                    <div class="flex items-start">
                                        <label class="c-label w-1/3">Form Identifier</label>
                                        <span class="w-3/4"><?php echo e($forms['form_identifier']); ?></span>
                                    </div>
                                    <?php endif; ?>
                                    
                                    <?php if(!empty($forms['form_1a'])): ?>
                                    <div class="flex items-start">
                                        <label class="c-label w-1/3">Form 1A</label>
                                        <span class="w-3/4"><?php echo e($forms['form_1a']); ?></span>
                                    </div>
                                    <?php endif; ?>
                                    
                                    <?php if(!empty($forms['form_1c'])): ?>
                                    <div class="flex items-start">
                                        <label class="c-label w-1/3">Form 1C</label>
                                        <span class="w-3/4"><?php echo e($forms['form_1c']); ?></span>
                                    </div>
                                    <?php endif; ?>
                                    
                                    <?php if(!empty($forms['form_9'])): ?>
                                    <div class="flex items-start">
                                        <label class="c-label w-1/3">Form 9</label>
                                        <span class="w-3/4"><?php echo e($forms['form_9']); ?></span>
                                    </div>
                                    <?php endif; ?>
                                    
                                    <?php if(!empty($forms['form_data']) && empty($forms['form_9'])): ?>
                                    <div class="flex items-start">
                                        <label class="c-label w-1/3">Form Data</label>
                                        <span class="w-3/4"><?php echo e(json_encode($forms['form_data'])); ?></span>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <?php endif; ?>
                        </div>
                        <?php endif; ?>

                        <!-- NDC Information -->
                        <?php
                            $ndc_info = $data['additional']['ndc_info'][$startIndex] ?? [];
                        ?>

                        <?php if(!empty($ndc_info)): ?>
                        <div class="bg-white px-4 py-5">
                            <h4 class="font-medium mb-3">NDC Information</h4>
                            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                                <?php if(!empty($ndc_info['code'])): ?>
                                <div class="flex items-start">
                                    <label class="c-label w-1/3">NDC Code</label>
                                    <span class="w-3/4"><?php echo e($ndc_info['code']); ?></span>
                                </div>
                                <?php endif; ?>
                                
                                <?php if(!empty($ndc_info['quantity'])): ?>
                                <div class="flex items-start">
                                    <label class="c-label w-1/3">Quantity</label>
                                    <span class="w-3/4"><?php echo e($ndc_info['quantity']); ?></span>
                                </div>
                                <?php endif; ?>
                                
                                <?php if(!empty($ndc_info['unit'])): ?>
                                <div class="flex items-start">
                                    <label class="c-label w-1/3">Unit</label>
                                    <span class="w-3/4"><?php echo e($ndc_info['unit']); ?></span>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php endif; ?>

                        <!-- Pricing & Network Information -->
                        <?php
                            $ppo_info = $data['additional']['ppo_info'][$startIndex] ?? [];
                            $pricing_info = $data['additional']['pricing_info'][$startIndex] ?? [];
                        ?>

                        <?php if(!empty($ppo_info) || !empty($pricing_info)): ?>
                        <div class="bg-gray-50 px-4 py-5">
                            <h4 class="font-medium mb-3">Pricing & Network Information</h4>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <?php if(!empty($ppo_info['network_id'])): ?>
                                <div class="flex items-start">
                                    <label class="c-label w-1/3">PPO Network ID</label>
                                    <span class="w-3/4"><?php echo e($ppo_info['network_id']); ?></span>
                                </div>
                                <?php endif; ?>
                                
                                <?php if(!empty($pricing_info['repriced_amount'])): ?>
                                <div class="flex items-start">
                                    <label class="c-label w-1/3">Repriced Amount</label>
                                    <span class="w-3/4">$<?php echo e(number_format($pricing_info['repriced_amount'], 2)); ?></span>
                                </div>
                                <?php endif; ?>
                                
                                <?php if(!empty($pricing_info['price_indicator'])): ?>
                                <div class="flex items-start">
                                    <label class="c-label w-1/3">Price Indicator</label>
                                    <span class="w-3/4"><?php echo e($pricing_info['price_indicator']); ?></span>
                                </div>
                                <?php endif; ?>
                                
                                <?php if(!empty($pricing_info['service_code'])): ?>
                                <div class="flex items-start">
                                    <label class="c-label w-1/3">Service Code</label>
                                    <span class="w-3/4"><?php echo e($pricing_info['service_code']); ?></span>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>













        </div>
        <?php
        $startIndex+=1;
        ?>
        <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</main><script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
window.onload = displayClock();
function displayClock() {
const currentDate = new Date(new Date().toLocaleString("en-US", {
timeZone: "America/New_York"
}));
var timestamp = currentDate.toString().split('GMT');
var splitstring = timestamp[0].split(" ");
var final_string = splitstring[0] + ', ' + splitstring[1] + ' ' + splitstring[2] + ' ' + splitstring[3] +
', ' + splitstring[4];
$("#clock").text(final_string);
setTimeout(displayClock, 1000);
}
</script>




<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/klyretmp/public_html/edi/resources/views/sftp/view_sftp_837_file_data.blade.php ENDPATH**/ ?>