<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>837P EDI Form</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .form-group{
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <div class="container mt-5">
        <h2>837P EDI File Generator</h2>
        <form action="<?php echo e(route('generate.edi')); ?>" method="POST">
            <?php echo csrf_field(); ?>

            <div class="mt-4">
                <h4>Interchange and Functional Group Headers</h4>
                <div class="mb-3">
                    <label for="sender_id" class="form-label">Sender ID (ISA06):</label>
                    <input type="text" id="sender_id" name="sender_id" value="581651222" required class="form-control">
                </div>

                <div class="mb-3">
                    <label for="receiver_id" class="form-label">Receiver ID (ISA08):</label>
                    <input type="text" id="receiver_id" name="receiver_id" value="KLYREPAY" required class="form-control">
                </div>

                <div class="mb-3">
                    <label for="transmission_date" class="form-label">Date of Transmission (YYMMDD):</label>
                    <input type="text" id="transmission_date" name="transmission_date" value="250211" required class="form-control">
                </div>

                <div class="form-group">
                    <label for="transmission_time">Time of Transmission (HHMM)</label>
                    <input type="text" name="transmission_time" id="transmission_time" class="form-control" required pattern="\d{4}" maxlength="4" placeholder="e.g., 1430" value="1430" >
                </div>

                <div class="form-group">
                    <label for="control_number">Control Number (ISA)</label>
                    <input type="text" name="control_number" id="control_number" class="form-control" required placeholder="Enter Unique Control Number" value="123500377">
                </div>
            </div>







           <div class="mt-4">
            <h4>GS SEGMENT</h4>
            <div class="form-group">
                <label for="sender_code">Sender Code</label>
                <input type="text" name="sender_code" id="sender_code" class="form-control" required placeholder="Enter Sender Code" value="SENDER123">
            </div>

            <div class="form-group">
                <label for="receiver_code">Receiver Code</label>
                <input type="text" name="receiver_code" id="receiver_code" class="form-control" required placeholder="Enter Receiver Code" value="RECEIVER456">
            </div>

            <div class="form-group">
                <label for="gs_date">Date (CCYYMMDD)</label>
                <input type="text" name="gs_date" id="gs_date" class="form-control" required pattern="\d{8}" maxlength="8" placeholder="e.g., 20240705" value="20250310">
            </div>

            <div class="form-group">
                <label for="gs_time">Time (HHMM)</label>
                <input type="text" name="gs_time" id="gs_time" class="form-control" required pattern="\d{4}" maxlength="4" placeholder="e.g., 1430" value="0930">
            </div>

            <div class="form-group">
                <label for="gs_control_number">Control Number (GS)</label>
                <input type="text" name="gs_control_number" id="gs_control_number" class="form-control" required placeholder="Enter Unique Control Number" value="123096815">
            </div>
        </div>





        <div class="mt-4">
            <h4>Submitter and Receiver Information</h4>

            <!-- Submitter Information -->
            <div class="form-group">
                <label for="submitter_name">Submitter Name</label>
                <input type="text" name="submitter_name" id="submitter_name" class="form-control" required placeholder="Enter Submitter Name" value="ABC Health">
            </div>

            <div class="form-group">
                <label for="submitter_id">Submitter ID</label>
                <input type="text" name="submitter_id" id="submitter_id" class="form-control" required placeholder="Enter Submitter ID" value="SUB123456">
            </div>

            <!-- Receiver Information -->
            <div class="form-group">
                <label for="receiver_name">Receiver Name</label>
                <input type="text" name="receiver_name" id="receiver_name" class="form-control" required placeholder="Enter Receiver Name" value="XYZ Payer">
            </div>

            <div class="form-group">
                <label for="receiver_id">Receiver ID</label>
                <input type="text" name="receiver_id" id="receiver_id" class="form-control" required placeholder="Enter Receiver ID" value="REC789101">
            </div>
        </div>






    <div class="mt-4">
    <h4>Billing Provider Information (2010AA Loop)</h4>

    <!-- Provider Name -->
    <div class="form-group">
        <label for="provider_name">Provider Name</label>
        <input type="text" name="provider_name" id="provider_name" class="form-control" required 
               placeholder="Enter Provider Name" value="ABC Healthcare" maxlength="100" pattern="^[A-Za-z0-9\s\-]+$">
        <small class="text-danger" id="provider_name_error"></small>
    </div>

    <!-- National Provider Identifier (NPI) -->
    <div class="form-group">
        <label for="provider_npi">National Provider Identifier (NPI)</label>
        <input type="text" name="provider_npi" id="provider_npi" class="form-control" required 
               placeholder="Enter NPI" value="1234567890" maxlength="10" pattern="^\d{10}$">
        <small class="text-danger" id="provider_npi_error"></small>
    </div>

    <!-- Tax ID -->
    <div class="form-group">
        <label for="provider_tax_id">Tax ID (REF*EI)</label>
        <input type="text" name="provider_tax_id" id="provider_tax_id" class="form-control" required 
               placeholder="Enter Tax ID" value="12-3456789" maxlength="10" pattern="^\d{2}-\d{7}$">
        <small class="text-danger" id="provider_tax_id_error"></small>
    </div>

    <!-- Address Fields -->
    <div class="form-group">
        <label for="provider_street">Street Address</label>
        <input type="text" name="provider_street" id="provider_street" class="form-control" required 
               placeholder="Enter Street Address" value="123 Main St" maxlength="150">
        <small class="text-danger" id="provider_street_error"></small>
    </div>

    <div class="form-group">
        <label for="provider_city">City</label>
        <input type="text" name="provider_city" id="provider_city" class="form-control" required 
               placeholder="Enter City" value="New York" maxlength="50">
        <small class="text-danger" id="provider_city_error"></small>
    </div>

    <div class="form-group">
        <label for="provider_state">State</label>
        <input type="text" name="provider_state" id="provider_state" class="form-control" required 
               placeholder="Enter State" value="NY" maxlength="2" pattern="^[A-Z]{2}$">
        <small class="text-danger" id="provider_state_error"></small>
    </div>

    <div class="form-group">
        <label for="provider_zip">ZIP Code (9 digits)</label>
        <input type="text" name="provider_zip" id="provider_zip" class="form-control" required 
               placeholder="Enter ZIP Code" value="100010000" maxlength="9" pattern="^\d{9}$">
        <small class="text-danger" id="provider_zip_error"></small>
    </div>
</div>







<div class="mt-4">
    <h4>Service Facility Location (2310C Loop)</h4>

    <div class="form-group">
        <label for="facility_name">Facility Name</label>
        <input type="text" name="facility_name" id="facility_name" class="form-control" required placeholder="Enter Facility Name" value="ABC Healthcare Center">
    </div>

    <div class="form-group">
        <label for="facility_npi">NPI (Different from Billing Provider)</label>
        <input type="text" name="facility_npi" id="facility_npi" class="form-control" required pattern="\d{10}" maxlength="10" placeholder="Enter 10-digit NPI" value="1234567890">
    </div>

    <div class="form-group">
        <label for="facility_street">Street Address</label>
        <input type="text" name="facility_street" id="facility_street" class="form-control" required placeholder="Enter Street Address" value="123 Main Street">
    </div>

    <div class="form-group">
        <label for="facility_city">City</label>
        <input type="text" name="facility_city" id="facility_city" class="form-control" required placeholder="Enter City" value="New York">
    </div>

    <div class="form-group">
        <label for="facility_state">State (2-letter Code)</label>
        <input type="text" name="facility_state" id="facility_state" class="form-control" required pattern="[A-Z]{2}" maxlength="2" placeholder="Enter State" value="NY">
    </div>

    <div class="form-group">
        <label for="facility_zip">ZIP Code (9-digit)</label>
        <input type="text" name="facility_zip" id="facility_zip" class="form-control" required pattern="\d{9}" maxlength="9" placeholder="Enter 9-digit ZIP" value="100010000">
    </div>
</div>




<div class="mt-4">
    <h4>Patient and Subscriber Information (2010BA Loop)</h4>

    <h5>Subscriber Details (NM1*IL Segment)</h5>
    <div class="form-group">
        <label for="subscriber_last_name">Subscriber Last Name</label>
        <input type="text" name="subscriber_last_name" id="subscriber_last_name" class="form-control" required placeholder="Enter Last Name" value="Doe">
    </div>

    <div class="form-group">
        <label for="subscriber_first_name">Subscriber First Name</label>
        <input type="text" name="subscriber_first_name" id="subscriber_first_name" class="form-control" required placeholder="Enter First Name" value="John">
    </div>

    <div class="form-group">
        <label for="member_id">Member ID (Insurance ID)</label>
        <input type="text" name="member_id" id="member_id" class="form-control" required pattern="\d{8,15}" maxlength="15" placeholder="Enter Insurance ID" value="123456789">
    </div>

    <h5>Subscriber Address (N3/N4 Segments)</h5>
    <div class="form-group">
        <label for="subscriber_street">Street Address</label>
        <input type="text" name="subscriber_street" id="subscriber_street" class="form-control" required placeholder="Enter Street Address" value="456 Elm Street">
    </div>

    <div class="form-group">
        <label for="subscriber_city">City</label>
        <input type="text" name="subscriber_city" id="subscriber_city" class="form-control" required placeholder="Enter City" value="Los Angeles">
    </div>

    <div class="form-group">
        <label for="subscriber_state">State (2-letter Code)</label>
        <input type="text" name="subscriber_state" id="subscriber_state" class="form-control" required pattern="[A-Z]{2}" maxlength="2" placeholder="Enter State" value="CA">
    </div>

    <div class="form-group">
        <label for="subscriber_zip">ZIP Code (9-digit)</label>
        <input type="text" name="subscriber_zip" id="subscriber_zip" class="form-control" required pattern="\d{9}" maxlength="9" placeholder="Enter 9-digit ZIP" value="900019999">
    </div>

    <h5>Subscriber Demographics (DMG Segment)</h5>
    <div class="form-group">
        <label for="subscriber_dob">Date of Birth (CCYYMMDD)</label>
        <input type="text" name="subscriber_dob" id="subscriber_dob" class="form-control" required pattern="\d{8}" maxlength="8" placeholder="e.g., 19850115" value="19850115">
    </div>

    <div class="form-group">
        <label for="subscriber_gender">Gender (M/F/U)</label>
        <select name="subscriber_gender" id="subscriber_gender" class="form-control" required>
            <option value="M" selected>Male</option>
            <option value="F">Female</option>
            <option value="U">Unknown</option>
        </select>
    </div>
</div>





<div class="mt-4">
    <h4>Payer Information (2010BB Loop)</h4>

    <div class="form-group">
        <label for="payer_name">Payer Name</label>
        <input type="text" name="payer_name" id="payer_name" class="form-control" required placeholder="Enter Payer Name" value="ABC Insurance">
    </div>

    <div class="form-group">
        <label for="payer_id">Payer ID (Assigned by Payer)</label>
        <input type="text" name="payer_id" id="payer_id" class="form-control" required pattern="\d{5,10}" maxlength="10" placeholder="Enter Payer ID" value="987654">
    </div>

    <h5>Payer Address (N3/N4 Segments) - Optional</h5>
    <div class="form-group">
        <label for="payer_street">Street Address</label>
        <input type="text" name="payer_street" id="payer_street" class="form-control" placeholder="Enter Street Address" value="789 Main St">
    </div>

    <div class="form-group">
        <label for="payer_city">City</label>
        <input type="text" name="payer_city" id="payer_city" class="form-control" placeholder="Enter City" value="New York">
    </div>

    <div class="form-group">
        <label for="payer_state">State (2-letter Code)</label>
        <input type="text" name="payer_state" id="payer_state" class="form-control" pattern="[A-Z]{2}" maxlength="2" placeholder="Enter State" value="NY">
    </div>

    <div class="form-group">
        <label for="payer_zip">ZIP Code (9-digit)</label>
        <input type="text" name="payer_zip" id="payer_zip" class="form-control" pattern="\d{9}" maxlength="9" placeholder="Enter 9-digit ZIP" value="100019999">
    </div>
</div>





<div class="mt-4">
    <h4>Claim Information (2300 Loop)</h4>

    <div class="form-group">
        <label for="claim_number">Claim Number (CLM01)</label>
        <input type="text" name="claim_number" id="claim_number" class="form-control" required placeholder="Enter Unique Claim Number" value="CLM123456">
    </div>

    <div class="form-group">
        <label for="claim_amount">Claim Amount (CLM02)</label>
        <input type="text" name="claim_amount" id="claim_amount" class="form-control" required pattern="^\d+(\.\d{1,2})?$" placeholder="Enter Total Charge Amount" value="500.25">
    </div>

    <div class="form-group">
        <label for="place_of_service">Place of Service (CLM05-1)</label>
        <select name="place_of_service" id="place_of_service" class="form-control" required>
            <option value="11" selected>Office (11)</option>
            <option value="21">Inpatient Hospital (21)</option>
            <option value="22">Outpatient Hospital (22)</option>
            <option value="23">Emergency Room (23)</option>
        </select>
    </div>

    <div class="form-group">
        <label for="claim_frequency">Claim Frequency (CLM05-3)</label>
        <select name="claim_frequency" id="claim_frequency" class="form-control" required>
            <option value="1" selected>Original (1)</option>
            <option value="7">Replacement (7)</option>
            <option value="8">Void (8)</option>
        </select>
    </div>

    <h5>Diagnosis Codes (HI Segment)</h5>
    <div class="form-group">
        <label for="primary_diagnosis">Primary Diagnosis (HI01-2) (ICD-10 Format)</label>
        <input type="text" name="primary_diagnosis" id="primary_diagnosis" class="form-control" required pattern="^[A-Z]\d{2}(\.\d{1,4})?$" placeholder="Enter Primary Diagnosis Code" value="J45.909">
    </div>

    <div class="form-group">
        <label for="additional_diagnosis">Additional Diagnoses (Optional)</label>
        <textarea name="additional_diagnosis" id="additional_diagnosis" class="form-control" placeholder="Enter Additional Diagnosis Codes (comma separated)"></textarea>
    </div>

    <h5>Condition Codes (HI Segment) - Optional</h5>
    <div class="form-group">
        <label for="condition_codes">Condition Codes</label>
        <input type="text" name="condition_codes" id="condition_codes" class="form-control" placeholder="Enter Condition Codes (if required)">
    </div>
</div>





<div class="mt-4">
    <h4>Service Line Information (2400 Loop)</h4>

    <div class="form-group">
        <label for="service_line_number">Service Line Number (LX01)</label>
        <input type="number" name="service_line_number" id="service_line_number" class="form-control" required min="1" placeholder="Enter Service Line Number" value="1">
    </div>

    <div class="form-group">
        <label for="procedure_code">Procedure Code (SV101-2)</label>
        <input type="text" name="procedure_code" id="procedure_code" class="form-control" required pattern="^[A-Z0-9]+$" placeholder="Enter CPT/HCPCS Code" value="99213">
    </div>

    <div class="form-group">
        <label for="charge_amount">Charge Amount (SV102)</label>
        <input type="text" name="charge_amount" id="charge_amount" class="form-control" required pattern="^\d+(\.\d{1,2})?$" placeholder="Enter Charge Amount" value="150.00">
    </div>

    <div class="form-group">
        <label for="unit_count">Unit Count (SV104)</label>
        <input type="number" name="unit_count" id="unit_count" class="form-control" required min="1" placeholder="Enter Unit Count" value="1">
    </div>

    <div class="form-group">
        <label for="diagnosis_pointer">Diagnosis Pointer (SV107)</label>
        <input type="text" name="diagnosis_pointer" id="diagnosis_pointer" class="form-control" required pattern="^[1-9]$" placeholder="Enter Diagnosis Pointer" value="1">
    </div>

    <div class="form-group">
        <label for="date_of_service">Date of Service (DTP03) (YYYYMMDD)</label>
        <input type="text" name="date_of_service" id="date_of_service" class="form-control" required pattern="^\d{8}$" placeholder="Enter Date of Service" value="20240310">
    </div>
</div>





<div class="mt-4">
    <h4>Referring Provider Information (2310A Loop)</h4>

    <div class="form-group">
        <label for="referring_provider_name">Referring Provider Name (NM103)</label>
        <input type="text" name="referring_provider_name" id="referring_provider_name" class="form-control" required placeholder="Enter Referring Provider Name" value="Dr. John Doe">
    </div>

    <div class="form-group">
        <label for="referring_npi">NPI (NM109)</label>
        <input type="text" name="referring_npi" id="referring_npi" class="form-control" required pattern="^\d{10}$" placeholder="Enter NPI" value="1234567890">
    </div>
</div>



<div class="mt-4">
    <h4>Rendering Provider Information (2310B Loop)</h4>
    <div class="form-group">
        <label for="rendering_provider_name">Rendering Provider Name (NM103)</label>
        <input type="text" name="rendering_provider_name" id="rendering_provider_name" class="form-control" required placeholder="Enter Rendering Provider Name" value="Dr. Jane Smith">
    </div>

    <div class="form-group">
        <label for="rendering_npi">NPI (NM109)</label>
        <input type="text" name="rendering_npi" id="rendering_npi" class="form-control" required pattern="^\d{10}$" placeholder="Enter Rendering NPI" value="9876543210">
    </div>
</div>

<div class="mt-4">
    <h4>Supervising Provider Information (2310D Loop)</h4>
    <div class="form-group">
        <label for="supervising_provider_name">Supervising Provider Name (NM103)</label>
        <input type="text" name="supervising_provider_name" id="supervising_provider_name" class="form-control" required placeholder="Enter Supervising Provider Name" value="Dr. Robert Johnson">
    </div>

    <div class="form-group">
        <label for="supervising_npi">NPI (NM109)</label>
        <input type="text" name="supervising_npi" id="supervising_npi" class="form-control" required pattern="^\d{10}$" placeholder="Enter Supervising NPI" value="1231231234">
    </div>
</div>





<div class="mt-4">
    <h4>Transaction Set Trailer (SE Segment)</h4>
    <div class="form-group">
        <label for="se01">Total Number of Segments (SE01)</label>
        <input type="number" name="se01" id="se01" class="form-control" required placeholder="Enter total segments" value="34">
    </div>

    <div class="form-group">
        <label for="se02">Transaction Set Control Number (SE02)</label>
        <input type="text" name="se02" id="se02" class="form-control" required placeholder="Enter control number (Matches ST02)" value="000000001">
    </div>
</div>

<div class="mt-4">
    <h4>Group and Interchange Trailer (GE and IEA Segments)</h4>
    <div class="form-group">
        <label for="ge_control_number">GE Control Number</label>
        <input type="text" name="ge_control_number" id="ge_control_number" class="form-control" required placeholder="Enter GE Control Number" value="123096815">
    </div>

    <div class="form-group">
        <label for="iea_control_number">IEA Control Number</label>
        <input type="text" name="iea_control_number" id="iea_control_number" class="form-control" required placeholder="Enter IEA Control Number (Matches ISA)" value="123500377">
    </div>
</div>




            <button type="submit" class="btn btn-primary">Generate 837P EDI</button>
        </form>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html><?php /**PATH D:\projectsFolder\htdocs\TestProjectJeet\resources\views/file.blade.php ENDPATH**/ ?>