<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css">
</head>

<body>
    <nav class="navbar navbar-expand-lg navbar-light bg-light">
        <a class="navbar-brand" href="#">Dashboard</a>
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav ml-auto">
                <li class="nav-item">
                    <span class="nav-link">Welcome, <?php echo e(Auth::user()->name); ?></span>
                </li>
                <li class="nav-item">
                    <form action="<?php echo e(route('logout')); ?>" method="post" class="form-inline">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="btn btn-primary">Logout</button>
                    </form>
                </li>
            </ul>
        </div>
    </nav>

    <div class="container mt-5">
        <h1>Welcome to the Dashboard, <?php echo e(Auth::user()->name); ?></h1>

        <?php if(session('success')): ?>
            <div class="alert alert-success">
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>

        <hr>

        <h2>Donate</h2>
        <form action="<?php echo e(route('donate')); ?>" method="post">
            <?php echo csrf_field(); ?>
            <div class="form-group">
                <label for="amount">Amount:</label>
                <input style="width:30%" type="text" class="form-control" id="amount" name="amount" required>
            </div>
            <button type="submit" class="btn btn-success">Donate</button>
        </form>

        <hr>

        <h2>Your Donations</h2>
        <?php if($donations->isEmpty()): ?>
            <p>You have not made any donations yet.</p>
        <?php else: ?>
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>User Name</th>
                        <th>OrderId</th>
                        <th>Amount (INR)</th>
                        <th>Payment Status</th>
                        <th>Date</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $donations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $donation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e(Auth::user()->name); ?></td>
                            <td><?php echo e($donation->order_id); ?></td>
                            <td><?php echo e(number_format($donation->amount, 2)); ?></td>
                            <td>
                                <?php if($donation->status == "C"): ?>
                                    <span style="color:green;font-weight: 700;">COMPLETED</span>
                                <?php else: ?>
                                    <span style="color:red;font-weight: 700;">FAILED</span>
                                <?php endif; ?>
                            </td>
                            <td><?php echo e($donation->created_at->format('Y-m-d H:i:s')); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        <?php endif; ?>
    </div>

    <script src="https://code.jquery.com/jquery-3.3.1.slim.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js"></script>
</body>

</html>
<?php /**PATH D:\projectsFolder\htdocs\TestProjectJeet\resources\views/Auth/dashboard.blade.php ENDPATH**/ ?>