<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <?php echo $__env->yieldContent('title'); ?>
        <link rel="stylesheet" href="<?php echo e(url('/')); ?>/public/layouts/css/tailwind.min.css?v=">
        <link href="<?php echo e(url('/')); ?>/public/layouts/css/output.css?ver=" rel="stylesheet">
        <link rel="stylesheet" href="<?php echo e(url('/')); ?>/public/layouts/css/style.css?ver=545">
        <link rel="stylesheet" href="https://use.fontawesome.com/releases/v6.6.0/css/all.css">
        <link href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
        <!-- CSS -->
        <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    </head>
    <style type="text/css">
    .active{
    background:rgb(13 0 246);
    }
    </style>
    <body>
        <?php if(Route::currentRouteName() != 'login'): ?>
        
        <?php if(Route::currentRouteName() == 'view.system.file.data' || Route::currentRouteName() == 'view.sftp.837.file.data' || Route::currentRouteName() == 'view.sftp.275.file.data' || Route::currentRouteName() == 'view.system.multiclaim.file'): ?>
        <?php else: ?>
        <header class="g-header md:pb-32">
            <div class="container">
                <div class="border-b border-gray-700">
                    <div class="flex items-center justify-between h-16 px-4 sm:px-0">
                        <div class="flex items-center">
                            <div class="flex-shrink-0">
                                <a href="javascript:void(0)" style="text-decoration: none;" class="font-light block text-center text-white text-2xl">Klyre<span class="font-bold">Payments</span></a>
                            </div>
                            <div class="hidden md:block">
                                <div class="ml-10 flex items-baseline space-x-4">
                                    <nav>
                                        <ul class="mainmenu">
                                            <li>
                                                <a href="javascript:void(0)" class="menuitem"style="text-decoration: none;">Dashboard</a>
                                            </li>
                                            <li>
                                                <a href="<?php echo e(route('dashboard.sftp')); ?>" class="menuitem"style="text-decoration: none;">EDI Files</a>
                                            </li>
                                            <?php if(@Auth()->user()->user_type=="A"): ?>
                                            <li>
                                                <a href="<?php echo e(route('all.providers')); ?>" class="menuitem"style="text-decoration: none;">Providasdaser</a>
                                            </li>
                                            <?php endif; ?>
                                            
                                        </ul>
                                    </nav>
                                </div>
                            </div>
                        </div>
                        <div class="hidden md:block text-right">
                            <div class="flex divide-x divide-gray-500">
                                <div class="text-white text-right text-sm ml-auto pr-6">
                                    <p id="clock" class="font-medium">Thu, Sep 19 2024, 05:17:34</p>
                                    <p class="text-gray-400 text-xs">New York</p>
                                </div>
                                <div class="text-sm pl-6">
                                    <?php if(@Auth()->user()->user_type=="A"): ?>
                                    <p class="text-white font-medium">Super User</p>
                                    <?php else: ?>
                                    
                                    <p class="text-white font-medium"><?php echo e(@Auth::user()->providerDetails->provider_clinic_name); ?></p>
                                    <?php endif; ?>
                                    <form method="POST" action="<?php echo e(route('logout')); ?>">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" class="text-gray-400 text-xs hover:underline hover:text-white focus:text-white focus:ring-offset-2">Log out</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <script>
            document.addEventListener('DOMContentLoaded', function () {
            var dropdownItems = document.querySelectorAll('.menu-item-has-children');
            var dropdowns = document.querySelectorAll('.menu-item-has-children .mainmenu-sub-menu');
            var delay = 2000;
            if (dropdownItems) {
            dropdownItems.forEach((dropdownItem, count) => {
            dropdownItem.addEventListener('mouseenter', function (e) {
            dropdowns[count].classList.add('dropdown-show');
            });
            dropdownItem.addEventListener('mouseleave', function () {
            dropdowns[count].classList.remove('dropdown-show');
            });
            });
            }
            })
            </script>
            <div class="container btn-container">
                <?php if(@Auth()->user()->user_type == 'P' && empty(@Auth()->user()->providerDetails)): ?>
                <?php else: ?>
                <?php if(Route::currentRouteName() == 'view.system.file.data' || Route::currentRouteName() == 'view.sftp.837.file.data' || Route::currentRouteName() == 'view.sftp.275.file.data'): ?>
                <br>
                <br>
                <?php else: ?>
                <div class="md:py-10 py-5 md:flex md:items-end md:justify-between w-full">
                    <div class="md:flex md:items-end md:justify-between">
                        
                        <?php if(Route::currentRouteName() !== 'all.providers' && Route::currentRouteName() !== 'create.provider.form' && Route::currentRouteName() !== 'provider.view'): ?> 
                        <?php if(@Auth()->user()->user_type == 'A'): ?>
                        <a <?php if(Route::currentRouteName() == 'dashboard.sftp'): ?> class="active btn text-white bg-indigo-600 hover:bg-indigo-700 mr-4" <?php else: ?> class=" btn text-white bg-indigo-600 hover:bg-indigo-700 mr-4" <?php endif; ?> id="" href="<?php echo e(route('dashboard.sftp')); ?>" >View Recived Files</a>
                        <?php endif; ?>

                        <a <?php if(Route::currentRouteName() == 'dashboard'): ?> class="active btn text-white bg-indigo-600 hover:bg-indigo-700 mr-4" <?php else: ?> class=" btn text-white bg-indigo-600 hover:bg-indigo-700 mr-4" <?php endif; ?> id="" href="<?php echo e(route('dashboard')); ?>" >View Created 837</a>
                        
                        <button class="btn text-white bg-indigo-600 hover:bg-indigo-700  mr-4" id="createedi" data-bs-toggle="modal" data-bs-target="#ediModal"> Create 837</button>
                        <?php if(@Auth()->user()->user_type=="A"): ?>
                        <?php endif; ?>
                        <?php else: ?>
                        <a href="<?php echo e(route('create.provider.form')); ?>" class="btn text-white bg-indigo-600 hover:bg-indigo-700  mr-4" > Create Provider</a>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endif; ?>
                <?php endif; ?>
            </div>
        </header>
        <?php endif; ?>
        <?php endif; ?>
        
        <style>
        select#ediType {
        max-height: 300px; /* Height of the visible box */
        overflow-y: auto;
        }
        </style>
        <?php echo $__env->yieldContent('content'); ?>
        <!-- Modal -->
        <div id="ediModal" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content p-4">
                    <div class="modal-header">
                        <h5 class="modal-title">Create 837 Edi File</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"><i class="fa-solid fa-xmark"></i></button>
                    </div>
                    <form id="ediForm">
                        <?php echo csrf_field(); ?>
                        <div class="modal-body">
                            <label for="ediType" class="block text-sm font-medium mb-2">Select Type</label>
                            <select id="ediType" name="ediType" class="form-control w-full" required>
                                <option value="<?php echo e(route('create.multiple.edi.p.form')); ?>">837-P </option>
                                
                                <option value="<?php echo e(route('create.multiple.edi.p.form.new', '12')); ?>">837-P (Commercial Insurance)</option>
                                <option value="<?php echo e(route('create.multiple.edi.p.form.new', 'EN')); ?>">837-P (Encounter)</option>
                                <option value="<?php echo e(route('create.multiple.edi.p.form.new', 'A1')); ?>">837-P (COB Primary)</option>
                                <option value="<?php echo e(route('create.multiple.edi.p.form.new', 'A2')); ?>">837-P (Medicare Secondary)</option>
                                <option value="<?php echo e(route('create.multiple.edi.p.form.new', 'A3')); ?>">837-P (Ambulance)</option>
                                <option value="<?php echo e(route('create.multiple.edi.p.form.new', 'CH')); ?>">837-P (Chiropractic)</option>
                                <option value="<?php echo e(route('create.multiple.edi.p.form.new', 'O2')); ?>">837-P (Oxygen)</option>
                                <option value="<?php echo e(route('create.multiple.edi.p.form.new', 'WC')); ?>">837-P (Wheelchair)</option>
                                <option value="<?php echo e(route('create.multiple.edi.p.form.new', 'AN')); ?>">837-P (Anesthesia)</option>
                                <option value="<?php echo e(route('create.multiple.edi.p.form.new', 'RX')); ?>">837-P (Drugs)</option>
                                <option value="<?php echo e(route('create.multiple.edi.p.form.new', 'PP')); ?>">837-P (PPO Repriced Claim)</option>
                                <option value="<?php echo e(route('create.multiple.edi.p.form.new', 'ON')); ?>">837-P (Out of Network Repriced Claim)</option>
                                <option value="<?php echo e(route('create.multiple.edi.i.form')); ?>"> 837-I</option>
                                
                            </select>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-primary">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        
        <div class="modal fade" id="ediModal2" tabindex="-1" aria-labelledby="createEDIModalModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-lg modal-dialog-centered modal-dialog-scrollable">
                <div class="modal-content">
                    <div class="modal-header">
                        <div class="text-xl font-semibold">Create 837 Edi File</div>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"><i class="fa-solid fa-xmark"></i></button>
                    </div>
                    <div class="modal-body">
                        <form id="providerInitialForm" method="POST" action="<?php echo e(route('create.provider')); ?>" class="space-y-4">
                            <?php echo csrf_field(); ?>
                            
                            <div class="card p-6 max-w-md mx-auto">
                                <h2 class="text-xl font-semibold mb-6">Create New Provider Account</h2>
                                
                                <div class="space-y-4">
                                    <div>
                                        <label for="name" class="block mb-1">Provider Name*</label>
                                        <input type="text" id="name" name="name" required
                                        class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                                    </div>
                                    
                                    <div>
                                        <label for="email" class="block mb-1">Email Address*</label>
                                        <input type="email" id="email" name="email" required
                                        class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                                        <p class="text-sm text-gray-500 mt-1">A temporary password will be generated and sent to this email</p>
                                    </div>
                                </div>
                                
                                <div class="mt-6">
                                    <button type="submit" class="btn btn-primary w-full py-2">
                                    Create Provider Account
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    <footer class="my-4 text-center text-base text-gray-400">© KlyrePayments, LLC. 2025.</footer>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- JS -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
    document.getElementById('ediForm').addEventListener('submit', function(event) {
    event.preventDefault();
    var selectedRoute = document.getElementById('ediType').value;
    if (selectedRoute) {
    window.location.href = selectedRoute;
    }
    });
    </script>
    <script>
    $(document).ready(function() {
    $('#ediType').select2({
    dropdownParent: $('#ediModal'),  // 🛠️ THIS FIXES THE DROPDOWN INSIDE MODAL
    width: '100%'                    // Ensures full width
    });
    });
    </script>
</body>
</html><?php /**PATH /home/klyretmp/public_html/edi/resources/views/layouts/app.blade.php ENDPATH**/ ?>