<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>User Login</title>

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css">

    <!-- Include jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.2/jquery.validate.min.js" integrity="sha512-UdIMMlVx0HEynClOIFSyOrPggomfhBKJE28LKl8yR3ghkgugPnG6iLfRfHwushZl1MOPSY6TsuBDGPK2X4zYKg==" crossorigin="anonymous"></script>

    <!-- Bootstrap JS -->
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js"></script>

    <style>
        body {
            background-color: #f5f5f5;
        }

        #loginForm {
            background-color: #fff;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            padding: 20px;
            margin: 50px auto;
            max-width: 400px;
        }

        .form-group {
            margin-bottom: 20px;
        }

        .error {
            color: #dc3545;
            font-size: 80%;
            margin-top: 5px;
        }

        .btn-primary {
            background-color: #4caf50;
            border: 1px solid #4caf50;
        }

        .btn-primary:hover {
            background-color: #45a049;
            border: 1px solid #45a049;
        }
    </style>
</head>

<body>
    <?php echo $__env->make('message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="container">
        <nav class="navbar navbar-expand-lg navbar-light bg-light" style="background-color: #e3ecf5 !important;">
            <a class="navbar-brand" href="#">Login Page</a>
            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ml-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo e(route('reg')); ?>">Register</a>
                    </li>
                   
                </ul>
            </div>
        </nav>

        <form id="loginForm" action="<?php echo e(route('login.post')); ?>" method="post">
            <h4 style="text-align: center;">User Login</h4>
            <?php echo csrf_field(); ?>

            <div class="form-group">
                <label for="email">Email:</label>
                <input type="email" class="form-control" id="email" name="email" required>
            </div>

            <div class="form-group">
                <label for="password">Password:</label>
                <input type="password" class="form-control" id="password" name="password" required>
            </div>
            <button type="submit" class="btn btn-primary">Login</button>
            <br>
            <br>
        </form>

    </div>


<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.2/jquery.validate.min.js" integrity="sha512-UdIMMlVx0HEynClOIFSyOrPggomfhBKJE28LKl8yR3ghkgugPnG6iLfRfHwushZl1MOPSY6TsuBDGPK2X4zYKg==" crossorigin="anonymous"></script>
    <script>
        $(document).ready(function () {
             jQuery.validator.addMethod("validate_email", function (value, element) {
                if (/^([a-zA-Z0-9_\.\-])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/.test(value)) {
                    return true;
                } else {
                    return false;
                }
            }, "Please enter a valid email address.");
            // Validate the form
            $('#loginForm').validate({
                rules: {
                    email: {
                        required: true,
                        email: true,
                        validate_email: true
                    },
                    password: {
                        required: true,
                    }
                },
                messages: {
                    email: {
                        required: "Please enter your email address.",
                        email: "Please enter a valid email address."
                    },
                    password: {
                        required: "Please enter your password."
                    }
                }
            });
        });
    </script>
</body>
</html>
<?php /**PATH D:\projectsFolder\htdocs\TestProjectJeet\resources\views/Auth/login.blade.php ENDPATH**/ ?>