<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\EdiiController;
use App\Http\Controllers\EdidController;
use App\Http\Controllers\EdipController;
use App\Http\Controllers\SftpEdiController;
use App\Http\Controllers\Multiple\MultipleEdiPController;
use App\Http\Controllers\Multiple\MultipleEdiIController;
use App\Http\Controllers\Multiple\MultipleEdiDController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Route::get('/', function () {
//     return view('welcome');
// });

Route::get('/register', [AuthController::class, 'showRegisterForm'])->name('register');
Route::post('/register', [AuthController::class, 'register'])->name('register.submit');

Route::get('/', [AuthController::class, 'showLoginForm'])->name('login');
Route::get('/login', [AuthController::class, 'showLoginForm'])->name('login');
Route::post('/login', [AuthController::class, 'login'])->name('login.submit');
Route::any('/logout', [AuthController::class, 'logout'])->name('logout');
Route::get('/link-expired', [AuthController::class, 'link_expired'])->name('link.expired');

Route::get('/forgot-password', [AuthController::class, 'showForgotPassword'])->name('password.request');
Route::post('/forgot-password', [AuthController::class, 'sendResetLink'])->name('password.email');


Route::group(['middleware' => ['auth','providerchk']], function () {
    Route::any('/dashboard', [AuthController::class, 'dashboard'])->name('dashboard');
    Route::any('/view-recived-files', [AuthController::class, 'view_rcv_files_sftp'])->name('dashboard.sftp')->middleware('adminCheck');


	Route::get('/edi-p', [EdipController::class, 'edip'])->name('edip'); //edi-p
	Route::post('/generate-edi', [EdipController::class, 'generateEDI'])->name('generate.edi');
	Route::get('/upload-275-for-edi-p/{id}', [EdipController::class, 'showUploadForm'])->name('upload.275.edip');
	Route::get('/generate-999-edip/{id}', [EdipController::class, 'generate999'])->name('generate.999.edip');
	Route::post('/upload-275', [EdipController::class, 'process275'])->name('process.275');
	Route::get('/download-999/{filename}', [EdipController::class, 'download999'])->name('download.999');



	Route::get('/edi-i', [EdiiController::class, 'edii'])->name('edii'); //edi-i
	Route::post('/edi-i', [EdiiController::class, 'submit_837i'])->name('submit-837i'); //edi-i
	Route::get('/upload-275-for-edi-i/{id}', [EdiiController::class, 'showUploadForm'])->name('upload.275.edii');
	Route::get('/generate-999-edii/{id}', [EdiiController::class, 'generate999'])->name('generate.999.edii');
	Route::post('/upload-275/i', [EdiiController::class, 'process275'])->name('process.275.i');
	Route::get('/download-999/i/{filename}', [EdiiController::class, 'download999'])->name('download.999.i');



	Route::get('/edi-d', [EdidController::class, 'edid'])->name('edid'); //edi-d
	Route::post('/edi-d', [EdidController::class, 'submit_837d'])->name('submit-837d'); //edi-d
	Route::get('/upload-275-for-edi-d/{id}', [EdidController::class, 'showUploadForm'])->name('upload.275.edid');
	Route::get('/generate-999-edid/{id}', [EdidController::class, 'generate999'])->name('generate.999.edid');
	Route::post('/upload-275/d', [EdidController::class, 'process275'])->name('process.275.d');
	Route::get('/download-999/d/{filename}', [EdidController::class, 'download999'])->name('download.999.d');


	Route::get('/download-edi/{id}', [AuthController::class, 'download'])->name('download.edi');

    Route::get('/send-999/{id}', [SftpEdiController::class, 'send_system_generated_999'])->name('send.999');//normal system generated file







	
  //sftp 
	Route::get('/sftp/get-files', [SftpEdiController::class, 'get_837_files'])->name('get.837.sftp');

	// Route::get('/sftp/get-837-files', [SftpEdiController::class, 'fetch837Files']);
 //    Route::get('/sftp/get-275-files', [SftpEdiController::class, 'fetch275Files']);
    Route::get('/sftp/send-to-999', [SftpEdiController::class, 'sendFileTo999'])->name('send.to.999');

    Route::get('/sftp/generate-999/{id}', [SftpEdiController::class, 'generate_999'])->name('generate.sftp.999');
    Route::get('/sftp/send-999/{id}', [SftpEdiController::class, 'send_999'])->name('send.sftp.999');
    
	Route::get('/downlode-sftp-file/{id}', [SftpEdiController::class, 'downlode_sftp_file'])->name('downlode.sftp.file');
	Route::get('/downlode/ack-file/{id}', [SftpEdiController::class, 'downlode_ack_file'])->name('downlode.ack.file');



   Route::get('/view-system-file-data/{id}', [SftpEdiController::class, 'view_system_file_data'])->name('view.system.file.data');
    Route::get('/view-sftp-837-file-data/{id}', [SftpEdiController::class, 'view_sftp_837_file_data'])->name('view.sftp.837.file.data');
    Route::get('/view-sftp-275-file-data/{id}', [SftpEdiController::class, 'view_sftp_275_file_data'])->name('view.sftp.275.file.data');





    // multiple
    Route::get('/multiple-create-edi-p', [MultipleEdiPController::class, 'create_multiple_edip_form'])->name('create.multiple.edi.p.form');
    Route::post('/generate-multiple-create-edi-p', [MultipleEdiPController::class, 'generate837P'])->name('multiple.edip.generate');
    Route::get('/generate-multiple-edi-p-999-ack/{id}', [MultipleEdiPController::class, 'generate999P'])->name('multiple.edip.999.generate');


    Route::get('/multiple-create-edi-i', [MultipleEdiIController::class, 'create_multiple_edii_form'])->name('create.multiple.edi.i.form');
    Route::post('/generate-multiple-create-edi-i', [MultipleEdiIController::class, 'generate837I'])->name('multiple.edii.generate');
     Route::get('/generate-multiple-edi-i-999-ack/{id}', [MultipleEdiIController::class, 'generate999I'])->name('multiple.edii.999.generate');


     Route::get('/multiple-create-edi-d', [MultipleEdiDController::class, 'create_multiple_edid_form'])->name('create.multiple.edi.d.form');
    Route::post('/generate-multiple-create-edi-d', [MultipleEdiDController::class, 'generate837D'])->name('multiple.edid.generate');
     Route::get('/generate-multiple-edi-d-999-ack/{id}', [MultipleEdiDController::class, 'generate999D'])->name('multiple.edid.999.generate');


      Route::get('/view-system-multiclaim-file-data/{id}', [MultipleEdiPController::class, 'view_system_multicliam_file_data'])->name('view.system.multiclaim.file');


//12
      Route::get('/multiple-create-edi-p/new/{type}', [MultipleEdiPController::class, 'create_multiple_edip_form_new'])->name('create.multiple.edi.p.form.new');
      Route::post('/generate-multiple-create-edi-p-new', [MultipleEdiPController::class, 'generate837P_new'])->name('multiple.edip.generate.new');





      // create provider
      Route::get('/create-provider-form', [AuthController::class, 'create_provider_form'])->name('create.provider.form')->middleware('adminCheck');
       Route::post('/create-provider', [AuthController::class, 'create_provider'])->name('create.provider')->middleware('adminCheck');
       // Route::get('/complete-provider-info', [AuthController::class, 'complete_provider_info'])->name('complete.provider.info');
       // Route::post('/complete-provider-info-store', [AuthController::class, 'provider_info_store'])->name('provider.info.store');
       Route::any('/providers', [AuthController::class, 'all_providers'])->name('all.providers')->middleware('adminCheck');
         Route::get('/provider-view/{id}', [AuthController::class, 'provider_view'])->name('provider.view')->middleware('adminCheck');





});

 Route::get('/complete-provider-info', [AuthController::class, 'complete_provider_info'])->name('complete.provider.info')->middleware('auth');
  Route::post('/complete-provider-info-store', [AuthController::class, 'provider_info_store'])->name('provider.info.store')->middleware('auth');

Route::get('/sftp/get-837-files', [SftpEdiController::class, 'fetch837Files']);
Route::get('/sftp/get-275-files', [SftpEdiController::class, 'fetch275Files']);




