@extends('layouts.app')

@section('content')
   <style>
    .btn.text-white {
        padding: 4px 14px;
        font-size: 13px;
        font-weight: 600;
        border-radius: 6px;
        line-height: 1.5;
        display: inline-block;
        text-align: center;
        white-space: nowrap;
        vertical-align: middle;
        transition: background-color 0.2s ease-in-out;
        background-color: rgb(79 70 229);
    }

    .form-group{
    margin-bottom: 20px;
    }
    .g-header{
    height: 170px;
    }
    .step { display: none; }
    .active { display: block; }
    .next, .prev {
    padding: 6px 16px;       /* good horizontal and vertical padding */
    font-size: 14px;
    border-radius: 6px;
    border: none;
    cursor: pointer;
    width: auto;
    height: auto;
    display: inline-block;
    text-align: center;
    line-height: normal;
    background-color: #0d6efd;  /* for .next */
    color: white;
    margin-right: 10px;
    margin-bottom: 10px;
    margin-top: 10px;
    }
    .prev {
    background-color: orange;
    }
    #multiStepForm {
    width: 50%;
    background: white;
    padding: 20px;
    margin: 50px auto;
    border-radius: 10px;
    box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
    }
    /*  .step {
    display: none;
    }
    .active {
    display: block;
    }*/
    .step {
    display: none;
    }
    .step.active {
    display: flex; /* or block, but flex works better for columns */
    flex-wrap: wrap;
    }
    h2 {
    color: #333;
    }
    input {
    width: 30%;
    padding: 10px;
    margin: 10px 0;
    border: 1px solid #ccc;
    border-radius: 5px;
    font-size: 16px;
    }
    button {
    background-color: #007bff;
    color: white;
    border: none;
    padding: 10px 15px;
    font-size: 16px;
    cursor: pointer;
    border-radius: 5px;
    transition: 0.3s;
    }
    button:hover {
    background-color: #0056b3;
    }
   
    .submit {
    background-color: #28a745;
    }
    .submit:hover {
    background-color: #218838;
    }
    .form-control{
    width: 30%;
    }

</style>
<div class="container">
        <title>Generate 999 File</title>
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    </head>
    <body>
        <div class="container mt-5">
            <h2 class="mb-4">Generate 999</h2>
            <br>
            <h4>Name of file : {{$data->file_name}}</h4>
            <br>
            <br>
            @if (session('success'))
            <div style="color: green;">
                {!! session('success') !!}
            </div>
            @endif
            @if (session('error'))
            <div style="color: red;">
                {{ session('error') }}
            </div>
            @endif
            <form action="{{ route('process.275.d') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="mb-3">
                     <label for="file_type" class="form-label">Select File Type</label>
                        <select name="file_type" id="file_type" class="form-control" required>
                            <option value="">Select File</option>
                            <option value="837">Upload 837 File</option>
                            {{-- <option value="275">Upload 275 File</option> --}}
                        </select>
                        <br>


                    <input type="hidden" name="id" value="{{$data->id}}">
                    <label for="file" class="form-label">Upload File</label>
                    <input type="file" name="file" class="form-control" required>
                </div>
                <button type="submit" class="btn btn-primary">Upload & Generate 999</button>
            </form>
        </div>
  @endsection