@extends('layouts.app')
<header class="g-header md:pb-32">
    <div class="container">
        <div class="border-b border-gray-700">
            <div class="flex items-center justify-between h-16 px-4 sm:px-0">
                <div class="flex items-center">
                    <div class="flex-shrink-0">
                        <a href="javascript:void(0)" style="text-decoration: none;" class="font-light block text-center text-white text-2xl">Klyre<span class="font-bold">Payments</span></a>
                    </div>
                    <div class="hidden md:block">
                        <div class="ml-10 flex items-baseline space-x-4">
                            <nav>
                                <ul class="mainmenu">
                                    <li>
                                        <a href="javascript:void(0)" class="menuitem"style="text-decoration: none;">Dashboard</a>
                                    </li>
                                    <li>
                                        <a href="{{route('dashboard')}}" class="menuitem"style="text-decoration: none;">EDI Files</a>
                                    </li>
                                    
                                </ul>
                            </nav>
                        </div>
                    </div>
                </div>
                @include('message')
                <div class="hidden md:block text-right">
                    <div class="flex divide-x divide-gray-500">
                        <div class="text-white text-right text-sm ml-auto pr-6">
                            <p id="clock" class="font-medium">Thu, Sep 19 2024, 05:17:34</p>
                            <p class="text-gray-400 text-xs">New York</p>
                        </div>
                        <div class="text-sm pl-6">
                            <p class="text-white font-medium">Super User</p>
                            <form method="POST" action="{{route('logout')}}">
                                @csrf
                                <button type="submit" class="text-gray-400 text-xs hover:underline hover:text-white focus:text-white focus:ring-offset-2">Log out</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
    document.addEventListener('DOMContentLoaded', function () {
    var dropdownItems = document.querySelectorAll('.menu-item-has-children');
    var dropdowns = document.querySelectorAll('.menu-item-has-children .mainmenu-sub-menu');
    var delay = 2000;
    if (dropdownItems) {
    dropdownItems.forEach((dropdownItem, count) => {
    dropdownItem.addEventListener('mouseenter', function (e) {
    dropdowns[count].classList.add('dropdown-show');
    });
    dropdownItem.addEventListener('mouseleave', function () {
    dropdowns[count].classList.remove('dropdown-show');
    });
    });
    }
    })
    </script>
    <div class="container btn-container">
        
        <div class="md:py-10 py-5 md:flex md:items-end md:justify-between w-full">
                <h1 class="text-3xl font-bold md:text-white">Details</h1> 
                <div class="flex flex-wrap items-center gap-1">
                            {{-- Static Navigation Buttons --}}
                            
                            {{-- Generate 999 Based on Status and Type --}}
                            @if($file->status == "P")
                            @if ($file->type === 'P')
                            <a href="{{ route('generate.999.edip', $file->id) }}"
                                class=" btn text-white bg-indigo-600 hover:bg-indigo-700">
                                Generate 999 (P)
                            </a>
                            @elseif ($file->type === 'I')
                            <a href="{{ route('generate.999.edii', $file->id) }}"
                                class=" btn text-white bg-indigo-600 hover:bg-indigo-700">
                                Generate 999 (I)
                            </a>
                            @else
                            <a href="{{ route('generate.999.edid', $file->id) }}"
                                class=" btn text-white bg-indigo-600 hover:bg-indigo-700">
                                Generate 999 (D)
                            </a>
                            @endif
                            @endif
                            {{-- Download 837 - Claims --}}
                            <a href="{{ route('download.edi', $file->id) }}"
                                class=" btn text-white bg-indigo-600 hover:bg-indigo-700">
                                Download 837 - Claims
                            </a>
                            {{-- Download Ack --}}
                            @if($file->find_837_to_999)
                            <a href="{{ route('download.999', $file->find_837_to_999->file_name) }}"
                                class=" btn text-white bg-indigo-600 hover:bg-indigo-700">
                                Download Ack
                            </a>
                            @endif
                        </div>
        </div>
    </div>
</header>
@section('content')
<main class="md:-mt-32 mt-5">
    <div class="container">
        {{-- part-1 --}}
        <form id="myform" name="myform" method="POST">
            <div class="md:flex items-start space-x-6 mb-6">
                <!-- Left Column - Patient Information -->
                <div class="bg-white w-1/2 shadow overflow-hidden sm:rounded-lg">
                    <div class="px-4 py-5 sm:px-6 border-b">
                        <div class="md:flex justify-between">
                            <div>
                                <h3 class="text-lg leading-6 font-medium text-gray-900">Claim Information</h3>
                            </div>
                        </div>
                    </div>
                    
                    <div>
                        {{--   <ul class="g-tabs2">
                            <li class="g-tab-link current" data-tab="tab-primary">Claim Info</li>
                        </ul> --}}
                        
                        <div id="tab-primary" class="g-tab-content2 current">
                            <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Claim Number</label>
                                <span class="w-3/4"><?= $data->claim_number ?></span>
                            </div>
                            <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Claim Amount</label>
                                <span class="w-3/4">$<?= number_format($data->claim_amount, 2) ?></span>
                            </div>
                            <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Authorization #</label>
                                <span class="w-3/4"><?= $data->authorization_number ?? 'N/A' ?></span>
                            </div>
                            <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Date of Service</label>
                                <span class="w-3/4"><?= date('m/d/Y', strtotime($data->date_of_service)) ?></span>
                            </div>
                            <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Primary Diagnosis</label>
                                <span class="w-3/4"><?= $data->primary_diagnosis ?></span>
                            </div>
                            <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Additional Diagnosis</label>
                                <span class="w-3/4"><?= $data->additional_diagnosis ?? 'None' ?></span>
                            </div>
                            <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Procedure Code</label>
                                <span class="w-3/4"><?= $data->procedure_code ?></span>
                            </div>
                            <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Service Location</label>
                                <span class="w-3/4"><?= $data->facility_name ?></span>
                            </div>
                        </div>
                        
                    </div>
                </div>
                
                <!-- Right Column - Provider & Transmission Info -->
                <div class="bg-white w-1/2 shadow overflow-hidden sm:rounded-lg">
                    <div class="px-4 py-5 sm:px-6 border-b">
                        <div class="md:flex justify-between">
                            <div>
                                <h3 class="text-lg leading-6 font-medium text-gray-900">Patient Information</h3>
                            </div>
                        </div>
                    </div>
                    
                    <div>
                        {{--  <ul class="g-tabs2">
                            <li class="g-tab-link current" data-tab="tab-primary">Patient Info</li>
                            
                        </ul> --}}
                        
                        <div id="tab-primary" class="g-tab-content2 current">
                            <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Patient Name</label>
                                <span class="w-3/4">
                                    <?= $data->subscriber_first_name ?>
                                    <?= !empty($data->subscriber_middle_name) ? $data->subscriber_middle_name . ' ' : '' ?>
                                    <?= $data->subscriber_last_name ?>
                                    <?= !empty($data->subscriber_suffix) ? ', ' . $data->subscriber_suffix : '' ?>
                                </span>
                            </div>
                            <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Member ID</label>
                                <span class="w-3/4"><?= $data->member_id ?></span>
                            </div>
                            <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Patient Account #</label>
                                <span class="w-3/4"><?= $data->patient_account_number ?? 'N/A' ?></span>
                            </div>
                            <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Date of Birth</label>
                                <span class="w-3/4"><?= date('m/d/Y', strtotime($data->subscriber_dob)) ?></span>
                            </div>
                            <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Gender</label>
                                <span class="w-3/4">
                                    <?= $data->subscriber_gender == 'M' ? 'Male' : ($data->subscriber_gender == 'F' ? 'Female' : 'Other') ?>
                                </span>
                            </div>
                            <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Relationship</label>
                                <span class="w-3/4">
                                    <?= match($data->patient_relationship ?? 'self') {
                                    'self' => 'Self',
                                    'spouse' => 'Spouse',
                                    'child' => 'Child',
                                    'other' => 'Other',
                                    default => 'Self'
                                    } ?>
                                </span>
                            </div>
                            <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Address</label>
                                <span class="w-3/4">
                                    <?= $data->subscriber_street ?><br>
                                    <?= $data->subscriber_city ?>, <?= $data->subscriber_state ?> <?= substr($data->subscriber_zip, 0, 5) ?>
                                </span>
                            </div>
                            <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Phone</label>
                                <span class="w-3/4"><?= $data->subscriber_phone ?? 'N/A' ?></span>
                            </div>
                            <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Payer</label>
                                <span class="w-3/4"><?= $data->payer_name ?> (<?= $data->payer_id ?>)</span>
                            </div>
                        </div>
                        
                    </div>
                </div>
            </div>
        </form>
        {{-- part-1 --}}
        <form id="myform" name="myform" method="POST">
            <div class="md:flex items-start space-x-6 mb-6">
                <!-- Left Column - Patient Information -->
                <div class="w-1/2">
                    <div class="bg-white shadow overflow-hidden sm:rounded-lg">
                        <div class="px-4 py-5 sm:px-6 border-b">
                            <div class="md:flex justify-between">
                                <div>
                                    <h3 class="text-lg leading-6 font-medium text-gray-900">Provider  Details</h3>
                                    
                                </div>
                            </div>
                        </div>
                        
                        <div class="pt-3 border-b">
                            {{--   <ul class="g-tabs">
                                <li class="g-tab-link current" data-tab="tab-1">Provider Info</li>
                            </ul> --}}
                            
                            <div id="tab-1" class="g-tab-content current">
                                <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Provider Name</label>
                                    <span class="w-3/4"><?= $data->provider_name ?></span>
                                </div>
                                <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">NPI</label>
                                    <span class="w-3/4"><?= $data->provider_npi ?></span>
                                </div>
                                <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Tax ID</label>
                                    <span class="w-3/4"><?= $data->provider_tax_id ?></span>
                                </div>
                                <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Billing Provider</label>
                                    <span class="w-3/4"><?= $data->billing_provider_name ?? $data->provider_name ?></span>
                                </div>
                                <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Facility</label>
                                    <span class="w-3/4"><?= $data->facility_name ?></span>
                                </div>
                                <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Facility Address</label>
                                    <span class="w-3/4">
                                        <?= $data->facility_street ?><br>
                                        <?= $data->facility_city ?>, <?= $data->facility_state ?> <?= substr($data->facility_zip, 0, 5) ?>
                                    </span>
                                </div>
                                <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Rendering Provider</label>
                                    <span class="w-3/4"><?= $data->rendering_provider_name ?> (<?= $data->rendering_npi ?>)</span>
                                </div>
                                <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Referring Provider</label>
                                    <span class="w-3/4">
                                        <?= $data->referring_provider_name ?? 'N/A' ?>
                                        <?= !empty($data->referring_npi) ? '(' . $data->referring_npi . ')' : '' ?>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Right Column - Provider & Transmission Info -->
                <div class="w-1/2">
                    <div class="bg-white shadow overflow-hidden sm:rounded-lg">
                        <div class="px-4 py-5 sm:px-6 border-b">
                            <div class="md:flex justify-between">
                                <div>
                                    <h3 class="text-lg leading-6 font-medium text-gray-900"> Transmission Details</h3>
                                    <p class="mt-1 max-w-2xl text-sm text-gray-500">Service provider and submission information</p>
                                </div>
                            </div>
                        </div>
                        
                        <div class="pt-3 border-b">
                            {{--  <ul class="g-tabs">
                                <li class="g-tab-link current" data-tab="tab-2">Transmission Info</li>
                                
                            </ul> --}}
                            
                            <div id="tab-1" class="g-tab-content current">
                                <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Submitter</label>
                                    <span class="w-3/4"><?= $data->submitter_name ?> (<?= $data->submitter_id ?>)</span>
                                </div>
                                <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Receiver</label>
                                    <span class="w-3/4"><?= $data->receiver_name ?> (<?= $data->receiver_code ?>)</span>
                                </div>
                                <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Transmission Date</label>
                                    <span class="w-3/4"><?= date('m/d/Y', strtotime($data->transmission_date)) ?></span>
                                </div>
                                <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Transmission Time</label>
                                    <span class="w-3/4"><?= date('h:i A', strtotime($data->transmission_time)) ?></span>
                                </div>
                                <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Control Number</label>
                                    <span class="w-3/4"><?= $data->control_number ?></span>
                                </div>
                                <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Sender Code</label>
                                    <span class="w-3/4"><?= $data->sender_code ?></span>
                                </div>
                                <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Receiver Code</label>
                                    <span class="w-3/4"><?= $data->receiver_code ?></span>
                                </div>
                            </div>
                            
                            
                        </div>
                    </div>
                </div>
            </div>
        </form>
        {{-- part-3 --}}
        <form id="myform" name="myform" method="POST">
            <div class="md:flex items-start space-x-6 mb-6">
                <!-- Left Column - Patient Information -->
                <div class="bg-white w-1/2 shadow overflow-hidden sm:rounded-lg">
                    <div class="px-4 py-5 sm:px-6 border-b">
                        <div class="md:flex justify-between">
                            <div>
                                <h3 class="text-lg leading-6 font-medium text-gray-900">Service Information</h3>
                            </div>
                        </div>
                    </div>
                    
                    <div>
                        {{--    <ul class="g-tabs2">
                            <li class="g-tab-link current" data-tab="tab-primary">Service Lines</li>
                        </ul> --}}
                        
                        <div id="tab-primary" class="g-tab-content2 current">
                            <div class="border-b mb-4">
                                <h4 class="px-4 py-2 bg-gray-100 font-medium">Service Line 1</h4>
                                <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Procedure Code</label>
                                    <span class="w-3/4"><?= $data->procedure_code ?? 'N/A' ?></span>
                                </div>
                                <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Modifier</label>
                                    <span class="w-3/4"><?= $data->modifier ?? 'N/A' ?></span>
                                </div>
                                <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Charge Amount</label>
                                    <span class="w-3/4">$<?= number_format($data->charge_amount ?? 0, 2) ?></span>
                                </div>
                                <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Units</label>
                                    <span class="w-3/4"><?= $data->unit_count ?? 'N/A' ?></span>
                                </div>
                                <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Date of Service</label>
                                    <span class="w-3/4">
                                        <?php
                                        $date = $data->date_of_service ?? null;
                                        echo $date ? date('m/d/Y', strtotime($date)) : 'N/A';
                                        ?>
                                    </span>
                                </div>
                                <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Diagnosis Pointer</label>
                                    <span class="w-3/4"><?= $data->diagnosis_pointer ?? 'N/A' ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                
            </div>
        </form>
    </div>
</main>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
{{-- <script>
const myElement = document.getElementById("customdropdown");
// Toggle the class when the element is clicked
myElement.addEventListener("click", function(event) {
this.classList.toggle("active");
event.stopPropagation(); // Prevent the event from bubbling to document
});
// Remove the class if clicking outside the element
document.addEventListener("click", function(event) {
if (!myElement.contains(event.target)) {
myElement.classList.remove("active");
}
});
document.getElementById('selectcategory_0').addEventListener('change', function() {
var myDiv = document.getElementById('lodging-category-options');
// Toggle between showing and hiding the div
myDiv.style.display = myDiv.style.display === 'none' ? 'block' : 'none';
});
document.getElementById('selectcategory_1').addEventListener('change', function() {
var myDiv = document.getElementById('nutrition-category-options');
// Toggle between showing and hiding the div
myDiv.style.display = myDiv.style.display === 'none' ? 'block' : 'none';
});
document.getElementById('selectcategory_2').addEventListener('change', function() {
var myDiv = document.getElementById('childcare-category-options');
// Toggle between showing and hiding the div
myDiv.style.display = myDiv.style.display === 'none' ? 'block' : 'none';
});
</script> --}}
<script>
window.onload = displayClock();
function displayClock() {
const currentDate = new Date(new Date().toLocaleString("en-US", {
timeZone: "America/New_York"
}));
var timestamp = currentDate.toString().split('GMT');
var splitstring = timestamp[0].split(" ");
var final_string = splitstring[0] + ', ' + splitstring[1] + ' ' + splitstring[2] + ' ' + splitstring[3] +
', ' + splitstring[4];
$("#clock").text(final_string);
setTimeout(displayClock, 1000);
}
</script>
{{-- <script>
$(document).ready(function() {
$('#callCategorySelect').on('change', function() {
var selectedValue = $(this).val();
// Hide all divs
$('.callCategorySelectoption').hide();
// Show the div if a valid option is selected
if (selectedValue !== "none") {
$('#' + selectedValue).show();
}
});
});
</script>
<script>
function toggleModal(modalID, rowid = null) {
if (modalID == 'modal-example-regular-update') {
loadUpdateUserForm(rowid);
}
if (modalID == 'modal-example-regular-update-ediprofile') {
loadEditProfileUserForm(rowid);
}
if (modalID == 'modal-example-regular-deposit') {
$("#modal-example-regular-deposit .service_id").val(rowid);
}
if (modalID == 'modal-program-configure-alert') {
loadProgramDetailsForm(rowid);
}
if (modalID == 'modal-program-configure-alert-import') {
loadImportForm(rowid);
}
if (modalID == 'modal-program-files') {
loadProgramFilesForm(rowid);
}
if (modalID == 'modal-audit-log') {
loadAuditLog(rowid);
}
document.getElementById(modalID).classList.toggle("hidden");
document.getElementById(modalID + "-backdrop").classList.toggle("hidden");
document.getElementById(modalID + "-backdrop").classList.toggle("flex");
}
function closeModal(modalID) {
document.getElementById(modalID).classList.toggle("hidden");
document.getElementById(modalID + "-backdrop").classList.toggle("hidden");
document.getElementById(modalID + "-backdrop").classList.toggle("flex");
}
$(document).ready(function () {
$('ul.g-tabs li').click(function () {
var tab_id = $(this).attr('data-tab');
$('ul.g-tabs li').removeClass('current');
$('.g-tab-content').removeClass('current');
$(this).addClass('current');
$("#" + tab_id).addClass('current');
});
$('ul.g-tabs1 li').click(function () {
var tab_id = $(this).attr('data-tab');
$('ul.g-tabs1 li').removeClass('current');
$('.g-tab-content1').removeClass('current');
$(this).addClass('current');
$("#" + tab_id).addClass('current');
});
$('ul.g-tabs2 li').click(function () {
var tab_id = $(this).attr('data-tab');
$('ul.g-tabs2 li').removeClass('current');
$('.g-tab-content2').removeClass('current');
$(this).addClass('current');
$("#" + tab_id).addClass('current');
});
$(".eye-button").on('click', function () {
$(".eye-icon").toggleClass('hidden');
$(".extra-info").toggleClass('hidden');
});
});
</script>
<script>
$(document).ready(function(){
var patientInfoVisible = false;
var travelCardInfoVisible = false;
// Toggle Patient Info Visibility
$('#viewPatientInfo').click(function(){
if(!patientInfoVisible){
// Unmask patient details
$('#patientDob').text('01/01/1980').removeClass('masked').addClass('unmasked');
$('#patientAddress').text('123 Main St').removeClass('masked').addClass('unmasked');
$('#patientCity').text('Los Angeles').removeClass('masked').addClass('unmasked');
$('#patientState').text('CA').removeClass('masked').addClass('unmasked');
$('#patientZip').text('90001').removeClass('masked').addClass('unmasked');
$('#patientEmail').text('john.doe@example.com').removeClass('masked').addClass('unmasked');
$('#gender').text('Male').removeClass('masked').addClass('unmasked');
$('#nationality').text('American').removeClass('masked').addClass('unmasked');
$('#EthnicityRace').text('Asian').removeClass('masked').addClass('unmasked');
$('#patientPhone1').text('(123) 456-7890').removeClass('masked').addClass('unmasked');
$('#patientPhone2').text('(098) 765-4321').removeClass('masked').addClass('unmasked');
$('#patientClinicalTrialSite').text('UCLA Medical Center').removeClass('masked').addClass('unmasked');
$('#patientCirmTrialNumber').text('CIRM-12345').removeClass('masked').addClass('unmasked');
$('#patientProgramId').text('PID-67890').removeClass('masked').addClass('unmasked');
$('#patientSiteCoordinator').text('Dr. Smith').removeClass('masked').addClass('unmasked');
$('#patientSiteContactNumber').text('(555) 123-4567').removeClass('masked').addClass('unmasked');
$('#patientSiteContactEmail').text('coordinator@example.com').removeClass('masked').addClass('unmasked');
$(this).html('<i class="fa-regular fa-eye-slash"></i> &nbsp; Hide Patient Info');
patientInfoVisible = true;
} else {
// Mask patient details
$('.patient-detail').each(function(){
$(this).text('••••••••••').removeClass('unmasked').addClass('masked');
});
$('#patientAddress').text('•••••••••••••••••••••••••••••••••');
$('#patientCity').text('••••••••••');
$('#patientState').text('••••••••••');
$('#patientZip').text('•••••');
$('#patientClinicalTrialSite').text('•••••••••••••••••••••••••');
$('#patientCirmTrialNumber').text('•••••••••••••••••••••••••');
$('#patientProgramId').text('•••••••••••••••••••••••••');
$('#patientSiteCoordinator').text('•••••••••••••••••••••••••');
$('#patientSiteContactNumber').text('••••••••••');
$('#patientSiteContactEmail').text('••••••••••••••••••••');
$(this).html('<i class="fa-regular fa-eye"></i> &nbsp; View Patient Info');
patientInfoVisible = false;
}
});
// Toggle Travel Card Information
$('#toggleTravelCardInfo').click(function(){
if(!travelCardInfoVisible){
$('#travelCardNumber').text('1234 5678 9012 3456');
$('#travelCardCVV').text('123');
$('#travelCardExpiration').text('12/26');
$(this).html('<i class="fa-regular fa-eye-slash"></i> &nbsp; Hide Card Information');
travelCardInfoVisible = true;
} else {
$('#travelCardNumber').text('•••• •••• •••• ••••');
$('#travelCardCVV').text('•••');
$('#travelCardExpiration').text('••/••');
$(this).html('<i class="fa-regular fa-eye"></i> &nbsp; Show Card Information');
travelCardInfoVisible = false;
}
});
// Toggle Allowance Card Status
$('#toggleCardStatus').click(function(){
var status = $('#cardStatus').text();
if(status === 'Active'){
$('#cardStatus').text('Suspended')
.removeClass('c-badge c-badge-verified')
.addClass('c-badge c-badge-warning');
$(this).text('Unsuspend Card');
} else {
$('#cardStatus').text('Active')
.removeClass('c-badge c-badge-warning')
.addClass('c-badge c-badge-verified');
$(this).text('Suspend Card');
}
});
// Form submissions
$('#uploadDocumentsForm, #logCallForm, #createRuleForm').submit(function(event){
event.preventDefault();
alert('Form submitted successfully!');
$(this).closest('.modal').modal('hide');
});
// Resend Enrollment Information
$('#resendEnrollmentModal .btn-primary').click(function(){
alert('Enrollment information resent successfully!');
$('#resendEnrollmentModal').modal('hide');
});
});
</script>
<script>
// Tab functionality
document.addEventListener('DOMContentLoaded', function() {
// For Patient/Claim tabs
const tabLinks2 = document.querySelectorAll('.g-tabs2 .g-tab-link');
tabLinks2.forEach(link => {
link.addEventListener('click', function() {
const tabId = this.getAttribute('data-tab');
// Remove current class from all tabs and content
document.querySelectorAll('.g-tabs2 .g-tab-link').forEach(t => t.classList.remove('current'));
document.querySelectorAll('.g-tab-content2').forEach(c => c.classList.remove('current'));
// Add current class to clicked tab and corresponding content
this.classList.add('current');
document.getElementById(tabId).classList.add('current');
});
});
// For Provider/Transmission/Service tabs
const tabLinks = document.querySelectorAll('.g-tabs .g-tab-link');
tabLinks.forEach(link => {
link.addEventListener('click', function() {
const tabId = this.getAttribute('data-tab');
// Remove current class from all tabs and content
document.querySelectorAll('.g-tabs .g-tab-link').forEach(t => t.classList.remove('current'));
document.querySelectorAll('.g-tab-content').forEach(c => c.classList.remove('current'));
// Add current class to clicked tab and corresponding content
this.classList.add('current');
document.getElementById(tabId).classList.add('current');
});
});
});
</script> --}}
@endsection