@extends('layouts.app')
@section('content')
<header class="g-header md:pb-32">
    <div class="container">

        <div class="border-b border-gray-700">
            <div class="flex items-center justify-between h-16 px-4 sm:px-0">
                <div class="flex items-center">
                    <div class="flex-shrink-0">
                        <a href="javascript:void(0)" style="text-decoration: none;" class="font-light block text-center text-white text-2xl">Klyre<span class="font-bold">Payments</span></a>
                    </div>
                    <div class="hidden md:block">
                        <div class="ml-10 flex items-baseline space-x-4">
                            <nav>
                                <ul class="mainmenu">
                                    <li>
                                        <a href="javascript:void(0)" class="menuitem"style="text-decoration: none;">Dashboard</a>
                                    </li>
                                    <li>
                                        <a href="{{route('dashboard')}}" class="menuitem"style="text-decoration: none;">EDI Files</a>
                                    </li>
                                    
                                </ul>
                            </nav>
                        </div>
                    </div>
                </div>
                @include('message')
                <div class="hidden md:block text-right">
                    <div class="flex divide-x divide-gray-500">
                        <div class="text-white text-right text-sm ml-auto pr-6">
                            <p id="clock" class="font-medium">Thu, Sep 19 2024, 05:17:34</p>
                            <p class="text-gray-400 text-xs">New York</p>
                        </div>
                        <div class="text-sm pl-6">
                            <p class="text-white font-medium">Super User</p>
                            <form method="POST" action="{{route('logout')}}">
                                @csrf
                                <button type="submit" class="text-gray-400 text-xs hover:underline hover:text-white focus:text-white focus:ring-offset-2">Log out</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
    document.addEventListener('DOMContentLoaded', function () {
    var dropdownItems = document.querySelectorAll('.menu-item-has-children');
    var dropdowns = document.querySelectorAll('.menu-item-has-children .mainmenu-sub-menu');
    var delay = 2000;
    if (dropdownItems) {
    dropdownItems.forEach((dropdownItem, count) => {
    dropdownItem.addEventListener('mouseenter', function (e) {
    dropdowns[count].classList.add('dropdown-show');
    });
    dropdownItem.addEventListener('mouseleave', function () {
    dropdowns[count].classList.remove('dropdown-show');
    });
    });
    }
    })
    </script>
    <div class="container btn-container">
        
        <div class="md:py-10 py-5 md:flex md:items-end md:justify-between w-full">
                <h1 class="text-3xl font-bold md:text-white">Details</h1>
                <div class="flex flex-wrap items-center gap-1">
                    {{-- Static Navigation Buttons --}}
                   {{--  <a
                        @if (Route::currentRouteName() == 'dashboard.sftp')
                        class="active btn text-white bg-indigo-600 hover:bg-indigo-700"
                        @else
                        class="btn text-white bg-indigo-600 hover:bg-indigo-700"
                        @endif
                        href="{{ route('dashboard.sftp') }}">
                        View Recived Files
                    </a> --}}
                    {{-- <a
                        @if (Route::currentRouteName() == 'dashboard')
                        class="active btn text-white bg-indigo-600 hover:bg-indigo-700"
                        @else
                        class="btn text-white bg-indigo-600 hover:bg-indigo-700"
                        @endif
                        href="{{ route('dashboard') }}">
                        View Created 837
                    </a> --}}
                {{--     <button
                    class="btn text-white bg-indigo-600 hover:bg-indigo-700"
                    id="createedi"
                    data-bs-toggle="modal"
                    data-bs-target="#ediModal">
                    Create 837
                    </button> --}}
                    {{-- Dynamic Buttons --}}
                    @if($file->status == "P")
                    <a href="{{ route('generate.sftp.999', $file->id) }}"
                        class=" btn text-white bg-indigo-600 hover:bg-indigo-700 ">
                        Generate 999
                    </a>
                    @elseif($file->status == "G")
                    <a href="{{ route('send.sftp.999', $file->id) }}"
                        class=" btn text-white bg-indigo-600 hover:bg-indigo-700 ">
                        Send 999 Ack
                    </a>
                    @endif
                    @if($file->file_string)
                    <a href="{{ route('downlode.sftp.file', $file->id) }}"
                        class=" btn text-white bg-indigo-600 hover:bg-indigo-700 ">
                        Download {{ $file->file_type == "837" ? '837 - Claims' : '275 - Attachments' }}
                    </a>
                    @endif
                    @if($file->ack_file_string)
                    <a href="{{ route('downlode.ack.file', $file->id) }}"
                        class=" btn text-white bg-indigo-600 hover:bg-indigo-700 ">
                        Download Ack
                    </a>
                    @endif
                </div>
        </div>
    </div>
</header>
<div class="flex gap-2"> {{-- Paste the buttons here --}} </div>

<main class="md:-mt-32 mt-5">
    <div class="container">
        {{-- part-1 --}}
        <form id="myform" name="myform" method="POST">
            <div class="md:flex items-start space-x-6 mb-6">
                <!-- Left Column - Patient/Subscriber Information -->
                <div class="bg-white w-1/2 shadow overflow-hidden sm:rounded-lg">
                    <div class="px-4 py-5 sm:px-6 border-b">
                        <div class="md:flex justify-between">
                            <div>
                                <h3 class="text-lg leading-6 font-medium text-gray-900">Patient Information</h3>
                                
                            </div>
                        </div>
                    </div>
                    
                    <div>
                        {{--   <ul class="g-tabs2">
                            <li class="g-tab-link current" data-tab="tab-primary">Subscriber Info</li>
                        </ul>
                        --}}
                        <div id="tab-primary" class="g-tab-content2 current">
                            @if(isset($data['subscriber']))
                            <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Subscriber Name</label>
                                <span class="w-3/4">
                                    {{ $data['subscriber']['last_name'] ?? '' }},
                                    {{ $data['subscriber']['first_name'] ?? '' }}
                                </span>
                            </div>
                            <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Member ID</label>
                                <span class="w-3/4">{{ $data['subscriber']['member_id'] ?? 'N/A' }}</span>
                            </div>
                            <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Address</label>
                                <span class="w-3/4">
                                    {{ $data['subscriber']['address']['street'] ?? 'N/A' }}<br>
                                    @if(isset($data['subscriber']['address']['street2']))
                                    {{ $data['subscriber']['address']['street2'] }}<br>
                                    @endif
                                    {{ $data['subscriber']['location']['city'] ?? '' }},
                                    {{ $data['subscriber']['location']['state'] ?? '' }}
                                    {{ $data['subscriber']['location']['zip'] ?? '' }}
                                </span>
                            </div>
                            @else
                            <div class="p-4 text-center text-gray-500">No subscriber data available</div>
                            @endif
                            
                            @if(isset($data['patient']))
                            <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Patient Name</label>
                                <span class="w-3/4">
                                    {{ $data['patient']['last_name'] ?? '' }},
                                    {{ $data['patient']['first_name'] ?? '' }}
                                </span>
                            </div>
                            <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Patient ID</label>
                                <span class="w-3/4">{{ $data['patient']['member_id'] ?? 'N/A' }}</span>
                            </div>
                            @endif
                        </div>
                        
                    </div>
                </div>
                
                <!-- Right Column - Transmission & System Info -->
                <div class="w-1/2">
                    <div class="bg-white shadow overflow-hidden sm:rounded-lg">
                        <div class="px-4 py-5 sm:px-6 border-b">
                            <div class="md:flex justify-between">
                                <div>
                                    <h3 class="text-lg leading-6 font-medium text-gray-900">Transmission Details</h3>
                                    
                                </div>
                            </div>
                        </div>
                        
                        <div class="pt-3 border-b">
                            {{--  <ul class="g-tabs">
                                <li class="g-tab-link current" data-tab="tab-1">Transmission Details</li>
                            </ul> --}}
                            
                            <div id="tab-1" class="g-tab-content current">
                                <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Transaction Set ID</label>
                                    <span class="w-3/4">{{ $data['st']['transaction_set_id'] ?? 'N/A' }}</span>
                                </div>
                                <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Functional ID Code</label>
                                    <span class="w-3/4">{{ $data['gs']['functional_id_code'] ?? 'N/A' }}</span>
                                </div>
                                <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Control Number</label>
                                    <span class="w-3/4">{{ $data['st']['control_number'] ?? 'N/A' }}</span>
                                </div>
                                <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Segment Count</label>
                                    <span class="w-3/4">{{ $data['se']['segment_count'] ?? 'N/A' }}</span>
                                </div>
                            </div>
                            
                        </div>
                    </div>
                </div>
            </div>
        </form>
        {{-- part-2 --}}
        <form id="myform" name="myform" method="POST">
            <div class="md:flex items-start space-x-6 mb-6">
                <!-- Left Column - Patient/Subscriber Information -->
                <div class="bg-white w-1/2 shadow overflow-hidden sm:rounded-lg">
                    <div class="px-4 py-5 sm:px-6 border-b">
                        <div class="md:flex justify-between">
                            <div>
                                <h3 class="text-lg leading-6 font-medium text-gray-900">Interchange Info</h3>
                                
                            </div>
                        </div>
                    </div>
                    
                    <div>
                        {{--  <ul class="g-tabs2">
                            <li class="g-tab-link current" data-tab="tab-primary">Interchange Info</li>
                        </ul> --}}
                        
                        <div id="tab-primary" class="g-tab-content2 current">
                            <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Sender ID</label>
                                <span class="w-3/4">{{ $data['isa']['sender_id'] ?? 'N/A' }}</span>
                            </div>
                            <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Receiver ID</label>
                                <span class="w-3/4">{{ $data['isa']['receiver_id'] ?? 'N/A' }}</span>
                            </div>
                            <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Transmission Date</label>
                                <span class="w-3/4">
                                    @if(isset($data['isa']['transmission_date']))
                                    {{ substr($data['isa']['transmission_date'], 0, 2) }}/{{ substr($data['isa']['transmission_date'], 2, 2) }}/{{ substr($data['isa']['transmission_date'], 4, 2) }}
                                    @else
                                    N/A
                                    @endif
                                </span>
                            </div>
                            <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Transmission Time</label>
                                <span class="w-3/4">
                                    @if(isset($data['isa']['transmission_time']))
                                    {{ substr($data['isa']['transmission_time'], 0, 2) }}:{{ substr($data['isa']['transmission_time'], 2, 2) }}
                                    @else
                                    N/A
                                    @endif
                                </span>
                            </div>
                            <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                <label class="c-label w-1/3">Interchange Control #</label>
                                <span class="w-3/4">{{ $data['isa']['control_number'] ?? 'N/A' }}</span>
                            </div>
                        </div>
                        
                    </div>
                </div>
                
                <!-- Right Column - Transmission & System Info -->
                <div class="w-1/2">
                    <div class="bg-white shadow overflow-hidden sm:rounded-lg">
                        <div class="px-4 py-5 sm:px-6 border-b">
                            <div class="md:flex justify-between">
                                <div>
                                    <h3 class="text-lg leading-6 font-medium text-gray-900">Functional Group Info</h3>
                                    
                                </div>
                            </div>
                        </div>
                        
                        <div class="pt-3 border-b">
                            {{--  <ul class="g-tabs">
                                <li class="g-tab-link current" data-tab="tab-1">Functional Group</li>
                            </ul> --}}
                            
                            <div id="tab-1" class="g-tab-content current">
                                <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Functional Group Code</label>
                                    <span class="w-3/4">{{ $data['gs']['functional_id_code'] ?? 'N/A' }}</span>
                                </div>
                                <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">GS Date</label>
                                    <span class="w-3/4">
                                        @if(isset($data['gs']['date']))
                                        {{ substr($data['gs']['date'], 0, 4) }}-{{ substr($data['gs']['date'], 4, 2) }}-{{ substr($data['gs']['date'], 6, 2) }}
                                        @else
                                        N/A
                                        @endif
                                    </span>
                                </div>
                                <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">GS Time</label>
                                    <span class="w-3/4">
                                        @if(isset($data['gs']['time']))
                                        {{ substr($data['gs']['time'], 0, 2) }}:{{ substr($data['gs']['time'], 2, 2) }}:{{ substr($data['gs']['time'], 4, 2) }}
                                        @else
                                        N/A
                                        @endif
                                    </span>
                                </div>
                                <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Responsible Agency</label>
                                    <span class="w-3/4">{{ $data['gs']['responsible_agency'] ?? 'N/A' }}</span>
                                </div>
                                <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Version/Release</label>
                                    <span class="w-3/4">{{ $data['gs']['version'] ?? 'N/A' }}</span>
                                </div>
                                <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                                    <label class="c-label w-1/3">Transaction Sets</label>
                                    <span class="w-3/4">{{ $data['ge']['number_of_transaction_sets'] ?? 'N/A' }}</span>
                                </div>
                            </div>
                            
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</main>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
{{-- <script>
const myElement = document.getElementById("customdropdown");
// Toggle the class when the element is clicked
myElement.addEventListener("click", function(event) {
this.classList.toggle("active");
event.stopPropagation(); // Prevent the event from bubbling to document
});
// Remove the class if clicking outside the element
document.addEventListener("click", function(event) {
if (!myElement.contains(event.target)) {
myElement.classList.remove("active");
}
});
document.getElementById('selectcategory_0').addEventListener('change', function() {
var myDiv = document.getElementById('lodging-category-options');
// Toggle between showing and hiding the div
myDiv.style.display = myDiv.style.display === 'none' ? 'block' : 'none';
});
document.getElementById('selectcategory_1').addEventListener('change', function() {
var myDiv = document.getElementById('nutrition-category-options');
// Toggle between showing and hiding the div
myDiv.style.display = myDiv.style.display === 'none' ? 'block' : 'none';
});
document.getElementById('selectcategory_2').addEventListener('change', function() {
var myDiv = document.getElementById('childcare-category-options');
// Toggle between showing and hiding the div
myDiv.style.display = myDiv.style.display === 'none' ? 'block' : 'none';
});
</script>
--}}
<script>
window.onload = displayClock();
function displayClock() {
const currentDate = new Date(new Date().toLocaleString("en-US", {
timeZone: "America/New_York"
}));
var timestamp = currentDate.toString().split('GMT');
var splitstring = timestamp[0].split(" ");
var final_string = splitstring[0] + ', ' + splitstring[1] + ' ' + splitstring[2] + ' ' + splitstring[3] +
', ' + splitstring[4];
$("#clock").text(final_string);
setTimeout(displayClock, 1000);
}
</script>
{{--  <script>
$(document).ready(function() {
$('#callCategorySelect').on('change', function() {
var selectedValue = $(this).val();
// Hide all divs
$('.callCategorySelectoption').hide();
// Show the div if a valid option is selected
if (selectedValue !== "none") {
$('#' + selectedValue).show();
}
});
});
</script>
<script>
function toggleModal(modalID, rowid = null) {
if (modalID == 'modal-example-regular-update') {
loadUpdateUserForm(rowid);
}
if (modalID == 'modal-example-regular-update-ediprofile') {
loadEditProfileUserForm(rowid);
}
if (modalID == 'modal-example-regular-deposit') {
$("#modal-example-regular-deposit .service_id").val(rowid);
}
if (modalID == 'modal-program-configure-alert') {
loadProgramDetailsForm(rowid);
}
if (modalID == 'modal-program-configure-alert-import') {
loadImportForm(rowid);
}
if (modalID == 'modal-program-files') {
loadProgramFilesForm(rowid);
}
if (modalID == 'modal-audit-log') {
loadAuditLog(rowid);
}
document.getElementById(modalID).classList.toggle("hidden");
document.getElementById(modalID + "-backdrop").classList.toggle("hidden");
document.getElementById(modalID + "-backdrop").classList.toggle("flex");
}
function closeModal(modalID) {
document.getElementById(modalID).classList.toggle("hidden");
document.getElementById(modalID + "-backdrop").classList.toggle("hidden");
document.getElementById(modalID + "-backdrop").classList.toggle("flex");
}
$(document).ready(function () {
$('ul.g-tabs li').click(function () {
var tab_id = $(this).attr('data-tab');
$('ul.g-tabs li').removeClass('current');
$('.g-tab-content').removeClass('current');
$(this).addClass('current');
$("#" + tab_id).addClass('current');
});
$('ul.g-tabs1 li').click(function () {
var tab_id = $(this).attr('data-tab');
$('ul.g-tabs1 li').removeClass('current');
$('.g-tab-content1').removeClass('current');
$(this).addClass('current');
$("#" + tab_id).addClass('current');
});
$('ul.g-tabs2 li').click(function () {
var tab_id = $(this).attr('data-tab');
$('ul.g-tabs2 li').removeClass('current');
$('.g-tab-content2').removeClass('current');
$(this).addClass('current');
$("#" + tab_id).addClass('current');
});
$(".eye-button").on('click', function () {
$(".eye-icon").toggleClass('hidden');
$(".extra-info").toggleClass('hidden');
});
});
</script>
<script>
$(document).ready(function(){
var patientInfoVisible = false;
var travelCardInfoVisible = false;
// Toggle Patient Info Visibility
$('#viewPatientInfo').click(function(){
if(!patientInfoVisible){
// Unmask patient details
$('#patientDob').text('01/01/1980').removeClass('masked').addClass('unmasked');
$('#patientAddress').text('123 Main St').removeClass('masked').addClass('unmasked');
$('#patientCity').text('Los Angeles').removeClass('masked').addClass('unmasked');
$('#patientState').text('CA').removeClass('masked').addClass('unmasked');
$('#patientZip').text('90001').removeClass('masked').addClass('unmasked');
$('#patientEmail').text('john.doe@example.com').removeClass('masked').addClass('unmasked');
$('#gender').text('Male').removeClass('masked').addClass('unmasked');
$('#nationality').text('American').removeClass('masked').addClass('unmasked');
$('#EthnicityRace').text('Asian').removeClass('masked').addClass('unmasked');
$('#patientPhone1').text('(123) 456-7890').removeClass('masked').addClass('unmasked');
$('#patientPhone2').text('(098) 765-4321').removeClass('masked').addClass('unmasked');
$('#patientClinicalTrialSite').text('UCLA Medical Center').removeClass('masked').addClass('unmasked');
$('#patientCirmTrialNumber').text('CIRM-12345').removeClass('masked').addClass('unmasked');
$('#patientProgramId').text('PID-67890').removeClass('masked').addClass('unmasked');
$('#patientSiteCoordinator').text('Dr. Smith').removeClass('masked').addClass('unmasked');
$('#patientSiteContactNumber').text('(555) 123-4567').removeClass('masked').addClass('unmasked');
$('#patientSiteContactEmail').text('coordinator@example.com').removeClass('masked').addClass('unmasked');
$(this).html('<i class="fa-regular fa-eye-slash"></i> &nbsp; Hide Patient Info');
patientInfoVisible = true;
} else {
// Mask patient details
$('.patient-detail').each(function(){
$(this).text('••••••••••').removeClass('unmasked').addClass('masked');
});
$('#patientAddress').text('•••••••••••••••••••••••••••••••••');
$('#patientCity').text('••••••••••');
$('#patientState').text('••••••••••');
$('#patientZip').text('•••••');
$('#patientClinicalTrialSite').text('•••••••••••••••••••••••••');
$('#patientCirmTrialNumber').text('•••••••••••••••••••••••••');
$('#patientProgramId').text('•••••••••••••••••••••••••');
$('#patientSiteCoordinator').text('•••••••••••••••••••••••••');
$('#patientSiteContactNumber').text('••••••••••');
$('#patientSiteContactEmail').text('••••••••••••••••••••');
$(this).html('<i class="fa-regular fa-eye"></i> &nbsp; View Patient Info');
patientInfoVisible = false;
}
});
// Toggle Travel Card Information
$('#toggleTravelCardInfo').click(function(){
if(!travelCardInfoVisible){
$('#travelCardNumber').text('1234 5678 9012 3456');
$('#travelCardCVV').text('123');
$('#travelCardExpiration').text('12/26');
$(this).html('<i class="fa-regular fa-eye-slash"></i> &nbsp; Hide Card Information');
travelCardInfoVisible = true;
} else {
$('#travelCardNumber').text('•••• •••• •••• ••••');
$('#travelCardCVV').text('•••');
$('#travelCardExpiration').text('••/••');
$(this).html('<i class="fa-regular fa-eye"></i> &nbsp; Show Card Information');
travelCardInfoVisible = false;
}
});
// Toggle Allowance Card Status
$('#toggleCardStatus').click(function(){
var status = $('#cardStatus').text();
if(status === 'Active'){
$('#cardStatus').text('Suspended')
.removeClass('c-badge c-badge-verified')
.addClass('c-badge c-badge-warning');
$(this).text('Unsuspend Card');
} else {
$('#cardStatus').text('Active')
.removeClass('c-badge c-badge-warning')
.addClass('c-badge c-badge-verified');
$(this).text('Suspend Card');
}
});
// Form submissions
$('#uploadDocumentsForm, #logCallForm, #createRuleForm').submit(function(event){
event.preventDefault();
alert('Form submitted successfully!');
$(this).closest('.modal').modal('hide');
});
// Resend Enrollment Information
$('#resendEnrollmentModal .btn-primary').click(function(){
alert('Enrollment information resent successfully!');
$('#resendEnrollmentModal').modal('hide');
});
});
</script> --}}
@endsection