@extends('layouts.app')
@section('content')
<main class="md:-mt-32 mt-5">
   <div class="container">
      @include('message')
      
      <!-- Filter -->
      
      
      <form id="myform" name="myform" method="POST" action="{{ route('dashboard.sftp') }}" class="relative flex flex-col min-w-0 break-words bg-white w-full mb-12 shadow-lg rounded" style="height: 132px;">
         @csrf
         <div class="relative flex flex-col min-w-0 break-words bg-white w-full mb-12 shadow-lg rounded">
            <div class="md:flex flex-wrap text-xs font-semibold p-2">
               <div class="flex flex-col md:w-1/5 px-2 py-1">
                  <label class="mb-2" for="daterange">Date</label>
                  <input name="daterange" id="daterange" class="rounded-md border py-2 px-3 text-grey-800 w-full h-full" type="date" value="{{ old('daterange', request('daterange')) }}">
               </div>
               <div class="flex flex-col md:w-1/5 px-2 py-1">
                  <label class="mb-2" for="file_type">File Type</label>
                  <select name="file_type" id="file_type" class="rounded-md border py-2 px-3 text-grey-800 w-full h-full">
                     <option value="">Select Type</option>
                     <option value="837" {{ request('file_type') == '837' ? 'selected' : '' }}>837</option>
                     <option value="275" {{ request('file_type') == '275' ? 'selected' : '' }}>275</option>
                  </select>
               </div>
               <div class="flex flex-col md:w-1/5 px-2 py-1">
                  <label class="mb-2" for="ref_id">Reference ID</label>
                  <input name="ref_id" id="ref_id" class="rounded-md border py-2 px-3 text-grey-800 w-full h-full" type="text" value="{{ old('ref_id', request('ref_id')) }}">
               </div>
               <div class="flex flex-col md:w-1/5 px-2 py-1">
                  <label class="mb-2" for="status">999 Status</label>
                  <select name="status" id="status" class="rounded-md border py-2 px-3 text-grey-800 w-full h-full">
                     <option value="">Select Status</option>
                     <option value="P" {{ request('status') == 'P' ? 'selected' : '' }}>Pending</option>
                     <option value="G" {{ request('status') == 'G' ? 'selected' : '' }}>Pending & Generated 999</option>
                     <option value="S" {{ request('status') == 'S' ? 'selected' : '' }}>Sent</option>
                  </select>
               </div>
               <div class="flex flex-col md:w-1/5 px-2 py-1">
                  <label class="mb-2" for="file_name">File Name</label>
                  <input name="file_name" id="file_name" class="rounded-md border py-2 px-3 text-grey-800 w-full h-full" type="text" value="{{ old('file_name', request('file_name')) }}">
               </div>
               <div class="flex flex-row gap-x-4 px-2 py-1 mt-1.5 w-full">
                  <button class="btn btn-primary" type="submit">Search</button>
                  <a href="{{ route('dashboard.sftp') }}" class="btn btn-primary">Reset</a>
               </div>
            </div>
         </div>
      </form>
      <div class="g-table-wrapper">
         <table class="g-table-main text-center">
            <thead>
               <tr>
                  <th class="th-sm px-6 align-middle border border-solid border-blueGray-100 py-3 border-l-0 border-r-0 font-semibold">Received Date/Time</th>
                  <th class="th-sm px-6 align-middle border border-solid border-blueGray-100 py-3 border-l-0 border-r-0 font-semibold"> File Name</th>
                  <th class="th-sm px-6 align-middle border border-solid border-blueGray-100 py-3 border-l-0 border-r-0 font-semibold">File Type</th>
                  <th class="th-sm px-6 align-middle border border-solid border-blueGray-100 py-3 border-l-0 border-r-0 font-semibold">Reference ID</th>
                  <th class="th-sm px-6 align-middle border border-solid border-blueGray-100 py-3 border-l-0 border-r-0 font-semibold">999 Acknowledgment</th>
                  <th class="th-sm px-6 align-middle border border-solid border-blueGray-100 py-3 border-l-0 border-r-0 font-semibold">Action</th>
                  {{-- <th class="th-sm px-6 align-middle border border-solid border-blueGray-100 py-3 border-l-0 border-r-0 font-semibold">Download</th> --}}
               </tr>
            </thead>
            <tbody>
               @if($data->isNotEmpty())
               @foreach ($data as $file)
               <tr>
                  <td class="px-6 align-middle p-4 border-b">{{$file->created_at}}</td>
                    {{-- <td class="px-6 align-middle p-4 border-b"> {{explode("/",$file->file_name)[1]}}</td> --}}
                  <td class="px-6 align-middle p-4 border-b"><a @if($file->file_type=="837") href="{{route('view.sftp.837.file.data',$file->id)}}" @else href="{{route('view.sftp.275.file.data',$file->id)}}" @endif> {{explode("/",$file->file_name)[1]}}</a></td>
                  <td class="px-6 align-middle p-4 border-b">
                     @if($file->file_type=="837")
                     837 - Claims
                     @else
                     275 - Attachments
                     @endif
                  </td>
                  <td class="px-6 align-middle p-4 border-b"> {{$file->ref_id}}
                  </td>
                  <td class="px-6 align-middle p-4 border-b">
                     @if($file->status == "P")
                     <span class="c-badge c-badge-rejected">Pending</span>
                     @elseif($file->status == "G")
                     <span class="c-badge c-badge-rejected">Pending</span>
                     @else
                     <span class="c-badge c-badge-verified">Sent</span>
                     @endif
                  </td>
                 {{--  <td class="px-6 align-middle p-4 border-b">
                     <div class="flex flex-wrap justify-end">
                        @if($file->status=="P")
                        <a class="btn btn-primary btn-sm" href="{{route('generate.sftp.999',$file->id)}}"> Generate 999</a>
                        @elseif($file->status=="G")
                        <a class="btn btn-primary btn-sm" href="{{route('send.sftp.999',$file->id)}}"> Send 999 Ack </a>
                        @endif
                        
                     </div>
                  </td> --}}
                    <td class="px-6 align-middle p-4 border-b">
                      <div class="flex justify-center gap-2">
                          {{-- Button 1: Generate or Send 999 --}}
                          <div>
                              @if($file->status == "P")
                                  <a href="{{ route('generate.sftp.999', $file->id) }}" 
                                     class="btn btn-primary btn-sm text-xs px-3 py-1 rounded bg-gray-800 text-white hover:bg-gray-700 w-full text-left">
                                      Generate 999
                                  </a>
                              @elseif($file->status == "G")
                                  <a href="{{ route('send.sftp.999', $file->id) }}" 
                                     class="btn btn-primary btn-sm text-xs px-3 py-1 rounded bg-gray-800 text-white hover:bg-gray-700 w-full text-left">
                                      Send 999 Ack
                                  </a>
                              
                              @endif
                          </div>

                          {{-- Button 2: Download 837 or 275 --}}
                          <div  >
                              @if($file->file_string)
                                  <a href="{{ route('downlode.sftp.file', $file->id) }}" 
                                     class="btn btn-primary btn-sm text-xs px-3 py-1 rounded bg-gray-800 text-white hover:bg-gray-700 w-full text-left">
                                      Download
                                      @if($file->file_type == "837")
                                          837 - Claims
                                      @else
                                          275 - Attachments
                                      @endif
                                  </a>
                              @endif
                          </div>

                          {{-- Button 3: Download Ack --}}
                          <div >
                              @if($file->ack_file_string)
                                  <a href="{{ route('downlode.ack.file', $file->id) }}" 
                                     class="btn btn-primary btn-sm text-xs px-3 py-1 rounded bg-gray-800 text-white hover:bg-gray-700 w-full text-right">
                                      Download Ack
                                  </a>
                              @endif
                          </div>
                      </div>
                  </td>

               </tr>
               @endforeach
               @else
               <tr>
                  <td colspan="6" class="text-center">No Data Available</td>
               </tr>
               @endif
               
            </tbody>
         </table>
      </div>
      
      {{-- pagination --}}
      {{-- <div class="c-pagination-wrapper">
         <div class="flex flex-col gap-x-1 c-pagination-result">
            <div>
               <span>Result per page:</span>
               <select class="rounded-md border py-2 px-3 text-grey-800 limitbox">
                  <option value="10" selected="">10</option>
                  <option value="25">25</option>
                  <option value="50">50</option>
                  <option value="75">75</option>
                  <option value="100">100</option>
               </select>
            </div>
            <div class="pt-1">Showing 1 to 10 of 100 entries</div>
         </div>
         <ul class="c-pagination">
            <li class="active c-pagination-item"><a class="page-link" href="javascript:void(0)">1</a></li>
            <li class="c-pagination-item"><a class="page-link" href="javascript:void(0)">2</a></li>
            <li class="c-pagination-item"><a class="page-link" href="javascript:void(0)">3</a></li>
            <li class="c-pagination-item"><a class="page-link" href="javascript:void(0)">4</a></li>
            <li class="c-pagination-item"><a class="page-link" href="javascript:void(0)">5</a></li>
            <li class="c-pagination-item"><a class="page-link" href="javascript:void(0)">6</a></li>
            <li class="c-pagination-item"><a class="page-link" href="javascript:void(0)">7</a></li>
            <li class="c-pagination-item"><a class="page-link" href="javascript:void(0)">8</a></li>
            <li class="disabled"><span>...</span></li>
            <li><a class="page-link" href="javascript:void(0)">50</a></li>
            <li class=" c-pagination-item">
               <a class="page-link" href="javascript:void(0)">
                  <svg xmlns="http://www.w3.org/2000/svg" class="h-6" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                  <path stroke-linecap="round" stroke-linejoin="round" d="M9 5l7 7-7 7"></path>
               </svg>
            </a>
         </li>
      </ul>
   </div> --}}
  <div class="c-pagination-wrapper">
    <div class="flex flex-col gap-x-1 c-pagination-result">
        <div>
            <span>Result per page:</span>
            <select class="rounded-md border py-2 px-3 text-grey-800 limitbox" onchange="changeLimit(this.value)">
                @foreach ([10, 25, 50, 75, 100] as $l)
                    <option value="{{ $l }}" {{ $limit == $l ? 'selected' : '' }}>{{ $l }}</option>
                @endforeach
            </select>
        </div>
        <div class="pt-1">
            Showing {{ $data->firstItem() }} to {{ $data->lastItem() }} of {{ $data->total() }} entries
        </div>
    </div>
    <ul class="c-pagination">
        {{-- Previous --}}
        @if ($data->onFirstPage())
            <li class="disabled c-pagination-item">
                <span>
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="none" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M15 5L8 12L15 19"/>
                    </svg>
                </span>
            </li>
        @else
            <li class="c-pagination-item">
                <a class="page-link" href="{{ $data->previousPageUrl() }}&limit={{ $limit }}">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="none" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M15 5L8 12L15 19"/>
                    </svg>
                </a>
            </li>
        @endif
        {{-- Page Numbers --}}
        @for ($i = 1; $i <= $data->lastPage(); $i++)
            @if ($i <= 8 || $i == $data->lastPage())
                <li class="c-pagination-item {{ $i == $data->currentPage() ? 'active' : '' }}">
                    <a class="page-link" href="{{ $data->url($i) }}&limit={{ $limit }}">{{ $i }}</a>
                </li>
            @elseif ($i == 9)
                <li class="disabled"><span>...</span></li>
            @endif
        @endfor
        {{-- Next --}}
        @if ($data->hasMorePages())
            <li class="c-pagination-item">
                <a class="page-link" href="{{ $data->nextPageUrl() }}&limit={{ $limit }}">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="none" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M9 5l7 7-7 7"/>
                    </svg>
                </a>
            </li>
        @else
            <li class="disabled c-pagination-item">
                <span>
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="none" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M9 5l7 7-7 7"/>
                    </svg>
                </span>
            </li>
        @endif
    </ul>
</div>

   
</div>

</main>
<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
$(document).ready(function() {
document.getElementById("movetosecond").addEventListener("click", function() {
// Hide step 1
document.querySelector(".patient-form-step1").classList.add("hidden");
// Show step 2
document.querySelector(".patient-form-step2").classList.remove("hidden");
});
document.getElementById("movetothird").addEventListener("click", function() {
// Hide step 1,2,4
document.querySelector(".patient-form-step1").classList.add("hidden");
document.querySelector(".patient-form-step2").classList.add("hidden");
// Show step 3
document.querySelector(".patient-form-step3").classList.remove("hidden");
});
document.getElementById("closemodal").addEventListener("click", function() {
// Hide step 2,3,4
document.querySelector(".patient-form-step2").classList.add("hidden");
document.querySelector(".patient-form-step3").classList.add("hidden");
// Show step 1
document.querySelector(".patient-form-step1").classList.remove("hidden");
});
});
</script>
<script>
window.onload = displayClock();
function displayClock() {
const currentDate = new Date(new Date().toLocaleString("en-US", {
timeZone: "America/New_York"
}));
var timestamp = currentDate.toString().split('GMT');
var splitstring = timestamp[0].split(" ");
var final_string = splitstring[0] + ', ' + splitstring[1] + ' ' + splitstring[2] + ' ' + splitstring[3] +
', ' + splitstring[4];
$("#clock").text(final_string);
setTimeout(displayClock, 1000);
}
</script>
<!-- JavaScript to Handle Form Submission -->
<script>
document.getElementById('ediForm').addEventListener('submit', function(event) {
event.preventDefault();
var selectedRoute = document.getElementById('ediType').value;
if (selectedRoute) {
window.location.href = selectedRoute;
}
});
</script>
<!-- Bootstrap 5 (Make sure it's included) -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
function changeLimit(limit) {
const url = new URL(window.location.href);
url.searchParams.set('limit', limit);
url.searchParams.set('page', 1); // reset to page 1
window.location.href = url.toString();
}
</script>
@endsection