@extends('layouts.app')
@section('content')
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
{{-- @include('message') --}}
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<style>
.btn.text-white {
padding: 4px 14px;
font-size: 13px;
font-weight: 600;
border-radius: 6px;
line-height: 1.5;
display: inline-block;
text-align: center;
white-space: nowrap;
vertical-align: middle;
transition: background-color 0.2s ease-in-out;
background-color: rgb(79 70 229);
}
.form-group{
margin-bottom: 20px;
}
.step { display: none; }
.active { display: block; }
.next, .prev {
padding: 6px 16px;       /* good horizontal and vertical padding */
font-size: 14px;
border-radius: 6px;
border: none;
cursor: pointer;
width: auto;
height: auto;
display: inline-block;
text-align: center;
line-height: normal;
background-color: #0d6efd;  /* for .next */
color: white;
margin-right: 10px;
margin-bottom: 10px;
margin-top: 10px;
}
.prev {
background-color: orange;
}
#multiStepForm {
width: 50%;
background: white;
padding: 20px;
margin: 50px auto;
border-radius: 10px;
box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
}
/*  .step {
display: none;
}
.active {
display: block;
}*/
.step {
display: none;
}
.step.active {
display: flex; /* or block, but flex works better for columns */
flex-wrap: wrap;
}
h2 {
color: #333;
}
input {
width: 30%;
padding: 10px;
/*margin: 10px 0;*/
border: 1px solid #ccc;
border-radius: 5px;
font-size: 16px;
}
button {
background-color: #007bff;
color: white;
border: none;
padding: 10px 15px;
font-size: 16px;
cursor: pointer;
border-radius: 5px;
transition: 0.3s;
}
button:hover {
background-color: #0056b3;
}
.prev {
background-color: #6c757d;
}
.prev:hover {
background-color: #5a6268;
}
.submit {
background-color: #28a745;
}
.submit:hover {
background-color: #218838;
}
.form-control{
width: 30%;
}
.g-header{
padding-bottom: 0 !important;
}
.btn-container>div{
padding: 2.5rem 0 !important;
}
.mb-n10{
margin-bottom: -10px!important;
}
.mainmenu{
margin-bottom: 0!important;
}
.g-header .divide-x{
align-items: center;
}
.g-header  .divide-x p{
margin-bottom: 0;
}
.g-header .divide-x button{
padding: 0!important;
}
.fa-solid.fa-xmark{
display: none;
}
</style>
<style>
input:read-only {
background-color: #f5f5f5;  /* Light grey background */
color: #555;               /* Text color */
border: 1px solid #ccc;    /* Optional: border style */
cursor: not-allowed;       /* Optional: indicate it's non-editable */
}
</style>
<main class="md:-mt-32 mt-5">
    <div class="container">
        {{-- <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet"> --}}
        @include('message')
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
       {{--  <form id="providerInitialForm" method="POST" action="{{ route('create.provider') }}" class="space-y-4">
            @csrf
            
            <div class="card p-6 max-w-6xl mx-auto">
                <h2 class="text-xl font-semibold mb-6">Create New Provider Account</h2>
                
                <div class="space-y-4">
                    <div class="row">
                        <div class="col-md-4">
                            <label for="name" class="block mb-1">Provider Name*</label>
                            <input type="text" id="name" name="name" required class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                        </div>
                        <div class="col-md-4">
                            <label for="email" class="block mb-1">Email Address*</label>
                            <input type="email" id="email" name="email" required class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                        </div>
                    </div>
                    <p class="text-sm text-gray-500 mt-1">A temporary password will be generated and sent to this email</p>
                </div>
                <!-- Provider Information Section -->
                <div class="mt-6 space-y-4">
                    <h5 class="text-lg font-medium border-b pb-2">Provider Information</h5>
                    <div class="row">
                        <div class="col-md-4">
                            <label for="provider_clinic_name" class="block mb-1">Provider/Clinic Name*</label>
                            <input type="text" id="provider_clinic_name" name="provider_clinic_name" required value="{{ old('provider_clinic_name') }}" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                        </div>
                        <div class="col-md-4">
                            <label for="npi" class="block mb-1">NPI (National Provider Identifier)*</label>
                            <input type="text" id="npi" name="npi" required value="{{ old('npi') }}" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500" minlength="10">
                        </div>
                        <div class="col-md-4">
                            <label for="tax_id" class="block mb-1">Tax ID *</label>
                            <input type="text" id="tax_id" name="tax_id" required value="{{ old('tax_id') }}" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4">
                            <label for="provider_type" class="block mb-1">Provider Type*</label>
                            <select id="provider_type" name="provider_type" required class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                                <option value="">Select Type</option>
                                <option value="Individual" {{ old('provider_type') == 'Individual' ? 'selected' : '' }}>Individual</option>
                                <option value="Organization" {{ old('provider_type') == 'Organization' ? 'selected' : '' }}>Organization</option>
                            </select>
                        </div>
                        <div class="col-md-4">
                            <label for="specialty" class="block mb-1">Specialty*</label>
                            <input type="text" id="specialty" name="specialty" required value="{{ old('specialty') }}" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                        </div>
                        <div class="col-md-4">
                            <label for="license_number" class="block mb-1">License Number*</label>
                            <input type="text" id="license_number" name="license_number" required value="{{ old('license_number') }}" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4">
                            <label for="license_state" class="block mb-1">Issuing State*</label>
                            <input type="text" id="license_state" name="license_state" required maxlength="2" value="{{ old('license_state') }}" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                        </div>
                    </div>
                </div>
                <!-- Contact Information Section -->
                <div class="mt-6 space-y-4">
                    <h5 class="text-lg font-medium border-b pb-2">Contact Information</h5>
                    <div class="row">
                        <div class="col-md-4">
                            <label for="primary_contact_name" class="block mb-1">Primary Contact Name*</label>
                            <input type="text" id="primary_contact_name" required name="primary_contact_name" value="{{ old('primary_contact_name') }}" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                        </div>
                        <div class="col-md-4">
                            <label for="phone_number" class="block mb-1">Phone Number*</label>
                            <input type="tel" id="phone_number" name="phone_number" required value="{{ old('phone_number') }}" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                        </div>
                        <div class="col-md-4">
                            <label for="fax_number" class="block mb-1">Fax Number*</label>
                            <input type="tel" id="fax_number" required name="fax_number" value="{{ old('fax_number') }}" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                        </div>
                    </div>
                </div>
                <!-- Facility Information Section -->
                <div class="mt-6 space-y-4">
                    <h5 class="text-lg font-medium border-b pb-2">Facility Information</h5>
                    <div class="row">
                        <div class="col-md-4">
                            <label for="f_name" class="block mb-1">Facility Name*</label>
                            <input type="text" id="f_name" name="f_name" required value="{{ old('f_name') }}" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                        </div>
                        <div class="col-md-4">
                            <label for="f_npi" class="block mb-1">Facility Npi*</label>
                            <input type="text" id="f_npi" name="f_npi" required value="{{ old('f_npi') }}" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                        </div>
                        <div class="col-md-4">
                            <label for="f_street" class="block mb-1">Facility Street*</label>
                            <input type="text" id="f_street" name="f_street" required value="{{ old('f_street') }}" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                        </div>
                        <div class="col-md-4">
                            <label for="f_city" class="block mb-1">Facility City*</label>
                            <input type="text" id="f_city" name="f_city" required value="{{ old('f_city') }}" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                        </div>
                        <div class="col-md-4">
                            <label for="f_state" class="block mb-1">Facility State*</label>
                            <input type="text" id="f_state" name="f_state" value="{{ old('f_state') }}" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500" maxlength="2">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4">
                            <label for="f_zip" class="block mb-1">Facility ZIP Code*</label>
                            <input type="text" id="f_zip" name="f_zip" required value="{{ old('f_zip') }}" minlength="9" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                        </div>
                    </div>
                </div>
                <!-- Service Location Address -->
                <div class="mt-6 space-y-4">
                    <h5 class="text-lg font-medium border-b pb-2">Service Location Address</h5>
                    <div class="row">
                        <div class="col-md-4">
                            <label for="service_street" class="block mb-1">Street*</label>
                            <input type="text" id="service_street" name="service_street" required value="{{ old('service_street') }}" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                        </div>
                        <div class="col-md-4">
                            <label for="service_city" class="block mb-1">City*</label>
                            <input type="text" id="service_city" name="service_city" required value="{{ old('service_city') }}" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                        </div>
                        <div class="col-md-4">
                            <label for="service_state" class="block mb-1">State*</label>
                            <input type="text" id="service_state" name="service_state" value="{{ old('service_state') }}" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500" maxlength="2">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4">
                            <label for="service_zip_code" class="block mb-1">ZIP Code*</label>
                            <input type="text" id="service_zip_code" name="service_zip_code" required value="{{ old('service_zip_code') }}" minlength="9" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                        </div>
                    </div>
                </div>
                <!-- Billing Address Toggle -->
                <div class="mt-6 space-y-4">
                    <label class="inline-flex items-center">
                        <input type="checkbox" id="different_billing" name="different_billing" class="mr-2" {{ old('different_billing') ? 'checked' : '' }}>
                        <span>Billing address is different from service location</span>
                    </label>
                    <div id="billingAddressFields" class="{{ old('different_billing') ? '' : 'hidden' }}">
                        <h5 class="text-lg font-medium border-b pb-2">Billing Address</h5>
                        <div class="row">
                            <div class="col-md-4">
                                <label for="billing_street" class="block mb-1">Street</label>
                                <input type="text" id="billing_street" name="billing_street" value="{{ old('billing_street') }}" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                            </div>
                            <div class="col-md-4">
                                <label for="billing_city" class="block mb-1">City</label>
                                <input type="text" id="billing_city" name="billing_city" value="{{ old('billing_city') }}" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                            </div>
                            <div class="col-md-4">
                                <label for="billing_state" class="block mb-1">State</label>
                                <input type="text" id="billing_state" name="billing_state" value="{{ old('billing_state') }}" maxlength="2" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4">
                                <label for="billing_zip_code" class="block mb-1">ZIP Code</label>
                                <input type="text" id="billing_zip_code" name="billing_zip_code" value="{{ old('billing_zip_code') }}" minlength="9" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="mt-6">
                    <button type="submit" class="btn btn-primary w-full py-2">Create Provider Account</button>
                </div>
            </div>
        </form> --}}








        <form id="providerInitialForm" method="POST" action="{{ route('create.provider') }}" class="space-y-4">
    @csrf
    
    <div class="card p-6 max-w-6xl mx-auto">
        <h2 class="text-xl font-semibold mb-6">Create New Provider Account</h2>
        
        <div class="space-y-4">
            <div class="row">
                <div class="col-md-4">
                    <label for="name" class="block mb-1">Provider Name*</label>
                    <input type="text" id="name" name="name" required class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <p class="text-xs text-gray-500 mt-1">EDI Segment: NM1 (08 - Provider Name)</p>
                </div>
                <div class="col-md-4">
                    <label for="email" class="block mb-1">Email Address*</label>
                    <input type="email" id="email" name="email" required class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <p class="text-xs text-gray-500 mt-1">Used for account communication only</p>
                </div>
            </div>
            <p class="text-sm text-gray-500 mt-1">A temporary password will be generated and sent to this email</p>
        </div>
        
        <!-- Provider Information Section -->
        <div class="mt-6 space-y-4">
            <h5 class="text-lg font-medium border-b pb-2">Provider Information</h5>
            <div class="row">
                <div class="col-md-4">
                    <label for="provider_clinic_name" class="block mb-1">Clinic Name*</label>
                    <input type="text" id="provider_clinic_name" name="provider_clinic_name" required value="{{ old('provider_clinic_name') }}" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <p class="text-xs text-gray-500 mt-1">EDI Segment: NM1 (03 - Billing Provider Name)</p>
                </div>
                <div class="col-md-4">
                    <label for="npi" class="block mb-1">NPI (National Provider Identifier)*</label>
                    <input type="text" id="npi" name="npi" required value="{{ old('npi') }}" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500" minlength="10" maxlength="10" pattern="\d{10}">
                    <p class="text-xs text-gray-500 mt-1">Must be 10 digits. EDI Segment: REF (0F - Provider NPI)</p>
                </div>
                <div class="col-md-4">
                    <label for="tax_id" class="block mb-1">Tax ID *</label>
                    <input type="text" id="tax_id" name="tax_id" required value="{{ old('tax_id') }}" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500" pattern="\d{9}">
                    <p class="text-xs text-gray-500 mt-1">9 digits only. EDI Segment: REF (EI - Employer's Identification Number)</p>
                </div>
            </div>
            <div class="row">
                <div class="col-md-4">
                    <label for="provider_type" class="block mb-1">Provider Type*</label>
                    <select id="provider_type" name="provider_type" required class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <option value="">Select Type</option>
                        <option value="Individual" {{ old('provider_type') == 'Individual' ? 'selected' : '' }}>Individual</option>
                        <option value="Organization" {{ old('provider_type') == 'Organization' ? 'selected' : '' }}>Organization</option>
                    </select>
                    <p class="text-xs text-gray-500 mt-1">EDI Segment: NM1 (02 - Entity Type Qualifier)</p>
                </div>
                <div class="col-md-4">
                    <label for="specialty" class="block mb-1">Specialty*</label>
                    <input type="text" id="specialty" name="specialty" required value="{{ old('specialty') }}" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <p class="text-xs text-gray-500 mt-1">EDI Segment: PRV (PE - Rendering Provider Specialty)</p>
                </div>
                <div class="col-md-4">
                    <label for="license_number" class="block mb-1">License Number*</label>
                    <input type="text" id="license_number" name="license_number" required value="{{ old('license_number') }}" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <p class="text-xs text-gray-500 mt-1">EDI Segment: REF (1G - Provider License Number)</p>
                </div>
            </div>
            <div class="row">
                <div class="col-md-4">
                    <label for="license_state" class="block mb-1">Issuing State*</label>
                    <input type="text" id="license_state" name="license_state" required maxlength="2" value="{{ old('license_state') }}" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500" pattern="[A-Za-z]{2}">
                    <p class="text-xs text-gray-500 mt-1">2-letter state code. EDI Segment: REF (1G - State)</p>
                </div>
            </div>
        </div>
        
        <!-- Contact Information Section -->
        <div class="mt-6 space-y-4">
            <h5 class="text-lg font-medium border-b pb-2">Contact Information</h5>
            <div class="row">
                <div class="col-md-4">
                    <label for="primary_contact_name" class="block mb-1">Primary Contact Name*</label>
                    <input type="text" id="primary_contact_name" required name="primary_contact_name" value="{{ old('primary_contact_name') }}" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <p class="text-xs text-gray-500 mt-1">EDI Segment: PER (Contact Information)</p>
                </div>
                <div class="col-md-4">
                    <label for="phone_number" class="block mb-1">Phone Number*</label>
                    <input type="tel" id="phone_number" name="phone_number" required value="{{ old('phone_number') }}" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500" pattern="[0-9]{10}">
                    <p class="text-xs text-gray-500 mt-1">10 digits only. EDI Segment: PER (TE - Telephone)</p>
                </div>
                <div class="col-md-4">
                    <label for="fax_number" class="block mb-1">Fax Number*</label>
                    <input type="tel" id="fax_number" required name="fax_number" value="{{ old('fax_number') }}" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500" pattern="[0-9]{10}">
                    <p class="text-xs text-gray-500 mt-1">10 digits only. EDI Segment: PER (FX - Fax)</p>
                </div>
            </div>
        </div>
        
        <!-- Facility Information Section -->
        <div class="mt-6 space-y-4">
            <h5 class="text-lg font-medium border-b pb-2">Facility Information</h5>
            <div class="row">
                <div class="col-md-4">
                    <label for="f_name" class="block mb-1">Facility Name*</label>
                    <input type="text" id="f_name" name="f_name" required value="{{ old('f_name') }}" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <p class="text-xs text-gray-500 mt-1">EDI Segment: NM1 (85 - Facility Name)</p>
                </div>
                <div class="col-md-4">
                    <label for="f_npi" class="block mb-1">Facility Npi*</label>
                    <input type="text" id="f_npi" name="f_npi" required value="{{ old('f_npi') }}" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500" minlength="10" maxlength="10" pattern="\d{10}">
                    <p class="text-xs text-gray-500 mt-1">10 digits only. EDI Segment: REF (1J - Facility NPI)</p>
                </div>
                <div class="col-md-4">
                    <label for="f_street" class="block mb-1">Facility Street*</label>
                    <input type="text" id="f_street" name="f_street" required value="{{ old('f_street') }}" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <p class="text-xs text-gray-500 mt-1">EDI Segment: N3 (Facility Address Line)</p>
                </div>
            </div>
            <div class="row">
                <div class="col-md-4">
                    <label for="f_city" class="block mb-1">Facility City*</label>
                    <input type="text" id="f_city" name="f_city" required value="{{ old('f_city') }}" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <p class="text-xs text-gray-500 mt-1">EDI Segment: N4 (Facility City)</p>
                </div>
                <div class="col-md-4">
                    <label for="f_state" class="block mb-1">Facility State*</label>
                    <input type="text" id="f_state" name="f_state" value="{{ old('f_state') }}" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500" maxlength="2" pattern="[A-Za-z]{2}" required>
                    <p class="text-xs text-gray-500 mt-1">2-letter state code. EDI Segment: N4 (Facility State)</p>
                </div>
                <div class="col-md-4">
                    <label for="f_zip" class="block mb-1">Facility ZIP Code*</label>
                    <input type="text" id="f_zip" name="f_zip" required value="{{ old('f_zip') }}" minlength="9" maxlength="9" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500" >
                    <p class="text-xs text-gray-500 mt-1">Format: 123456789  EDI Segment: N4 (Facility ZIP)</p>
                </div>
            </div>
        </div>
        
        <!-- Service Location Address -->
        <div class="mt-6 space-y-4">
            <h5 class="text-lg font-medium border-b pb-2">Service Location Address</h5>
            <div class="row">
                <div class="col-md-4">
                    <label for="service_street" class="block mb-1">Street*</label>
                    <input type="text" id="service_street" name="service_street" required value="{{ old('service_street') }}" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <p class="text-xs text-gray-500 mt-1">EDI Segment: N3 (Service Location Address)</p>
                </div>
                <div class="col-md-4">
                    <label for="service_city" class="block mb-1">City*</label>
                    <input type="text" id="service_city" name="service_city" required value="{{ old('service_city') }}" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <p class="text-xs text-gray-500 mt-1">EDI Segment: N4 (Service Location City)</p>
                </div>
                <div class="col-md-4">
                    <label for="service_state" class="block mb-1">State*</label>
                    <input type="text" id="service_state" name="service_state" value="{{ old('service_state') }}" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500" maxlength="2" pattern="[A-Za-z]{2}" required>
                    <p class="text-xs text-gray-500 mt-1">2-letter state code. EDI Segment: N4 (Service Location State)</p>
                </div>
            </div>
            <div class="row">
                <div class="col-md-4">
                    <label for="service_zip_code" class="block mb-1">ZIP Code*</label>
                    <input type="text" id="service_zip_code" name="service_zip_code" required value="{{ old('service_zip_code') }}" minlength="9" maxlength="9" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500" >
                    <p class="text-xs text-gray-500 mt-1">Format: 12345678 EDI Segment: N4 (Service Location ZIP)</p>
                </div>
            </div>
        </div>
        <style>
            input[type="checkbox"] {
                    cursor: pointer !important;
                    pointer-events: auto !important;
                }

        </style>
        <!-- Billing Address Toggle -->
        <div class="mt-6 space-y-4">
            <label class="inline-flex items-center">
                <input type="checkbox" id="different_billing" name="different_billing" class="mr-2" {{ old('different_billing') ? 'checked' : '' }}>
                <span>Billing address is different from service location</span>
            </label>
            <div id="billingAddressFields" class="{{ old('different_billing') ? '' : 'hidden' }}">
                <h5 class="text-lg font-medium border-b pb-2">Billing Address</h5>
                <div class="row">
                    <div class="col-md-4">
                        <label for="billing_street" class="block mb-1">Street</label>
                        <input type="text" id="billing_street" name="billing_street" value="{{ old('billing_street') }}" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <p class="text-xs text-gray-500 mt-1">EDI Segment: N3 (Billing Address)</p>
                    </div>
                    <div class="col-md-4">
                        <label for="billing_city" class="block mb-1">City</label>
                        <input type="text" id="billing_city" name="billing_city" value="{{ old('billing_city') }}" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <p class="text-xs text-gray-500 mt-1">EDI Segment: N4 (Billing City)</p>
                    </div>
                    <div class="col-md-4">
                        <label for="billing_state" class="block mb-1">State</label>
                        <input type="text" id="billing_state" name="billing_state" value="{{ old('billing_state') }}" maxlength="2" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500" pattern="[A-Za-z]{2}">
                        <p class="text-xs text-gray-500 mt-1">2-letter state code. EDI Segment: N4 (Billing State)</p>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-4">
                        <label for="billing_zip_code" class="block mb-1">ZIP Code</label>
                        <input type="text" id="billing_zip_code" name="billing_zip_code" value="{{ old('billing_zip_code') }}" minlength="9" maxlength="9" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500" >
                        <p class="text-xs text-gray-500 mt-1">Format: 123456789  EDI Segment: N4 (Billing ZIP)</p>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="mt-6">
            <button type="submit" class="btn btn-primary w-full py-2" style="width:200px">Create Provider Account</button>
        </div>
    </div>
</form>
        
        
        
        
    </div>
</main>
<script>
window.onload = displayClock();
function displayClock() {
const currentDate = new Date(new Date().toLocaleString("en-US", {
timeZone: "America/New_York"
}));
var timestamp = currentDate.toString().split('GMT');
var splitstring = timestamp[0].split(" ");
var final_string = splitstring[0] + ', ' + splitstring[1] + ' ' + splitstring[2] + ' ' + splitstring[3] +
', ' + splitstring[4];
$("#clock").text(final_string);
setTimeout(displayClock, 1000);
}
</script>
<!-- JavaScript to Handle Form Submission -->
<script>
document.getElementById('different_billing').addEventListener('change', function() {
document.getElementById('billingAddressFields').style.display = this.checked ? 'block' : 'none';
// Optional: Make billing address fields required when checkbox is checked
const billingFields = document.querySelectorAll('#billingAddressFields [name]');
billingFields.forEach(field => {
if (this.checked) {
field.setAttribute('required', 'required');
} else {
field.removeAttribute('required');
}
});
});
// Initialize the form state based on old input
document.addEventListener('DOMContentLoaded', function() {
const differentBilling = document.getElementById('different_billing');
if (differentBilling.checked) {
document.getElementById('billingAddressFields').style.display = 'block';
}
});
</script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Toggle billing address fields
    document.getElementById('different_billing').addEventListener('change', function() {
        document.getElementById('billingAddressFields').classList.toggle('hidden', !this.checked);
    });
    
    // Form validation
    document.getElementById('providerInitialForm').addEventListener('submit', function(e) {
        let isValid = true;
        
        // Validate NPI fields (10 digits)
        const npiFields = ['npi', 'f_npi'];
        npiFields.forEach(field => {
            const value = document.getElementById(field).value;
            if (!/^\d{10}$/.test(value)) {
                alert(`Please enter a valid 10-digit NPI for ${field}`);
                isValid = false;
            }
        });
        
        // Validate Tax ID (9 digits)
        const taxId = document.getElementById('tax_id').value;
        if (!/^\d{9}$/.test(taxId)) {
            alert('Please enter a valid 9-digit Tax ID');
            isValid = false;
        }
        
        // Validate state fields (2 letters)
        const stateFields = ['license_state', 'f_state', 'service_state', 'billing_state'];
        stateFields.forEach(field => {
            const element = document.getElementById(field);
            if (element && !element.disabled && !/^[A-Za-z]{2}$/.test(element.value)) {
                alert(`Please enter a valid 2-letter state code for ${field}`);
                isValid = false;
            }
        });
        
        // Validate ZIP codes (5 or 9 digits)
        // const zipFields = ['f_zip', 'service_zip_code', 'billing_zip_code'];
        // zipFields.forEach(field => {
        //     const element = document.getElementById(field);
        //     if (element && !element.disabled && !/^\d{5}(-\d{4})?$/.test(element.value)) {
        //         alert(`Please enter a valid ZIP code (12345 or 12345-6789) for ${field}`);
        //         isValid = false;
        //     }
        // });
        
        if (!isValid) {
            e.preventDefault();
        }
    });
});
</script>
@endsection