@extends('layouts.app')
@section('content')
<main class="md:-mt-32 mt-5">
    <div class="container">
        {{-- <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet"> --}}
        @include('message')
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        
        <!-- Filter -->
        <form id="myform" name="myform" method="POST" action="{{ route('all.providers') }}" class="relative flex flex-col min-w-0 break-words bg-white w-full mb-12 shadow-lg rounded" style="height: 132px;">
            @csrf
            <div class="relative flex flex-col min-w-0 break-words bg-white w-full mb-12 shadow-lg rounded">
                <div class="md:flex flex-wrap text-xs font-semibold p-2">
                    <div class="flex flex-col md:w-1/5 px-2 py-1">
                        <label class="mb-2" for="daterange">Date</label>
                        <input name="daterange" id="daterange" class="rounded-md border py-2 px-3 text-grey-800 w-full h-full" type="date" value="{{ old('daterange', request('daterange')) }}">
                    </div>
                    
                    <div class="flex flex-col md:w-1/5 px-2 py-1">
                        <label class="mb-2" for="name">Provider Name</label>
                        <input name="name" id="name" class="rounded-md border py-2 px-3 text-grey-800 w-full h-full" type="text" value="{{ old('name', request('name')) }}">
                    </div>
                    
                    <div class="flex flex-row gap-x-4 px-2 py-1 mt-1.5 w-full">
                        <button class="btn btn-primary" type="submit">Search</button>
                        <a href="{{ route('all.providers') }}" class="btn btn-primary">Reset</a>
                    </div>
                </div>
            </div>
        </form>
        
        <div class="g-table-wrapper">
            <table class="g-table-main text-center">
                <thead>
                    <tr>
                        
                        <th class="th-sm px-6 align-middle border border-solid border-blueGray-100 py-3 border-l-0 border-r-0 font-semibold">Created Date/Time</th>
                        <th class="th-sm px-6 align-middle border border-solid border-blueGray-100 py-3 border-l-0 border-r-0 font-semibold">Provider Name </th>
                        <th class="th-sm px-6 align-middle border border-solid border-blueGray-100 py-3 border-l-0 border-r-0 font-semibold"> Provider Email</th>
                        <th class="th-sm px-6 align-middle border border-solid border-blueGray-100 py-3 border-l-0 border-r-0 font-semibold">Profile Completed Status</th>
                        
                        <th class="th-sm px-6 align-middle border border-solid border-blueGray-100 py-3 border-l-0 border-r-0 font-semibold">Action</th>
                    </tr>
                </thead>
                <tbody>
                    @if($data->isNotEmpty())
                    @foreach ($data as $val)
                    <tr>
                        
                        <td class="px-6 align-middle p-4 border-b">{{ $val->created_at }}</td>
                        
                        <td class="px-6 align-middle p-4 border-b">{{ $val->name }}</td>
                        <td class="px-6 align-middle p-4 border-b">{{ $val->email }}</td>
                        <td class="px-6 align-middle p-4 border-b">{{ @$val->username ?"Completed":"Not Completed" }}</td>
                        
                        <td>
                            
                            <a href="{{route('provider.view',$val->id)}}" class="btn btn-primary btn-sm" id="createedi" > View</a>
                            
                            
                        </td>
                        
                    </tr>
              
                    @endforeach
                    @else
                    <tr>
                        <td colspan="4" class="text-center">No Data Available</td>
                    </tr>
                    @endif
                </tbody>
            </table>
        </div>
        
        
        <div class="c-pagination-wrapper">
            <div class="flex flex-col gap-x-1 c-pagination-result">
                <div>
                    <span>Result per page:</span>
                    <select class="rounded-md border py-2 px-3 text-grey-800 limitbox" onchange="changeLimit(this.value)">
                        @foreach ([10, 25, 50, 75, 100] as $l)
                        <option value="{{ $l }}" {{ $limit == $l ? 'selected' : '' }}>{{ $l }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="pt-1">
                    Showing {{ $data->firstItem() }} to {{ $data->lastItem() }} of {{ $data->total() }} entries
                </div>
            </div>
            <ul class="c-pagination">
                {{-- Previous --}}
                @if ($data->onFirstPage())
                <li class="disabled c-pagination-item">
                    <span>
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="none" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M15 5L8 12L15 19"/>
                        </svg>
                    </span>
                </li>
                @else
                <li class="c-pagination-item">
                    <a class="page-link" href="{{ $data->previousPageUrl() }}&limit={{ $limit }}">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="none" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M15 5L8 12L15 19"/>
                        </svg>
                    </a>
                </li>
                @endif
                {{-- Page Numbers --}}
                @for ($i = 1; $i <= $data->lastPage(); $i++)
                @if ($i <= 8 || $i == $data->lastPage())
                <li class="c-pagination-item {{ $i == $data->currentPage() ? 'active' : '' }}">
                    <a class="page-link" href="{{ $data->url($i) }}&limit={{ $limit }}">{{ $i }}</a>
                </li>
                @elseif ($i == 9)
                <li class="disabled"><span>...</span></li>
                @endif
                @endfor
                {{-- Next --}}
                @if ($data->hasMorePages())
                <li class="c-pagination-item">
                    <a class="page-link" href="{{ $data->nextPageUrl() }}&limit={{ $limit }}">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="none" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M9 5l7 7-7 7"/>
                        </svg>
                    </a>
                </li>
                @else
                <li class="disabled c-pagination-item">
                    <span>
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="none" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M9 5l7 7-7 7"/>
                        </svg>
                    </span>
                </li>
                @endif
            </ul>
        </div>
    </div>
</main>
<script>
$(document).ready(function() {
document.getElementById("movetosecond").addEventListener("click", function() {
// Hide step 1
document.querySelector(".patient-form-step1").classList.add("hidden");
// Show step 2
document.querySelector(".patient-form-step2").classList.remove("hidden");
});
document.getElementById("movetothird").addEventListener("click", function() {
// Hide step 1,2,4
document.querySelector(".patient-form-step1").classList.add("hidden");
document.querySelector(".patient-form-step2").classList.add("hidden");
// Show step 3
document.querySelector(".patient-form-step3").classList.remove("hidden");
});
document.getElementById("closemodal").addEventListener("click", function() {
// Hide step 2,3,4
document.querySelector(".patient-form-step2").classList.add("hidden");
document.querySelector(".patient-form-step3").classList.add("hidden");
// Show step 1
document.querySelector(".patient-form-step1").classList.remove("hidden");
});
});
</script>
<script>
window.onload = displayClock();
function displayClock() {
const currentDate = new Date(new Date().toLocaleString("en-US", {
timeZone: "America/New_York"
}));
var timestamp = currentDate.toString().split('GMT');
var splitstring = timestamp[0].split(" ");
var final_string = splitstring[0] + ', ' + splitstring[1] + ' ' + splitstring[2] + ' ' + splitstring[3] +
', ' + splitstring[4];
$("#clock").text(final_string);
setTimeout(displayClock, 1000);
}
</script>
<!-- JavaScript to Handle Form Submission -->
<script>
document.getElementById('ediForm').addEventListener('submit', function(event) {
event.preventDefault();
var selectedRoute = document.getElementById('ediType').value;
if (selectedRoute) {
window.location.href = selectedRoute;
}
});
</script>
<!-- Bootstrap 5 (Make sure it's included) -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
function changeLimit(limit) {
const url = new URL(window.location.href);
url.searchParams.set('limit', limit);
url.searchParams.set('page', 1); // reset to page 1
window.location.href = url.toString();
}
</script>
<script>
document.getElementById('different_billing').addEventListener('change', function() {
document.getElementById('billingAddressFields').style.display = this.checked ? 'block' : 'none';
// Optional: Make billing address fields required when checkbox is checked
const billingFields = document.querySelectorAll('#billingAddressFields [name]');
billingFields.forEach(field => {
if (this.checked) {
field.setAttribute('required', 'required');
} else {
field.removeAttribute('required');
}
});
});
// Initialize the form state based on old input
document.addEventListener('DOMContentLoaded', function() {
const differentBilling = document.getElementById('different_billing');
if (differentBilling.checked) {
document.getElementById('billingAddressFields').style.display = 'block';
}
});
</script>
@endsection