@extends('layouts.app')
<header class="g-header md:pb-32">
	<div class="container">
		<div class="border-b border-gray-700">
			<div class="flex items-center justify-between h-16 px-4 sm:px-0">
				<div class="flex items-center">
					<div class="flex-shrink-0">
						<a href="javascript:void(0)" style="text-decoration: none;" class="font-light block text-center text-white text-2xl">Klyre<span class="font-bold">Payments</span></a>
					</div>
					<div class="hidden md:block">
						<div class="ml-10 flex items-baseline space-x-4">
							<nav>
								<ul class="mainmenu">
									<li>
										<a href="javascript:void(0)" class="menuitem"style="text-decoration: none;">Dashboard</a>
									</li>
									<li>
										<a href="{{route('dashboard')}}" class="menuitem"style="text-decoration: none;">EDI Files</a>
									</li>
									
								</ul>
							</nav>
						</div>
					</div>
				</div>
				@include('message')
				<div class="hidden md:block text-right">
					<div class="flex divide-x divide-gray-500">
						<div class="text-white text-right text-sm ml-auto pr-6">
							<p id="clock" class="font-medium">Thu, Sep 19 2024, 05:17:34</p>
							<p class="text-gray-400 text-xs">New York</p>
						</div>
						<div class="text-sm pl-6">
							<p class="text-white font-medium">Super User</p>
							<form method="POST" action="{{route('logout')}}">
								@csrf
								<button type="submit" class="text-gray-400 text-xs hover:underline hover:text-white focus:text-white focus:ring-offset-2">Log out</button>
							</form>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<script>
	document.addEventListener('DOMContentLoaded', function () {
	var dropdownItems = document.querySelectorAll('.menu-item-has-children');
	var dropdowns = document.querySelectorAll('.menu-item-has-children .mainmenu-sub-menu');
	var delay = 2000;
	if (dropdownItems) {
	dropdownItems.forEach((dropdownItem, count) => {
	dropdownItem.addEventListener('mouseenter', function (e) {
	dropdowns[count].classList.add('dropdown-show');
	});
	dropdownItem.addEventListener('mouseleave', function () {
	dropdowns[count].classList.remove('dropdown-show');
	});
	});
	}
	})
	</script>
	<div class="container btn-container">
		
		<div class="md:py-10 py-5 md:flex md:items-end md:justify-between w-full">
			<h1 class="text-3xl font-bold md:text-white">Details</h1>
			<div class="flex flex-wrap items-center gap-1">
				{{-- Static Navigation Buttons --}}
				
				{{-- Generate 999 Based on Status and Type --}}
				@if($file->status == "P")
				@if ($file->type === 'P')
				<a href="{{ route('generate.999.edip', $file->id) }}"
					class=" btn text-white bg-indigo-600 hover:bg-indigo-700">
					Generate 999 (P)
				</a>
				@elseif ($file->type === 'I')
				<a href="{{ route('generate.999.edii', $file->id) }}"
					class=" btn text-white bg-indigo-600 hover:bg-indigo-700">
					Generate 999 (I)
				</a>
				@else
				<a href="{{ route('generate.999.edid', $file->id) }}"
					class=" btn text-white bg-indigo-600 hover:bg-indigo-700">
					Generate 999 (D)
				</a>
				@endif
				@endif
				{{-- Download 837 - Claims --}}
				<a href="{{ route('download.edi', $file->id) }}"
					class=" btn text-white bg-indigo-600 hover:bg-indigo-700">
					Download 837 - Claims
				</a>
				{{-- Download Ack --}}
				@if($file->find_837_to_999)
				<a href="{{ route('download.999', $file->find_837_to_999->file_name) }}"
					class=" btn text-white bg-indigo-600 hover:bg-indigo-700">
					Download Ack
				</a>
				@endif
			</div>
		</div>
	</div>
</header>
@section('content')







<main class="md:-mt-32 mt-5">
	<div class="container">
		{{-- Claim Navigation (for multiple claims) --}}
		@php
		$startIndex=1;
		@endphp
		@if(count($data['claims']) > 1)
		<div class="mb-6 bg-white p-4 rounded-lg shadow">
			<h3 class="text-lg font-medium mb-2">Claims in this File</h3>
			<div class="flex flex-wrap gap-2">
				@foreach($data['claims'] as $index => $claim)
				@if(count($claim['services'])>0)
				<a href="#claim-{{ $index }}" class="px-3 py-1 bg-blue-100 text-blue-800 rounded hover:bg-blue-200">
					Claim #{{ $startIndex  }} ({{ $claim['claim_info']['number'] ?? 'N/A' }})
				</a>
				@php
				$startIndex+=1;
				@endphp
				@endif
				@endforeach
			</div>
		</div>
		@endif


		@php
		$startIndex=1;
		@endphp
		@foreach($data['claims'] as $claimIndex => $claim)
		@php
		// dd(count($claim['services']));
		@endphp
		@if(count($claim['services'])>0)
		<div id="claim-{{ $startIndex }}" class="mb-10 border-b pb-10">
			{{-- 1st part --}}
			<form id="myform" name="myform" method="POST">
				<div class="md:flex items-start space-x-6 mb-6">
					<!-- Left Column - Claim Information -->
					<div class="bg-white w-1/2 shadow overflow-hidden sm:rounded-lg">
						<div class="px-4 py-5 sm:px-6 border-b">
							<div class="md:flex justify-between">
								<div>
									<h3 class="text-lg leading-6 font-medium text-gray-900">
									Claim Information
									@if(count($data['claims']) > 1)
									<span class="text-sm text-gray-500">(Claim #{{ $startIndex  }})</span>
									@endif
									</h3>
								</div>
							</div>
						</div>
						
						<div>
							<div id="tab-primary" class="g-tab-content2 current">
								<div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
									<label class="c-label w-1/3">Claim Number</label>
									<span class="w-3/4">{{ $claim['claim_info']['number'] ?? 'N/A' }}</span>
								</div>
								<div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
									<label class="c-label w-1/3">Claim Amount</label>
									<span class="w-3/4">${{ number_format($claim['claim_info']['amount'] ?? 0, 2) }}</span>
								</div>
								<div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
									<label class="c-label w-1/3">Place of Service</label>
									@php
									$code = $claim['claim_info']['place_of_service'] ?? 'N/A';
									$posText = '';
									if ($code === '11') {
									$posText = 'Office';
									} elseif ($code === '12') {
									$posText = 'Home';
									} elseif ($code === '21') {
									$posText = 'Inpatient Hospital';
									} elseif ($code === '22') {
									$posText = 'Outpatient Hospital';
									} elseif ($code === '23') {
									$posText = 'Emergency Room';
									} elseif ($code === '24') {
									$posText = 'Ambulatory Surgical Center';
									} elseif ($code === '31') {
									$posText = 'Skilled Nursing Facility';
									} elseif ($code === '32') {
									$posText = 'Nursing Facility';
									} elseif ($code === '33') {
									$posText = 'Custodial Care Facility';
									} elseif ($code === '34') {
									$posText = 'Hospice';
									} elseif ($code === '41') {
									$posText = 'Ambulance - Land';
									} elseif ($code === '42') {
									$posText = 'Ambulance - Air or Water';
									} elseif ($code === '49') {
									$posText = 'Independent Clinic';
									} elseif ($code === '50') {
									$posText = 'Federally Qualified Health Center';
									} elseif ($code === '71') {
									$posText = 'State or Local Public Health Clinic';
									} elseif ($code === '72') {
									$posText = 'Rural Health Clinic';
									} else {
									$posText = "Office";
									}
									@endphp
									<span class="w-3/4">
										{{$posText }}
									</span>
								</div>
								<div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
									<label class="c-label w-1/3">Claim Type</label>
									<span class="w-3/4">
										{{ $data['meta']['edi_type'] == 'I' ? 'Institutional' :
										($data['meta']['edi_type'] == 'D' ? 'Dental' : 'Professional') }}
									</span>
								</div>
								<div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
									<label class="c-label w-1/3">Primary Diagnosis</label>
									<span class="w-3/4">
										@if(!empty($claim['diagnosis_codes']))
										{{ $claim['diagnosis_codes'][0]['code'] ?? 'N/A' }}
										@else
										N/A
										@endif
									</span>
								</div>
								
								@if($data['meta']['edi_type'] == 'I' && isset($claim['institutional_info']))
								<div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
									<label class="c-label w-1/3">Admission Type</label>
									<span class="w-3/4">{{ $claim['institutional_info']['admission_type'] ?? 'N/A' }}</span>
								</div>
								<div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
									<label class="c-label w-1/3">Patient Status</label>
									<span class="w-3/4">{{ $claim['institutional_info']['patient_status'] ?? 'N/A' }}</span>
								</div>
								@endif
							</div>
						</div>
					</div>
					
					<!-- Right Column - Patient Info -->
					<div class="bg-white w-1/2 shadow overflow-hidden sm:rounded-lg">
						<div class="px-4 py-5 sm:px-6 border-b">
							<div class="md:flex justify-between">
								<div>
									<h3 class="text-lg leading-6 font-medium text-gray-900">Patient Information</h3>
								</div>
							</div>
						</div>
						
						<div>
							<div id="tab-primary" class="g-tab-content2 current">
								<div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
									<label class="c-label w-1/3">Patient Name</label>
									<span class="w-3/4">
										{{ $claim['patient']['first_name'] ?? '' }}
										{{ $claim['patient']['last_name'] ?? '' }}
									</span>
								</div>
								<div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
									<label class="c-label w-1/3">Member ID</label>
									<span class="w-3/4">{{ $claim['patient']['id_code'] ?? 'N/A' }}</span>
								</div>
								<div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
									<label class="c-label w-1/3">Date of Birth</label>
									<span class="w-3/4">
										@if(!empty($claim['patientnew']['dob']))
										{{ date('m/d/Y', strtotime($claim['patientnew']['dob'])) }}
										@else
										N/A
										@endif
									</span>
								</div>
								<div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
									<label class="c-label w-1/3">Gender</label>
									<span class="w-3/4">
										@if(isset($claim['patientnew']['gender']))
										{{ $claim['patientnew']['gender'] == 'M' ? 'Male' : 'Female' }}
										@else
										N/A
										@endif
									</span>
								</div>
								<div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
									<label class="c-label w-1/3">Address</label>
									<span class="w-3/4">
										@if(isset($claim['patient']['address']['street1']))
										{{ $claim['patient']['address']['street1'] }}
										{{ $claim['patient']['address']['street2'] ?? '' }}<br>
										{{ $claim['patient']['address']['city'] ?? '' }},
										{{ $claim['patient']['address']['state'] ?? '' }}
										{{ isset($claim['patient']['address']['zip']) ? substr($claim['patient']['address']['zip'], 0, 5) : '' }}
										@else
										N/A
										@endif
									</span>
								</div>
								<div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
									<label class="c-label w-1/3">Payer</label>
									<span class="w-3/4">
										{{ $data['payers'][0]['last_name'] ?? 'N/A' }}
										({{ $data['payers'][0]['id_code'] ?? '' }})
									</span>
								</div>
								@if(isset($claim['subscriber_info']))
								<div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
									<label class="c-label w-1/3">Subscriber</label>
									<span class="w-3/4">
										{{ $claim['subscriber_info']['group_number'] ?? 'N/A' }}
										({{ $claim['subscriber_info']['insurance_type'] ?? '' }})
									</span>
								</div>
								@endif
							</div>
						</div>
					</div>
				</div>
			</form>
			
			{{-- 2nd part --}}
			<form id="myform" name="myform" method="POST">
				<div class="md:flex items-start space-x-6 mb-6">
					<!-- left Column - Provider & Transmission Info -->
					<div class="w-1/2">
						<div class="bg-white shadow overflow-hidden sm:rounded-lg">
							<div class="px-4 py-5 sm:px-6 border-b">
								<div class="md:flex justify-between">
									<div>
										<h3 class="text-lg leading-6 font-medium text-gray-900">Provider Details</h3>
									</div>
								</div>
							</div>
							
							<div class="pt-3 border-b">
								<div id="tab-1" class="g-tab-content current">
									<div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
										<label class="c-label w-1/3">Provider Name</label>
										<span class="w-3/4">{{ $data['providers'][0]['last_name'] ?? 'N/A' }}</span>
									</div>
									<div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
										<label class="c-label w-1/3">NPI</label>
										<span class="w-3/4">{{ $data['providers'][0]['id_code'] ?? 'N/A' }}</span>
									</div>
									<div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
										<label class="c-label w-1/3">Tax ID</label>
										<span class="w-3/4">{{ $data['providers'][0]['tax_id'] ?? 'N/A' }}</span>
									</div>
									<div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
										<label class="c-label w-1/3">Address</label>
										<span class="w-3/4">
											@if(isset($data['providers'][0]['address']['street1']))
											{{ $data['providers'][0]['address']['street1'] }}<br>
											{{ $data['providers'][0]['address']['city'] ?? '' }},
											{{ $data['providers'][0]['address']['state'] ?? '' }}
											{{ $data['providers'][0]['address']['zip'] ?? '' }}
											@else
											N/A
											@endif
										</span>
									</div>
									
									<!-- Service Lines -->
									@if(!empty($claim['services']))
									<div class="bg-white px-4 py-5">
										<h4 class="font-medium mb-3">Service Lines</h4>
										@foreach($claim['services'] as $service)
										<div class="mb-4 border-b pb-4">
											<div class="font-medium">Line #{{ $service['line_number'] ?? '' }}</div>
											<div class="mt-2">
												<span class="block">
													<strong>Procedure:</strong>
													{{ $service['service']['code'] ?? 'N/A' }}
													@if(!empty($service['service']['modifier']))
													(Modifier: {{ $service['service']['modifier'] }})
													@endif
												</span>
												<span class="block">
													<strong>Amount:</strong> ${{ number_format($service['service']['amount'] ?? 0, 2) }}
												</span>
												<span class="block">
													<strong>Units:</strong> {{ $service['service']['units'] ?? 1 }}
												</span>
												@if(!empty($service['dates']))
												@foreach($service['dates'] as $date)
												<span class="block">
													<strong>DOS:</strong> {{ date('m/d/Y', strtotime($date['date'])) }}
												</span>
												@endforeach
												@endif
												@if($data['meta']['edi_type'] == 'D' && isset($service['tooth_info']))
												<span class="block">
													<strong>Tooth:</strong> {{ $service['tooth_info']['number'] ?? '' }}
													({{ $service['tooth_info']['code'] ?? '' }})
												</span>
												@endif
											</div>
										</div>
										@endforeach
									</div>
									@endif
								</div>
							</div>
						</div>
					</div>
					
					{{-- right --}}
					<div class="w-1/2">
						<div class="bg-white shadow overflow-hidden sm:rounded-lg">
							<div class="px-4 py-5 sm:px-6 border-b">
								<div class="md:flex justify-between">
									<div>
										<h3 class="text-lg leading-6 font-medium text-gray-900">Transmission Details</h3>
									</div>
								</div>
							</div>
							
							<div class="pt-3 border-b">
								<div id="tab-1" class="g-tab-content current">
									<div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
										<label class="c-label w-1/3">Submitter</label>
										<span class="w-3/4">
											{{ $data['submitters'][0]['last_name'] ?? 'N/A' }}
											({{ $data['submitters'][0]['id_code'] ?? '' }})
										</span>
									</div>
									<div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
										<label class="c-label w-1/3">Receiver</label>
										<span class="w-3/4">
											{{ $data['payers'][0]['last_name'] ?? 'N/A' }}
											({{ $data['payers'][0]['id_code'] ?? '' }})
										</span>
									</div>
									<div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
										<label class="c-label w-1/3">Transmission Date/Time</label>
										<span class="w-3/4">
											{{ date('m/d/Y', strtotime($data['meta']['interchange']['date'])) }}
											{{ $data['meta']['interchange']['time'] ?? '' }}
										</span>
									</div>
									<div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
										<label class="c-label w-1/3">File Type</label>
										<span class="w-3/4">
											Health Care Claim -
											@if($data['meta']['edi_type'] == 'I') Institutional (837I)
											@elseif($data['meta']['edi_type'] == 'D') Dental (837D)
											@else Professional (837P)
											@endif
										</span>
									</div>
									<div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
										<label class="c-label w-1/3">Version</label>
										<span class="w-3/4">{{ $data['meta']['functional_group']['version'] ?? 'N/A' }}</span>
									</div>
									<div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
										<label class="c-label w-1/3">Control Number</label>
										<span class="w-3/4">{{ $data['meta']['interchange']['control_number'] ?? 'N/A' }}</span>
									</div>
									<div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
										<label class="c-label w-1/3">Sender ID</label>
										<span class="w-3/4">{{ $data['meta']['interchange']['sender_id'] ?? 'N/A' }}</span>
									</div>
									<div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
										<label class="c-label w-1/3">Receiver ID</label>
										<span class="w-3/4">{{ $data['meta']['interchange']['receiver_id'] ?? 'N/A' }}</span>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</form>














			
			
			{{-- 3rd part --}}
			<form id="myform" name="myform" method="POST">
    <div class="md:flex items-start space-x-6 mb-6">
        <!-- Left Column - other Information -->
        <div class="w-full">
            <div class="bg-white shadow overflow-hidden sm:rounded-lg">
                <div class="px-4 py-5 sm:px-6 border-b">
                    <div class="md:flex justify-between">
                        <div>
                            <h3 class="text-lg leading-6 font-medium text-gray-900">Diagnosis & Additional Information</h3>
                        </div>
                    </div>
                </div>
                
                <div class="pt-3 border-b">
                    <div id="tab-1" class="g-tab-content current">
                        @if(!empty($claim['diagnosis_codes']))
                        <div class="bg-white px-4 py-5">
                            <h4 class="font-medium mb-3">Diagnosis Codes</h4>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                @foreach($claim['diagnosis_codes'] as $diag)
                                <div class="border p-3 rounded">
                                    <span class="font-medium">{{ $diag['type'] }}:</span>
                                    {{ $diag['code'] }}
                                </div>
                                @endforeach
                            </div>
                        </div>
                        @endif
                        
                        @if(!empty($claim['dates']))
                        <div class="bg-gray-50 px-4 py-5">
                            <h4 class="font-medium mb-3">Important Dates</h4>
                            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                                @foreach($claim['dates'] as $date)
                                <div class="border p-3 rounded bg-white">
                                    <span class="font-medium">{{ $date['type'] }}:</span>
                                    {{ date('m/d/Y', strtotime($date['date'])) }}
                                </div>
                                @endforeach
                            </div>
                        </div>
                        @endif

                        <!-- Employee Information -->
                        @if(!empty($data['additional']['36'][$claimIndex-1]['emp_name']) || !empty($data['additional']['36'][$claimIndex-1]['id']))
                        <div class="bg-gray-50 px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                            <div class="w-full">
                                <h4 class="font-medium mb-3">Employee Information</h4>
                                @if(!empty($data['additional']['36'][$claimIndex-1]['emp_name']))
                                <div class="flex items-start mb-2">
                                    <label class="c-label w-1/3">Employee Name</label>
                                    <span class="w-3/4">{{ $data['additional']['36'][$claimIndex-1]['emp_name'] }}</span>
                                </div>
                                @endif
                                @if(!empty($data['additional']['36'][$claimIndex-1]['id']))
                                <div class="flex items-start">
                                    <label class="c-label w-1/3">Employee ID</label>
                                    <span class="w-3/4">{{ $data['additional']['36'][$claimIndex-1]['id'] }}</span>
                                </div>
                                @endif
                            </div>
                        </div>
                        @endif

                        <!-- Payer Information -->
                        @if(!empty($data['additional']['PR'][$claimIndex]['other_payer_name']) || !empty($data['additional']['PR'][$claimIndex]['policy_number']))
                        <div class="bg-white px-4 py-5 sm:flex sm:gap-4 sm:px-6">
                            <div class="w-full">
                                <h4 class="font-medium mb-3">Payer Information</h4>
                                @if(!empty($data['additional']['PR'][$claimIndex]['other_payer_name']))
                                <div class="flex items-start mb-2">
                                    <label class="c-label w-1/3">Payer Name</label>
                                    <span class="w-3/4">{{ $data['additional']['PR'][$claimIndex]['other_payer_name'] }}</span>
                                </div>
                                @endif
                                @if(!empty($data['additional']['PR'][$claimIndex]['policy_number']))
                                <div class="flex items-start">
                                    <label class="c-label w-1/3">Policy Number</label>
                                    <span class="w-3/4">{{ $data['additional']['PR'][$claimIndex]['policy_number'] }}</span>
                                </div>
                                @endif
                            </div>
                        </div>
                        @endif

                        <!-- Location Information -->
                        @php
                            $pickup = $data['additional']['pickup_location'][$startIndex-1] ?? [];
                            $dropoff = $data['additional']['dropoff_location'][$startIndex-1] ?? [];
                        @endphp

                        @if(!empty($pickup) || !empty($dropoff))
                        <div class="bg-gray-50 px-4 py-5">
                            <h4 class="font-medium mb-3">Location Information</h4>
                            
                            @if(!empty($pickup))
                            <div class="mb-4">
                                <h5 class="font-medium mb-2">Pickup Location</h5>
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                    @foreach($pickup as $key => $value)
                                        @if(!empty($value))
                                        <div class="flex items-start">
                                            <label class="c-label w-1/3">{{ ucfirst($key) }}</label>
                                            <span class="w-3/4">{{ $value }}</span>
                                        </div>
                                        @endif
                                    @endforeach
                                </div>
                            </div>
                            @endif
                            
                            @if(!empty($dropoff))
                            <div>
                                <h5 class="font-medium mb-2">Dropoff Location</h5>
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                    @foreach($dropoff as $key => $value)
                                        @if(!empty($value))
                                        <div class="flex items-start">
                                            <label class="c-label w-1/3">{{ ucfirst($key) }}</label>
                                            <span class="w-3/4">{{ $value }}</span>
                                        </div>
                                        @endif
                                    @endforeach
                                </div>
                            </div>
                            @endif
                        </div>
                        @endif

                        <!-- Chiropractic Information -->
                        @php
                            $chiropractic = $data['additional']['chiropractic'][$startIndex] ?? [];
                        @endphp

                        @if(!empty($chiropractic))
                        <div class="bg-white px-4 py-5">
                            <h4 class="font-medium mb-3">Chiropractic Information</h4>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                @foreach($chiropractic as $key => $value)
                                    @if(!empty($value))
                                    <div class="flex items-start">
                                        <label class="c-label w-1/3">{{ ucfirst($key) }}</label>
                                        <span class="w-3/4">
                                            @if($key == 'spinal_region')
                                                @switch($value)
                                                    @case('A') All Regions @break
                                                    @case('C') Cervical @break
                                                    @case('D') Dorsal (Thoracic) @break
                                                    @case('E') Lumbar @break
                                                    @case('F') Sacroiliac @break
                                                    @case('G') Coccygeal @break
                                                    @case('M') Multiple Regions @break
                                                    @default Unknown Region
                                                @endswitch
                                            @else
                                                {{ $value }}
                                            @endif
                                        </span>
                                    </div>
                                    @endif
                                @endforeach
                            </div>
                        </div>
                        @endif

                        <!-- DME Information -->
                        @php
                            $dme_certification = $data['additional']['dme_certification'][$startIndex] ?? [];
                            $dme_dates = $data['additional']['dme_dates'][$startIndex] ?? [];
                            $group_info = $data['additional']['group_info'][$startIndex] ?? [];
                            $forms = $data['additional']['forms'][$startIndex] ?? [];
                            $dme_documentation = $data['additional']['dme_documentation'][$startIndex] ?? [];
                            $provider_contact = $data['additional']['provider_contacts'][$startIndex] ?? [];
                        @endphp

                        @if(!empty($dme_certification) || !empty($dme_documentation))
                        <div class="bg-gray-50 px-4 py-5">
                            <h4 class="font-medium mb-3">DME Details</h4>
                            
                            @if(!empty($dme_documentation))
                            <div class="mb-4">
                                <h5 class="font-medium mb-2">Documentation</h5>
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                    @if(!empty($dme_documentation['documentation_type']))
                                    <div class="flex items-start">
                                        <label class="c-label w-1/3">Documentation Type</label>
                                        <span class="w-3/4">{{ $dme_documentation['documentation_type'] }}</span>
                                    </div>
                                    @endif
                                    
                                    @if(!empty($dme_documentation['transmission_code']))
                                    <div class="flex items-start">
                                        <label class="c-label w-1/3">Transmission Code</label>
                                        <span class="w-3/4">{{ $dme_documentation['transmission_code'] }}</span>
                                    </div>
                                    @endif
                                </div>
                            </div>
                            @endif
                            
                            @if(!empty($provider_contact))
                            <div class="mb-4">
                                <h5 class="font-medium mb-2">Provider Contact</h5>
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                    @if(!empty($provider_contact['name']))
                                    <div class="flex items-start">
                                        <label class="c-label w-1/3">Name</label>
                                        <span class="w-3/4">{{ $provider_contact['name'] }}</span>
                                    </div>
                                    @endif
                                    
                                    @if(!empty($provider_contact['phone']))
                                    <div class="flex items-start">
                                        <label class="c-label w-1/3">Phone</label>
                                        <span class="w-3/4">
                                            {{ $provider_contact['phone'] }}
                                            @if(!empty($provider_contact['communication_method']))
                                            ({{ $provider_contact['communication_method'] }})
                                            @endif
                                        </span>
                                    </div>
                                    @endif
                                </div>
                            </div>
                            @endif
                            
                            @if(!empty($dme_certification))
                            <div class="mb-4">
                                <h5 class="font-medium mb-2">Certification Details</h5>
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                    @if(!empty($dme_certification['certification_type']))
                                    <div class="flex items-start">
                                        <label class="c-label w-1/3">Certification Type</label>
                                        <span class="w-3/4">{{ $dme_certification['certification_type'] }}</span>
                                    </div>
                                    @endif
                                    
                                    @if(!empty($dme_certification['equipment_type']))
                                    <div class="flex items-start">
                                        <label class="c-label w-1/3">Equipment Type</label>
                                        <span class="w-3/4">{{ $dme_certification['equipment_type'] }}</span>
                                    </div>
                                    @endif
                                    
                                    @if(!empty($dme_certification['quantity']))
                                    <div class="flex items-start">
                                        <label class="c-label w-1/3">Quantity</label>
                                        <span class="w-3/4">{{ $dme_certification['quantity'] }}</span>
                                    </div>
                                    @endif
                                    
                                    @if(!empty($group_info['group_number']))
                                    <div class="flex items-start">
                                        <label class="c-label w-1/3">Group Number</label>
                                        <span class="w-3/4">{{ $group_info['group_number'] }}</span>
                                    </div>
                                    @endif
                                </div>
                            </div>
                            
                            <div class="mb-4">
                                <h5 class="font-medium mb-2">Dates</h5>
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                    @if(!empty($dme_dates['service_date']))
                                    <div class="flex items-start">
                                        <label class="c-label w-1/3">Service Date</label>
                                        <span class="w-3/4">{{ $dme_dates['service_date'] }}</span>
                                    </div>
                                    @endif
                                    
                                    @if(!empty($dme_dates['certification_start_date']))
                                    <div class="flex items-start">
                                        <label class="c-label w-1/3">Certification Start</label>
                                        <span class="w-3/4">{{ $dme_dates['certification_start_date'] }}</span>
                                    </div>
                                    @endif
                                    
                                    @if(!empty($dme_dates['last_certification_date']))
                                    <div class="flex items-start">
                                        <label class="c-label w-1/3">Last Certification</label>
                                        <span class="w-3/4">{{ $dme_dates['last_certification_date'] }}</span>
                                    </div>
                                    @endif
                                    
                                    @if(!empty($dme_dates['recertification_date']))
                                    <div class="flex items-start">
                                        <label class="c-label w-1/3">Recertification Due</label>
                                        <span class="w-3/4">{{ $dme_dates['recertification_date'] }}</span>
                                    </div>
                                    @endif
                                </div>
                            </div>
                            @endif
                            
                            @if(!empty($forms))
                            <div>
                                <h5 class="font-medium mb-2">Forms</h5>
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                    @if(!empty($forms['form_identifier']))
                                    <div class="flex items-start">
                                        <label class="c-label w-1/3">Form Identifier</label>
                                        <span class="w-3/4">{{ $forms['form_identifier'] }}</span>
                                    </div>
                                    @endif
                                    
                                    @if(!empty($forms['form_1a']))
                                    <div class="flex items-start">
                                        <label class="c-label w-1/3">Form 1A</label>
                                        <span class="w-3/4">{{ $forms['form_1a'] }}</span>
                                    </div>
                                    @endif
                                    
                                    @if(!empty($forms['form_1c']))
                                    <div class="flex items-start">
                                        <label class="c-label w-1/3">Form 1C</label>
                                        <span class="w-3/4">{{ $forms['form_1c'] }}</span>
                                    </div>
                                    @endif
                                    
                                    @if(!empty($forms['form_9']))
                                    <div class="flex items-start">
                                        <label class="c-label w-1/3">Form 9</label>
                                        <span class="w-3/4">{{ $forms['form_9'] }}</span>
                                    </div>
                                    @endif
                                    
                                    @if(!empty($forms['form_data']) && empty($forms['form_9']))
                                    <div class="flex items-start">
                                        <label class="c-label w-1/3">Form Data</label>
                                        <span class="w-3/4">{{ json_encode($forms['form_data']) }}</span>
                                    </div>
                                    @endif
                                </div>
                            </div>
                            @endif
                        </div>
                        @endif

                        <!-- NDC Information -->
                        @php
                            $ndc_info = $data['additional']['ndc_info'][$startIndex] ?? [];
                        @endphp

                        @if(!empty($ndc_info))
                        <div class="bg-white px-4 py-5">
                            <h4 class="font-medium mb-3">NDC Information</h4>
                            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                                @if(!empty($ndc_info['code']))
                                <div class="flex items-start">
                                    <label class="c-label w-1/3">NDC Code</label>
                                    <span class="w-3/4">{{ $ndc_info['code'] }}</span>
                                </div>
                                @endif
                                
                                @if(!empty($ndc_info['quantity']))
                                <div class="flex items-start">
                                    <label class="c-label w-1/3">Quantity</label>
                                    <span class="w-3/4">{{ $ndc_info['quantity'] }}</span>
                                </div>
                                @endif
                                
                                @if(!empty($ndc_info['unit']))
                                <div class="flex items-start">
                                    <label class="c-label w-1/3">Unit</label>
                                    <span class="w-3/4">{{ $ndc_info['unit'] }}</span>
                                </div>
                                @endif
                            </div>
                        </div>
                        @endif

                        <!-- Pricing & Network Information -->
                        @php
                            $ppo_info = $data['additional']['ppo_info'][$startIndex] ?? [];
                            $pricing_info = $data['additional']['pricing_info'][$startIndex] ?? [];
                        @endphp

                        @if(!empty($ppo_info) || !empty($pricing_info))
                        <div class="bg-gray-50 px-4 py-5">
                            <h4 class="font-medium mb-3">Pricing & Network Information</h4>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                @if(!empty($ppo_info['network_id']))
                                <div class="flex items-start">
                                    <label class="c-label w-1/3">PPO Network ID</label>
                                    <span class="w-3/4">{{ $ppo_info['network_id'] }}</span>
                                </div>
                                @endif
                                
                                @if(!empty($pricing_info['repriced_amount']))
                                <div class="flex items-start">
                                    <label class="c-label w-1/3">Repriced Amount</label>
                                    <span class="w-3/4">${{ number_format($pricing_info['repriced_amount'], 2) }}</span>
                                </div>
                                @endif
                                
                                @if(!empty($pricing_info['price_indicator']))
                                <div class="flex items-start">
                                    <label class="c-label w-1/3">Price Indicator</label>
                                    <span class="w-3/4">{{ $pricing_info['price_indicator'] }}</span>
                                </div>
                                @endif
                                
                                @if(!empty($pricing_info['service_code']))
                                <div class="flex items-start">
                                    <label class="c-label w-1/3">Service Code</label>
                                    <span class="w-3/4">{{ $pricing_info['service_code'] }}</span>
                                </div>
                                @endif
                            </div>
                        </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>













		</div>
		@php
		$startIndex+=1;
		@endphp
		@endif
		@endforeach
	</div>
</main>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
{{-- <script>
const myElement = document.getElementById("customdropdown");
// Toggle the class when the element is clicked
myElement.addEventListener("click", function(event) {
this.classList.toggle("active");
event.stopPropagation(); // Prevent the event from bubbling to document
});
// Remove the class if clicking outside the element
document.addEventListener("click", function(event) {
if (!myElement.contains(event.target)) {
myElement.classList.remove("active");
}
});
document.getElementById('selectcategory_0').addEventListener('change', function() {
var myDiv = document.getElementById('lodging-category-options');
// Toggle between showing and hiding the div
myDiv.style.display = myDiv.style.display === 'none' ? 'block' : 'none';
});
document.getElementById('selectcategory_1').addEventListener('change', function() {
var myDiv = document.getElementById('nutrition-category-options');
// Toggle between showing and hiding the div
myDiv.style.display = myDiv.style.display === 'none' ? 'block' : 'none';
});
document.getElementById('selectcategory_2').addEventListener('change', function() {
var myDiv = document.getElementById('childcare-category-options');
// Toggle between showing and hiding the div
myDiv.style.display = myDiv.style.display === 'none' ? 'block' : 'none';
});
</script> --}}
<script>
window.onload = displayClock();
function displayClock() {
const currentDate = new Date(new Date().toLocaleString("en-US", {
timeZone: "America/New_York"
}));
var timestamp = currentDate.toString().split('GMT');
var splitstring = timestamp[0].split(" ");
var final_string = splitstring[0] + ', ' + splitstring[1] + ' ' + splitstring[2] + ' ' + splitstring[3] +
', ' + splitstring[4];
$("#clock").text(final_string);
setTimeout(displayClock, 1000);
}
</script>
{{-- <script>
$(document).ready(function() {
$('#callCategorySelect').on('change', function() {
var selectedValue = $(this).val();
// Hide all divs
$('.callCategorySelectoption').hide();
// Show the div if a valid option is selected
if (selectedValue !== "none") {
$('#' + selectedValue).show();
}
});
});
</script>
<script>
function toggleModal(modalID, rowid = null) {
if (modalID == 'modal-example-regular-update') {
loadUpdateUserForm(rowid);
}
if (modalID == 'modal-example-regular-update-ediprofile') {
loadEditProfileUserForm(rowid);
}
if (modalID == 'modal-example-regular-deposit') {
$("#modal-example-regular-deposit .service_id").val(rowid);
}
if (modalID == 'modal-program-configure-alert') {
loadProgramDetailsForm(rowid);
}
if (modalID == 'modal-program-configure-alert-import') {
loadImportForm(rowid);
}
if (modalID == 'modal-program-files') {
loadProgramFilesForm(rowid);
}
if (modalID == 'modal-audit-log') {
loadAuditLog(rowid);
}
document.getElementById(modalID).classList.toggle("hidden");
document.getElementById(modalID + "-backdrop").classList.toggle("hidden");
document.getElementById(modalID + "-backdrop").classList.toggle("flex");
}
function closeModal(modalID) {
document.getElementById(modalID).classList.toggle("hidden");
document.getElementById(modalID + "-backdrop").classList.toggle("hidden");
document.getElementById(modalID + "-backdrop").classList.toggle("flex");
}
$(document).ready(function () {
$('ul.g-tabs li').click(function () {
var tab_id = $(this).attr('data-tab');
$('ul.g-tabs li').removeClass('current');
$('.g-tab-content').removeClass('current');
$(this).addClass('current');
$("#" + tab_id).addClass('current');
});
$('ul.g-tabs1 li').click(function () {
var tab_id = $(this).attr('data-tab');
$('ul.g-tabs1 li').removeClass('current');
$('.g-tab-content1').removeClass('current');
$(this).addClass('current');
$("#" + tab_id).addClass('current');
});
$('ul.g-tabs2 li').click(function () {
var tab_id = $(this).attr('data-tab');
$('ul.g-tabs2 li').removeClass('current');
$('.g-tab-content2').removeClass('current');
$(this).addClass('current');
$("#" + tab_id).addClass('current');
});
$(".eye-button").on('click', function () {
$(".eye-icon").toggleClass('hidden');
$(".extra-info").toggleClass('hidden');
});
});
</script>
<script>
$(document).ready(function(){
var patientInfoVisible = false;
var travelCardInfoVisible = false;
// Toggle Patient Info Visibility
$('#viewPatientInfo').click(function(){
if(!patientInfoVisible){
// Unmask patient details
$('#patientDob').text('01/01/1980').removeClass('masked').addClass('unmasked');
$('#patientAddress').text('123 Main St').removeClass('masked').addClass('unmasked');
$('#patientCity').text('Los Angeles').removeClass('masked').addClass('unmasked');
$('#patientState').text('CA').removeClass('masked').addClass('unmasked');
$('#patientZip').text('90001').removeClass('masked').addClass('unmasked');
$('#patientEmail').text('john.doe@example.com').removeClass('masked').addClass('unmasked');
$('#gender').text('Male').removeClass('masked').addClass('unmasked');
$('#nationality').text('American').removeClass('masked').addClass('unmasked');
$('#EthnicityRace').text('Asian').removeClass('masked').addClass('unmasked');
$('#patientPhone1').text('(123) 456-7890').removeClass('masked').addClass('unmasked');
$('#patientPhone2').text('(098) 765-4321').removeClass('masked').addClass('unmasked');
$('#patientClinicalTrialSite').text('UCLA Medical Center').removeClass('masked').addClass('unmasked');
$('#patientCirmTrialNumber').text('CIRM-12345').removeClass('masked').addClass('unmasked');
$('#patientProgramId').text('PID-67890').removeClass('masked').addClass('unmasked');
$('#patientSiteCoordinator').text('Dr. Smith').removeClass('masked').addClass('unmasked');
$('#patientSiteContactNumber').text('(555) 123-4567').removeClass('masked').addClass('unmasked');
$('#patientSiteContactEmail').text('coordinator@example.com').removeClass('masked').addClass('unmasked');
$(this).html('<i class="fa-regular fa-eye-slash"></i> &nbsp; Hide Patient Info');
patientInfoVisible = true;
} else {
// Mask patient details
$('.patient-detail').each(function(){
$(this).text('••••••••••').removeClass('unmasked').addClass('masked');
});
$('#patientAddress').text('•••••••••••••••••••••••••••••••••');
$('#patientCity').text('••••••••••');
$('#patientState').text('••••••••••');
$('#patientZip').text('•••••');
$('#patientClinicalTrialSite').text('•••••••••••••••••••••••••');
$('#patientCirmTrialNumber').text('•••••••••••••••••••••••••');
$('#patientProgramId').text('•••••••••••••••••••••••••');
$('#patientSiteCoordinator').text('•••••••••••••••••••••••••');
$('#patientSiteContactNumber').text('••••••••••');
$('#patientSiteContactEmail').text('••••••••••••••••••••');
$(this).html('<i class="fa-regular fa-eye"></i> &nbsp; View Patient Info');
patientInfoVisible = false;
}
});
// Toggle Travel Card Information
$('#toggleTravelCardInfo').click(function(){
if(!travelCardInfoVisible){
$('#travelCardNumber').text('1234 5678 9012 3456');
$('#travelCardCVV').text('123');
$('#travelCardExpiration').text('12/26');
$(this).html('<i class="fa-regular fa-eye-slash"></i> &nbsp; Hide Card Information');
travelCardInfoVisible = true;
} else {
$('#travelCardNumber').text('•••• •••• •••• ••••');
$('#travelCardCVV').text('•••');
$('#travelCardExpiration').text('••/••');
$(this).html('<i class="fa-regular fa-eye"></i> &nbsp; Show Card Information');
travelCardInfoVisible = false;
}
});
// Toggle Allowance Card Status
$('#toggleCardStatus').click(function(){
var status = $('#cardStatus').text();
if(status === 'Active'){
$('#cardStatus').text('Suspended')
.removeClass('c-badge c-badge-verified')
.addClass('c-badge c-badge-warning');
$(this).text('Unsuspend Card');
} else {
$('#cardStatus').text('Active')
.removeClass('c-badge c-badge-warning')
.addClass('c-badge c-badge-verified');
$(this).text('Suspend Card');
}
});
// Form submissions
$('#uploadDocumentsForm, #logCallForm, #createRuleForm').submit(function(event){
event.preventDefault();
alert('Form submitted successfully!');
$(this).closest('.modal').modal('hide');
});
// Resend Enrollment Information
$('#resendEnrollmentModal .btn-primary').click(function(){
alert('Enrollment information resent successfully!');
$('#resendEnrollmentModal').modal('hide');
});
});
</script>
<script>
// Tab functionality
document.addEventListener('DOMContentLoaded', function() {
// For Patient/Claim tabs
const tabLinks2 = document.querySelectorAll('.g-tabs2 .g-tab-link');
tabLinks2.forEach(link => {
link.addEventListener('click', function() {
const tabId = this.getAttribute('data-tab');
// Remove current class from all tabs and content
document.querySelectorAll('.g-tabs2 .g-tab-link').forEach(t => t.classList.remove('current'));
document.querySelectorAll('.g-tab-content2').forEach(c => c.classList.remove('current'));
// Add current class to clicked tab and corresponding content
this.classList.add('current');
document.getElementById(tabId).classList.add('current');
});
});
// For Provider/Transmission/Service tabs
const tabLinks = document.querySelectorAll('.g-tabs .g-tab-link');
tabLinks.forEach(link => {
link.addEventListener('click', function() {
const tabId = this.getAttribute('data-tab');
// Remove current class from all tabs and content
document.querySelectorAll('.g-tabs .g-tab-link').forEach(t => t.classList.remove('current'));
document.querySelectorAll('.g-tab-content').forEach(c => c.classList.remove('current'));
// Add current class to clicked tab and corresponding content
this.classList.add('current');
document.getElementById(tabId).classList.add('current');
});
});
});
</script> --}}
@endsection