@extends('layouts.app')

@section('content')
<style>
.btn.text-white {
padding: 4px 14px;
font-size: 13px;
font-weight: 600;
border-radius: 6px;
line-height: 1.5;
display: inline-block;
text-align: center;
white-space: nowrap;
vertical-align: middle;
transition: background-color 0.2s ease-in-out;
background-color: rgb(79 70 229);
}
.form-group{
margin-bottom: 20px;
}

.step { display: none; }
.active { display: block; }
.next, .prev {
padding: 6px 16px;       /* good horizontal and vertical padding */
font-size: 14px;
border-radius: 6px;
border: none;
cursor: pointer;
width: auto;
height: auto;
display: inline-block;
text-align: center;
line-height: normal;
background-color: #0d6efd;  /* for .next */
color: white;
margin-right: 10px;
margin-bottom: 10px;
margin-top: 10px;
}
.prev {
background-color: orange;
}
#multiStepForm {
width: 50%;
background: white;
padding: 20px;
margin: 50px auto;
border-radius: 10px;
box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
}
/*  .step {
display: none;
}
.active {
display: block;
}*/
.step {
display: none;
}
.step.active {
display: flex; /* or block, but flex works better for columns */
flex-wrap: wrap;
}
h2 {
color: #333;
}
input {
width: 30%;
padding: 10px;
/*margin: 10px 0;*/
border: 1px solid #ccc;
border-radius: 5px;
font-size: 16px;
}
button {
background-color: #007bff;
color: white;
border: none;
padding: 10px 15px;
font-size: 16px;
cursor: pointer;
border-radius: 5px;
transition: 0.3s;
}
button:hover {
background-color: #0056b3;
}
.prev {
background-color: #6c757d;
}
.prev:hover {
background-color: #5a6268;
}
.submit {
background-color: #28a745;
}
.submit:hover {
background-color: #218838;
}
.form-control{
width: 30%;
}
.g-header{
padding-bottom: 0 !important;
}
.btn-container>div{
padding: 2.5rem 0 !important;
}
.mb-n10{
margin-bottom: -10px!important;
}
.mainmenu{
margin-bottom: 0!important;
}
.g-header .divide-x{
align-items: center;
}
.g-header  .divide-x p{
margin-bottom: 0;
}
.g-header .divide-x button{
padding: 0!important;
}
.fa-solid.fa-xmark{
    display: none;
}
</style>
<style>
input:read-only {
    background-color: #f5f5f5;  /* Light grey background */
    color: #555;               /* Text color */
    border: 1px solid #ccc;    /* Optional: border style */
    cursor: not-allowed;       /* Optional: indicate it's non-editable */
}
</style>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
@include('message')
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<div class="container">
    {{-- <h1>EDI-P Multiple Claim Generator</h1> --}}
    <form method="POST" action="{{ route('multiple.edip.generate') }}">
        @csrf
        <!-- Transmission Information (Single Instance) -->
        <div class="card mb-4 mt-4">
            <div class="card-header bg-primary text-white">Transmission Information</div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="sender_id">Sender ID</label>
                            <input type="text" class="form-control" id="sender_id" name="sender_id" value="{{ old('sender_id', '581651222') }}" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="receiver_id">Receiver ID</label>
                            <input type="text" class="form-control" id="receiver_id" name="receiver_id" value="{{ old('receiver_id', 'REC789101') }}" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="control_number">Control Number</label>
                            <input type="text" class="form-control" id="control_number" name="control_number" value="{{ old('control_number', '123500377') }}" required>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="sender_code">Sender Code</label>
                            <input type="text" class="form-control" id="sender_code" name="sender_code" value="{{ old('sender_code', 'SENDER123') }}" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="receiver_code">Receiver Code</label>
                            <input type="text" class="form-control" id="receiver_code" name="receiver_code" value="{{ old('receiver_code', 'RECEIVER456') }}" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="submitter_id">Submitter ID</label>
                            <input type="text" class="form-control" id="submitter_id" name="submitter_id" value="{{ old('submitter_id', 'SUB123456') }}" required>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="submitter_name">Submitter Name</label>
                            <input type="text" class="form-control" id="submitter_name" name="submitter_name" value="{{ old('submitter_name', 'ABC Health') }}" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="submitter_contact">Submitter contact</label>
                            <input type="text" class="form-control" id="submitter_contact" name="submitter_contact" value="{{ old('submitter_contact', 'BILLING DEPARTMENT') }}" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="submitter_phone">Submitter phone</label>
                            <input type="text" class="form-control" id="submitter_phone" name="submitter_phone" value="{{ old('submitter_phone', '8005551234') }}" pattern="[0-9]{10}" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="receiver_name">Receiver Name</label>
                            <input type="text" class="form-control" id="receiver_name" name="receiver_name" value="{{ old('receiver_name', 'XYZ Payer') }}" required>
                        </div>
                    </div>
                </div>
            </div>
        </div>

@php
// dd(@Auth()->user()->providerDetails->provider_clinic_name);
@endphp

@if(@Auth::user()->user_type=="A")

        <!-- Provider Information (Single Instance) -->
        <div class="card mb-4">
            <div class="card-header bg-primary text-white">Provider Information</div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="provider_name">Provider Name</label>
                            <input type="text" class="form-control" id="provider_name" name="provider_name" value="{{ old('provider_name', 'ABC Healthcare') }}" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="provider_npi">Provider NPI</label>
                            <input type="text" class="form-control" id="provider_npi" name="provider_npi" value="{{ old('provider_npi', '1234567890') }}" required>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="provider_tax_id">Provider Tax ID</label>
                            <input type="text" class="form-control" id="provider_tax_id" name="provider_tax_id" value="{{ old('provider_tax_id', '123456789') }}" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="facility_npi">Facility NPI</label>
                            <input type="text" class="form-control" id="facility_npi" name="facility_npi" value="{{ old('facility_npi', '1234567890') }}" required>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="facility_name">Facility Name</label>
                            <input type="text" class="form-control" id="facility_name" name="facility_name" value="{{ old('facility_name', 'ABC Healthcare Center') }}" required>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                   
                        <h5>Provider Address</h5>
                   
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="provider_street">Street</label>
                            <input type="text" class="form-control" id="provider_street" name="provider_street" value="{{ old('provider_street', '123 Main St') }}" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="provider_city">City</label>
                            <input type="text" class="form-control" id="provider_city" name="provider_city" value="{{ old('provider_city', 'New York') }}" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="provider_state">State</label>
                            <input type="text" class="form-control" id="provider_state" name="provider_state" value="{{ old('provider_state', 'NY') }}" required>
                        </div>
                    </div>
                    <div class="col-md-1">
                        <div class="form-group">
                            <label for="provider_zip">ZIP</label>
                            <input type="text" class="form-control" id="provider_zip" name="provider_zip" value="{{ old('provider_zip', '100010000') }}" required>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        @else
         <div class="card mb-4">
            <div class="card-header bg-primary text-white">Provider Information</div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="provider_name">Provider Name</label>
                            <input type="text" class="form-control" id="provider_name" name="provider_name" value="{{@Auth::user()->providerDetails->provider_clinic_name}}" required readonly>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="provider_npi">Provider NPI</label>
                            <input type="text" class="form-control" id="provider_npi" name="provider_npi" value="{{ @Auth::user()->providerDetails->npi }}"  required readonly>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="provider_tax_id">Provider Tax ID</label>
                            <input type="text" class="form-control" id="provider_tax_id" name="provider_tax_id" value="{{ @Auth::user()->providerDetails->tax_id }}"  required readonly>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="facility_npi">Facility NPI</label>
                            <input type="text" class="form-control" id="facility_npi" name="facility_npi" value="{{ @Auth::user()->providerDetails->f_npi }}" required >
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="facility_name">Facility Name</label>
                            <input type="text" class="form-control" id="facility_name" name="facility_name" value="{{ @Auth::user()->providerDetails->f_name }}" required >
                        </div>
                    </div>
                </div>
                
                <div class="row">
                   
                        <h5>Provider Address</h5>
                   
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="provider_street">Street</label>
                            <input type="text" class="form-control" id="provider_street" name="provider_street" value="{{ @Auth::user()->providerDetails->service_street }}" required readonly>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="provider_city">City</label>
                            <input type="text" class="form-control" id="provider_city" name="provider_city" value="{{ @Auth::user()->providerDetails->service_city }}" required readonly>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="provider_state">State</label>
                            <input type="text" class="form-control" id="provider_state" name="provider_state" value="{{ @Auth::user()->providerDetails->service_state }}" required readonly>
                        </div>
                    </div>
                    <div class="col-md-1">
                        <div class="form-group">
                            <label for="provider_zip">ZIP</label>
                            <input type="text" class="form-control" id="provider_zip" name="provider_zip" value="{{ @Auth::user()->providerDetails->service_zip_code }}" required readonly>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        @endif





        <!-- Subscriber Information (Single Instance) -->
        {{--  <div class="card mb-4">
            <div class="card-header">Subscriber Information</div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="subscriber_last_name">Last Name</label>
                            <input type="text" class="form-control" id="subscriber_last_name" name="subscriber_last_name" value="{{ old('subscriber_last_name', 'Doe') }}" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="subscriber_first_name">First Name</label>
                            <input type="text" class="form-control" id="subscriber_first_name" name="subscriber_first_name" value="{{ old('subscriber_first_name', 'John') }}" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="member_id">Member ID</label>
                            <input type="text" class="form-control" id="member_id" name="member_id" value="{{ old('member_id', '123456789') }}" required>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="subscriber_dob">Date of Birth</label>
                            <input type="date" class="form-control" id="subscriber_dob" name="subscriber_dob" value="{{ old('subscriber_dob', '1985-01-15') }}" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="subscriber_gender">Gender</label>
                            <select class="form-control" id="subscriber_gender" name="subscriber_gender" required>
                                <option value="M" {{ old('subscriber_gender', 'M') == 'M' ? 'selected' : '' }}>Male</option>
                                <option value="F" {{ old('subscriber_gender', 'M') == 'F' ? 'selected' : '' }}>Female</option>
                                <option value="U" {{ old('subscriber_gender', 'M') == 'U' ? 'selected' : '' }}>Unknown</option>
                            </select>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-4">
                        <h5>Subscriber Address</h5>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="subscriber_street">Street</label>
                            <input type="text" class="form-control" id="subscriber_street" name="subscriber_street" value="{{ old('subscriber_street', '456 Elm Street') }}" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="subscriber_city">City</label>
                            <input type="text" class="form-control" id="subscriber_city" name="subscriber_city" value="{{ old('subscriber_city', 'Los Angeles') }}" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="subscriber_state">State</label>
                            <input type="text" class="form-control" id="subscriber_state" name="subscriber_state" value="{{ old('subscriber_state', 'CA') }}" required>
                        </div>
                    </div>
                    <div class="col-md-1">
                        <div class="form-group">
                            <label for="subscriber_zip">ZIP</label>
                            <input type="text" class="form-control" id="subscriber_zip" name="subscriber_zip" value="{{ old('subscriber_zip', '900019999') }}" required>
                        </div>
                    </div>
                </div>
            </div>
        </div> --}}
        <!-- Payer Information (Single Instance) -->
        <div class="card mb-4">
            <div class="card-header bg-primary text-white">Payer Information</div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="payer_name">Payer Name</label>
                            <input type="text" class="form-control" id="payer_name" name="payer_name" value="{{ old('payer_name', 'ABC Insurance') }}" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="payer_id">Payer ID</label>
                            <input type="text" class="form-control" id="payer_id" name="payer_id" value="{{ old('payer_id', '987654') }}" required>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    {{-- <div class="col-md-4"> --}}
                        <h5>Payer Address</h5>
                    {{-- </div> --}}
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="payer_street">Street</label>
                            <input type="text" class="form-control" id="payer_street" name="payer_street" value="{{ old('payer_street', '789 Main St') }}" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="payer_city">City</label>
                            <input type="text" class="form-control" id="payer_city" name="payer_city" value="{{ old('payer_city', 'New York') }}" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="payer_state">State</label>
                            <input type="text" class="form-control" id="payer_state" name="payer_state" value="{{ old('payer_state', 'NY') }}" required>
                        </div>
                    </div>
                    <div class="col-md-1">
                        <div class="form-group">
                            <label for="payer_zip">ZIP</label>
                            <input type="text" class="form-control" id="payer_zip" name="payer_zip" value="{{ old('payer_zip', '100019999') }}" required>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Claims Section (Repeatable) -->
        <div id="claims-container">
            <div class="card mb-4 claim-section">
                <div class="card-header bg-info text-white d-flex justify-content-between align-items-center">
                    <span>Claim #1</span>
                    <button type="button" class="btn btn-danger btn-sm remove-claim" data-claim-index="0">Remove</button>
                </div>
                <div class="card-body">
                    <!-- PATIENT/SUBSCRIBER INFO PER CLAIM -->
                    <div class="card mb-3">
                        <div class="card-header">Patient/Subscriber Information</div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Last Name</label>
                                        <input type="text" class="form-control" name="claims[0][subscriber_last_name]" value="Doe" required>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>First Name</label>
                                        <input type="text" class="form-control" name="claims[0][subscriber_first_name]" value="John" required>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Member ID</label>
                                        <input type="text" class="form-control" name="claims[0][member_id]" value="123456789" required>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Date of Birth</label>
                                        <input type="date" class="form-control" name="claims[0][subscriber_dob]" value="1985-01-15" required>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Gender</label>
                                        <select class="form-control" name="claims[0][subscriber_gender]" required>
                                            <option value="M" selected>Male</option>
                                            <option value="F">Female</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                {{-- <div class="col-md-4"> --}}
                                    <h5>Patient Address</h5>
                                {{-- </div> --}}
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Street</label>
                                        <input type="text" class="form-control" name="claims[0][subscriber_street]" value="456 Elm Street" required>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>City</label>
                                        <input type="text" class="form-control" name="claims[0][subscriber_city]" value="Los Angeles" required>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>State</label>
                                        <input type="text" class="form-control" name="claims[0][subscriber_state]" value="CA" required>
                                    </div>
                                </div>
                                <div class="col-md-1">
                                    <div class="form-group">
                                        <label>ZIP</label>
                                        <input type="text" class="form-control" name="claims[0][subscriber_zip]" value="900019999" required>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Group Number</label>
                                        <input type="text" class="form-control" name="claims[0][group_number]" value="GROUP1" required>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Insurance Type</label>
                                        <select class="form-control" name="claims[0][insurance_type]" required>
                                            <option value="MC">Medicare</option>
                                            <option value="CI">Commercial</option>
                                            <option value="BL">Blue Cross</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims[0][claim_number]">Claim Number</label>
                                <input type="text" class="form-control" id="claims[0][claim_number]" name="claims[0][claim_number]" value="{{ old('claims.0.claim_number', 'CLM123456') }}" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims[0][claim_amount]">Claim Amount</label>
                                <input type="number" step="0.01" class="form-control" id="claims[0][claim_amount]" name="claims[0][claim_amount]" value="{{ old('claims.0.claim_amount', '500.25') }}" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims[0][place_of_service]">Place of Service</label>
                                <input type="text" class="form-control" id="claims[0][place_of_service]" name="claims[0][place_of_service]" value="{{ old('claims.0.place_of_service', '11') }}" required>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims[0][claim_frequency]">Claim Frequency</label>
                                <select class="form-control" id="claims[0][claim_frequency]" name="claims[0][claim_frequency]" required>
                                    <option value="1" {{ old('claims.0.claim_frequency', '1') == '1' ? 'selected' : '' }}>Original</option>
                                    <option value="7" {{ old('claims.0.claim_frequency', '1') == '7' ? 'selected' : '' }}>Replacement</option>
                                    <option value="8" {{ old('claims.0.claim_frequency', '1') == '8' ? 'selected' : '' }}>Void/Cancel</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims[0][primary_diagnosis]">Primary Diagnosis</label>
                                <input type="text" class="form-control" id="claims[0][primary_diagnosis]" name="claims[0][primary_diagnosis]" value="{{ old('claims.0.primary_diagnosis', 'J45.909') }}" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims[0][additional_diagnosis]">Additional Diagnosis (comma separated)</label>
                                <input type="text" class="form-control" id="claims[0][additional_diagnosis]" name="claims[0][additional_diagnosis]" value="{{ old('claims.0.additional_diagnosis') }}">
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims[0][date_of_service]">Date of Service</label>
                                <input type="date" class="form-control" id="claims[0][date_of_service]" name="claims[0][date_of_service]" value="{{ old('claims.0.date_of_service', '2024-03-10') }}" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims[0][condition_codes]">Condition Codes (comma separated)</label>
                                <input type="text" class="form-control" id="claims[0][condition_codes]" name="claims[0][condition_codes]" value="{{ old('claims.0.condition_codes') }}">
                            </div>
                        </div>
                    </div>
                    



                    <!-- Service Lines (Repeatable within each claim) -->
                    <div class="service-lines-container" data-claim-index="0">
                        <div class="card mb-3 service-line">
                            <div class="card-header bg-info text-white d-flex justify-content-between align-items-center">
                                <span>Service Line </span>
                                <div style="display:none;">
                                    <button type="button" class="btn btn-danger btn-sm remove-service-line" data-claim-index="0" data-service-line-index="0">Remove</button>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="claims[0][service_lines][0][service_line_number]">Line Number</label>
                                            <input type="text" class="form-control" id="claims[0][service_lines][0][service_line_number]" name="claims[0][service_lines][0][service_line_number]" value="{{ old('claims.0.service_lines.0.service_line_number', '1') }}" required>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="claims[0][service_lines][0][procedure_code]">Procedure Code</label>
                                            <input type="text" class="form-control" id="claims[0][service_lines][0][procedure_code]" name="claims[0][service_lines][0][procedure_code]" value="{{ old('claims.0.service_lines.0.procedure_code', '99213') }}" required>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="claims[0][service_lines][0][charge_amount]">Charge Amount</label>
                                            <input type="number" step="0.01" class="form-control" id="claims[0][service_lines][0][charge_amount]" name="claims[0][service_lines][0][charge_amount]" value="{{ old('claims.0.service_lines.0.charge_amount', '150.00') }}" required>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="claims[0][service_lines][0][date_of_service]">date of service</label>
                                            <input type="date" step="0.01" class="form-control" id="claims[0][service_lines][0][date_of_service]" name="claims[0][service_lines][0][date_of_service]"  required>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="claims[0][service_lines][0][unit_count]">Unit Count</label>
                                            <input type="number" class="form-control" id="claims[0][service_lines][0][unit_count]" name="claims[0][service_lines][0][unit_count]" value="{{ old('claims.0.service_lines.0.unit_count', '1') }}" required>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="claims[0][service_lines][0][diagnosis_pointer]">Diagnosis Pointer</label>
                                            <input type="text" class="form-control" id="claims[0][service_lines][0][diagnosis_pointer]" name="claims[0][service_lines][0][diagnosis_pointer]" value="{{ old('claims.0.service_lines.0.diagnosis_pointer', '1') }}" required>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div style="display:none;">
                        <button type="button" class="btn btn-secondary btn-sm add-service-line" data-claim-index="0">Add Service Line</button>
                    </div>





                    <!-- Provider References -->
                    <div class="service-lines-container" data-claim-index="0">
                        <div class="card mb-3 service-line">

                     <div class="card-body">
                         <div class="row">
                    <div class="row mt-3">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims[0][referring_provider_name]">Referring Provider Name</label>
                                <input type="text" class="form-control" id="claims[0][referring_provider_name]" name="claims[0][referring_provider_name]" value="{{ old('claims.0.referring_provider_name', 'Dr. John Doe') }}">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims[0][referring_npi]">Referring NPI</label>
                                <input type="text" class="form-control" id="claims[0][referring_npi]" name="claims[0][referring_npi]" value="{{ old('claims.0.referring_npi', '1234567890') }}">
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims[0][rendering_provider_name]">Rendering Provider Name</label>
                                <input type="text" class="form-control" id="claims[0][rendering_provider_name]" name="claims[0][rendering_provider_name]" value="{{ old('claims.0.rendering_provider_name', 'Dr. Jane Smith') }}">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims[0][rendering_npi]">Rendering NPI</label>
                                <input type="text" class="form-control" id="claims[0][rendering_npi]" name="claims[0][rendering_npi]" value="{{ old('claims.0.rendering_npi', '9876543210') }}">
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims[0][supervising_provider_name]">Supervising Provider Name</label>
                                <input type="text" class="form-control" id="claims[0][supervising_provider_name]" name="claims[0][supervising_provider_name]" value="{{ old('claims.0.supervising_provider_name', 'Dr. Robert Johnson') }}">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims[0][supervising_npi]">Supervising NPI</label>
                                <input type="text" class="form-control" id="claims[0][supervising_npi]" name="claims[0][supervising_npi]" value="{{ old('claims.0.supervising_npi', '1231231234') }}">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
  
                    </div>
                </div>
            </div>
        </div>
        
        <button type="button" id="add-claim" class="btn btn-primary mb-4">Add Another Claim</button>
        
        <!-- Control Numbers -->
        <div class="card mb-4">
            <div class="card-header bg-primary text-white">Control Numbers</div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="se01">SE01</label>
                            <input type="text" class="form-control" id="se01" name="se01" value="{{ old('se01', '34') }}" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="ge_control_number">GE Control Number</label>
                            <input type="text" class="form-control" id="ge_control_number" name="ge_control_number" value="{{ old('ge_control_number', '123096815') }}" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            {{-- <label for="se02">SE02</label> --}}
                            <input type="hidden" class="form-control" id="se02" name="se02" value="{{ old('se02', mt_rand(1000, 999999999)) }}" required>
                        </div>
                    </div>
                    
                </div>
            </div>
        </div>
        
        <button type="submit" class="btn btn-success">Generate EDI</button>
    </form>
</div>

<script type="text/javascript">
	document.addEventListener('DOMContentLoaded', function() {
    // Add New Claim
    document.getElementById('add-claim').addEventListener('click', function() {
        const container = document.getElementById('claims-container');
        const claimCount = container.querySelectorAll('.claim-section').length;
        const newClaimIndex = claimCount;
        const today = new Date().toISOString().split('T')[0];
        
        const newClaimHTML = `
        <div class="card mb-4 claim-section">
            <div class="card-header bg-info text-white d-flex justify-content-between align-items-center">
                <span>Claim #${newClaimIndex + 1}</span>
               
                <button type="button" class="btn btn-danger btn-sm remove-claim">Remove</button>
               
            </div>
            <div class="card-body">
                <!-- Patient/Subscriber Information -->
                <div class="card mb-3">
                    <div class="card-header">Patient/Subscriber Information</div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Last Name</label>
                                    <input type="text" class="form-control" name="claims[${newClaimIndex}][subscriber_last_name]" value="Doe" required>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>First Name</label>
                                    <input type="text" class="form-control" name="claims[${newClaimIndex}][subscriber_first_name]" value="John" required>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Member ID</label>
                                    <input type="text" class="form-control" name="claims[${newClaimIndex}][member_id]" value="M${Math.floor(100000000 + Math.random() * 900000000)}" required>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Date of Birth</label>
                                    <input type="date" class="form-control" name="claims[${newClaimIndex}][subscriber_dob]" value="1985-01-15" required>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Gender</label>
                                    <select class="form-control" name="claims[${newClaimIndex}][subscriber_gender]" required>
                                        <option value="M" selected>Male</option>
                                        <option value="F">Female</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                          
                                <h5>Patient Address</h5>
                           
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Street</label>
                                    <input type="text" class="form-control" name="claims[${newClaimIndex}][subscriber_street]" value="456 Elm Street" required>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>City</label>
                                    <input type="text" class="form-control" name="claims[${newClaimIndex}][subscriber_city]" value="Los Angeles" required>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>State</label>
                                    <input type="text" class="form-control" name="claims[${newClaimIndex}][subscriber_state]" value="CA" required>
                                </div>
                            </div>
                            <div class="col-md-1">
                                <div class="form-group">
                                    <label>ZIP</label>
                                    <input type="text" class="form-control" name="claims[${newClaimIndex}][subscriber_zip]" value="90001" required>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Group Number</label>
                                    <input type="text" class="form-control" name="claims[${newClaimIndex}][group_number]" value="GROUP${newClaimIndex + 1}" required>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Insurance Type</label>
                                    <select class="form-control" name="claims[${newClaimIndex}][insurance_type]" required>
                                        <option value="MC">Medicare</option>
                                        <option value="CI">Commercial</option>
                                        <option value="BL">Blue Cross</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Claim Information -->
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Claim Number</label>
                            <input type="text" class="form-control" name="claims[${newClaimIndex}][claim_number]" value="CLM${Math.floor(100000 + Math.random() * 900000)}" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Claim Amount</label>
                            <input type="number" step="0.01" class="form-control" name="claims[${newClaimIndex}][claim_amount]" value="100.00" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Place of Service</label>
                            <input type="text" class="form-control" name="claims[${newClaimIndex}][place_of_service]" value="11" required>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Claim Frequency</label>
                            <select class="form-control" name="claims[${newClaimIndex}][claim_frequency]" required>
                                <option value="1" selected>Original</option>
                                <option value="7">Replacement</option>
                                <option value="8">Void/Cancel</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Primary Diagnosis</label>
                            <input type="text" class="form-control" name="claims[${newClaimIndex}][primary_diagnosis]" value="J45.909" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Additional Diagnosis (comma separated)</label>
                            <input type="text" class="form-control" name="claims[${newClaimIndex}][additional_diagnosis]">
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Date of Service</label>
                            <input type="date" class="form-control" name="claims[${newClaimIndex}][date_of_service]" value="${today}" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Condition Codes (comma separated)</label>
                            <input type="text" class="form-control" name="claims[${newClaimIndex}][condition_codes]">
                        </div>
                    </div>
                </div>
                
                <!-- Service Lines -->
                <div class="service-lines-container" data-claim-index="${newClaimIndex}">
                    <div class="card mb-3 service-line">
                        <div class="card-header bg-info text-white d-flex justify-content-between align-items-center">
                            <span>Service Line</span>
                             <div style="display:none;">
                            <button type="button" class="btn btn-danger btn-sm remove-service-line" data-claim-index="${newClaimIndex}" data-service-line-index="0">Remove</button>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Line Number</label>
                                        <input type="text" class="form-control" name="claims[${newClaimIndex}][service_lines][0][service_line_number]" value="1" required>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Procedure Code</label>
                                        <input type="text" class="form-control" name="claims[${newClaimIndex}][service_lines][0][procedure_code]" value="99213" required>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Charge Amount</label>
                                        <input type="number" step="0.01" class="form-control" name="claims[${newClaimIndex}][service_lines][0][charge_amount]" value="100.00" required>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Date of Service</label>
                                        <input type="date" class="form-control" name="claims[${newClaimIndex}][service_lines][0][date_of_service]" value="${today}" required>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Unit Count</label>
                                        <input type="number" class="form-control" name="claims[${newClaimIndex}][service_lines][0][unit_count]" value="1" required>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Diagnosis Pointer</label>
                                        <input type="text" class="form-control" name="claims[${newClaimIndex}][service_lines][0][diagnosis_pointer]" value="1" required>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div style="display:none;">
                <button type="button" class="btn btn-secondary btn-sm add-service-line" data-claim-index="${newClaimIndex}">Add Service Line</button>
                </div>
                
                <!-- Provider References -->
                 <div class="service-lines-container" data-claim-index="0">
                        <div class="card mb-3 service-line">

                     <div class="card-body">
                         <div class="row">
                <div class="row mt-3">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Referring Provider Name</label>
                            <input type="text" class="form-control" name="claims[${newClaimIndex}][referring_provider_name]" value="Dr. John Doe">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Referring NPI</label>
                            <input type="text" class="form-control" name="claims[${newClaimIndex}][referring_npi]" value="1234567890">
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Rendering Provider Name</label>
                            <input type="text" class="form-control" name="claims[${newClaimIndex}][rendering_provider_name]" value="Dr. Jane Smith">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Rendering NPI</label>
                            <input type="text" class="form-control" name="claims[${newClaimIndex}][rendering_npi]" value="9876543210">
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Supervising Provider Name</label>
                            <input type="text" class="form-control" name="claims[${newClaimIndex}][supervising_provider_name]" value="Dr. Robert Johnson">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Supervising NPI</label>
                            <input type="text" class="form-control" name="claims[${newClaimIndex}][supervising_npi]" value="1231231234">
                        </div>
                    </div>
                </div>
                </div>
                </div>
                </div>
                </div>
            </div>
        </div>`;
        
        container.insertAdjacentHTML('beforeend', newClaimHTML);
    });

    // Remove Claim
    document.addEventListener('click', function(e) {
        if (e.target.classList.contains('remove-claim')) {
            const claimSection = e.target.closest('.claim-section');
            if (document.querySelectorAll('.claim-section').length > 1) {
                claimSection.remove();
                // Renumber remaining claims
                document.querySelectorAll('.claim-section').forEach((section, index) => {
                    section.querySelector('.card-header span').textContent = `Claim #${index + 1}`;
                });
            } else {
                alert('You must have at least one claim.');
            }
        }
    });

    // Add Service Line
    document.addEventListener('click', function(e) {
        if (e.target.classList.contains('add-service-line')) {
            const claimIndex = e.target.getAttribute('data-claim-index');
            const container = e.target.previousElementSibling;
            const lineIndex = container.querySelectorAll('.service-line').length;
            const today = new Date().toISOString().split('T')[0];
            
            const newLineHTML = `
            <div class="card mb-3 service-line">
                <div class="card-header bg-info text-white d-flex justify-content-between align-items-center">
                    <span>Service Line #${lineIndex + 1}</span>
                    <button type="button" class="btn btn-danger btn-sm remove-service-line" data-claim-index="${claimIndex}" data-service-line-index="${lineIndex}">Remove</button>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Line Number</label>
                                <input type="text" class="form-control" name="claims[${claimIndex}][service_lines][${lineIndex}][service_line_number]" value="${lineIndex + 1}" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Procedure Code</label>
                                <input type="text" class="form-control" name="claims[${claimIndex}][service_lines][${lineIndex}][procedure_code]" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Charge Amount</label>
                                <input type="number" step="0.01" class="form-control" name="claims[${claimIndex}][service_lines][${lineIndex}][charge_amount]" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Date of Service</label>
                                <input type="date" class="form-control" name="claims[${claimIndex}][service_lines][${lineIndex}][date_of_service]" value="${today}" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Unit Count</label>
                                <input type="number" class="form-control" name="claims[${claimIndex}][service_lines][${lineIndex}][unit_count]" value="1" required>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Diagnosis Pointer</label>
                                <input type="text" class="form-control" name="claims[${claimIndex}][service_lines][${lineIndex}][diagnosis_pointer]" value="1" required>
                            </div>
                        </div>
                    </div>
                </div>
            </div>`;
            
            container.insertAdjacentHTML('beforeend', newLineHTML);
        }
    });

    // Remove Service Line
    document.addEventListener('click', function(e) {
        if (e.target.classList.contains('remove-service-line')) {
            const serviceLine = e.target.closest('.service-line');
            if (serviceLine.parentElement.querySelectorAll('.service-line').length > 1) {
                serviceLine.remove();
                // Renumber remaining service lines
                const remainingLines = serviceLine.parentElement.querySelectorAll('.service-line');
                remainingLines.forEach((line, index) => {
                    line.querySelector('.card-header span').textContent = `Service Line #${index + 1}`;
                    line.querySelector('[name*="service_line_number"]').value = index + 1;
                });
            } else {
                alert('You must have at least one service line per claim.');
            }
        }
    });

    // Initialize with one claim if empty
    if (document.querySelectorAll('.claim-section').length === 0) {
        document.getElementById('add-claim').click();
    }
});
	
</script>
@endsection