@extends('layouts.app')
@section('content')
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
@include('message')
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<style>
.btn-danger{
background: red;
}
</style>
<style>
.btn.text-white {
padding: 4px 14px;
font-size: 13px;
font-weight: 600;
border-radius: 6px;
line-height: 1.5;
display: inline-block;
text-align: center;
white-space: nowrap;
vertical-align: middle;
transition: background-color 0.2s ease-in-out;
background-color: rgb(79 70 229);
}
.form-group{
margin-bottom: 20px;
}

.step { display: none; }
.active { display: block; }
.next, .prev {
padding: 6px 16px;       /* good horizontal and vertical padding */
font-size: 14px;
border-radius: 6px;
border: none;
cursor: pointer;
width: auto;
height: auto;
display: inline-block;
text-align: center;
line-height: normal;
background-color: #0d6efd;  /* for .next */
color: white;
margin-right: 10px;
margin-bottom: 10px;
margin-top: 10px;
}
.prev {
background-color: orange;
}
#multiStepForm {
width: 50%;
background: white;
padding: 20px;
margin: 50px auto;
border-radius: 10px;
box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
}
/*  .step {
display: none;
}
.active {
display: block;
}*/
.step {
display: none;
}
.step.active {
display: flex; /* or block, but flex works better for columns */
flex-wrap: wrap;
}
h2 {
color: #333;
}
input {
/*width: 30%;
padding: 10px;*/
/*margin: 10px 0;*/
border: 1px solid #ccc;
border-radius: 5px;
font-size: 16px;
}
button {
background-color: #007bff;
color: white;
border: none;
padding: 10px 15px;
font-size: 16px;
cursor: pointer;
border-radius: 5px;
transition: 0.3s;
}
button:hover {
background-color: #0056b3;
}
.prev {
background-color: #6c757d;
}
.prev:hover {
background-color: #5a6268;
}
.submit {
background-color: #28a745;
}
.submit:hover {
background-color: #218838;
}
/*.form-control{
width: 30%;
}*/
.g-header{
padding-bottom: 0 !important;
}
.btn-container>div{
padding: 2.5rem 0 !important;
}
.mb-n10{
margin-bottom: -10px!important;
}
.mainmenu{
margin-bottom: 0!important;
}
.g-header .divide-x{
align-items: center;
}
.g-header  .divide-x p{
margin-bottom: 0;
}
.g-header .divide-x button{
padding: 0!important;
}
.fa-solid.fa-xmark{
    display: none;
}
</style>
<style>
input:read-only {
    background-color: #f5f5f5;  /* Light grey background */
    color: #555;               /* Text color */
    border: 1px solid #ccc;    /* Optional: border style */
    cursor: not-allowed;       /* Optional: indicate it's non-editable */
}
</style>

<div class="container">
    {{-- <h1>EDI-I Multiple Claim Form</h1> --}}
    
    <form id="ediIForm" method="POST" action="{{ route('multiple.edii.generate') }}">
        @csrf
        
        <!-- Part 1: Transaction Header (Non-repeatable) -->
        <div class="card mb-4 mt-4">
            <div class="card-header bg-primary text-white">
                Transaction Header 
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="sender_id">Sender ID</label>
                            <input type="text" class="form-control" id="sender_id" name="sender_id" required
                            value="{{ old('sender_id', 'SENDER123') }}">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="receiver_id">Receiver ID</label>
                            <input type="text" class="form-control" id="receiver_id" name="receiver_id" required
                            value="{{ old('receiver_id', 'RECEIVER456') }}">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="transmission_time">Transmission Time (HHMM)</label>
                            <input type="text" class="form-control" id="transmission_time" name="transmission_time" required
                            value="{{ old('transmission_time', '1430') }}">
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="control_number">Control Number</label>
                            <input type="text" class="form-control" id="control_number" name="control_number" required
                            value="{{ old('control_number', '123500377') }}">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="sender_code">Sender Code</label>
                            <input type="text" class="form-control" id="sender_code" name="sender_code" required
                            value="{{ old('sender_code', 'SENDCODE01') }}">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="receiver_code">Receiver Code</label>
                            <input type="text" class="form-control" id="receiver_code" name="receiver_code" required
                            value="{{ old('receiver_code', 'RECVCODE01') }}">
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="gs_date">GS Date (CCYYMMDD)</label>
                            <input type="text" class="form-control" id="gs_date" name="gs_date" required
                            value="{{ old('gs_date', '20231115') }}">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="gs_time">GS Time (HHMM)</label>
                            <input type="text" class="form-control" id="gs_time" name="gs_time" required
                            value="{{ old('gs_time', '0930') }}">
                        </div>
                    </div>
                    
                    <!-- Part 2: Submitter/Receiver Info -->
                    
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="submitter_name">Submitter Name</label>
                            <input type="text" class="form-control" id="submitter_name" name="submitter_name" required
                            value="{{ old('submitter_name', 'ABC Medical Billing') }}">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="submitter_contact">Submitter contact</label>
                            <input type="text" class="form-control" id="submitter_contact" name="submitter_contact" value="{{ old('submitter_contact', 'BILLING DEPARTMENT') }}" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="submitter_phone">Submitter phone</label>
                            <input type="text" class="form-control" id="submitter_phone" name="submitter_phone" value="{{ old('submitter_phone', '8005551234') }}" pattern="[0-9]{10}" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="submitter_id">Submitter ID</label>
                            <input type="text" class="form-control" id="submitter_id" name="submitter_id" required
                            value="{{ old('submitter_id', 'SUBMITTER01') }}">
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="receiver_name">Receiver Name</label>
                            <input type="text" class="form-control" id="receiver_name" name="receiver_name" required
                            value="{{ old('receiver_name', 'XYZ Insurance Company') }}">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="receiver_id">Receiver ID</label>
                            <input type="text" class="form-control" id="receiver_id" name="receiver_id" required
                            value="{{ old('receiver_id', 'PAYER12345') }}">
                        </div>
                    </div>
                </div>
            </div>
        </div>







@if(@Auth::user()->user_type=="A")
        <!-- Part 3: Billing Provider Info -->
        <div class="card mb-4">
            <div class="card-header bg-primary text-white">
                 Provider Information 
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="billing_provider_name">Provider Name</label>
                            <input type="text" class="form-control" id="billing_provider_name" name="billing_provider_name" required
                            value="{{ old('billing_provider_name', 'City General Hospital') }}">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="billing_provider_npi">NPI</label>
                            <input type="text" class="form-control" id="billing_provider_npi" name="billing_provider_npi" required
                            value="{{ old('billing_provider_npi', '1234567890') }}">
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="billing_provider_tax_id">Tax ID</label>
                            <input type="text" class="form-control" id="billing_provider_tax_id" name="billing_provider_tax_id" required
                            value="{{ old('billing_provider_tax_id', '12-3456789') }}">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="billing_provider_street">Street Address</label>
                            <input type="text" class="form-control" id="billing_provider_street" name="billing_provider_street" required
                            value="{{ old('billing_provider_street', '123 Medical Center Dr') }}">
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="billing_provider_city">City</label>
                            <input type="text" class="form-control" id="billing_provider_city" name="billing_provider_city" required
                            value="{{ old('billing_provider_city', 'Anytown') }}">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="billing_provider_state">State</label>
                            <input type="text" class="form-control" id="billing_provider_state" name="billing_provider_state" required
                            value="{{ old('billing_provider_state', 'NY') }}">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="billing_provider_zip">ZIP Code</label>
                            <input type="text" class="form-control" id="billing_provider_zip" name="billing_provider_zip" required
                            value="{{ old('billing_provider_zip', '123456789') }}">
                        </div>
                    </div>
                    
                    
                    <!-- Facility Name -->
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="facility_name">Facility Name</label>
                            <input type="text" class="form-control" id="facility_name" name="facility_name" value="{{ old('facility_name', 'ABC Healthcare') }}" required>
                        </div>
                    </div>
                    <!-- Facility NPI -->
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="facility_npi">Facility NPI</label>
                            <input type="text" class="form-control" id="facility_npi" name="facility_npi" value="{{ old('facility_npi', '1234567890') }}" required>
                        </div>
                    </div>
                    <!-- Facility Street -->
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="facility_street">Facility Street</label>
                            <input type="text" class="form-control" id="facility_street" name="facility_street" value="{{ old('facility_street', '123 Main St') }}" required>
                        </div>
                    </div>
                    <!-- Facility City -->
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="facility_city">Facility City</label>
                            <input type="text" class="form-control" id="facility_city" name="facility_city" value="{{ old('facility_city', 'New York') }}" required>
                        </div>
                    </div>
                    <!-- Facility State -->
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="facility_state">Facility State</label>
                            <input type="text" class="form-control" id="facility_state" name="facility_state" value="{{ old('facility_state', 'NY') }}" required>
                        </div>
                    </div>
                    <!-- Facility Zip -->
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="facility_zip">Facility Zip</label>
                            <input type="text" class="form-control" id="facility_zip" name="facility_zip" value="{{ old('facility_zip', '123456789') }}" required>
                        </div>
                    </div>
                </div>
            </div>
        </div>
@else
  <!-- Part 3: Billing Provider Info -->
        <div class="card mb-4">
            <div class="card-header bg-primary text-white">
                 Provider Information 
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="billing_provider_name">Provider Name</label>
                            <input type="text" class="form-control" id="billing_provider_name" name="billing_provider_name" 
                           value="{{@Auth::user()->providerDetails->provider_clinic_name}}" required readonly>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="billing_provider_npi">Provider NPI</label>
                            <input type="text" class="form-control" id="billing_provider_npi" name="billing_provider_npi" value="{{ @Auth::user()->providerDetails->npi }}"  required readonly>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="billing_provider_tax_id">Provider Tax ID</label>
                            <input type="text" class="form-control" id="billing_provider_tax_id" name="billing_provider_tax_id" value="{{ @Auth::user()->providerDetails->tax_id }}"  required readonly>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="billing_provider_street">Provider Street Address</label>
                            <input type="text" class="form-control" id="billing_provider_street" name="billing_provider_street" value="{{ @Auth::user()->providerDetails->service_street }}" required readonly>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="billing_provider_city">Provider City</label>
                            <input type="text" class="form-control" id="billing_provider_city" name="billing_provider_city" value="{{ @Auth::user()->providerDetails->service_city }}" required readonly>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="billing_provider_state">Provider State</label>
                            <input type="text" class="form-control" id="billing_provider_state" name="billing_provider_state" value="{{ @Auth::user()->providerDetails->service_state }}" required readonly>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="billing_provider_zip">Provider ZIP Code</label>
                            <input type="text" class="form-control" id="billing_provider_zip" name="billing_provider_zip" value="{{ @Auth::user()->providerDetails->service_zip_code }}" required readonly>
                        </div>
                    </div>
                    
                    
                    <!-- Facility Name -->
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="facility_name">Facility Name</label>
                            <input type="text" class="form-control" id="facility_name" name="facility_name" value="{{ @Auth::user()->providerDetails->f_name }}" required>
                        </div>
                    </div>
                    <!-- Facility NPI -->
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="facility_npi">Facility NPI</label>
                            <input type="text" class="form-control" id="facility_npi" name="facility_npi" value="{{ @Auth::user()->providerDetails->f_npi }}" required>
                        </div>
                    </div>
                    <!-- Facility Street -->
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="facility_street">Facility Street</label>
                            <input type="text" class="form-control" id="facility_street" name="facility_street" value="{{ @Auth::user()->providerDetails->f_street }}" required>
                        </div>
                    </div>
                    <!-- Facility City -->
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="facility_city">Facility City</label>
                            <input type="text" class="form-control" id="facility_city" name="facility_city" value="{{ @Auth::user()->providerDetails->f_city }}" required>
                        </div>
                    </div>
                    <!-- Facility State -->
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="facility_state">Facility State</label>
                            <input type="text" class="form-control" id="facility_state" name="facility_state" value="{{ @Auth::user()->providerDetails->f_state }}" required>
                        </div>
                    </div>
                    <!-- Facility Zip -->
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="facility_zip">Facility Zip</label>
                            <input type="text" class="form-control" id="facility_zip" name="facility_zip" value="{{ @Auth::user()->providerDetails->f_zip }}" required>
                        </div>
                    </div>
                </div>
            </div>
        </div>


@endif








        <!-- Payer Information -->
        <div class="card mb-4">
            <div class="card-header bg-primary text-white">
                Payer Information
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="payer_name">Payer Name</label>
                            <input type="text" class="form-control" id="payer_name" name="payer_name" required
                            value="{{ old('payer_name', 'XYZ Health Insurance') }}">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="payer_id">Payer ID</label>
                            <input type="text" class="form-control" id="payer_id" name="payer_id" required
                            value="{{ old('payer_id', '12345') }}">
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="payer_street">Street Address</label>
                            <input type="text" class="form-control" id="payer_street" name="payer_street" required
                            value="{{ old('payer_street', '789 Insurance Blvd') }}">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="payer_city">City</label>
                            <input type="text" class="form-control" id="payer_city" name="payer_city" required
                            value="{{ old('payer_city', 'Metropolis') }}">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="payer_state">State</label>
                            <input type="text" class="form-control" id="payer_state" name="payer_state" value="{{ old('payer_state', 'NY') }}" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="payer_zip">ZIP Code</label>
                            <input type="text" class="form-control" id="payer_zip" name="payer_zip" required
                            value="{{ old('payer_zip', '987654321') }}">
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Repeatable Claims Section -->
        <div id="claims-container">
            <div class="card mb-4 claim-section">
                <div class="card-header bg-info text-white d-flex justify-content-between align-items-center">
                    <h3 class="mb-0">Claim #1</h3>
                    <button type="button" class="btn btn-danger btn-sm remove-claim">Remove</button>
                </div>
                <div class="card-body">
                    <!-- Patient Information -->
                    <h4>Patient Information</h4>
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims[0][patient_last_name]">Last Name</label>
                                <input type="text" class="form-control" name="claims[0][patient_last_name]" required
                                value="{{ old('claims.0.patient_last_name', 'Smith') }}">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims[0][patient_first_name]">First Name</label>
                                <input type="text" class="form-control" name="claims[0][patient_first_name]" required
                                value="{{ old('claims.0.patient_first_name', 'John') }}">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims[0][patient_dob]">Date of Birth (YYYYMMDD)</label>
                                <input type="date" class="form-control" name="claims[0][patient_dob]" required
                                value="{{ old('claims.0.patient_dob', '1985-01-15') }}">
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims[0][patient_gender]">Gender</label>
                                <select class="form-control" name="claims[0][patient_gender]" required>
                                    <option value="M" {{ old('claims.0.patient_gender', 'M') == 'M' ? 'selected' : '' }}>Male</option>
                                    <option value="F" {{ old('claims.0.patient_gender') == 'F' ? 'selected' : '' }}>Female</option>
                                    <option value="U" {{ old('claims.0.patient_gender') == 'U' ? 'selected' : '' }}>Unknown</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims[0][patient_member_id]">Member ID</label>
                                <input type="text" class="form-control" name="claims[0][patient_member_id]" required
                                value="{{ old('claims.0.patient_member_id', 'MEMBER001') }}">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims[0][patient_street]">Street Address</label>
                                <input type="text" class="form-control" name="claims[0][patient_street]" required
                                value="{{ old('claims.0.patient_street', '123 Main St') }}">
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims[0][patient_city]">City</label>
                                <input type="text" class="form-control" name="claims[0][patient_city]" required
                                value="{{ old('claims.0.patient_city', 'Anytown') }}">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims[0][patient_state]">State</label>
                                <input type="text" class="form-control" name="claims[0][patient_state]" required
                                value="{{ old('claims.0.patient_state', 'NY') }}">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims[0][patient_zip]">ZIP Code</label>
                                <input type="text" class="form-control" name="claims[0][patient_zip]" required
                                value="{{ old('claims.0.patient_zip', '123456789') }}">
                            </div>
                        </div>
                    </div>
                    
                    <!-- Admission Information -->
                    <h4>Admission Information</h4>
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims[0][admission_date]">Admission Date (YYYYMMDD)</label>
                                <input type="text" class="form-control" name="claims[0][admission_date]" required
                                value="{{ old('claims.0.admission_date', '20231001') }}">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims[0][discharge_date]">Discharge Date (YYYYMMDD)</label>
                                <input type="text" class="form-control" name="claims[0][discharge_date]" required
                                value="{{ old('claims.0.discharge_date', '20231005') }}">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims[0][admission_type_code]">Admission Type Code</label>
                                <input type="text" class="form-control" name="claims[0][admission_type_code]" required
                                value="{{ old('claims.0.admission_type_code', '1') }}">
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims[0][admission_source_code]">Admission Source Code (2 chars)</label>
                                <input type="text" class="form-control" name="claims[0][admission_source_code]" required maxlength="2"
                                value="{{ old('claims.0.admission_source_code', '4') }}">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims[0][facility_type_code]">Facility Type Code (2 chars)</label>
                                <input type="text" class="form-control" name="claims[0][facility_type_code]" required maxlength="2"
                                value="{{ old('claims.0.facility_type_code', '11') }}">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims[0][claim_frequency_code]">Claim Frequency Code</label>
                                <input type="text" class="form-control" name="claims[0][claim_frequency_code]" required maxlength="1"
                                value="{{ old('claims.0.claim_frequency_code', '1') }}">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims[0][claim_number]">Claim Number</label>
                                <input type="text" class="form-control" name="claims[0][claim_number]" required
                                value="{{ old('claims.0.claim_number', 'CLM20230001') }}">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims[0][total_claim_amount]">Total Claim Amount</label>
                                <input type="text" class="form-control" name="claims[0][total_claim_amount]" required
                                value="{{ old('claims.0.total_claim_amount', '2500.00') }}">
                            </div>
                        </div>
                    </div>
                    <!-- Provider Information -->
                    <h4>Provider Information</h4>
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims[0][attending_provider_npi]">Attending Provider NPI</label>
                                <input type="text" class="form-control" name="claims[0][attending_provider_npi]" required minlength="10" maxlength="10"
                                value="{{ old('claims.0.attending_provider_npi', '1234567890') }}">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims[0][operating_provider_npi]">Operating Provider NPI</label>
                                <input type="text" class="form-control" name="claims[0][operating_provider_npi]" required minlength="10" maxlength="10"
                                value="{{ old('claims.0.operating_provider_npi', '2345678901') }}">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims[0][referring_provider_npi]">Referring Provider NPI</label>
                                <input type="text" class="form-control" name="claims[0][referring_provider_npi]" required minlength="10" maxlength="10"
                                value="{{ old('claims.0.referring_provider_npi', '3456789012') }}">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims[0][supervising_provider_npi]">Supervising Provider NPI</label>
                                <input type="text" class="form-control" name="claims[0][supervising_provider_npi]" required minlength="10" maxlength="10"
                                value="{{ old('claims.0.supervising_provider_npi', '4567890123') }}">
                            </div>
                        </div>
                    </div>
                    
                    <!-- Diagnosis Information -->
                    <h4>Diagnosis Information</h4>
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims[0][primary_diagnosis]">Primary Diagnosis</label>
                                <input type="text" class="form-control" name="claims[0][primary_diagnosis]" required
                                value="{{ old('claims.0.primary_diagnosis', 'E11.65') }}">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims[0][additional_diagnosis]">Additional Diagnosis (comma separated)</label>
                                <input type="text" class="form-control" name="claims[0][additional_diagnosis]"
                                value="{{ old('claims.0.additional_diagnosis', 'I10, Z79.899') }}">
                            </div>
                        </div>
                    </div>
                    
                    <!-- Service Lines (Repeatable within each claim) -->
                    <div class="service-lines-container">
                        <div class="card mb-3 service-line">
                            <div class="card-header bg-light d-flex justify-content-between align-items-center">
                                <h5 class="mb-0">Service Line </h5>
                                <div style="display:none;">
                                    <button type="button" class="btn btn-danger btn-sm remove-service-line">Remove</button>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="claims[0][service_lines][0][procedure_code]">Procedure Code</label>
                                            <input type="text" class="form-control" name="claims[0][service_lines][0][procedure_code]" required
                                            value="{{ old('claims.0.service_lines.0.procedure_code', '99213') }}">
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="claims[0][service_lines][0][revenue_code]">Revenue Code</label>
                                            <input type="text" class="form-control" name="claims[0][service_lines][0][revenue_code]" required
                                            value="{{ old('claims.0.service_lines.0.revenue_code', '0300') }}">
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="claims[0][service_lines][0][charge_amount]">Charge Amount</label>
                                            <input type="text" class="form-control" name="claims[0][service_lines][0][charge_amount]" required
                                            value="{{ old('claims.0.service_lines.0.charge_amount', '150.00') }}">
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="claims[0][service_lines][0][units_of_service]">Units</label>
                                            <input type="number" class="form-control" name="claims[0][service_lines][0][units_of_service]" required min="1"
                                            value="{{ old('claims.0.service_lines.0.units_of_service', '1') }}">
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="claims[0][service_lines][0][service_date]">Service Date (YYYYMMDD)</label>
                                            <input type="text" class="form-control" name="claims[0][service_lines][0][service_date]" required
                                            value="{{ old('claims.0.service_lines.0.service_date', '20231002') }}">
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="claims[0][service_lines][0][condition_codes]">Condition Codes (comma separated)</label>
                                            <input type="text" class="form-control" name="claims[0][service_lines][0][condition_codes]"
                                            value="{{ old('claims.0.service_lines.0.condition_codes', 'A1,B2') }}">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div style="display:none;">
                        <button type="button" class="btn btn-primary btn-sm add-service-line" data-claim-index="0">Add Service Line</button>
                    </div>
                </div>
            </div>
        </div>
        
        <button type="button" id="add-claim" class="btn btn-primary mb-4">Add Another Claim</button>
        
        
        <!-- Transaction Footer -->
        <div class="card mb-4">
            <div class="card-header bg-primary text-white">
                Transaction Footer
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="se01">SE01</label>
                            <input type="number" class="form-control" id="se01" name="se01" required min="1"
                            value="{{ old('se01', '1') }}">
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="ge_control_number">GE Control Number</label>
                            <input type="text" class="form-control" id="ge_control_number" name="ge_control_number" required
                            value="{{ old('ge_control_number', 'GE20230001') }}">
                        </div>
                    </div>

                    
                    <div class="col-md-4">
                        <div class="form-group">
                            {{-- <label for="se02">SE02</label> --}}
                            <input type="hidden" class="form-control" id="se02" name="se02" required
                            value="{{ old('se02', mt_rand(1000, 999999999)) }}"
                            >
                        </div>
                    </div>
                    
                </div>
            </div>
        </div>
        
        <button type="submit" class="btn btn-success btn-lg">Submit Claims</button>
    </form>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Add new claim
    let claimCounter = 1;
    document.getElementById('add-claim').addEventListener('click', function() {
        const container = document.getElementById('claims-container');
        const newClaim = container.firstElementChild.cloneNode(true);
        
        // Update claim index
        const newIndex = claimCounter++;
        newClaim.innerHTML = newClaim.innerHTML.replace(/claims\[0\]/g, `claims[${newIndex}]`);
        newClaim.innerHTML = newClaim.innerHTML.replace(/claims\.0/g, `claims.${newIndex}`);
        newClaim.querySelector('.card-header h3').textContent = `Claim #${newIndex + 1}`;
        
        // Reset values in the cloned claim
        const inputs = newClaim.querySelectorAll('input');
        inputs.forEach(input => {
            if (input.name.includes('claims[') && !input.name.includes('service_lines')) {
                const nameParts = input.name.match(/claims\[\d+\]\[(.*?)\]/);
                if (nameParts) {
                    const fieldName = nameParts[1];
                    // Set default empty values for patient info
                    if (['patient_last_name', 'patient_first_name'].includes(fieldName)) {
                        input.value = '';
                    } 
                    // Set default values for required codes
                    else if (fieldName === 'admission_type_code') {
                        input.value = '1';
                    }
                    else if (fieldName === 'admission_source_code') {
                        input.value = '4';
                    }
                    else if (fieldName === 'facility_type_code') {
                        input.value = '11';
                    }
                    else if (fieldName === 'claim_frequency_code') {
                        input.value = '1';
                    }
                    // Set default NPIs
                    else if (fieldName === 'attending_provider_npi') {
                        input.value = '1234567890';
                    }
                    else if (fieldName === 'operating_provider_npi') {
                        input.value = '2345678901';
                    }
                    else if (fieldName === 'referring_provider_npi') {
                        input.value = '3456789012';
                    }
                    else if (fieldName === 'supervising_provider_npi') {
                        input.value = '4567890123';
                    }
                    else if (fieldName === 'patient_dob') {
                        input.value = '19800101'; // Default DOB
                    }
                    else if (fieldName === 'patient_gender') {
                        input.value = 'M'; // Default gender
                    }
                    else if (fieldName === 'admission_date' || fieldName === 'discharge_date') {
                        input.value = '20230101'; // Default dates
                    }
                    else if (fieldName === 'total_claim_amount') {
                        input.value = '0.00'; // Default amount
                    }
                }
            }
        });
        
        // Update service line button data attribute
        const addServiceLineBtn = newClaim.querySelector('.add-service-line');
        if (addServiceLineBtn) {
            addServiceLineBtn.setAttribute('data-claim-index', newIndex);
        }
        
        container.appendChild(newClaim);
    });
    
    // Remove claim
    document.addEventListener('click', function(e) {
        if (e.target.classList.contains('remove-claim')) {
            if (document.querySelectorAll('.claim-section').length > 1) {
                e.target.closest('.claim-section').remove();
            } else {
                alert('You must have at least one claim.');
            }
        }
    });
    
    // Add service line
    document.addEventListener('click', function(e) {
        if (e.target.classList.contains('add-service-line')) {
            const claimIndex = e.target.getAttribute('data-claim-index');
            const container = e.target.closest('.card-body').querySelector('.service-lines-container');
            const serviceLines = container.querySelectorAll('.service-line');
            const newIndex = serviceLines.length;
            
            const newServiceLine = serviceLines[0].cloneNode(true);
            newServiceLine.innerHTML = newServiceLine.innerHTML.replace(/service_lines\[0\]/g, `service_lines[${newIndex}]`);
            newServiceLine.innerHTML = newServiceLine.innerHTML.replace(/service_lines\.0/g, `service_lines.${newIndex}`);
            newServiceLine.querySelector('.card-header h5').textContent = `Service Line #${newIndex + 1}`;
            
            // Reset values
            const inputs = newServiceLine.querySelectorAll('input');
            inputs.forEach(input => {
                if (input.name.includes('service_lines')) {
                    if (input.name.includes('charge_amount')) {
                        input.value = '0.00';
                    } else if (input.name.includes('units_of_service')) {
                        input.value = '1';
                    } else if (input.name.includes('service_date')) {
                        input.value = '20230101';
                    } else {
                        input.value = '';
                    }
                }
            });
            
            container.appendChild(newServiceLine);
        }
    });
    
    // Remove service line
    document.addEventListener('click', function(e) {
        if (e.target.classList.contains('remove-service-line')) {
            const serviceLines = e.target.closest('.service-lines-container').querySelectorAll('.service-line');
            if (serviceLines.length > 1) {
                e.target.closest('.service-line').remove();
            } else {
                alert('You must have at least one service line per claim.');
            }
        }
    });
});
</script>
@endsection