@extends('layouts.app')

@section('content')
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
@include('message')
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<style>
    .btn-danger{
        background: red;
    }
</style>
<style>
input:read-only {
    background-color: #f5f5f5;  /* Light grey background */
    color: #555;               /* Text color */
    border: 1px solid #ccc;    /* Optional: border style */
    cursor: not-allowed;       /* Optional: indicate it's non-editable */
}
</style>

<div class="container">
    <h1>EDI-D Multiple Claims Form</h1>
    
    <form id="ediDForm" method="POST" action="{{ route('multiple.edid.generate') }}">
        @csrf
        
        <!-- Part 1: Non-repeatable fields (Transmission Info) -->
        <div class="card mb-4">
            <div class="card-header bg-primary text-white">
                <h3>Part 1: Transmission Information</h3>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="sender_id">Sender ID</label>
                            <input type="text" class="form-control" id="sender_id" name="sender_id" 
                                   value="{{ old('sender_id', 'SENDER123') }}" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="receiver_id">Receiver ID</label>
                            <input type="text" class="form-control" id="receiver_id" name="receiver_id" 
                                   value="{{ old('receiver_id', 'RECEIVER456') }}" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="transmission_date">Transmission Date (YYYYMMDD)</label>
                            <input type="text" class="form-control" id="transmission_date" name="transmission_date" 
                                   value="{{ old('transmission_date', date('Ymd')) }}" pattern="\d{8}" required>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="transmission_time">Transmission Time (HHMM)</label>
                            <input type="text" class="form-control" id="transmission_time" name="transmission_time" 
                                   value="{{ old('transmission_time', date('Hi')) }}" pattern="\d{4}" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="control_number">Control Number</label>
                            <input type="text" class="form-control" id="control_number" name="control_number" 
                                   value="{{ old('control_number', '123456789') }}" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="sender_code">Sender Code</label>
                            <input type="text" class="form-control" id="sender_code" name="sender_code" 
                                   value="{{ old('sender_code', 'SENDCODE') }}" required>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="receiver_code">Receiver Code</label>
                            <input type="text" class="form-control" id="receiver_code" name="receiver_code" 
                                   value="{{ old('receiver_code', 'RECVCODE') }}" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="gs_date">GS Date (YYYYMMDD)</label>
                            <input type="text" class="form-control" id="gs_date" name="gs_date" 
                                   value="{{ old('gs_date', date('Ymd')) }}" pattern="\d{8}" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="gs_time">GS Time (HHMM)</label>
                            <input type="text" class="form-control" id="gs_time" name="gs_time" 
                                   value="{{ old('gs_time', date('Hi')) }}" pattern="\d{4}" required>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="gs_control_number">GS Control Number</label>
                            <input type="text" class="form-control" id="gs_control_number" name="gs_control_number" 
                                   value="{{ old('gs_control_number', '987654321') }}" required>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Part 2: Non-repeatable fields (Submitter/Receiver Info) -->
        <div class="card mb-4">
            <div class="card-header bg-primary text-white">
                <h3>Part 2: Submitter/Receiver Information</h3>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="submitter_name">Submitter Name</label>
                            <input type="text" class="form-control" id="submitter_name" name="submitter_name" 
                                   value="{{ old('submitter_name', 'ABC Medical Billing') }}" required>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="submitter_id">Submitter ID</label>
                            <input type="text" class="form-control" id="submitter_id" name="submitter_id" 
                                   value="{{ old('submitter_id', 'SUBMIT123') }}" required>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="receiver_name">Receiver Name</label>
                            <input type="text" class="form-control" id="receiver_name" name="receiver_name" 
                                   value="{{ old('receiver_name', 'XYZ Insurance') }}" required>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="receiver_id">Receiver ID</label>
                            <input type="text" class="form-control" id="receiver_id" name="receiver_id" 
                                   value="{{ old('receiver_id', 'RECEIVE456') }}" required>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Part 3: Non-repeatable fields (Billing Provider Info) -->
        <div class="card mb-4">
            <div class="card-header bg-primary text-white">
                <h3>Part 3: Billing Provider Information</h3>
            </div>
            <div class="card-body">



                @if(@Auth::user()->user_type=="A")
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="billing_provider_name">Billing Provider Name</label>
                            <input type="text" class="form-control" id="billing_provider_name" name="billing_provider_name" 
                                   value="{{ old('billing_provider_name', 'Sunshine Dental Clinic') }}" required>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="billing_provider_npi">Billing Provider NPI</label>
                            <input type="text" class="form-control" id="billing_provider_npi" name="billing_provider_npi" 
                                   value="{{ old('billing_provider_npi', '1234567890') }}" pattern="\d{10}" required>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="billing_provider_tax_id">Billing Provider Tax ID</label>
                            <input type="text" class="form-control" id="billing_provider_tax_id" name="billing_provider_tax_id" 
                                   value="{{ old('billing_provider_tax_id', '12-3456789') }}" required>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="billing_provider_street">Billing Provider Street</label>
                            <input type="text" class="form-control" id="billing_provider_street" name="billing_provider_street" 
                                   value="{{ old('billing_provider_street', '123 Main St') }}" required>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="billing_provider_city">Billing Provider City</label>
                            <input type="text" class="form-control" id="billing_provider_city" name="billing_provider_city" 
                                   value="{{ old('billing_provider_city', 'Anytown') }}" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="billing_provider_state">Billing Provider State</label>
                            <input type="text" class="form-control" id="billing_provider_state" name="billing_provider_state" 
                                   value="{{ old('billing_provider_state', 'NY') }}" pattern="[A-Z]{2}" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="billing_provider_zip">Billing Provider ZIP</label>
                            <input type="text" class="form-control" id="billing_provider_zip" name="billing_provider_zip" 
                                   value="{{ old('billing_provider_zip', '123456789') }}" pattern="\d{9}" required>
                        </div>
                    </div>
                </div>



                @else
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="billing_provider_name">Billing Provider Name</label>
                            <input type="text" class="form-control" id="billing_provider_name" name="billing_provider_name" 
                                   value="{{@Auth::user()->providerDetails->provider_clinic_name}}" required readonly>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="billing_provider_npi">Billing Provider NPI</label>
                            <input type="text" class="form-control" id="billing_provider_npi" name="billing_provider_npi" 
                                   value="{{ @Auth::user()->providerDetails->npi }}"  required readonly>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="billing_provider_tax_id">Billing Provider Tax ID</label>
                            <input type="text" class="form-control" id="billing_provider_tax_id" name="billing_provider_tax_id" 
                                   value="{{ @Auth::user()->providerDetails->tax_id }}"  required readonly>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="billing_provider_street">Billing Provider Street</label>
                            <input type="text" class="form-control" id="billing_provider_street" name="billing_provider_street" 
                                  value="{{ @Auth::user()->providerDetails->service_street }}" required readonly>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="billing_provider_city">Billing Provider City</label>
                            <input type="text" class="form-control" id="billing_provider_city" name="billing_provider_city" 
                                   value="{{ @Auth::user()->providerDetails->service_city }}" required readonly>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="billing_provider_state">Billing Provider State</label>
                            <input type="text" class="form-control" id="billing_provider_state" name="billing_provider_state" 
                                   value="{{ @Auth::user()->providerDetails->service_state }}" required readonly>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="billing_provider_zip">Billing Provider ZIP</label>
                            <input type="text" class="form-control" id="billing_provider_zip" name="billing_provider_zip" 
                                   value="{{ @Auth::user()->providerDetails->service_zip_code }}" required readonly>
                        </div>
                    </div>
                </div>




                @endif




                 @if(@Auth::user()->user_type=="A")
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="facility_name">Facility Name</label>
                            <input type="text" class="form-control" id="facility_name" name="facility_name" 
                                   value="{{ old('facility_name', 'Sunshine Dental Clinic') }}" required>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="facility_npi">Facility NPI</label>
                            <input type="text" class="form-control" id="facility_npi" name="facility_npi" 
                                   value="{{ old('facility_npi', '1234567890') }}" pattern="\d{10}" required>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="facility_street">Facility Street</label>
                            <input type="text" class="form-control" id="facility_street" name="facility_street" 
                                   value="{{ old('facility_street', '123 Main St') }}" required>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="facility_city">Facility City</label>
                            <input type="text" class="form-control" id="facility_city" name="facility_city" 
                                   value="{{ old('facility_city', 'Anytown') }}" required>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="facility_state">Facility State</label>
                            <input type="text" class="form-control" id="facility_state" name="facility_state" 
                                   value="{{ old('facility_state', 'NY') }}" pattern="[A-Z]{2}" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="facility_zip">Facility ZIP</label>
                            <input type="text" class="form-control" id="facility_zip" name="facility_zip" 
                                   value="{{ old('facility_zip', '123456789') }}" pattern="\d{9}" required>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        @else
         <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="facility_name">Facility Name</label>
                            <input type="text" class="form-control" id="facility_name" name="facility_name" 
                                   value="{{ @Auth::user()->providerDetails->f_name }}" required>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="facility_npi">Facility NPI</label>
                            <input type="text" class="form-control" id="facility_npi" name="facility_npi" 
                                   value="{{ @Auth::user()->providerDetails->f_npi }}"  required>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="facility_street">Facility Street</label>
                            <input type="text" class="form-control" id="facility_street" name="facility_street" 
                                   value="{{ @Auth::user()->providerDetails->f_street }}" required>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="facility_city">Facility City</label>
                            <input type="text" class="form-control" id="facility_city" name="facility_city" 
                                   value="{{ @Auth::user()->providerDetails->f_city }}" required>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="facility_state">Facility State</label>
                            <input type="text" class="form-control" id="facility_state" name="facility_state" 
                                   value="{{ @Auth::user()->providerDetails->f_state }}" pattern="[A-Z]{2}" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="facility_zip">Facility ZIP</label>
                            <input type="text" class="form-control" id="facility_zip" name="facility_zip" 
                                   value="{{ @Auth::user()->providerDetails->f_zip }}" pattern="\d{9}" required>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @endif

















          <div class="card mb-4">
            <div class="card-header bg-primary text-white">
                <h3>Part 8: Payer Information</h3>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="payer_name">Payer Name</label>
                            <input type="text" class="form-control" id="payer_name" name="payer_name" 
                                   value="{{ old('payer_name', 'XYZ Dental Insurance') }}" required>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="payer_id">Payer ID</label>
                            <input type="text" class="form-control" id="payer_id" name="payer_id" 
                                   value="{{ old('payer_id', '123456789') }}" pattern="\d{9}" required>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="payer_street">Payer Street</label>
                            <input type="text" class="form-control" id="payer_street" name="payer_street" 
                                   value="{{ old('payer_street', '789 Insurance Blvd') }}" required>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="payer_city">Payer City</label>
                            <input type="text" class="form-control" id="payer_city" name="payer_city" 
                                   value="{{ old('payer_city', 'Metropolis') }}" required>
                        </div>
                    </div>
                     <div class="col-md-2">
                        <div class="form-group">
                            <label for="payer_state">State</label>
                            <input type="text" class="form-control" id="payer_state" name="payer_state" value="{{ old('payer_state', 'NY') }}" required>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="payer_zip">Payer ZIP</label>
                            <input type="text" class="form-control" id="payer_zip" name="payer_zip" 
                                   value="{{ old('payer_zip', '123456789') }}" maxlength ="9" required>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        










        
        <!-- Part 4: Repeatable fields (Patient Information) -->
        <div id="claims-container">
            <div class="card mb-4 claim-section" data-index="0">
                <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
                    <h3>Part 4: Patient Information - Claim #1</h3>
                    <button type="button" class="btn btn-danger btn-sm remove-claim" style="display: none;">Remove</button>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims_0_patient_last_name">Patient Last Name</label>
                                <input type="text" class="form-control" id="claims_0_patient_last_name" name="claims[0][patient_last_name]" 
                                       value="{{ old('claims.0.patient_last_name', 'Smith') }}" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims_0_patient_first_name">Patient First Name</label>
                                <input type="text" class="form-control" id="claims_0_patient_first_name" name="claims[0][patient_first_name]" 
                                       value="{{ old('claims.0.patient_first_name', 'John') }}" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims_0_patient_dob">Patient DOB (YYYYMMDD)</label>
                                <input type="text" class="form-control" id="claims_0_patient_dob" name="claims[0][patient_dob]" 
                                       value="{{ old('claims.0.patient_dob', '19800101') }}" pattern="\d{8}" required>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="claims_0_patient_gender">Patient Gender</label>
                                <select class="form-control" id="claims_0_patient_gender" name="claims[0][patient_gender]" required>
                                    <option value="M" {{ old('claims.0.patient_gender', 'M') == 'M' ? 'selected' : '' }}>Male</option>
                                    <option value="F" {{ old('claims.0.patient_gender', 'M') == 'F' ? 'selected' : '' }}>Female</option>
                                    <option value="U" {{ old('claims.0.patient_gender', 'M') == 'U' ? 'selected' : '' }}>Unknown</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="claims_0_patient_member_id">Patient Member ID</label>
                                <input type="text" class="form-control" id="claims_0_patient_member_id" name="claims[0][patient_member_id]" 
                                       value="{{ old('claims.0.patient_member_id', 'MEMBER123') }}" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="claims_0_patient_street">Patient Street</label>
                                <input type="text" class="form-control" id="claims_0_patient_street" name="claims[0][patient_street]" 
                                       value="{{ old('claims.0.patient_street', '456 Oak Ave') }}" required>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims_0_patient_city">Patient City</label>
                                <input type="text" class="form-control" id="claims_0_patient_city" name="claims[0][patient_city]" 
                                       value="{{ old('claims.0.patient_city', 'Anytown') }}" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims_0_patient_state">Patient State</label>
                                <input type="text" class="form-control" id="claims_0_patient_state" name="claims[0][patient_state]" 
                                       value="{{ old('claims.0.patient_state', 'NY') }}" pattern="[A-Z]{2}" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims_0_patient_zip">Patient ZIP</label>
                                <input type="text" class="form-control" id="claims_0_patient_zip" name="claims[0][patient_zip]" 
                                       value="{{ old('claims.0.patient_zip', '123456789') }}" pattern="\d{9}" required>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Part 5: Claim Information -->
                    <div class="row mt-4">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims_0_claim_number">Claim Number</label>
                                <input type="text" class="form-control" id="claims_0_claim_number" name="claims[0][claim_number]" 
                                       value="{{ old('claims.0.claim_number', 'CLM123456') }}" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims_0_total_claim_amount">Total Claim Amount</label>
                                <input type="text" class="form-control" id="claims_0_total_claim_amount" name="claims[0][total_claim_amount]" 
                                       value="{{ old('claims.0.total_claim_amount', '150.00') }}" pattern="\d+(\.\d{1,2})?" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims_0_facility_type_code">Facility Type Code</label>
                                <input type="text" class="form-control" id="claims_0_facility_type_code" name="claims[0][facility_type_code]" 
                                       value="{{ old('claims.0.facility_type_code', '11') }}" required>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims_0_claim_frequency_code">Claim Frequency Code</label>
                                <input type="hidden" class="form-control" id="claims_0_claim_frequency_code" name="claims[0][claim_frequency_code]" 
                                       value="{{ old('claims.0.claim_frequency_code', 'B') }}" size="1" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims_0_primary_diagnosis_code">Primary Diagnosis Code</label>
                                <input type="text" class="form-control" id="claims_0_primary_diagnosis_code" name="claims[0][primary_diagnosis_code]" 
                                       value="{{ old('claims.0.primary_diagnosis_code', 'K02.9') }}" pattern="[A-Z]\d{2}(\.\d{1,4})?" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims_0_additional_diagnosis_codes">Additional Diagnosis Codes (comma separated)</label>
                                <input type="text" class="form-control" id="claims_0_additional_diagnosis_codes" name="claims[0][additional_diagnosis_codes]" 
                                       value="{{ old('claims.0.additional_diagnosis_codes', 'K05.1, K06.9') }}">
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims_0_place_of_service">Place of Service</label>
                                <select class="form-control" id="claims_0_place_of_service" name="claims[0][place_of_service]" required>
                                    <option value="11" {{ old('claims.0.place_of_service', '11') == '11' ? 'selected' : '' }}>Office</option>
                                    <option value="12" {{ old('claims.0.place_of_service', '11') == '12' ? 'selected' : '' }}>Home</option>
                                    <option value="21" {{ old('claims.0.place_of_service', '11') == '21' ? 'selected' : '' }}>Inpatient Hospital</option>
                                    <option value="22" {{ old('claims.0.place_of_service', '11') == '22' ? 'selected' : '' }}>Outpatient Hospital</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Part 6: Dental Information -->
                    <div class="row mt-4">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="claims_0_tooth_number">Tooth Number</label>
                                <select class="form-control" id="claims_0_tooth_number" name="claims[0][tooth_number]" required>
                                    <option value="">Select Tooth</option>
                                    @for($i = 1; $i <= 32; $i++)
                                        <option value="{{ $i }}" {{ old('claims.0.tooth_number') == $i ? 'selected' : '' }}>{{ $i }}</option>
                                    @endfor
                                    <option value="A" {{ old('claims.0.tooth_number') == 'A' ? 'selected' : '' }}>Supernumerary Tooth A</option>
                                    <option value="B" {{ old('claims.0.tooth_number') == 'B' ? 'selected' : '' }}>Supernumerary Tooth B</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="claims_0_tooth_surface">Tooth Surface</label>
                                <input type="text" class="form-control" id="claims_0_tooth_surface" name="claims[0][tooth_surface]" 
                                       value="{{ old('claims.0.tooth_surface', 'MO') }}" pattern="[MDOIL]+" required>
                                <small class="form-text text-muted">M-Mesial, D-Distal, O-Occlusal, I-Incisal, L-Lingual</small>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="claims_0_oral_cavity_location">Oral Cavity Location</label>
                                <select class="form-control" id="claims_0_oral_cavity_location" name="claims[0][oral_cavity_location]" required>
                                    <option value="1" {{ old('claims.0.oral_cavity_location', '1') == '1' ? 'selected' : '' }}>Upper Right</option>
                                    <option value="2" {{ old('claims.0.oral_cavity_location', '1') == '2' ? 'selected' : '' }}>Upper Left</option>
                                    <option value="3" {{ old('claims.0.oral_cavity_location', '1') == '3' ? 'selected' : '' }}>Lower Left</option>
                                    <option value="4" {{ old('claims.0.oral_cavity_location', '1') == '4' ? 'selected' : '' }}>Lower Right</option>
                                    <option value="U" {{ old('claims.0.oral_cavity_location', '1') == 'U' ? 'selected' : '' }}>Unspecified</option>
                                    <option value="L" {{ old('claims.0.oral_cavity_location', '1') == 'L' ? 'selected' : '' }}>Lower</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="claims_0_missing_teeth_info">Missing Teeth Info</label>
                                <input type="text" class="form-control" id="claims_0_missing_teeth_info" name="claims[0][missing_teeth_info]" 
                                       value="{{ old('claims.0.missing_teeth_info') }}">
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="claims_0_replacement_status">Replacement Status</label>
                                <select class="form-control" id="claims_0_replacement_status" name="claims[0][replacement_status]" required>
                                    <option value="Yes" {{ old('claims.0.replacement_status', 'No') == 'Yes' ? 'selected' : '' }}>Yes</option>
                                    <option value="No" {{ old('claims.0.replacement_status', 'No') == 'No' ? 'selected' : '' }}>No</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="claims_0_procedure_date">Procedure Date (YYYYMMDD)</label>
                                <input type="text" class="form-control" id="claims_0_procedure_date" name="claims[0][procedure_date]" 
                                       value="{{ old('claims.0.procedure_date', date('Ymd')) }}" pattern="\d{8}" required>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="claims_0_prosthesis_code">Prosthesis Code</label>
                                <input type="text" class="form-control" id="claims_0_prosthesis_code" name="claims[0][prosthesis_code]" 
                                       value="{{ old('claims.0.prosthesis_code') }}">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="claims_0_orthodontic_treatment">Orthodontic Treatment</label>
                                <select class="form-control" id="claims_0_orthodontic_treatment" name="claims[0][orthodontic_treatment]" required>
                                    <option value="Yes" {{ old('claims.0.orthodontic_treatment', 'No') == 'Yes' ? 'selected' : '' }}>Yes</option>
                                    <option value="No" {{ old('claims.0.orthodontic_treatment', 'No') == 'No' ? 'selected' : '' }}>No</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row" id="ortho-dates-0" style="{{ old('claims.0.orthodontic_treatment', 'No') == 'Yes' ? '' : 'display: none;' }}">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims_0_orthodontic_start_date">Orthodontic Start Date (YYYYMMDD)</label>
                                <input type="text" class="form-control" id="claims_0_orthodontic_start_date" name="claims[0][orthodontic_start_date]" 
                                       value="{{ old('claims.0.orthodontic_start_date') }}" pattern="\d{8}">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="claims_0_orthodontic_end_date">Orthodontic End Date (YYYYMMDD)</label>
                                <input type="text" class="form-control" id="claims_0_orthodontic_end_date" name="claims[0][orthodontic_end_date]" 
                                       value="{{ old('claims.0.orthodontic_end_date') }}" pattern="\d{8}">
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="claims_0_anesthesia_usage">Anesthesia Usage</label>
                                <select class="form-control" id="claims_0_anesthesia_usage" name="claims[0][anesthesia_usage]" required>
                                    <option value="Yes" {{ old('claims.0.anesthesia_usage', 'No') == 'Yes' ? 'selected' : '' }}>Yes</option>
                                    <option value="No" {{ old('claims.0.anesthesia_usage', 'No') == 'No' ? 'selected' : '' }}>No</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3" id="anesthesia-type-0" style="{{ old('claims.0.anesthesia_usage', 'No') == 'Yes' ? '' : 'display: none;' }}">
                            <div class="form-group">
                                <label for="claims_0_anesthesia_type">Anesthesia Type</label>
                                <input type="text" class="form-control" id="claims_0_anesthesia_type" name="claims[0][anesthesia_type]" 
                                       value="{{ old('claims.0.anesthesia_type') }}">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="claims_0_emergency_treatment">Emergency Treatment</label>
                                <select class="form-control" id="claims_0_emergency_treatment" name="claims[0][emergency_treatment]" required>
                                    <option value="Yes" {{ old('claims.0.emergency_treatment', 'No') == 'Yes' ? 'selected' : '' }}>Yes</option>
                                    <option value="No" {{ old('claims.0.emergency_treatment', 'No') == 'No' ? 'selected' : '' }}>No</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Part 7: Procedure Information -->
                                       <div class="service-lines-container" data-claim-index="0">
                        <div class="card mb-3 service-line" data-service-line-index="0">
                            <div class="card-header bg-secondary text-white d-flex justify-content-between align-items-center">
                                <h4>Service Line </h4>
                                
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label for="claims_0_service_lines_0_procedure_code">Procedure Code</label>
                                            <input type="text" class="form-control" id="claims_0_service_lines_0_procedure_code" 
                                                   name="claims[0][service_lines][0][procedure_code]" 
                                                   value="{{ old('claims.0.service_lines.0.procedure_code', '99213') }}" 
                                                   pattern="[A-Z0-9]{5}" required>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label for="claims_0_service_lines_0_revenue_code">Revenue Code</label>
                                            <input type="text" class="form-control" id="claims_0_service_lines_0_revenue_code" 
                                                   name="claims[0][service_lines][0][revenue_code]" 
                                                   value="{{ old('claims.0.service_lines.0.revenue_code', '0300') }}" 
                                                   pattern="\d{4}" required>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label for="claims_0_service_lines_0_charge_amount">Charge Amount</label>
                                            <input type="text" class="form-control" id="claims_0_service_lines_0_charge_amount" 
                                                   name="claims[0][service_lines][0][charge_amount]" 
                                                   value="{{ old('claims.0.service_lines.0.charge_amount', '150.00') }}" 
                                                   pattern="\d+(\.\d{1,2})?" required>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label for="claims_0_service_lines_0_units">Units</label>
                                            <input type="number" class="form-control" id="claims_0_service_lines_0_units" 
                                                   name="claims[0][service_lines][0][units]" 
                                                   value="{{ old('claims.0.service_lines.0.units', '1') }}" 
                                                   min="1" required>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="claims_0_service_lines_0_service_date">Service Date (YYYYMMDD)</label>
                                            <input type="text" class="form-control" id="claims_0_service_lines_0_service_date" 
                                                   name="claims[0][service_lines][0][service_date]" 
                                                   value="{{ old('claims.0.service_lines.0.service_date', '20231002') }}" 
                                                   pattern="\d{8}" required>
                                        </div>
                                    </div>
                                    <div class="col-md-8">
                                        <div class="form-group">
                                            <label for="claims_0_service_lines_0_condition_codes">Condition Codes (comma separated)</label>
                                            <input type="text" class="form-control" id="claims_0_service_lines_0_condition_codes" 
                                                   name="claims[0][service_lines][0][condition_codes]" 
                                                   value="{{ old('claims.0.service_lines.0.condition_codes', 'A1,B2') }}">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Add Service Line Button -->
                    <div class="form-group" style="display:none;">
                        <button type="button" class="btn btn-info btn-sm add-service-line" data-claim-index="0">Add Service Line</button>
                    </div>
                    
                  
                    
                    <!-- Part 9: Provider Information -->
                    <div class="row mt-4">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="claims_0_attending_provider_name">Attending Provider Name</label>
                                <input type="text" class="form-control" id="claims_0_attending_provider_name" name="claims[0][attending_provider_name]" 
                                       value="{{ old('claims.0.attending_provider_name', 'Dr. Jane Smith') }}" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="claims_0_attending_provider_npi">Attending Provider NPI</label>
                                <input type="text" class="form-control" id="claims_0_attending_provider_npi" name="claims[0][attending_provider_npi]" 
                                       value="{{ old('claims.0.attending_provider_npi', '9876543210') }}" pattern="\d{10}" required>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="claims_0_operating_provider_name">Operating Provider Name</label>
                                <input type="text" class="form-control" id="claims_0_operating_provider_name" name="claims[0][operating_provider_name]" 
                                       value="{{ old('claims.0.operating_provider_name', 'Dr. John Doe') }}" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="claims_0_operating_provider_npi">Operating Provider NPI</label>
                                <input type="text" class="form-control" id="claims_0_operating_provider_npi" name="claims[0][operating_provider_npi]" 
                                       value="{{ old('claims.0.operating_provider_npi', '1234567890') }}" pattern="\d{10}" required>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="claims_0_referring_provider_name">Referring Provider Name</label>
                                <input type="text" class="form-control" id="claims_0_referring_provider_name" name="claims[0][referring_provider_name]" 
                                       value="{{ old('claims.0.referring_provider_name', 'Dr. Robert Johnson') }}" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="claims_0_referring_provider_npi">Referring Provider NPI</label>
                                <input type="text" class="form-control" id="claims_0_referring_provider_npi" name="claims[0][referring_provider_npi]" 
                                       value="{{ old('claims.0.referring_provider_npi', '2345678901') }}" pattern="\d{10}" required>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="claims_0_supervising_provider_name">Supervising Provider Name</label>
                                <input type="text" class="form-control" id="claims_0_supervising_provider_name" name="claims[0][supervising_provider_name]" 
                                       value="{{ old('claims.0.supervising_provider_name', 'Dr. Sarah Williams') }}" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="claims_0_supervising_provider_npi">Supervising Provider NPI</label>
                                <input type="text" class="form-control" id="claims_0_supervising_provider_npi" name="claims[0][supervising_provider_npi]" 
                                       value="{{ old('claims.0.supervising_provider_npi', '3456789012') }}" pattern="\d{10}" required>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Part 10: Non-repeatable fields (Control Numbers) -->
        <div class="card mb-4">
            <div class="card-header bg-primary text-white">
                <h3>Part 10: Control Numbers</h3>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="se01">SE01</label>
                            <input type="number" class="form-control" id="se01" name="se01" 
                                   value="{{ old('se01', '1') }}" required>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="se02">SE02</label>
                            <input type="hidden" class="form-control" id="se02" name="se02" 
                                   value="{{ old('se02', mt_rand(1000, 999999999)) }}" required>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="ge_control_number">GE Control Number</label>
                            <input type="number" class="form-control" id="ge_control_number" name="ge_control_number" 
                                   value="{{ old('ge_control_number', '1') }}" required>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="iea_control_number">IEA Control Number</label>
                            <input type="number" class="form-control" id="iea_control_number" name="iea_control_number" 
                                   value="{{ old('iea_control_number', '1') }}" required>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="form-group text-center mb-4">
            <button type="button" id="add-claim" class="btn btn-success">Add Another Claim</button>
            <button type="submit" class="btn btn-primary">Submit All Claims</button>
        </div>
    </form>
</div>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Add claim section
    const addClaimBtn = document.getElementById('add-claim');
    const claimsContainer = document.getElementById('claims-container');
    let claimIndex = claimsContainer.children.length;

     // Predefined values
    const predefinedClaimValues = {
        patient_last_name: 'Smith',
        patient_first_name: 'John',
        patient_dob: '19800101',
        patient_gender: 'M',
        patient_member_id: 'MEMBER' + Math.floor(1000 + Math.random() * 9000),
        patient_street: '123 Main St',
        patient_city: 'Anytown',
        patient_state: 'NY',
        patient_zip: '123456789',
        claim_number: 'CLM' + Math.floor(100000 + Math.random() * 900000),
        total_claim_amount: (150 + Math.floor(Math.random() * 200)).toFixed(2),
        facility_type_code: '11',
        claim_frequency_code: 'B',
        primary_diagnosis_code: 'K02.9',
        additional_diagnosis_codes: 'K05.1, K06.9',
        place_of_service: '11',
        tooth_number: '3',
        tooth_surface: 'MO',
        oral_cavity_location: '1',
        replacement_status: 'No',
        procedure_date: new Date().toISOString().slice(0, 10).replace(/-/g, ''),
        orthodontic_treatment: 'No',
        anesthesia_usage: 'No',
        emergency_treatment: 'No',
        attending_provider_name: 'Dr. Jane Smith',
        attending_provider_npi: '9876543210',
        operating_provider_name: 'Dr. John Doe',
        operating_provider_npi: '1234567890',
        referring_provider_name: 'Dr. Robert Johnson',
        referring_provider_npi: '2345678901',
        supervising_provider_name: 'Dr. Sarah Williams',
        supervising_provider_npi: '3456789012'
    };

      const predefinedServiceLineValues = {
        procedure_code: '99213',
        revenue_code: '0300',
        charge_amount: '150.00',
        units: '1',
        service_date: new Date().toISOString().slice(0, 10).replace(/-/g, ''),
        condition_codes: 'A1,B2'
    };

    
    // Initialize the form
    initForm();

    // Add claim event listener
    addClaimBtn.addEventListener('click', addNewClaim);

    // Delegated event listeners for dynamic elements
    claimsContainer.addEventListener('click', handleClaimActions);
    document.addEventListener('click', handleServiceLineActions);

   function initForm() {
        // Initialize remove buttons visibility
        updateRemoveClaimButtons();
        document.querySelectorAll('.service-lines-container').forEach(container => {
            updateRemoveServiceLineButtons(container);
        });

        // Setup event listeners for the first claim
        setupClaimEventListeners(0);
        
        // Fill first claim with predefined values if it exists
        const firstClaim = claimsContainer.querySelector('.claim-section');
        if (firstClaim) {
            fillClaimWithPredefinedValues(firstClaim, 0);
            const firstServiceLine = firstClaim.querySelector('.service-line');
            if (firstServiceLine) {
                fillServiceLineWithPredefinedValues(firstServiceLine, 0, 0);
            }
        }
    }

    function addNewClaim() {
        const newIndex = claimIndex++;
        const newClaimSection = claimsContainer.firstElementChild.cloneNode(true);
        
        // Update all IDs, names, and labels for the claim
        updateElementIndexes(newClaimSection, '0', newIndex, 'claim');
        
        // Update the claim number in the header
        const header = newClaimSection.querySelector('.card-header h3');
        if (header) {
            header.textContent = `Patient & Claim Information - Claim #${newIndex + 1}`;
        }
        
        // Update the data-claim-index for service lines container
        const serviceLinesContainer = newClaimSection.querySelector('.service-lines-container');
        serviceLinesContainer.setAttribute('data-claim-index', newIndex);
        
        // Update the add service line button
        const addServiceLineBtn = newClaimSection.querySelector('.add-service-line');
        addServiceLineBtn.setAttribute('data-claim-index', newIndex);
        
        // Reset all service lines to just one
        const existingServiceLines = newClaimSection.querySelectorAll('.service-line');
        if (existingServiceLines.length > 1) {
            existingServiceLines.forEach((line, index) => {
                if (index > 0) line.remove();
            });
        }
        
        // Reset the first service line
        const firstServiceLine = newClaimSection.querySelector('.service-line');
        updateElementIndexes(firstServiceLine, '0', '0', 'service-line');
        firstServiceLine.querySelector('.card-header h4').textContent = 'Service Line #1';
        
        // Fill claim fields with predefined values
        fillClaimWithPredefinedValues(newClaimSection, newIndex);
        
        // Fill the first service line with predefined values
        fillServiceLineWithPredefinedValues(firstServiceLine, newIndex, 0);
        
        // Add the new claim section to the container
        claimsContainer.appendChild(newClaimSection);
        
        // Update event listeners for the new claim section
        setupClaimEventListeners(newIndex);
        
        // Update remove buttons visibility
        updateRemoveClaimButtons();
        updateRemoveServiceLineButtons(serviceLinesContainer);
    }

    function fillClaimWithPredefinedValues(claimElement, claimIndex) {
        Object.entries(predefinedClaimValues).forEach(([field, value]) => {
            const input = claimElement.querySelector(`[name="claims[${claimIndex}][${field}]"]`);
            if (input) {
                input.value = value;
                if (input.tagName === 'SELECT') {
                    input.dispatchEvent(new Event('change')); // Trigger change event
                }
            }
        });
    }

    function fillServiceLineWithPredefinedValues(lineElement, claimIndex, lineIndex) {
        Object.entries(predefinedServiceLineValues).forEach(([field, value]) => {
            const input = lineElement.querySelector(`[name="claims[${claimIndex}][service_lines][${lineIndex}][${field}]"]`);
            if (input) input.value = value;
        });
    }
    function handleClaimActions(e) {
        // Remove claim section
        if (e.target.classList.contains('remove-claim')) {
            const claimSection = e.target.closest('.claim-section');
            if (claimSection && claimsContainer.children.length > 1) {
                claimSection.remove();
                updateClaimNumbers();
                updateRemoveClaimButtons();
            }else{
            	alert("min 1")
            }
        }
    }

    function handleServiceLineActions(e) {
        // Add service line
        if (e.target.classList.contains('add-service-line')) {
            const claimIndex = e.target.getAttribute('data-claim-index');
            const serviceLinesContainer = document.querySelector(`.service-lines-container[data-claim-index="${claimIndex}"]`);
            const serviceLineCount = serviceLinesContainer.querySelectorAll('.service-line').length;
            const newServiceLine = serviceLinesContainer.querySelector('.service-line').cloneNode(true);
            
            // Update all IDs, names, and labels for the service line
            updateElementIndexes(newServiceLine, '0', serviceLineCount, 'service-line');
            
            // Update the service line number in the header
            const header = newServiceLine.querySelector('.card-header h4');
            if (header) {
                header.textContent = `Service Line #${serviceLineCount + 1}`;
            }
            
            // Clear all input values
            newServiceLine.querySelectorAll('input:not([type="hidden"]), select, textarea').forEach(input => {
                if (input.type !== 'button' && input.type !== 'submit') {
                    input.value = '';
                    if (input.type === 'checkbox' || input.type === 'radio') {
                        input.checked = false;
                    }
                }
            });
            
            // Add the new service line to the container
            serviceLinesContainer.appendChild(newServiceLine);
            
            // Update remove buttons visibility for service lines
            updateRemoveServiceLineButtons(serviceLinesContainer);
        }
        
        // Remove service line
        if (e.target.classList.contains('remove-service-line')) {
            const serviceLine = e.target.closest('.service-line');
            const serviceLinesContainer = serviceLine.closest('.service-lines-container');
            if (serviceLinesContainer.querySelectorAll('.service-line').length > 1) {
                serviceLine.remove();
                updateServiceLineNumbers(serviceLinesContainer);
                updateRemoveServiceLineButtons(serviceLinesContainer);
            }else{
            	alert("min 1 req")
            }
        }
    }

    function updateRemoveClaimButtons() {
        const claims = claimsContainer.querySelectorAll('.claim-section');
        claims.forEach((claim, index) => {
            const removeBtn = claim.querySelector('.remove-claim');
            if (removeBtn) {
                removeBtn.style.display = claims.length > 1 ? 'block' : 'none';
            }
        });
    }

    function updateRemoveServiceLineButtons(container) {
        const serviceLines = container.querySelectorAll('.service-line');
        serviceLines.forEach((line, index) => {
            const removeBtn = line.querySelector('.remove-service-line');
            if (removeBtn) {
                removeBtn.style.display = serviceLines.length > 1 ? 'block' : 'none';
            }
        });
    }

    function updateElementIndexes(element, oldIndex, newIndex, type) {
        const selectors = {
            'id': `[id*="_${oldIndex}_"]`,
            'name': `[name*="[${oldIndex}]"]`,
            'for': `[for*="_${oldIndex}_"]`,
            'data-claim-index': `[data-claim-index="${oldIndex}"]`,
            'data-service-line-index': `[data-service-line-index="${oldIndex}"]`
        };
        
        // Update IDs
        element.querySelectorAll(selectors.id).forEach(el => {
            el.id = el.id.replace(`_${oldIndex}_`, `_${newIndex}_`);
        });
        
        // Update names
        element.querySelectorAll(selectors.name).forEach(el => {
            if (type === 'claim') {
                el.name = el.name.replace(`[${oldIndex}]`, `[${newIndex}]`);
            } else if (type === 'service-line') {
                const nameParts = el.name.match(/\[(\d+)\]\[(\d+)\]/);
                if (nameParts && nameParts[1] === oldIndex) {
                    el.name = el.name.replace(`[${oldIndex}][${nameParts[2]}]`, `[${nameParts[1]}][${newIndex}]`);
                }
            }
        });
        
        // Update labels
        element.querySelectorAll(selectors.for).forEach(el => {
            el.htmlFor = el.htmlFor.replace(`_${oldIndex}_`, `_${newIndex}_`);
        });
        
        // Update data attributes
        if (type === 'claim') {
            element.querySelectorAll(selectors['data-claim-index']).forEach(el => {
                el.setAttribute('data-claim-index', newIndex);
            });
            element.dataset.index = newIndex;
        } else if (type === 'service-line') {
            element.querySelectorAll(selectors['data-service-line-index']).forEach(el => {
                el.setAttribute('data-service-line-index', newIndex);
            });
        }
    }
    
    function updateClaimNumbers() {
        Array.from(claimsContainer.children).forEach((section, index) => {
            const header = section.querySelector('.card-header h3');
            if (header) {
                header.textContent = `Patient & Claim Information - Claim #${index + 1}`;
            }
            
            // Update the claim index in IDs, names, and labels
            updateElementIndexes(section, section.dataset.index, index, 'claim');
            section.dataset.index = index;
            
            // Update the service lines container
            const serviceLinesContainer = section.querySelector('.service-lines-container');
            if (serviceLinesContainer) {
                serviceLinesContainer.setAttribute('data-claim-index', index);
                const addBtn = section.querySelector('.add-service-line');
                if (addBtn) {
                    addBtn.setAttribute('data-claim-index', index);
                }
            }
        });
    }
    
    function updateServiceLineNumbers(container) {
        Array.from(container.querySelectorAll('.service-line')).forEach((line, index) => {
            const header = line.querySelector('.card-header h4');
            if (header) {
                header.textContent = `Service Line #${index + 1}`;
            }
            
            // Update the service line index in IDs, names, and labels
            updateElementIndexes(line, line.dataset.serviceLineIndex, index, 'service-line');
            line.dataset.serviceLineIndex = index;
        });
    }
    
    function setupClaimEventListeners(index) {
        // Orthodontic treatment toggle
        const orthoTreatment = document.getElementById(`claims_${index}_orthodontic_treatment`);
        const orthoDates = document.getElementById(`ortho-dates-${index}`);
        
        if (orthoTreatment && orthoDates) {
            orthoTreatment.addEventListener('change', function() {
                orthoDates.style.display = this.value === 'Yes' ? 'block' : 'none';
            });
        }
        
        // Anesthesia usage toggle
        const anesthesiaUsage = document.getElementById(`claims_${index}_anesthesia_usage`);
        const anesthesiaType = document.getElementById(`anesthesia-type-${index}`);
        
        if (anesthesiaUsage && anesthesiaType) {
            anesthesiaUsage.addEventListener('change', function() {
                anesthesiaType.style.display = this.value === 'Yes' ? 'block' : 'none';
            });
        }
    }
});
</script>
@endsection