@extends('layouts.app')

@section('content')
<section>
    @include('message')
    <div class="container">
        <div class="w-full min-h-screen flex flex-col items-center justify-center">
            <form method="POST" action="{{ route('login.submit') }}" id="loginForm">
                @csrf
                <input type="hidden" name="recaptcha_token" id="recaptchaToken">
                
                <div class="border bg-white shadow w-96 h-auto rounded-lg pt-8 pb-8 px-8 flex flex-col items-center">
                    <div class="mb-2">
                        <a class="font-light text-3xl md:text-3xl" href="#">
                            Klyre<span class="font-bold">Payments</span>
                        </a>
                    </div>
                    
                    <div class="w-full mt-4">
                        <label class="block font-medium text-sm text-gray-700 mb-1" for="Username">Username</label>
                        <input type="text" id="Username" class="rounded-md border py-2 text-grey-800 w-full rounded-lg px-4 text-lg focus:ring-blue-600" name="email" required>
                    </div>
                    
                    <div class="w-full mt-4">
                        <label class="block font-medium text-sm text-gray-700 mb-1" for="Password">Password</label>
                        <div class="flex items-center border rounded-md w-full">
                            <input id="password" type="password" class="py-2 text-grey-800 w-full px-4 text-lg focus:ring-blue-600 outline-none" name="password" required>
                            <button type="button" class="px-3 py-2 text-gray-600" onclick="togglePassword()">
                                <i id="eyeIcon" class="bi bi-eye"></i>
                            </button>
                        </div>
                    </div>
                    
                    <!-- reCAPTCHA Badge (required by Google's terms) -->
                   <div class="g-recaptcha mt-4" data-sitekey="6Lf5LhErAAAAAKEaaWK8MOnx5xuogJog5_9ojbt0"></div>
                    
                    <div class="w-full mt-4">
                        <button type="submit" class="btn btn-primary w-full">
                            Login
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</section>

{{-- Bootstrap Icons --}}
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css">

{{-- reCAPTCHA Script --}}
<script src="https://www.google.com/recaptcha/api.js" async defer></script>

<script>
// Password toggle
function togglePassword() {
    const passwordField = document.getElementById("password");
    const eyeIcon = document.getElementById("eyeIcon");
    if (passwordField.type === "password") {
        passwordField.type = "text";
        eyeIcon.classList.replace("bi-eye", "bi-eye-slash");
    } else {
        passwordField.type = "password";
        eyeIcon.classList.replace("bi-eye-slash", "bi-eye");
    }
}

// reCAPTCHA token handling
document.getElementById('loginForm').addEventListener('submit', function(e) {
    e.preventDefault();
    const response = grecaptcha.getResponse();
    
    if (!response) {
        // alert("Please complete the reCAPTCHA");
        // return;
    }
    
    document.getElementById('recaptchaToken').value = response;
    this.submit();
});
</script>
@endsection