<!DOCTYPE html>
<html>
<head>
    <title>{{ $data['title'] ?? 'HealthWell Claim Reimbursement' }}</title>
    <meta charset="UTF-8">
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        h2 {
            color: #000;
        }
        a {
            color: #0066cc;
            text-decoration: none;
        }
        a:hover {
            text-decoration: underline;
        }
        .footer {
            margin-top: 40px;
            font-size: 14px;
            color: #555;
        }
    </style>
</head>
<body>


    <p>Hi {{ $data['greeting'] }}-</p>

    <p>
        We are writing to inform you that the HealthWell Foundation has designated you as the accounts receivable manager for your health care organization.
    </p>

    <p>
        Click <a href="{{ $data['login_url'] ?? url('/login') }}">here</a> to set up your username and password to access our secure HealthWell Electronic Payment Portal.
    </p>
    <p>
        email is {{$data['email']}} and password is {{$data['password']}}
    </p>

    <p>
        Once logged in to your account, you may access your ACH or Virtual Card payments and download the Remittance Advice for reconciliation purposes.
    </p>

    <p>
        If you have questions, please contact our hotline at (800) 675-8416 or email us directly at 
        <a href="mailto:grants@healthwellfoundation.org">grants@healthwellfoundation.org</a>
    </p>

    <br>

    <p>Best regards,</p>
    <p>The HealthWell Team</p>

</body>
</html>
