@extends('layouts.app')
@section('title')
 <title>837 edi-p Create Multi-Step Form</title>
@endsection

@section('content')
   <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        <style>
    .btn.text-white {
        padding: 4px 14px;
        font-size: 13px;
        font-weight: 600;
        border-radius: 6px;
        line-height: 1.5;
        display: inline-block;
        text-align: center;
        white-space: nowrap;
        vertical-align: middle;
        transition: background-color 0.2s ease-in-out;
        background-color: rgb(79 70 229);
    }

    .form-group{
    margin-bottom: 20px;
    }
   
    .step { display: none; }
    .active { display: block; }
    .next, .prev {
    padding: 6px 16px;       /* good horizontal and vertical padding */
    font-size: 14px;
    border-radius: 6px;
    border: none;
    cursor: pointer;
    width: auto;
    height: auto;
    display: inline-block;
    text-align: center;
    line-height: normal;
    background-color: #0d6efd;  /* for .next */
    color: white;
    margin-right: 10px;
    margin-bottom: 10px;
    margin-top: 10px;
    }
    .prev {
    background-color: orange;
    }
    #multiStepForm {
    width: 50%;
    background: white;
    padding: 20px;
    margin: 50px auto;
    border-radius: 10px;
    box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
    }
    /*  .step {
    display: none;
    }
    .active {
    display: block;
    }*/
    .step {
    display: none;
    }
    .step.active {
    display: flex; /* or block, but flex works better for columns */
    flex-wrap: wrap;
    }
    h2 {
    color: #333;
    }
    input {
    width: 30%;
    padding: 10px;
    /*margin: 10px 0;*/
    border: 1px solid #ccc;
    border-radius: 5px;
    font-size: 16px;
    }
    button {
    background-color: #007bff;
    color: white;
    border: none;
    padding: 10px 15px;
    font-size: 16px;
    cursor: pointer;
    border-radius: 5px;
    transition: 0.3s;
    }
    button:hover {
    background-color: #0056b3;
    }
    .prev {
    background-color: #6c757d;
    }
    .prev:hover {
    background-color: #5a6268;
    }
    .submit {
    background-color: #28a745;
    }
    .submit:hover {
    background-color: #218838;
    }
    .form-control{
    width: 30%;
    }
     .g-header{
        padding-bottom: 0 !important;
    }
     .btn-container>div{
        padding: 2.5rem 0 !important;
    }
.mb-n10{
    margin-bottom: -10px!important;
}
.mainmenu{
    margin-bottom: 0!important;

}
.g-header .divide-x{
align-items: center;
}
.g-header  .divide-x p{
    margin-bottom: 0;
}
.g-header .divide-x button{
    padding: 0!important;
}

</style>
    
        @if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif
<h2 style="text-align:center;"  class="mt-5">Generate 837 EDI-P FILE</h2>

        <form class="container p-4 mt-4" id="multiStepForm" action="{{ route('generate.edi') }}" method="POST">
            @csrf
            <!-- Step 1 -->
            <div class="row step active row-gap-4">
                
                    <h4 class="font-semibold mb-n10 "> Interchange and Functional Group Headers</h4>
                    <div class="col-md-3">
                        <label for="sender_id" class="block font-medium text-sm text-gray-700 mb-1">Sender ID (ISA06):</label>
                        <input type="text" id="sender_id" name="sender_id" value="581651222" required class="form-control w-100">
                    </div>
                    <div class="col-md-3">
                        <label for="receiver_id" class="block font-medium text-sm text-gray-700 mb-1">Receiver ID (ISA08):</label>
                        <input type="text" id="receiver_id" name="receiver_id" value="KLYREPAY" required class="form-control w-100">
                    </div>
                    <div class="col-md-3">
                        <label for="transmission_date" class="block font-medium text-sm text-gray-700 mb-1">Date of Transmission (YYMMDD):</label>
                        <input type="text" id="transmission_date" name="transmission_date" value="250211" required class="form-control w-100">
                    </div>
                    <div class="col-md-3">
                        <label for="transmission_time">Time of Transmission (HHMM)</label>
                        <input type="text" name="transmission_time" id="transmission_time" class="form-control w-100" required pattern="\d{4}" maxlength="4" placeholder="e.g., 1430" value="1430" >
                    </div>
                    <div class="col-md-3">
                        <label for="control_number">Control Number (ISA)</label>
                        <input type="text" name="control_number" id="control_number" class="form-control w-100" required placeholder="Enter Unique Control Number" value="123500377">
                    </div>
               
              
                    <h4 class="font-semibold mb-n10  mt-2">GS SEGMENT</h4>
                    <div class="col-md-3">
                        <label for="sender_code">Sender Code</label>
                        <input type="text" name="sender_code" id="sender_code" class="form-control w-100" required placeholder="Enter Sender Code" value="SENDER123">
                    </div>
                    <div class="col-md-3">
                        <label for="receiver_code">Receiver Code</label>
                        <input type="text" name="receiver_code" id="receiver_code" class="form-control w-100" required placeholder="Enter Receiver Code" value="RECEIVER456">
                    </div>
                    <div class="col-md-3">
                        <label for="gs_date">Date (CCYYMMDD)</label>
                        <input type="text" name="gs_date" id="gs_date" class="form-control w-100" required pattern="\d{8}" maxlength="8" placeholder="e.g., 20240705" value="20250310">
                    </div>
                    <div class="col-md-3">
                        <label for="gs_time">Time (HHMM)</label>
                        <input type="text" name="gs_time" id="gs_time" class="form-control w-100" required pattern="\d{4}" maxlength="4" placeholder="e.g., 1430" value="0930">
                    </div>
                    <div class="col-md-3">
                        <label for="gs_control_number">Control Number (GS)</label>
                        <input type="text" name="gs_control_number" id="gs_control_number" class="form-control w-100" required placeholder="Enter Unique Control Number" value="123096815">
                    </div>
               
                
                    <h4 class="font-semibold mb-n10  mt-2">Submitter and Receiver Information</h4>
                    <!-- Submitter Information -->
                    <div class="col-md-3">
                        <label for="submitter_name">Submitter Name</label>
                        <input type="text" name="submitter_name" id="submitter_name" class="form-control w-100" required placeholder="Enter Submitter Name" value="ABC Health">
                    </div>
                    <div class="col-md-3">
                        <label for="submitter_id">Submitter ID</label>
                        <input type="text" name="submitter_id" id="submitter_id" class="form-control w-100" required placeholder="Enter Submitter ID" value="SUB123456">
                    </div>
                    <!-- Receiver Information -->
                    <div class="col-md-3">
                        <label for="receiver_name">Receiver Name</label>
                        <input type="text" name="receiver_name" id="receiver_name" class="form-control w-100" required placeholder="Enter Receiver Name" value="XYZ Payer">
                    </div>
                    <div class="col-md-3">
                        <label for="receiver_id">Receiver ID</label>
                        <input type="text" name="receiver_id" id="receiver_id" class="form-control w-100" required placeholder="Enter Receiver ID" value="REC789101">
                    </div>
                
                    <div class="col-md-12">
                <button type="button" class="next">Next</button>

                    </div>
            </div>


            <!-- Step 2 -->
            <div class="row step row-gap-4">
                    <h4 class="font-semibold mb-n10  mt-2"> Billing Provider Information (2010AA Loop)</h4>
                    <!-- Provider Name -->
                    <div class="col-md-3">
                        <label for="provider_name">Provider Name</label>
                        <input type="text" name="provider_name" id="provider_name" class="form-control w-100" required
                        placeholder="Enter Provider Name" value="ABC Healthcare" maxlength="100">
                        <small class="text-danger" id="provider_name_error"></small>
                    </div>
                    <!-- National Provider Identifier (NPI) -->
                    <div class="col-md-3">
                        <label for="provider_npi">National Provider Identifier (NPI)</label>
                        <input type="text" name="provider_npi" id="provider_npi" class="form-control w-100" required
                        placeholder="Enter NPI" value="1234567890" maxlength="10" pattern="^\d{10}$">
                        <small class="text-danger" id="provider_npi_error"></small>
                    </div>
                    <!-- Tax ID -->
                    <div class="col-md-3">
                        <label for="provider_tax_id">Tax ID (REF*EI)</label>
                        <input type="text" name="provider_tax_id" id="provider_tax_id" class="form-control w-100" required
                        placeholder="Enter Tax ID" value="123456789" maxlength="10" >
                        <small class="text-danger" id="provider_tax_id_error"></small>
                    </div>
                    <!-- Address Fields -->
                    <div class="col-md-3">
                        <label for="provider_street">Street Address</label>
                        <input type="text" name="provider_street" id="provider_street" class="form-control w-100" required
                        placeholder="Enter Street Address" value="123 Main St" maxlength="150">
                        <small class="text-danger" id="provider_street_error"></small>
                    </div>
                    <div class="col-md-3">
                        <label for="provider_city">City</label>
                        <input type="text" name="provider_city" id="provider_city" class="form-control w-100" required
                        placeholder="Enter City" value="New York" maxlength="50">
                        <small class="text-danger" id="provider_city_error"></small>
                    </div>
                    <div class="col-md-3">
                        <label for="provider_state">State</label>
                        <input type="text" name="provider_state" id="provider_state" class="form-control w-100" required
                        placeholder="Enter State" value="NY" maxlength="2" pattern="^[A-Z]{2}$">
                        <small class="text-danger" id="provider_state_error"></small>
                    </div>
                    <div class="col-md-3">
                        <label for="provider_zip">ZIP Code (9 digits)</label>
                        <input type="text" name="provider_zip" id="provider_zip" class="form-control w-100" required
                        placeholder="Enter ZIP Code" value="100010000" maxlength="9" pattern="^\d{9}$">
                        <small class="text-danger" id="provider_zip_error"></small>
                    </div>
                
               
                    <h4 class="font-semibold mb-n10  mt-2">Service Facility Location (2310C Loop)</h4>
                    <div class="col-md-3">
                        <label for="facility_name">Facility Name</label>
                        <input type="text" name="facility_name" id="facility_name" class="form-control w-100" required placeholder="Enter Facility Name" value="ABC Healthcare Center">
                    </div>
                    <div class="col-md-3">
                        <label for="facility_npi">NPI (Different from Billing Provider)</label>
                        <input type="text" name="facility_npi" id="facility_npi" class="form-control w-100" required pattern="\d{10}" maxlength="10" placeholder="Enter 10-digit NPI" value="1234567890">
                    </div>
                    <div class="col-md-3">
                        <label for="facility_street">Street Address</label>
                        <input type="text" name="facility_street" id="facility_street" class="form-control w-100" required placeholder="Enter Street Address" value="123 Main Street">
                    </div>
                    <div class="col-md-3">
                        <label for="facility_city">City</label>
                        <input type="text" name="facility_city" id="facility_city" class="form-control w-100" required placeholder="Enter City" value="New York">
                    </div>
                    <div class="col-md-3">
                        <label for="facility_state">State (2-letter Code)</label>
                        <input type="text" name="facility_state" id="facility_state" class="form-control w-100" required pattern="[A-Z]{2}" maxlength="2" placeholder="Enter State" value="NY">
                    </div>
                    <div class="col-md-3">
                        <label for="facility_zip">ZIP Code (9-digit)</label>
                        <input type="text" name="facility_zip" id="facility_zip" class="form-control w-100" required pattern="\d{9}" maxlength="9" placeholder="Enter 9-digit ZIP" value="100010000">
                    </div>
               
              
                    <h4 class="font-semibold mb-n10  mt-2">Patient and Subscriber Information (2010BA Loop)</h4>
                    {{-- loop --}}
                    <h5 class="mb-n10">Subscriber Details (NM1*IL Segment)</h5>
                    
                    <div class="col-md-3">
                        <label for="subscriber_first_name">Subscriber First Name</label>
                        <input type="text" name="subscriber_first_name" id="subscriber_first_name" class="form-control w-100" required placeholder="Enter First Name" value="John">
                    </div>
                    <div class="col-md-3">
                        <label for="subscriber_last_name">Subscriber Last Name</label>
                        <input type="text" name="subscriber_last_name" id="subscriber_last_name" class="form-control w-100" required placeholder="Enter Last Name" value="Doe">
                    </div>
                   <div class="col-md-3">
                        <label for="member_id">Member ID (Insurance ID)</label>
                        <input type="text" name="member_id" id="member_id" class="form-control w-100" required maxlength="15" 
                            pattern="^[A-Z0-9]{6,20}$" placeholder="Enter Insurance ID" value="123456789">
                        <small class="form-text text-muted">Allowed characters: Uppercase letters (A-Z) and digits (0-9). No spaces or special characters.</small>
                    </div>

                    <h5 class="mb-n10">Subscriber Address (N3/N4 Segments)</h5>
                    <div class="col-md-3">
                        <label for="subscriber_street">Street Address</label>
                        <input type="text" name="subscriber_street" id="subscriber_street" class="form-control w-100" required placeholder="Enter Street Address" value="456 Elm Street">
                    </div>
                    <div class="col-md-3">
                        <label for="subscriber_city">City</label>
                        <input type="text" name="subscriber_city" id="subscriber_city" class="form-control w-100" required placeholder="Enter City" value="Los Angeles">
                    </div>
                    <div class="col-md-3">
                        <label for="subscriber_state">State (2-letter Code)</label>
                        <input type="text" name="subscriber_state" id="subscriber_state" class="form-control w-100" required pattern="[A-Z]{2}" maxlength="2" placeholder="Enter State" value="CA">
                    </div>
                    <div class="col-md-3">
                        <label for="subscriber_zip">ZIP Code (9-digit)</label>
                        <input type="text" name="subscriber_zip" id="subscriber_zip" class="form-control w-100" required pattern="\d{9}" maxlength="9" placeholder="Enter 9-digit ZIP" value="900019999">
                    </div>
                    <h5 class="mb-n10">Subscriber Demographics (DMG Segment)</h5>
                    <div class="col-md-3">
                        <label for="subscriber_dob">Date of Birth (CCYYMMDD)</label>
                        <input type="text" name="subscriber_dob" id="subscriber_dob" class="form-control w-100" required pattern="\d{8}" maxlength="8" placeholder="e.g., 19850115" value="19850115">
                    </div>
                    <div class="col-md-3">
                        <label for="subscriber_gender">Gender</label>
                        <select name="subscriber_gender" id="subscriber_gender" class="form-control w-100" required>
                            <option value="M" selected>Male</option>
                            <option value="F">Female</option>
                            <option value="U">Unknown</option>
                        </select>
                    </div>
                <div class="col-md-12">
                <button type="button" class="prev">Previous</button>
                <button type="button" class="next">Next</button>
            </div>
            </div>


            <!-- Step 3 -->
            <div class="row step row-gap-4">
               
                    <h4 class="font-semibold mb-n10  mt-2">Payer Information (2010BB Loop)</h4>
                    <div class="col-md-3">
                        <label for="payer_name">Payer Name</label>
                        <input type="text" name="payer_name" id="payer_name" class="form-control w-100" required placeholder="Enter Payer Name" value="ABC Insurance">
                    </div>
                    <div class="col-md-3">
                        <label for="payer_id">Payer ID (Assigned by Payer)</label>
                        <input type="text" name="payer_id" id="payer_id" class="form-control w-100" required  maxlength="10" placeholder="Enter Payer ID" value="987654">
                    </div>
                    <h5 class="mb-n10">Payer Address (N3/N4 Segments) - Optional</h5>
                    <div class="col-md-3">
                        <label for="payer_street">Street Address</label>
                        <input type="text" name="payer_street" id="payer_street" class="form-control w-100" placeholder="Enter Street Address" value="789 Main St">
                    </div>
                    <div class="col-md-3">
                        <label for="payer_city">City</label>
                        <input type="text" name="payer_city" id="payer_city" class="form-control w-100" placeholder="Enter City" value="New York">
                    </div>
                    <div class="col-md-3">
                        <label for="payer_state">State (2-letter Code)</label>
                        <input type="text" name="payer_state" id="payer_state" class="form-control w-100" pattern="[A-Z]{2}" maxlength="2" placeholder="Enter State" value="NY">
                    </div>
                    <div class="col-md-3">
                        <label for="payer_zip">ZIP Code (9-digit)</label>
                        <input type="text" name="payer_zip" id="payer_zip" class="form-control w-100" pattern="\d{9}" maxlength="9" placeholder="Enter 9-digit ZIP" value="100019999">
                    </div>
                
                
                    <h4 class="font-semibold mb-n10  mt-2">Claim Information (2300 Loop)</h4>
                    <div class="col-md-3">
                        <label for="claim_number">Claim Number (CLM01)</label>
                        <input type="text" name="claim_number" id="claim_number" class="form-control w-100" required placeholder="Enter Unique Claim Number" value="CLM123456">
                    </div>
                    <div class="col-md-3">
                        <label for="claim_amount">Claim Amount (CLM02)</label>
                        <input type="text" name="claim_amount" id="claim_amount" class="form-control w-100" required pattern="^\d+(\.\d{1,2})?$" placeholder="Enter Total Charge Amount" value="500.25">
                    </div>
                    <div class="col-md-3">
                        <label for="place_of_service">Place of Service (CLM05-1)</label>
                        <select name="place_of_service" id="place_of_service" class="form-control w-100" required>
                            <option value="11" selected>Office (11)</option>
                            <option value="21">Inpatient Hospital (21)</option>
                            <option value="22">Outpatient Hospital (22)</option>
                            <option value="23">Emergency Room (23)</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label for="claim_frequency">Claim Frequency (CLM05-3)</label>
                        <select name="claim_frequency" id="claim_frequency" class="form-control w-100" required>
                            <option value="1" selected>Original (1)</option>
                            <option value="7">Replacement (7)</option>
                            <option value="8">Void (8)</option>
                        </select>
                    </div>
                    <h5 class="mb-n10">Diagnosis Codes (HI Segment)</h5>
                    <div class="col-md-3">
                        <label for="primary_diagnosis">Primary Diagnosis (HI01-2) (ICD-10 Format)</label>
                        <input type="text" name="primary_diagnosis" id="primary_diagnosis" class="form-control w-100" required pattern="^[A-Z]\d{2}(\.\d{1,4})?$" placeholder="Enter Primary Diagnosis Code" value="J45.909">
                    </div>
                    <div class="col-md-3">
                        <label for="additional_diagnosis">Additional Diagnoses (Optional)</label>
                        <textarea name="additional_diagnosis" id="additional_diagnosis" class="form-control w-100" placeholder="Enter Additional Diagnosis Codes (comma separated)"></textarea>
                    </div>
                    <h5 class="mb-n10">Condition Codes (HI Segment) - Optional</h5>
                    <div class="col-md-3">
                        <label for="condition_codes">Condition Codes</label>
                        <input type="text" name="condition_codes" id="condition_codes" class="form-control w-100" placeholder="Enter Condition Codes (if required)">
                    </div>
                
                
                    <h4 class="font-semibold mb-n10  mt-2">Service Line Information (2400 Loop)</h4>
                    <div class="col-md-3">
                        <label for="service_line_number">Service Line Number (LX01)</label>
                        <input type="number" name="service_line_number" id="service_line_number" class="form-control w-100" required min="1" placeholder="Enter Service Line Number" value="1">
                    </div>
                    <div class="col-md-3">
                        <label for="procedure_code">Procedure Code (SV101-2)</label>
                        <input type="text" name="procedure_code" id="procedure_code" class="form-control w-100" required pattern="^[A-Z0-9]+$" placeholder="Enter CPT/HCPCS Code" value="99213">
                    </div>
                    <div class="col-md-3">
                        <label for="charge_amount">Charge Amount (SV102)</label>
                        <input type="text" name="charge_amount" id="charge_amount" class="form-control w-100" required pattern="^\d+(\.\d{1,2})?$" placeholder="Enter Charge Amount" value="150.00">
                    </div>
                    <div class="col-md-3">
                        <label for="unit_count">Unit Count (SV104)</label>
                        <input type="number" name="unit_count" id="unit_count" class="form-control w-100" required min="1" placeholder="Enter Unit Count" value="1">
                    </div>
                    <div class="col-md-3">
                        <label for="diagnosis_pointer">Diagnosis Pointer (SV107)</label>
                        <input type="text" name="diagnosis_pointer" id="diagnosis_pointer" class="form-control w-100" required pattern="^[1-9]$" placeholder="Enter Diagnosis Pointer" value="1">
                    </div>
                    <div class="col-md-3">
                        <label for="date_of_service">Date of Service (DTP03) (YYYYMMDD)</label>
                        <input type="text" name="date_of_service" id="date_of_service" class="form-control w-100" required pattern="^\d{8}$" placeholder="Enter Date of Service" value="20240310">
                    </div>
               <div class="col-md-12">

                <button type="button" class="prev">Previous</button>
                <button type="button" class="next">Next</button>
            </div>
            </div>

            <!-- Step 4 -->
            <div class="row step row-gap-4">
               
                    <h4 class="font-semibold mb-n10  mt-2"> Referring Provider Information (2310A Loop)</h4>
                    <div class="col-md-3">
                        <label for="referring_provider_name">Referring Provider Name (NM103)</label>
                        <input type="text" name="referring_provider_name" id="referring_provider_name" class="form-control w-100" required placeholder="Enter Referring Provider Name" value="Dr. John Doe">
                    </div>
                    <div class="col-md-3">
                        <label for="referring_npi">NPI (NM109)</label>
                        <input type="text" name="referring_npi" id="referring_npi" class="form-control w-100" required pattern="^\d{10}$" placeholder="Enter NPI" value="1234567890">
                    </div>
                
               
                    <h4 class="font-semibold mb-n10  mt-2">Rendering Provider Information (2310B Loop)</h4>
                    <div class="col-md-3">
                        <label for="rendering_provider_name">Rendering Provider Name (NM103)</label>
                        <input type="text" name="rendering_provider_name" id="rendering_provider_name" class="form-control w-100" required placeholder="Enter Rendering Provider Name" value="Dr. Jane Smith">
                    </div>
                    <div class="col-md-3">
                        <label for="rendering_npi">NPI (NM109)</label>
                        <input type="text" name="rendering_npi" id="rendering_npi" class="form-control w-100" required pattern="^\d{10}$" placeholder="Enter Rendering NPI" value="9876543210">
                    </div>
                
                
                    <h4 class="font-semibold mb-n10  mt-2">Supervising Provider Information (2310D Loop)</h4>
                    <div class="col-md-3">
                        <label for="supervising_provider_name">Supervising Provider Name (NM103)</label>
                        <input type="text" name="supervising_provider_name" id="supervising_provider_name" class="form-control w-100" required placeholder="Enter Supervising Provider Name" value="Dr. Robert Johnson">
                    </div>
                    <div class="col-md-3">
                        <label for="supervising_npi">NPI (NM109)</label>
                        <input type="text" name="supervising_npi" id="supervising_npi" class="form-control w-100" required pattern="^\d{10}$" placeholder="Enter Supervising NPI" value="1231231234">
                    </div>
               <div class="col-md-12">
                <button type="button" class="prev">Previous</button>
                <button type="button" class="next">Next</button>
            </div>
            </div>

            
            <!-- Step 5 (Final Step) -->
            <div class="row step row-gap-4">
                
                    <h4 class="font-semibold mb-n10  mt-2">Transaction Set Trailer (SE Segment)</h4>
                    <div class="col-md-3">
                        <label for="se01">Total Number of Segments (SE01)</label>
                        <input type="number" name="se01" id="se01" class="form-control w-100" required placeholder="Enter total segments" value="34">
                    </div>
                    <div class="col-md-3">
                        <label for="se02">Transaction Set Control Number (SE02)</label>
                        <input type="text" name="se02" id="se02" class="form-control w-100" required placeholder="Enter control number (Matches ST02)" value="000000001">
                    </div>
                
              
                    <h4 class="font-semibold mb-n10  mt-2">Group and Interchange Trailer (GE and IEA Segments)</h4>
                    <div class="col-md-3">
                        <label for="ge_control_number">GE Control Number</label>
                        <input type="text" name="ge_control_number" id="ge_control_number" class="form-control w-100" required placeholder="Enter GE Control Number" value="123096815">
                    </div>
                    <div class="col-md-3">
                        <label for="iea_control_number">IEA Control Number</label>
                        <input type="text" name="iea_control_number" id="iea_control_number" class="form-control w-100" required placeholder="Enter IEA Control Number (Matches ISA)" value="123500377">
                    </div>
               <div class="col-md-12">
                <button type="button" class="prev">Previous</button>
                <button type="submit" class="btn btn-primary btn-sm">Generate 837P EDI</button>
            </div>
            </div>
        </form>


<script>
     let currentStep = 0;
    const steps = document.querySelectorAll(".step");
    const nextButtons = document.querySelectorAll(".next");
    const prevButtons = document.querySelectorAll(".prev");
    const form = document.getElementById("multiStepForm");

    // Show the current step
    function showStep(step) {
        steps.forEach((s, index) => {
            s.classList.toggle("active", index === step);
        });
        window.scrollTo({ top: 0, behavior: "smooth" }); // Auto scroll to top
    }

       // Handle the 'Next' button click
  // Function to validate the entire form for the current step
    function validateStep() {
        const currentFields = steps[currentStep].querySelectorAll("input, select, textarea");
        let stepIsValid = true;

        currentFields.forEach((field) => {
            if (!validateField(field)) {
                stepIsValid = false;
            }
        });

        return stepIsValid;
    }

    // Handle the 'Next' button click
    nextButtons.forEach(button => {
        button.addEventListener("click", () => {
            if (validateStep()) { // Only proceed if validation passes
                if (currentStep < steps.length - 1) {
                    currentStep++;
                    showStep(currentStep);
                }
            } else {
                alert("Please fix the errors in the current step.");
            }
        });
    });

    // Handle the 'Previous' button click
    prevButtons.forEach(button => {
        button.addEventListener("click", () => {
            if (currentStep > 0) {
                currentStep--;
                showStep(currentStep);
            }
        });
    });


    // Function to validate individual fields
    function validateField(field) {
        let isValid = true;

        // Validate sender_id
        if (field.name === 'sender_id') {
            if (!field.value || field.value.length < 2 || field.value.length > 15) {
                alert("Sender ID must be between 2 to 15 characters.");
                isValid = false;
            }
        }

        // Validate receiver_id
        if (field.name === 'receiver_id') {
            if (!field.value || field.value.length < 2 || field.value.length > 15) {
                alert("Receiver ID must be between 2 to 15 characters.");
                isValid = false;
            }
        }

        // Validate transmission_time (exactly 4 digits)
        if (field.name === 'transmission_time') {
            const regex = /^\d{4}$/;
            if (!regex.test(field.value)) {
                alert("Transmission Time must be exactly 4 digits.");
                isValid = false;
            }
        }

        // Validate control_number (max 15 characters)
        if (field.name === 'control_number') {
            if (field.value.length > 15) {
                alert("Control Number must be a string with a max length of 15 characters.");
                isValid = false;
            }
        }

        // Validate sender_code (max 15 characters)
        if (field.name === 'sender_code') {
            if (field.value.length > 15) {
                alert("Sender Code must be a string with a max length of 15 characters.");
                isValid = false;
            }
        }

        // Validate receiver_code (max 15 characters)
        if (field.name === 'receiver_code') {
            if (field.value.length > 15) {
                alert("Receiver Code must be a string with a max length of 15 characters.");
                isValid = false;
            }
        }

        // Validate gs_date (exactly 8 digits, format CCYYMMDD)
        if (field.name === 'gs_date') {
            const regex = /^\d{8}$/;
            if (!regex.test(field.value)) {
                alert("GS Date must be exactly 8 digits in the format CCYYMMDD.");
                isValid = false;
            }
        }

        // Validate gs_time (exactly 4 digits, format HHMM)
        if (field.name === 'gs_time') {
            const regex = /^\d{4}$/;
            if (!regex.test(field.value)) {
                alert("GS Time must be exactly 4 digits in the format HHMM.");
                isValid = false;
            }
        }

        // Validate gs_control_number (max 15 characters)
        if (field.name === 'gs_control_number') {
            if (field.value.length > 15) {
                alert("GS Control Number must be a string with a max length of 15 characters.");
                isValid = false;
            }
        }

        // Validate submitter_name (max 100 characters)
        if (field.name === 'submitter_name') {
            if (field.value.length > 100) {
                alert("Submitter Name must be a string with a max length of 100 characters.");
                isValid = false;
            }
        }

        // Validate submitter_id (max 15 characters)
        if (field.name === 'submitter_id') {
            if (field.value.length > 15) {
                alert("Submitter ID must be a string with a max length of 15 characters.");
                isValid = false;
            }
        }

        // Validate receiver_name (max 100 characters)
        if (field.name === 'receiver_name') {
            if (field.value.length > 100) {
                alert("Receiver Name must be a string with a max length of 100 characters.");
                isValid = false;
            }
        }

         // Validate provider_name (max 100 characters)
        if (field.name === 'provider_name') {
            if (field.value.length > 100) {
                alert("Provider Name must be a string with a max length of 100 characters.");
                isValid = false;
            }
        }

        // Validate provider_npi (exactly 10 digits)
        if (field.name === 'provider_npi') {
            const regex = /^\d{10}$/;
            if (!regex.test(field.value)) {
                alert("Provider NPI must be exactly 10 digits.");
                isValid = false;
            }
        }

        // Validate provider_tax_id (format: 12-3456789)
  if (field.name === 'provider_tax_id') {
    const regex = /^\d{9}$/; // Ensures exactly 9 digits
    if (!regex.test(field.value)) {
        alert("Provider Tax ID must be exactly 9 digits.");
        isValid = false;
    }
}



        // Validate provider_street (max 150 characters)
        if (field.name === 'provider_street') {
            if (field.value.length > 150) {
                alert("Provider Street must be a string with a max length of 150 characters.");
                isValid = false;
            }
        }

        // Validate provider_city (max 50 characters)
        if (field.name === 'provider_city') {
            if (field.value.length > 50) {
                alert("Provider City must be a string with a max length of 50 characters.");
                isValid = false;
            }
        }

        // Validate provider_state (2 uppercase letters)
        if (field.name === 'provider_state') {
            const regex = /^[A-Z]{2}$/;
            if (!regex.test(field.value)) {
                alert("Provider State must be exactly 2 uppercase letters.");
                isValid = false;
            }
        }

        // Validate provider_zip (exactly 9 digits)
        if (field.name === 'provider_zip') {
            const regex = /^\d{9}$/;
            if (!regex.test(field.value)) {
                alert("Provider ZIP must be exactly 9 digits.");
                isValid = false;
            }
        }

        // Validate facility_name (max 100 characters)
        if (field.name === 'facility_name') {
            if (field.value.length > 100) {
                alert("Facility Name must be a string with a max length of 100 characters.");
                isValid = false;
            }
        }

        // Validate facility_npi (exactly 10 digits and different from billing_provider_npi)
        // if (field.name === 'facility_npi') {
        //     const regex = /^\d{10}$/;
        //     if (!regex.test(field.value)) {
        //         alert("Facility NPI must be exactly 10 digits.");
        //         isValid = false;
        //     }
        //     // Check if the facility_npi is different from billing_provider_npi
        //     const billingProviderNpi = document.querySelector("[name='billing_provider_npi']").value;
        //     if (field.value === billingProviderNpi) {
        //         alert("Facility NPI must be different from Billing Provider NPI.");
        //         isValid = false;
        //     }
        // }

        if (field.name === 'facility_street') {
            if (field.value.trim().length === 0) {
                alert("Facility Street is required.");
                isValid = false;
            } else if (field.value.length > 150) {
                alert("Facility Street must be at most 150 characters.");
                isValid = false;
            }
        }

        if (field.name === 'facility_city') {
            if (field.value.trim().length === 0) {
                alert("Facility City is required.");
                isValid = false;
            } else if (field.value.length > 50) {
                alert("Facility City must be at most 50 characters.");
                isValid = false;
            }
        }

        if (field.name === 'facility_state') {
            const regex = /^[A-Z]{2}$/;
            if (!regex.test(field.value)) {
                alert("Facility State must be exactly 2 uppercase letters.");
                isValid = false;
            }
        }

        if (field.name === 'facility_zip') {
            const regex = /^\d{9}$/;
            if (!regex.test(field.value)) {
                alert("Facility Zip must be exactly 9 digits.");
                isValid = false;
            }
        }

        if (field.name === 'subscriber_last_name') {
            if (field.value.trim().length === 0) {
                alert("Subscriber Last Name is required.");
                isValid = false;
            } else if (field.value.length > 100) {
                alert("Subscriber Last Name must be at most 100 characters.");
                isValid = false;
            }
        }

        if (field.name === 'subscriber_first_name') {
            if (field.value.trim().length === 0) {
                alert("Subscriber First Name is required.");
                isValid = false;
            } else if (field.value.length > 100) {
                alert("Subscriber First Name must be at most 100 characters.");
                isValid = false;
            }
        }

       if (field.name === 'member_id') {
    const regex = /^[A-Z0-9]{8,15}$/;
    if (!regex.test(field.value)) {
        alert("Member ID must be between 8 and 15 characters and consist of uppercase letters (A-Z) and digits (0-9).");
        isValid = false;
    }
}


        if (field.name === 'subscriber_street') {
            if (field.value.trim().length === 0) {
                alert("Subscriber Street is required.");
                isValid = false;
            } else if (field.value.length > 150) {
                alert("Subscriber Street must be at most 150 characters.");
                isValid = false;
            }
        }

        if (field.name === 'subscriber_city') {
            if (field.value.trim().length === 0) {
                alert("Subscriber City is required.");
                isValid = false;
            } else if (field.value.length > 50) {
                alert("Subscriber City must be at most 50 characters.");
                isValid = false;
            }
        }

        if (field.name === 'subscriber_state') {
            const regex = /^[A-Z]{2}$/;
            if (!regex.test(field.value)) {
                alert("Subscriber State must be exactly 2 uppercase letters.");
                isValid = false;
            }
        }

        if (field.name === 'subscriber_zip') {
            const regex = /^\d{9}$/;
            if (!regex.test(field.value)) {
                alert("Subscriber Zip must be exactly 9 digits.");
                isValid = false;
            }
        }

        if (field.name === 'subscriber_dob') {
            const regex = /^\d{8}$/; // Format CCYYMMDD
            if (!regex.test(field.value)) {
                alert("Subscriber DOB must be in CCYYMMDD format.");
                isValid = false;
            }
        }

        if (field.name === 'subscriber_gender') {
            if (!['M', 'F', 'U'].includes(field.value)) {
                alert("Subscriber Gender must be M, F, or U.");
                isValid = false;
            }
        }

        if (field.name === 'payer_name') {
            if (field.value.trim().length === 0) {
                alert("Payer Name is required.");
                isValid = false;
            } else if (field.value.length > 100) {
                alert("Payer Name must be at most 100 characters.");
                isValid = false;
            }
        }

      if (field.name === 'payer_id') {
    const regex = /^[a-zA-Z0-9]{5,10}$/; // Allows letters (both upper and lower case) and digits, between 5 and 10 characters
    if (!regex.test(field.value)) {
        alert("Payer ID must be between 5 and 10 alphanumeric characters.");
        isValid = false;
    }
}


        if (field.name === 'payer_street') {
            if (field.value.trim().length > 150) {
                alert("Payer Street must be at most 150 characters.");
                isValid = false;
            }
        }

        if (field.name === 'payer_city') {
            if (field.value.trim().length > 50) {
                alert("Payer City must be at most 50 characters.");
                isValid = false;
            }
        }

        if (field.name === 'payer_state') {
            if (field.value.trim() && !/^[A-Z]{2}$/.test(field.value)) {
                alert("Payer State must be exactly 2 uppercase letters.");
                isValid = false;
            }
        }

        if (field.name === 'payer_zip') {
            if (field.value.trim() && !/^\d{9}$/.test(field.value)) {
                alert("Payer Zip must be exactly 9 digits.");
                isValid = false;
            }
        }

        if (field.name === 'claim_number') {
            if (field.value.trim().length === 0) {
                alert("Claim Number is required.");
                isValid = false;
            } else if (field.value.length > 50) {
                alert("Claim Number must be at most 50 characters.");
                isValid = false;
            }
        }

        if (field.name === 'claim_amount') {
            const regex = /^\d+(\.\d{1,2})?$/;
            if (!regex.test(field.value)) {
                alert("Claim Amount must be a valid number with up to two decimal places.");
                isValid = false;
            }
        }

        if (field.name === 'place_of_service') {
            if (!['11', '21', '22', '23'].includes(field.value)) {
                alert("Place of Service must be one of the following: 11, 21, 22, 23.");
                isValid = false;
            }
        }

        if (field.name === 'claim_frequency') {
            if (!['1', '7', '8'].includes(field.value)) {
                alert("Claim Frequency must be one of the following: 1, 7, 8.");
                isValid = false;
            }
        }

        if (field.name === 'primary_diagnosis') {
            const regex = /^[A-Z]\d{2}(\.\d{1,4})?$/;
            if (!regex.test(field.value)) {
                alert("Primary Diagnosis must follow the pattern: [A-Z][2 digits] and optionally .[1-4 digits].");
                isValid = false;
            }
        }

        if (field.name === 'additional_diagnosis') {
            if (field.value.trim().length > 0 && field.value.length > 150) {
                alert("Additional Diagnosis must be at most 150 characters.");
                isValid = false;
            }
        }

        if (field.name === 'condition_codes') {
            if (field.value.trim().length > 0 && field.value.length > 150) {
                alert("Condition Codes must be at most 150 characters.");
                isValid = false;
            }
        }
        if (field.name === 'service_line_number') {
            const value = parseInt(field.value);
            if (isNaN(value) || value < 1) {
                alert("Service Line Number must be an integer and greater than or equal to 1.");
                isValid = false;
            }
        }

        if (field.name === 'procedure_code') {
            const regex = /^[A-Z0-9]+$/;
            if (!regex.test(field.value)) {
                alert("Procedure Code must contain only uppercase letters and numbers.");
                isValid = false;
            }
        }

        if (field.name === 'charge_amount') {
            const regex = /^\d+(\.\d{1,2})?$/;
            if (!regex.test(field.value)) {
                alert("Charge Amount must be a valid number with up to two decimal places.");
                isValid = false;
            }
        }

        if (field.name === 'unit_count') {
            const value = parseInt(field.value);
            if (isNaN(value) || value < 1) {
                alert("Unit Count must be an integer and greater than or equal to 1.");
                isValid = false;
            }
        }

        if (field.name === 'diagnosis_pointer') {
            const value = parseInt(field.value);
            if (isNaN(value) || value < 1 || value > 9) {
                alert("Diagnosis Pointer must be an integer between 1 and 9.");
                isValid = false;
            }
        }

        if (field.name === 'date_of_service') {
            const regex = /^\d{8}$/;  // CCYYMMDD format
            if (!regex.test(field.value)) {
                alert("Date of Service must be in the format: CCYYMMDD.");
                isValid = false;
            }
        }

        if (field.name === 'referring_provider_name') {
            if (field.value.trim().length === 0) {
                alert("Referring Provider Name is required.");
                isValid = false;
            } else if (field.value.length > 255) {
                alert("Referring Provider Name must be at most 255 characters.");
                isValid = false;
            }
        }

        if (field.name === 'referring_npi') {
            const regex = /^\d{10}$/;
            if (!regex.test(field.value)) {
                alert("Referring NPI must be exactly 10 digits.");
                isValid = false;
            }
        }

        if (field.name === 'rendering_provider_name') {
            if (field.value.trim().length === 0) {
                alert("Rendering Provider Name is required.");
                isValid = false;
            } else if (field.value.length > 255) {
                alert("Rendering Provider Name must be at most 255 characters.");
                isValid = false;
            }
        }

        if (field.name === 'rendering_npi') {
            const regex = /^\d{10}$/;
            if (!regex.test(field.value)) {
                alert("Rendering NPI must be exactly 10 digits.");
                isValid = false;
            }
        }

        if (field.name === 'supervising_provider_name') {
            if (field.value.trim().length === 0) {
                alert("Supervising Provider Name is required.");
                isValid = false;
            } else if (field.value.length > 255) {
                alert("Supervising Provider Name must be at most 255 characters.");
                isValid = false;
            }
        }

        if (field.name === 'supervising_npi') {
            const regex = /^\d{10}$/;
            if (!regex.test(field.value)) {
                alert("Supervising NPI must be exactly 10 digits.");
                isValid = false;
            }
        }

        if (field.name === 'se01') {
            const value = parseInt(field.value);
            if (isNaN(value) || value < 1) {
                alert("SE01 must be an integer and greater than or equal to 1.");
                isValid = false;
            }
        }

        if (field.name === 'se02') {
            if (field.value.trim().length > 20) {
                alert("SE02 must be at most 20 characters.");
                isValid = false;
            }
        }

        if (field.name === 'ge_control_number') {
            if (field.value.trim().length > 20) {
                alert("GE Control Number must be at most 20 characters.");
                isValid = false;
            }
        }

        if (field.name === 'iea_control_number') {
            if (field.value.trim().length > 20) {
                alert("IEA Control Number must be at most 20 characters.");
                isValid = false;
            }
        }



                return isValid;
            }

            // Function to validate the entire form
            function validateForm() {
                const formFields = document.querySelectorAll("input, select, textarea");
                let formIsValid = true;

                formFields.forEach((field) => {
                    if (!validateField(field)) {
                        formIsValid = false;
                    }
                });

                return formIsValid;
            }

    // Add event listener to the form submit

    form.addEventListener("submit", (event) => {
        event.preventDefault();
        if (validateForm()) {
            // Proceed with form submission if valid
            alert("Form submitted successfully!");
            form.submit(); // Or your submit action
        } else {
            alert("Please fix the errors in the form.");
        }
    });
</script>

<script>
window.onload = displayClock();
function displayClock() {
const currentDate = new Date(new Date().toLocaleString("en-US", {
timeZone: "America/New_York"
}));
var timestamp = currentDate.toString().split('GMT');
var splitstring = timestamp[0].split(" ");
var final_string = splitstring[0] + ', ' + splitstring[1] + ' ' + splitstring[2] + ' ' + splitstring[3] +
', ' + splitstring[4];
$("#clock").text(final_string);
setTimeout(displayClock, 1000);
}
</script>

@endsection