<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;

class Acknowledge999FileModel extends Model
{
    use HasFactory;

    protected $table = 'ack_999_file';
    protected $guarded = [];


    protected static function boot()
    {
        parent::boot();

        // Automatically set 'created_user_id' ONLY when inserting a new record
        static::creating(function ($model) {
            if (Auth::check() && empty($model->created_user_id)) { // Ensure it's not already set
                $model->created_user_id = Auth::id();
            }
        });
    }
}
