<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Auth;
use App\Models\ProviderInfoModel;
use App\Models\User;

class ProviderCheckMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        
        // Example: allow only users with user_type = 'provider'
        if (auth()->check() && auth()->user()->user_type == 'P') {
            // dd(1);
           $providerInfo = User::where('id', Auth()->user()->id)->first();
            if (!$providerInfo->username) {
                // dd(2);
                return redirect()->route('complete.provider.info')->with('error','please complete your info');
            }else{
                 return $next($request);
            }
            
        }

        else{
            return $next($request);
        }
    
    }




}
