<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use App\Models\SftpEdiModel;
use App\Models\EdiFileModel;
use App\Models\Acknowledge999FileModel;

class SftpEdiController extends Controller
{
    public function get_837_files()
    {
       // try {
       //      $sftp = Storage::disk('sftp');
       //      $files = $sftp->files('/');
       //      return response()->json(['success' => 'Connected!', 'files' => $files]);
       //  } catch (\Exception $e) {
       //      return response()->json(['error' => $e->getMessage()], 500);
       //  }

        try {
            $sftp = Storage::disk('sftp');
            $path = '837/'; // Folder where 837 files are stored
            $files = $sftp->files($path); // Get all files in the folder

            if (empty($files)) {
                return response()->json(['message' => 'No 837 files found.']);
            }

            $fileNames = [];
            foreach ($files as $file) {
                $fileNames[] = basename($file);
            }

            return response()->json([
                'total_files' => count($fileNames),
                'files' => $fileNames
            ]);
        } catch (\Exception $e) {
            return response()->json(['error' => $e->getMessage()], 500);
        }
    }







 public function fetch837Files()
{
    try {
        $sftp = Storage::disk('sftp');
        $files = $sftp->files('/837');

        if (empty($files)) {
            return response()->json(['message' => 'No files found in /837 folder.'], 200);
        }

        $newFilesAdded = 0;

        foreach ($files as $file) {
            $exists = SftpEdiModel::where('file_name', $file)->where('file_type', '837')->exists();

            if (!$exists) {
                $fileContent = $sftp->get($file);

               // Extract REF ID from ST*837 segment
                preg_match('/ST\*837\*([0-9]+)\*/', $fileContent, $matches);
                $refId = $matches[1] ?? null;


                // Create new instance and save
                $ediFile = new SftpEdiModel();
                $ediFile->file_name = $file;
                $ediFile->file_type = '837';
                $ediFile->status = 'P';
                $ediFile->ref_id = $refId;
                $ediFile->file_string = $fileContent;
                $ediFile->save();

                $newFilesAdded++;
            }
        }

        if ($newFilesAdded > 0) {
            return response()->json(['message' => "$newFilesAdded new 837 files processed successfully."]);
        } else {
            return response()->json(['message' => 'No new 837 files found. All files are already processed.']);
        }
    } catch (\Exception $e) {
        return response()->json(['error' => $e->getMessage()], 500);
    }
}









public function fetch275Files()
{
    try {
        $sftp = Storage::disk('sftp');
        $files = $sftp->files('/275');

        if (empty($files)) {
            return response()->json(['message' => 'No files found in /275 folder.'], 200);
        }

        $newFilesAdded = 0;

        foreach ($files as $file) {
            $exists = SftpEdiModel::where('file_name', $file)->where('file_type', '275')->exists();

            if (!$exists) {
                $fileContent = $sftp->get($file);

               preg_match('/ST\*\d+\*([0-9]+)(?:\*|~)/', $fileContent, $matches);
                $refId = $matches[1] ?? null;
                // dd($refId);

                

                // Create new instance and save
                $ediFile = new SftpEdiModel();
                $ediFile->file_name = $file;
                $ediFile->file_type = '275';
                $ediFile->status = 'P';
                $ediFile->ref_id = $refId;
                $ediFile->file_string = $fileContent;
                $ediFile->save();

                $newFilesAdded++;
            }
        }

        if ($newFilesAdded > 0) {
            return response()->json(['message' => "$newFilesAdded new 275 files processed successfully."]);
        } else {
            return response()->json(['message' => 'No new 275 files found. All files are already processed.']);
        }
    } catch (\Exception $e) {
        return response()->json(['error' => $e->getMessage()], 500);
    }
}









public function sendFileTo999($filePath='/837/sample.edi', $fileContent='EDI FILE CONTENT HERE')
{
    try {
        $sftp = Storage::disk('sftp');

        // Define the destination path in the 999 folder
        $fileName = basename($filePath);
        $destinationPath = "/999/{$fileName}";

        // Upload the file
        $sftp->put($destinationPath, $fileContent);

        return response()->json(['message' => "File {$fileName} uploaded to /999 folder successfully."]);
    } catch (\Exception $e) {
        return response()->json(['error' => $e->getMessage()], 500);
    }
}










public function generate_999($id){
     $find = SftpEdiModel::where('id', $id)->first();
     if(!$find){
        return back()->with('error','Id missmatch');
     }
     //create 999 file for 837
    if($find->file_type=="837"){

        $content=$find->file_string;
        $originalName = '837_to_999_sftp_' . time() . '.edi';
       
        // Extract dynamic values from 837 file
        $senderId = str_pad($this->extractSegmentValue($content, 'ISA', 6, 15), 15, " ", STR_PAD_RIGHT);
        $receiverId = str_pad($this->extractSegmentValue($content, 'ISA', 8, 15), 15, " ", STR_PAD_RIGHT);
        $controlNumber = $this->extractSegmentValue($content, 'ISA', 13, 9); // ISA Control Number
        $gsControlNumber = str_pad(mt_rand(100000000, 999999999), 9, "0", STR_PAD_LEFT);
        //$this->extractSegmentValue($content, 'GS', 6, 9); // GS Control Number
        $date = date('ymd'); // YYMMDD format
        $time = date('Hi');  // HHMM format
        $gsDate = date('Ymd');   // GS-04 must be CCYYMMD

        // Check rejection indicators in 837
        $isFullyRejected = strpos($content, "BHT*0085*RE") !== false; // Example: Fully Rejected
        $hasSegmentErrors = strpos($content, "IK3*") !== false; // Means some segments are invalid
        $hasElementErrors = strpos($content, "IK4*") !== false; // Means some elements are incorrect

        // Determine IK5 and AK9 values based on conditions
        if ($isFullyRejected) {
            $ik5Code = "R"; // Fully Rejected
            $ak9Code = "R"; // Functional Group Rejected
        } elseif ($hasSegmentErrors || $hasElementErrors) {
            $ik5Code = "R"; // Some transactions rejected
            $ak9Code = "P"; // Partially Accepted
        } else {
            $ik5Code = "A"; // Fully Accepted
            $ak9Code = "A"; // Functional Group Accepted
        }


        // Generate 999 file content
        $generatedContent = "ISA*00*          *00*          *ZZ*$senderId*ZZ*$receiverId*$date*$time*^*00501*$controlNumber*1*T*:~
        GS*FA*$senderId*$receiverId*$gsDate*$time*$gsControlNumber*X*005010X231A1~
        ST*999*0001*005010X231A1~
        AK1*HC*$gsControlNumber*005010X222A1~
        AK2*837*000000001~
        IK5*$ik5Code~
        AK9*$ak9Code*1*1*1~
        SE*6*0001~
        GE*1*$gsControlNumber~
        IEA*1*$controlNumber~";

        // Save the generated 999 file
        Storage::put("uploads/$originalName", $generatedContent);
        // Determine file status
         $status = $isFullyRejected 
        ? "rejected" 
        : (($hasSegmentErrors || $hasElementErrors) 
            ? "partially accepted" 
            : "accepted");


           $update=SftpEdiModel::where('id', $id)->update(['ack_file_string'=>$generatedContent,'status'=>'G','ack_file_name'=>$originalName]);
           return back()->with('success','999 Ack file generated for 837');

    }



    else{
        

        $content=$find->file_string;
        $originalName = '275_to_999_' . time() . '.edi';
       
        // Extract dynamic values from .275 file
        $senderId = str_pad($this->extractSegmentValue($content, 'ISA', 6, 15), 15, " ", STR_PAD_RIGHT);
        $receiverId = str_pad($this->extractSegmentValue($content, 'ISA', 8, 15), 15, " ", STR_PAD_RIGHT);
        $date = $this->extractSegmentValue($content, 'ISA', 9, 6);
        $time = $this->extractSegmentValue($content, 'ISA', 10, 4);
        $controlNumber = str_pad($this->extractSegmentValue($content, 'ISA', 13, 9), 9, "0", STR_PAD_LEFT);

        // Generate new control number
        $newControlNumber = str_pad(mt_rand(100000000, 999999999), 9, "0", STR_PAD_LEFT);

        // Check for rejection conditions
        $isFullyRejected = strpos($content, "BDS*R") !== false;
        $isPartiallyAccepted = strpos($content, "BDS*P") !== false;
        $hasSegmentErrors = strpos($content, "IK3*") !== false;
        $hasElementErrors = strpos($content, "IK4*") !== false;
         $currentDate = date('Ymd');
                $currentTime = date('His');

        // Determine IK5 and AK9 codes
        if ($isFullyRejected) {
            $ik5Code = "R";
            $ak9Code = "R";
        } elseif ($isPartiallyAccepted || $hasSegmentErrors || $hasElementErrors) {
            $ik5Code = "R";
            $ak9Code = "P";
        } else {
            $ik5Code = "A";
            $ak9Code = "A";
        }

        // Count transactions
        $transactionCount = substr_count($content, "ST*275");

        // Generate 999 file content
        $generatedContent = "ISA*00*          *00*          *ZZ*$senderId*ZZ*$receiverId*$date*$time*^*00501*$newControlNumber*1*T*:~
        GS*FA*$senderId*$receiverId*$currentDate*$currentTime*$newControlNumber*X*005010X231A1~
        ST*999*$newControlNumber*005010X231A1~
        AK1*PI*$controlNumber*005010X210~
        AK2*275*000000001~
        IK5*$ik5Code~
        AK9*$ak9Code*$transactionCount*$transactionCount*$transactionCount~
        SE*6*$newControlNumber~
        GE*1*$newControlNumber~
        IEA*1*$newControlNumber~";

        // Determine file status
        $status = $isFullyRejected ? "rejected" : ($isPartiallyAccepted || $hasSegmentErrors || $hasElementErrors ? "partially accepted" : "accepted");

        // Save the new 999 file
        Storage::put("uploads/$originalName", $generatedContent);


        $update=SftpEdiModel::where('id', $id)->update(['ack_file_string'=>$generatedContent,'status'=>'G','ack_file_name'=>$originalName]);
           return back()->with('success','999 Ack file generated for 275');

    }

}


    // Function to extract a specific segment value from the EDI file
    private function extractSegmentValue($content, $segment, $position, $length)
    {
        $lines = explode("~", $content); // Split by segment delimiter (~)
        foreach ($lines as $line) {
            if (strpos($line, $segment) === 0) {
                $elements = explode('*', $line); // Split segment into elements
                return isset($elements[$position]) ? trim($elements[$position]) : 'UNKNOWN';
            }
        }
        return 'UNKNOWN';
    }





    public function send_999($id){
         $find = SftpEdiModel::where('id', $id)->where('status','G')->first();
         if(!$find){
            return back()->with('error','Id missmatch');
         }
        try {
            $sftp = Storage::disk('sftp');

            // Define the destination path in the 999 folder
            $fileName =$find->ack_file_name;
            $destinationPath = "/999/{$fileName}";
            $fileContent=$find->ack_file_string;

            // Upload the file
            $sftp->put($destinationPath, $fileContent);

            // return response()->json(['message' => "File {$fileName} uploaded to /999 folder successfully."]);
            $update=SftpEdiModel::where('id', $id)->update(['status'=>'S',]);
           return back()->with('success',"File {$fileName} uploaded to /999 folder successfully.");
        } catch (\Exception $e) {
             return back()->with('error' , $e->getMessage());
        }
    }





   public function downlode_sftp_file($id)
{
    $edi = SftpEdiModel::find($id);
    // dd(1);

    if (!$edi || !$edi->file_string) {
          return back()->with('error' , 'File not found');
    }

    $filename = $edi->file_name ?? 'edi_file.edi';

    // dd($filename);

    return response($edi->file_string)
        ->header('Content-Type', 'application/edi-x12')
        ->header('Content-Disposition', 'attachment; filename="' . $filename . '"');
}




 public function downlode_ack_file($id)
{
    $edi = SftpEdiModel::find($id);

    if (!$edi || !$edi->ack_file_string) {
      return back()->with('error' , 'File not found');
    }

    $filename = $edi->ack_file_name ?? 'ack_file.edi';

    return response($edi->ack_file_string)
        ->header('Content-Type', 'application/edi-x12')
        ->header('Content-Disposition', 'attachment; filename="' . $filename . '"');
}







public function send_system_generated_999($id){
  $find=Acknowledge999FileModel::where('file_837_id',$id)->first();
  if(!$find){
     return back()->with('error' , 'File not found');
  }
  try {
            $sftp = Storage::disk('sftp');

            // Define the destination path in the 999 folder
            $fileName =$find->file_name;
            $destinationPath = "/999/{$fileName}";
            $fileContent=$find->file_string;

            // Upload the file
            $sftp->put($destinationPath, $fileContent);

            // return response()->json(['message' => "File {$fileName} uploaded to /999 folder successfully."]);
            $update=EdiFileModel::where('id', $id)->update(['status'=>'S',]);
           return back()->with('success',"File {$fileName} uploaded to /999 folder successfully.");
        } catch (\Exception $e) {
             return back()->with('error' , $e->getMessage());
        }
}








public function view_system_file_data($id)
{
    $find=EdiFileModel::where('id',$id)->first();
    if(!$find){
     return back()->with('error' , 'File not found');
    }
    if($find->is_multiple=="Y"){
        return redirect()->route('view.system.multiclaim.file',$find->id);
    }
    $details = json_decode($find->request_data);
    
    $data['data']=$details;
    
    $find_837_to_999 = Acknowledge999FileModel::where('file_837_id', $find->id)
                            ->where('file_type', '837')->first();
    $find['find_837_to_999'] = $find_837_to_999 ?? null;

    $find_275_to_999 = Acknowledge999FileModel::where('file_837_id', $find->id)
                            ->where('file_type', '275')->first();
    $find['find_275_to_999'] = $find_275_to_999 ?? null;
    $data['file']=$find;

    // dd($data);
    if($find->type=="P"){
      return view('system_file_details')->with($data);
    } elseif($find->type=="I"){
        return view('system_file_details_i')->with($data);
    }else{
       return view('system_file_details_d')->with($data);
    }

}







public function view_sftp_837_file_data($id)
{
    $file = SftpEdiModel::findOrFail($id);
    $ediContent = $file->file_string;
    
    $parsedData = $this->parseEdi837($ediContent);
    // dd($parsedData,"k");
    
    return view('sftp.view_sftp_837_file_data', [
        'data' => $parsedData,
        'originalContent' => $ediContent,
        'file'=>$file
    ]);
}




private $currentLocationType = null; // 'pickup' or 'dropoff'
 private function parseEdi837($ediContent)
    {
        $segments = explode('~', $ediContent);
        $parsed = [
            'meta' => [
                'edi_type' => null,
                'interchange' => [],
                'functional_group' => [],
            ],
            'submitters' => [],
            'providers' => [],
            'payers' => [],
            'subscribers' => [],
            'patients' => [],
            'claims' => [],
            'additional'=>[],
        ];

        $currentClaimIndex = -1;
        $currentServiceIndex = -1;
        $currentLoopLevel = 0;
        $currentLoopId = null;

        foreach ($segments as $segment) {
            $segment = trim($segment);
            if (empty($segment)) continue;
            
            $elements = explode('*', $segment);
            $segmentId = $elements[0];
            
            switch ($segmentId) {
                // ISA - Interchange Control Header
                case 'ISA':
                    $parsed['meta']['interchange'] = [
                        'sender_id' => trim($elements[6] ?? ''),
                        'receiver_id' => trim($elements[8] ?? ''),
                        'date' => trim($elements[9] ?? ''),
                        'time' => trim($elements[10] ?? ''),
                        'control_number' => trim($elements[13] ?? ''),
                    ];
                    break;
                    
                // GS - Functional Group Header
                case 'GS':
                    $version = trim($elements[8] ?? '');
                    $parsed['meta']['edi_type'] = match($version) {
                        '005010X223A2' => 'I', // Institutional
                        '005010X224A2' => 'D',  // Dental
                        '005010X222A1' => 'P',  // Professional
                        default => 'U'          // Unknown
                    };
                    
                    $parsed['meta']['functional_group'] = [
                        'sender_code' => trim($elements[2] ?? ''),
                        'receiver_code' => trim($elements[3] ?? ''),
                        'date' => trim($elements[4] ?? ''),
                        'time' => trim($elements[5] ?? ''),
                        'control_number' => trim($elements[6] ?? ''),
                        'version' => $version,
                    ];
                    break;
                    
                // ST - Transaction Set Header
                case 'ST':
                    $parsed['meta']['transaction_set'] = [
                        'id' => trim($elements[1] ?? ''),
                        'control_number' => trim($elements[2] ?? ''),
                    ];
                    break;
                    
                // BHT - Beginning of Hierarchical Transaction
                case 'BHT':
                    $parsed['meta']['hierarchical_transaction'] = [
                        'purpose_code' => trim($elements[2] ?? ''),
                        'reference_id' => trim($elements[3] ?? ''),
                        'date' => trim($elements[4] ?? ''),
                        'time' => trim($elements[5] ?? ''),
                    ];
                    break;
                    
                // HL - Hierarchical Level
                case 'HL':
                    $currentLoopLevel = (int)($elements[3] ?? 0);
                    $currentLoopId = trim($elements[1] ?? '');
                    
                    // If this is a claim level (typically HL*2 or HL*3 depending on EDI type)
                    if ($currentLoopLevel >= 2) {
                        $currentClaimIndex++;
                        $currentServiceIndex = -1;
                        
                        $parsed['claims'][$currentClaimIndex] = [
                            'loop_id' => $currentLoopId,
                            'level' => $currentLoopLevel,
                            'services' => [],
                            'type' => $parsed['meta']['edi_type'],
                        ];
                    }
                    break;

                    case 'REF':
                     // dd($segmentId,$elements[2]);
                     if (($elements[1] ?? '') === '1G') { // Group Number
                            $parsed['additional']['group_info'][$currentClaimIndex] = [
                                'group_number' => trim($elements[2] ?? '')
                            ];
                        }
                      $parsed['providers'][0]['tax_id']=$elements[2];

                      if (($elements[1] ?? '') === '9A') {
                      // dd($elements); // PPO Network ID
                            $parsed['additional']['ppo_info'][$currentClaimIndex] = [
                                'network_id' => trim($elements[2] ?? '')
                            ];
                        }

                     break;



                    case 'HCP':
                        if (($elements[1] ?? '') === '04') { // Repriced Amount
                            // dd($elements);
                            $parsed['additional']['pricing_info'][$currentClaimIndex] = [
                                'repriced_amount' => isset($elements[2]) ? (float)$elements[2] : null,
                                'price_indicator' => $elements[3] ?? '', // Should be '2' for contracted rate
                                'service_code' => $elements[4] ?? ''
                            ];
                        }
                        break;


                     case 'PER':
                        // Provider Contact Information
                     // dd($elements);
                        if (($elements[1] ?? '') === 'IC') {
                            $contactInfo = [
                                'name' => trim($elements[2] ?? ''),
                                'communication_method' => trim($elements[3] ?? ''),
                                'phone' => trim($elements[4] ?? '')
                            ];
                            
                            // Add to existing ordering provider if available
                            if (!empty($parsed['additional']['provider_contacts'][$currentClaimIndex])) {
                                $parsed['additional']['provider_contacts'][$currentClaimIndex]['contact'] = $contactInfo;
                            } else {
                                // Or create new contact entry
                                $parsed['additional']['provider_contacts'][$currentClaimIndex] = $contactInfo;
                            }
                        }
                        break;


                     case 'LQ':
                        if (($elements[1] ?? '') === 'UT') { // Form Identifier
                            $parsed['additional']['forms'][$currentClaimIndex]['form_identifier'] = trim($elements[2] ?? '');
                        }
                        break;

                    case 'FRM':
                        $formType = $elements[1] ?? '';
                           $formNum = "FRM ".trim($elements[1] ?? '');
                           $formValue = trim($elements[2] ?? '');
                        if ($formType === '1A') {
                            $parsed['additional']['forms'][$currentClaimIndex]['form_1a'] = trim($elements[3] ?? '');
                        } elseif ($formType === '1C') {
                            $parsed['additional']['forms'][$currentClaimIndex]['form_1c'] = trim($elements[3] ?? '');
                        } elseif ($formType === '9') {
                            $parsed['additional']['forms'][$currentClaimIndex]['form_9'] = trim($elements[2] ?? '');
                        }
                        $parsed['additional']['forms'][$currentClaimIndex]['form_data'][$formNum] = $formValue;
                        break;
                    
                // NM1 - Name segments
                case 'NM1':
                    $entityCode = trim($elements[1] ?? '');
                    $data = [
                        'entity_identifier' => $entityCode,
                        'type_qualifier' => trim($elements[2] ?? ''),
                        'last_name' => trim($elements[3] ?? ''),
                        'first_name' => trim($elements[4] ?? ''),
                        'middle_name' => trim($elements[5] ?? ''),
                        'suffix' => trim($elements[7] ?? ''),
                        'id_qualifier' => trim($elements[8] ?? ''),
                        'id_code' => trim($elements[9] ?? ''),
                    ];
                    
                    // Assign to appropriate array based on entity code
                    switch ($entityCode) {
                        case '41': $parsed['submitters'][] = $data; break;
                        case '40': $parsed['payers'][] = $data; break;
                        case '85': $parsed['providers'][] = $data; break;
                        case 'IL': 
                        case 'QC': 
                            if ($currentClaimIndex >= 0) {
                                $parsed['claims'][$currentClaimIndex]['patient'] = $data;
                            }
                            break;
                        case '82': 
                        case '77': 
                            if ($currentClaimIndex >= 0) {
                                $parsed['claims'][$currentClaimIndex]['rendering_provider'] = $data;
                            }
                            break;

                        case '36':
                            $parsed['additional']['36'][$currentClaimIndex] = [
                                'entity_type' => trim($elements[2] ?? ''), // 1=Person, 2=Non-Person
                                'emp_name' => trim($elements[3] ?? ''), // Employer Name
                                'id_qualifier' => trim($elements[8] ?? ''), // FI=Federal Tax Number
                                'id' => trim($elements[9] ?? '') // Employer Tax ID
                            ];
                            break;

                        case 'PR':
                                 $parsed['additional']['PR'][$currentClaimIndex]= [
                                    'other_payer_name' => trim($elements[3] ?? ''),  // Payer name
                                    'policy_number' => trim($elements[9] ?? '')  // Insurance policy number
                                ];
                        break;

                       case 'PW':  // Pickup Location
                        $this->currentLocationType = 'pickup';
                        $this->currentClaimIndex = count($parsed['additional']['pickup_location'] ?? []);
                        $parsed['additional']['pickup_location'][$this->currentClaimIndex] = [
                            'entity_type' => 'PW',
                            'name' => trim($elements[3] ?? ''),
                            'address' => '',  // Will be filled by N3
                            'city' => '',     // Will be filled by N4
                            'state' => '',   // Will be filled by N4
                            'zip' => ''       // Will be filled by N4
                        ];
                        break;
                        
                    case '45':  // Dropoff Location
                        $this->currentLocationType = 'dropoff';
                        $this->currentClaimIndex = count($parsed['additional']['dropoff_location'] ?? []);
                        $parsed['additional']['dropoff_location'][$this->currentClaimIndex] = [
                            'entity_type' => '45',
                            'name' => trim($elements[3] ?? ''),
                            'address' => '',  // Will be filled by N3
                            'city' => '',     // Will be filled by N4
                            'state' => '',    // Will be filled by N4
                            'zip' => ''       // Will be filled by N4
                        ];
                        break;
                        
                    default:
                        // $this->currentLocationType = null;




                    }
                    break;

                     case 'DMG':
                    $dob = trim($elements[2] ?? '');
                    $gender = trim($elements[3] ?? '');
                    
                    // if ($currentClaimIndex >= 0) {
                        $parsed['claims'][$currentClaimIndex]['patientnew']['dob'] = $dob;
                        $parsed['claims'][$currentClaimIndex]['patientnew']['gender'] = $gender;
                    // }
                    break;
                    
                // N3/N4 - Address segments
                case 'N3':
                
                    $address = [
                        'street1' => trim($elements[1] ?? ''),
                        'street2' => trim($elements[2] ?? ''),
                    ];

                     if ($this->currentLocationType === 'pickup') {
                        $parsed['additional']['pickup_location'][$this->currentClaimIndex]['address'] = 
                            trim($elements[1] ?? '');
                    } elseif ($this->currentLocationType === 'dropoff') {
                        // echo json_encode($elements[1]);
                        // echo $this->currentClaimIndex;
                        if($this->currentClaimIndex=="0"){
                            if(!$parsed['additional']['dropoff_location'][$this->currentClaimIndex]['address']){
                            $parsed['additional']['dropoff_location'][$this->currentClaimIndex]['address'] = 
                            trim($elements[1] ?? '');
                        }
                        }else{
                            $parsed['additional']['dropoff_location'][$this->currentClaimIndex]['address'] = 
                            trim($elements[1] ?? '');

                        }
                    }
                   
                    
                    // Attach to the most recent entity
                    $this->attachAddress($parsed, $address, false);
                    break;
                    
                case 'N4':
                    $address = [
                        'city' => trim($elements[1] ?? ''),
                        'state' => trim($elements[2] ?? ''),
                        'zip' => trim($elements[3] ?? ''),
                        'country' => trim($elements[4] ?? ''),
                    ];


                    if ($this->currentLocationType === 'pickup') {
                        $parsed['additional']['pickup_location'][$this->currentClaimIndex]['city'] = 
                            trim($elements[1] ?? '');
                        $parsed['additional']['pickup_location'][$this->currentClaimIndex]['state'] = 
                            trim($elements[2] ?? '');
                        $parsed['additional']['pickup_location'][$this->currentClaimIndex]['zip'] = 
                            trim($elements[3] ?? '');
                    } elseif ($this->currentLocationType === 'dropoff') {
                        $parsed['additional']['dropoff_location'][$this->currentClaimIndex]['city'] = 
                            trim($elements[1] ?? '');
                        $parsed['additional']['dropoff_location'][$this->currentClaimIndex]['state'] = 
                            trim($elements[2] ?? '');
                        $parsed['additional']['dropoff_location'][$this->currentClaimIndex]['zip'] = 
                            trim($elements[3] ?? '');
                    }

                   
                    
                    $this->attachAddress($parsed, $address, true);

                    break;



                    case 'CR2':
                        $spinalRegion = $elements[8] ?? ''; // 10th element (0-indexed as 9)
                        $condition = $elements[10] ?? '';   // 12th element
                        
                        $parsed['additional']['chiropractic'][$currentClaimIndex] = [
                            'spinal_region' => $spinalRegion,
                            'condition' => $condition
                        ];
                        break;





                    case 'PWK':
                        $parsed['additional']['dme_documentation'][$currentClaimIndex] = [
                            'documentation_type' => $elements[1] ?? '',
                            'transmission_code' => $elements[2] ?? ''
                        ];
                    break;

                    case 'CR3':
                        $parsed['additional']['dme_certification'][$currentClaimIndex] = [
                            'certification_type' => $elements[1] ?? '',
                            'equipment_type' => $elements[2] ?? '',
                            'quantity' => $elements[3] ?? ''
                        ];
                    break;


                    case 'LIN':
                        // Handle drug/NDC information in additional section
                        if (($elements[1] ?? '') === '' && ($elements[2] ?? '') === 'N4') {
                            $parsed['additional']['ndc_info'][$currentClaimIndex] = [
                                'code' => trim($elements[3] ?? ''),
                                'quantity' => '',       // Will be filled by CTP segment
                                'unit' => ''            // Will be filled by CTP segment
                            ];
                        }
                        break;

                    case 'CTP':
                    // dd($elements);
                        // Handle drug pricing/quantity information in additional section
                        if (isset($parsed['additional']['ndc_info'][$currentClaimIndex])) {
                            $parsed['additional']['ndc_info'][$currentClaimIndex]['quantity'] = trim($elements[5] ?? '');
                            $parsed['additional']['ndc_info'][$currentClaimIndex]['unit'] = trim($elements[4] ?? '');
                        }
                        break;




                 // CR1 - Transport Details (New)
                    case 'CR1':
                        $transportReason = explode('*', $elements[4] ?? '');
                        $parsed['additional']['transport'][$currentClaimIndex] = [
                            'transport_type' => trim($elements[1] ?? ''),       // 'LB' (stretcher)
                            'mileage' => trim($elements[2] ?? ''),              // e.g., '50' (no decimal)
                            'reason_code' => trim($transportReason[0] ?? ''),   // 'A' or 'B'
                            'reason_description' => trim($transportReason[1] ?? ''), // 'DH' or 'NH'
                            'qualifier' => trim($elements[5] ?? ''),            // '21'
                            'patient_condition' => trim($elements[9] ?? ''),    // 'PATIENT IMMOBILIZED'
                        ];
                        break;
                    
                // SBR - Subscriber Information
                case 'SBR':
                    if ($currentClaimIndex >= 0) {
                        $parsed['claims'][$currentClaimIndex]['subscriber_info'] = [
                            'payer_responsibility' => trim($elements[1] ?? ''),
                            'group_number' => trim($elements[3] ?? ''),
                            'group_name' => trim($elements[4] ?? ''),
                            'insurance_type' => trim($elements[5] ?? ''),
                        ];
                    }
                    break;
                    
                // CLM - Claim Information
                case 'CLM':
                    if ($currentClaimIndex >= 0) {
                        $parsed['claims'][$currentClaimIndex]['claim_info'] = [
                            'number' => trim($elements[1] ?? ''),
                            'amount' => trim($elements[2] ?? ''),
                            'place_of_service' => trim($elements[4] ?? ''),
                            'type' => trim($elements[5] ?? ''),
                            'facility_type' => trim($elements[6] ?? ''),
                        ];
                    }
                    break;
                    
                // HI - Diagnosis Codes
                case 'HI':
                    if ($currentClaimIndex >= 0) {
                        $diagnosisCodes = [];
                        for ($i = 1; $i < count($elements); $i++) {
                            if (!empty(trim($elements[$i]))) {
                                $codeParts = explode(':', trim($elements[$i]));
                                if (count($codeParts) > 1) {
                                    $diagnosisCodes[] = [
                                        'type' => $codeParts[0],
                                        'code' => $codeParts[1],
                                    ];
                                }
                            }
                        }
                        $parsed['claims'][$currentClaimIndex]['diagnosis_codes'] = $diagnosisCodes;
                    }
                    break;
                    
                // LX - Service Line Number
                case 'LX':
                    if ($currentClaimIndex >= 0) {
                        $currentServiceIndex++;
                        $parsed['claims'][$currentClaimIndex]['services'][$currentServiceIndex] = [
                            'line_number' => trim($elements[1] ?? ''),
                        ];
                    }
                    break;
                    
                // // SV1/SV3 - Service Line Details
                // case 'SV1':
                // case 'SV2':
                // case 'SV3':
                //     if ($currentClaimIndex >= 0 && $currentServiceIndex >= 0) {
                //         $procedure = explode(':', trim($elements[1] ?? ''));
                //         $parsed['claims'][$currentClaimIndex]['services'][$currentServiceIndex]['service'] = [
                //             'code' => $procedure[1] ?? '',
                //             'modifier' => $procedure[2] ?? '',
                //             'amount' => trim($elements[2] ?? ''),
                //             'units' => trim($elements[4] ?? ''),
                //             'diagnosis_pointer' => trim($elements[7] ?? ''),
                //         ];
                //     }
                //     break;

                    case 'SV1':
                    case 'SV2':
                    case 'SV3':
                        if ($currentClaimIndex >= 0 && $currentServiceIndex >= 0) {
                            $serviceData = [];
                            
                            // Common for all service types
                            $procedureParts = explode(':', trim($elements[1] ?? ''));
                            
                            // Handle different segment structures
                            if ($segmentId === 'SV1') {
                                // SV1*HC:99213*100.00*UN*1***1~
                                $serviceData = [
                                    'type' => 'SV1',
                                    'code' => $procedureParts[1] ?? '',
                                    'modifier' => $procedureParts[2] ?? '',
                                    'amount' => trim($elements[2] ?? ''),
                                    'units' => trim($elements[4] ?? ''),
                                    'diagnosis_pointer' => trim($elements[7] ?? ''),
                                ];
                            } 
                            elseif ($segmentId === 'SV2') {
                                // SV2*0300*HC:99213*150.00*DA*1~
                                $serviceData = [
                                    'type' => 'SV2',
                                    'revenue_code' => trim($elements[1] ?? ''), // 0300
                                    'code' => $procedureParts[1] ?? '',         // From HC:99213
                                    'modifier' => $procedureParts[2] ?? '',
                                    'amount' => trim($elements[3] ?? ''),      // 150.00
                                    'units' => trim($elements[5] ?? ''),        // 1
                                ];
                            } 
                            elseif ($segmentId === 'SV3') {
                                // SV3*AD:99213*150.00*UN*1~
                                $serviceData = [
                                    'type' => 'SV3',
                                    'code' => $procedureParts[1] ?? '',
                                    'modifier' => $procedureParts[2] ?? '',
                                    'amount' => trim($elements[2] ?? ''),
                                    'units' => trim($elements[4] ?? ''),
                                ];
                            }
                            
                            // Add service line notes if present (common for all types)
                            if (isset($elements[6])) {
                                $serviceData['notes'] = trim($elements[6]);
                            }
                            
                            $parsed['claims'][$currentClaimIndex]['services'][$currentServiceIndex]['service'] = $serviceData;
                        }
                        break;
                                   



                // // DTP - Service Dates
                // case 'DTP':
                //     if ($currentClaimIndex >= 0) {
                //         $dateType = trim($elements[1] ?? '');
                //         $dateFormat = trim($elements[2] ?? '');
                //         $dateValue = trim($elements[3] ?? '');
                        
                //         if ($currentServiceIndex >= 0) {
                //             // Service line date
                //             $parsed['claims'][$currentClaimIndex]['services'][$currentServiceIndex]['dates'][] = [
                //                 'type' => $dateType,
                //                 'date' => $dateValue,
                //                 'format' => $dateFormat,
                //             ];
                //         } else {
                //             // Claim level date
                //             $parsed['claims'][$currentClaimIndex]['dates'][] = [
                //                 'type' => $dateType,
                //                 'date' => $dateValue,
                //                 'format' => $dateFormat,
                //             ];
                //         }
                //     }
                //     break;

                    case 'DTP':
                        $dateType = trim($elements[1] ?? '');
                        $dateFormat = trim($elements[2] ?? '');
                        $dateValue = trim($elements[3] ?? '');
                        
                        // 1. First check for Oxygen/DME specific dates
                        $dmeDateTypes = ['472', '607', '463', '461']; // Service, Cert Start, Last Cert, Recert
                        if (in_array($dateType, $dmeDateTypes)) {
                            $dateMap = [
                                '472' => 'service_date',
                                '607' => 'certification_start_date',
                                '463' => 'last_certification_date',
                                '461' => 'recertification_date'
                            ];
                            
                            $parsed['additional']['dme_dates'][$currentClaimIndex][$dateMap[$dateType]] = $this->formatEdiDate($dateValue, $dateFormat);
                        }
                        // 2. Then handle your existing service/claim dates
                        elseif ($currentClaimIndex >= 0) {
                            if ($currentServiceIndex >= 0) {
                                // Service line date
                                $parsed['claims'][$currentClaimIndex]['services'][$currentServiceIndex]['dates'][] = [
                                    'type' => $dateType,
                                    'date' => $dateValue,
                                    'format' => $dateFormat,
                                ];
                            } else {
                                // Claim level date
                                $parsed['claims'][$currentClaimIndex]['dates'][] = [
                                    'type' => $dateType,
                                    'date' => $dateValue,
                                    'format' => $dateFormat,
                                ];
                            }
                        }
                        break;
                    
                // TOO - Tooth Information (Dental)
                case 'TOO':
                    if ($currentClaimIndex >= 0 && $currentServiceIndex >= 0 && $parsed['meta']['edi_type'] === 'D') {
                        $parsed['claims'][$currentClaimIndex]['services'][$currentServiceIndex]['tooth_info'] = [
                            'code' => trim($elements[1] ?? ''),
                            'number' => trim($elements[2] ?? ''),
                        ];
                    }
                    break;
                    
                // CL1 - Institutional Claim Info
                case 'CL1':
                    if ($currentClaimIndex >= 0 && $parsed['meta']['edi_type'] === 'I') {
                        $parsed['claims'][$currentClaimIndex]['institutional_info'] = [
                            'admission_type' => trim($elements[1] ?? ''),
                            'admission_source' => trim($elements[2] ?? ''),
                            'patient_status' => trim($elements[3] ?? ''),
                        ];
                    }
                    break;
                    
                // DMG - Demographic Information
                case 'DMG':
                    $dob = trim($elements[2] ?? '');
                    $gender = trim($elements[3] ?? '');
                    
                    // if ($currentClaimIndex >= 0) {
                        $parsed['claims'][$currentClaimIndex]['patient']['dob'] = $dob;
                        $parsed['claims'][$currentClaimIndex]['patient']['gender'] = $gender;
                    // }
                    break;
            }
        }
        
        return $parsed;
    }
    
    /**
     * Helper method to attach address information to the most recent entity
     */
    private function attachAddress(&$parsed, $address, $isN4)
    {

    

        // Check claims first (patient/provider addresses)
        if (!empty($parsed['claims'])) {
            $lastClaim = end($parsed['claims']);
            
            if (isset($lastClaim['patient']) && !isset($lastClaim['patient']['address'])) {
                $lastClaim['patient']['address'] = $address;
                $parsed['claims'][key($parsed['claims'])] = $lastClaim;
                return;
            }
            
            if (isset($lastClaim['rendering_provider']) && !isset($lastClaim['rendering_provider']['address'])) {
                $lastClaim['rendering_provider']['address'] = $address;
                $parsed['claims'][key($parsed['claims'])] = $lastClaim;
                return;
            }
        }
        
        // Check providers
        if (!empty($parsed['providers'])) {
            $lastProvider = end($parsed['providers']);
            if (!isset($lastProvider['address'])) {
                $lastProvider['address'] = $address;
                $parsed['providers'][key($parsed['providers'])] = $lastProvider;
                return;
            } elseif (!$isN4) {
                // Merge N3 with existing N4
                $lastProvider['address'] = array_merge($lastProvider['address'], $address);
                $parsed['providers'][key($parsed['providers'])] = $lastProvider;
                return;
            }
        }
        
        // Check payers
        if (!empty($parsed['payers'])) {
            $lastPayer = end($parsed['payers']);
            if (!isset($lastPayer['address'])) {
                $lastPayer['address'] = $address;
                $parsed['payers'][key($parsed['payers'])] = $lastPayer;
                return;
            } elseif (!$isN4) {
                $lastPayer['address'] = array_merge($lastPayer['address'], $address);
                $parsed['payers'][key($parsed['payers'])] = $lastPayer;
                return;
            }
        }
    }




    private function formatEdiDate($dateValue, $dateFormat)
    {
        if ($dateFormat === 'D8') {
            // Format YYYYMMDD to YYYY-MM-DD
            return preg_replace('/^(\d{4})(\d{2})(\d{2})$/', '$1-$2-$3', $dateValue);
        } elseif ($dateFormat === 'RD8') {
            // Date range - handle accordingly
            return $dateValue; // Or implement specific range formatting
        }
        return $dateValue;
    }








  // private function parseEdi837($ediContent)
  //   {
  //       $segments = explode('~', $ediContent);
  //       $parsed = [
  //           'meta' => [
  //               'edi_type' => null,
  //               'interchange' => [],
  //               'functional_group' => [],
  //           ],
  //           'submitters' => [],
  //           'providers' => [],
  //           'payers' => [],
  //           'subscribers' => [],
  //           'patients' => [],
  //           'claims' => [],
  //       ];

  //       $currentClaimIndex = -1;
  //       $currentServiceIndex = -1;
  //       $currentLoopLevel = 0;
  //       $currentLoopId = null;

  //       foreach ($segments as $segment) {
  //           $segment = trim($segment);
  //           if (empty($segment)) continue;
            
  //           $elements = explode('*', $segment);
  //           $segmentId = $elements[0];
            
  //           switch ($segmentId) {
  //               // ISA - Interchange Control Header
  //               case 'ISA':
  //                   $parsed['meta']['interchange'] = [
  //                       'sender_id' => trim($elements[6] ?? ''),
  //                       'receiver_id' => trim($elements[8] ?? ''),
  //                       'date' => trim($elements[9] ?? ''),
  //                       'time' => trim($elements[10] ?? ''),
  //                       'control_number' => trim($elements[13] ?? ''),
  //                   ];
  //                   break;
                    
  //               // GS - Functional Group Header
  //               case 'GS':
  //                   $version = trim($elements[8] ?? '');
  //                   $parsed['meta']['edi_type'] = match($version) {
  //                       '005010X223A2' => 'I', // Institutional
  //                       '005010X224A2' => 'D',  // Dental
  //                       '005010X222A1' => 'P',  // Professional
  //                       default => 'U'          // Unknown
  //                   };
                    
  //                   $parsed['meta']['functional_group'] = [
  //                       'sender_code' => trim($elements[2] ?? ''),
  //                       'receiver_code' => trim($elements[3] ?? ''),
  //                       'date' => trim($elements[4] ?? ''),
  //                       'time' => trim($elements[5] ?? ''),
  //                       'control_number' => trim($elements[6] ?? ''),
  //                       'version' => $version,
  //                   ];
  //                   break;
                    
  //               // ST - Transaction Set Header
  //               case 'ST':
  //                   $parsed['meta']['transaction_set'] = [
  //                       'id' => trim($elements[1] ?? ''),
  //                       'control_number' => trim($elements[2] ?? ''),
  //                   ];
  //                   break;
                    
  //               // BHT - Beginning of Hierarchical Transaction
  //               case 'BHT':
  //                   $parsed['meta']['hierarchical_transaction'] = [
  //                       'purpose_code' => trim($elements[2] ?? ''),
  //                       'reference_id' => trim($elements[3] ?? ''),
  //                       'date' => trim($elements[4] ?? ''),
  //                       'time' => trim($elements[5] ?? ''),
  //                   ];
  //                   break;
                    
  //               // HL - Hierarchical Level
  //               case 'HL':
  //                   $currentLoopLevel = (int)($elements[3] ?? 0);
  //                   $currentLoopId = trim($elements[1] ?? '');
                    
  //                   // If this is a claim level (typically HL*2 or HL*3 depending on EDI type)
  //                   if ($currentLoopLevel >= 2) {
  //                       $currentClaimIndex++;
  //                       $currentServiceIndex = -1;
                        
  //                       $parsed['claims'][$currentClaimIndex] = [
  //                           'loop_id' => $currentLoopId,
  //                           'level' => $currentLoopLevel,
  //                           'services' => [],
  //                           'type' => $parsed['meta']['edi_type'],
  //                       ];
  //                   }
  //                   break;
                    
  //               // NM1 - Name segments
  //               case 'NM1':
  //                   $entityCode = trim($elements[1] ?? '');
  //                   $data = [
  //                       'entity_identifier' => $entityCode,
  //                       'type_qualifier' => trim($elements[2] ?? ''),
  //                       'last_name' => trim($elements[3] ?? ''),
  //                       'first_name' => trim($elements[4] ?? ''),
  //                       'middle_name' => trim($elements[5] ?? ''),
  //                       'suffix' => trim($elements[7] ?? ''),
  //                       'id_qualifier' => trim($elements[8] ?? ''),
  //                       'id_code' => trim($elements[9] ?? ''),
  //                   ];
                    
  //                   // Assign to appropriate array based on entity code
  //                   switch ($entityCode) {
  //                       case '41': $parsed['submitters'][] = $data; break;
  //                       case '40': $parsed['payers'][] = $data; break;
  //                       case '85': $parsed['providers'][] = $data; break;
  //                       case 'IL': 
  //                       case 'QC': 
  //                           if ($currentClaimIndex >= 0) {
  //                               $parsed['claims'][$currentClaimIndex]['patient'] = $data;
  //                           }
  //                           break;
  //                       case '82': 
  //                       case '77': 
  //                           if ($currentClaimIndex >= 0) {
  //                               $parsed['claims'][$currentClaimIndex]['rendering_provider'] = $data;
  //                           }
  //                           break;
  //                   }
  //                   break;
                    
  //               // N3/N4 - Address segments
  //               case 'N3':
  //                   $address = [
  //                       'street1' => trim($elements[1] ?? ''),
  //                       'street2' => trim($elements[2] ?? ''),
  //                   ];
                    
  //                   // Attach to the most recent entity
  //                   $this->attachAddress($parsed, $address, false);
  //                   break;
                    
  //               case 'N4':
  //                   $address = [
  //                       'city' => trim($elements[1] ?? ''),
  //                       'state' => trim($elements[2] ?? ''),
  //                       'zip' => trim($elements[3] ?? ''),
  //                       'country' => trim($elements[4] ?? ''),
  //                   ];
                    
  //                   $this->attachAddress($parsed, $address, true);
  //                   break;
                    
  //               // SBR - Subscriber Information
  //               case 'SBR':
  //                   if ($currentClaimIndex >= 0) {
  //                       $parsed['claims'][$currentClaimIndex]['subscriber_info'] = [
  //                           'payer_responsibility' => trim($elements[1] ?? ''),
  //                           'group_number' => trim($elements[3] ?? ''),
  //                           'group_name' => trim($elements[4] ?? ''),
  //                           'insurance_type' => trim($elements[5] ?? ''),
  //                       ];
  //                   }
  //                   break;
                    
  //               // CLM - Claim Information
  //               case 'CLM':
  //                   if ($currentClaimIndex >= 0) {
  //                       $parsed['claims'][$currentClaimIndex]['claim_info'] = [
  //                           'number' => trim($elements[1] ?? ''),
  //                           'amount' => trim($elements[2] ?? ''),
  //                           'place_of_service' => trim($elements[4] ?? ''),
  //                           'type' => trim($elements[5] ?? ''),
  //                           'facility_type' => trim($elements[6] ?? ''),
  //                       ];
  //                   }
  //                   break;
                    
  //               // HI - Diagnosis Codes
  //               case 'HI':
  //                   if ($currentClaimIndex >= 0) {
  //                       $diagnosisCodes = [];
  //                       for ($i = 1; $i < count($elements); $i++) {
  //                           if (!empty(trim($elements[$i]))) {
  //                               $codeParts = explode(':', trim($elements[$i]));
  //                               if (count($codeParts) > 1) {
  //                                   $diagnosisCodes[] = [
  //                                       'type' => $codeParts[0],
  //                                       'code' => $codeParts[1],
  //                                   ];
  //                               }
  //                           }
  //                       }
  //                       $parsed['claims'][$currentClaimIndex]['diagnosis_codes'] = $diagnosisCodes;
  //                   }
  //                   break;
                    
  //               // LX - Service Line Number
  //               case 'LX':
  //                   if ($currentClaimIndex >= 0) {
  //                       $currentServiceIndex++;
  //                       $parsed['claims'][$currentClaimIndex]['services'][$currentServiceIndex] = [
  //                           'line_number' => trim($elements[1] ?? ''),
  //                       ];
  //                   }
  //                   break;
                    
  //               // // SV1/SV3 - Service Line Details
  //               // case 'SV1':
  //               // case 'SV2':
  //               // case 'SV3':
  //               //     if ($currentClaimIndex >= 0 && $currentServiceIndex >= 0) {
  //               //         $procedure = explode(':', trim($elements[1] ?? ''));
  //               //         $parsed['claims'][$currentClaimIndex]['services'][$currentServiceIndex]['service'] = [
  //               //             'code' => $procedure[1] ?? '',
  //               //             'modifier' => $procedure[2] ?? '',
  //               //             'amount' => trim($elements[2] ?? ''),
  //               //             'units' => trim($elements[4] ?? ''),
  //               //             'diagnosis_pointer' => trim($elements[7] ?? ''),
  //               //         ];
  //               //     }
  //               //     break;

  //                   case 'SV1':
  //                   case 'SV2':
  //                   case 'SV3':
  //                       if ($currentClaimIndex >= 0 && $currentServiceIndex >= 0) {
  //                           $serviceData = [];
                            
  //                           // Common for all service types
  //                           $procedureParts = explode(':', trim($elements[1] ?? ''));
                            
  //                           // Handle different segment structures
  //                           if ($segmentId === 'SV1') {
  //                               // SV1*HC:99213*100.00*UN*1***1~
  //                               $serviceData = [
  //                                   'type' => 'SV1',
  //                                   'code' => $procedureParts[1] ?? '',
  //                                   'modifier' => $procedureParts[2] ?? '',
  //                                   'amount' => trim($elements[2] ?? ''),
  //                                   'units' => trim($elements[4] ?? ''),
  //                                   'diagnosis_pointer' => trim($elements[7] ?? ''),
  //                               ];
  //                           } 
  //                           elseif ($segmentId === 'SV2') {
  //                               // SV2*0300*HC:99213*150.00*DA*1~
  //                               $serviceData = [
  //                                   'type' => 'SV2',
  //                                   'revenue_code' => trim($elements[1] ?? ''), // 0300
  //                                   'code' => $procedureParts[1] ?? '',         // From HC:99213
  //                                   'modifier' => $procedureParts[2] ?? '',
  //                                   'amount' => trim($elements[3] ?? ''),      // 150.00
  //                                   'units' => trim($elements[5] ?? ''),        // 1
  //                               ];
  //                           } 
  //                           elseif ($segmentId === 'SV3') {
  //                               // SV3*AD:99213*150.00*UN*1~
  //                               $serviceData = [
  //                                   'type' => 'SV3',
  //                                   'code' => $procedureParts[1] ?? '',
  //                                   'modifier' => $procedureParts[2] ?? '',
  //                                   'amount' => trim($elements[2] ?? ''),
  //                                   'units' => trim($elements[4] ?? ''),
  //                               ];
  //                           }
                            
  //                           // Add service line notes if present (common for all types)
  //                           if (isset($elements[6])) {
  //                               $serviceData['notes'] = trim($elements[6]);
  //                           }
                            
  //                           $parsed['claims'][$currentClaimIndex]['services'][$currentServiceIndex]['service'] = $serviceData;
  //                       }
  //                       break;
                                   



  //               // DTP - Service Dates
  //               case 'DTP':
  //                   if ($currentClaimIndex >= 0) {
  //                       $dateType = trim($elements[1] ?? '');
  //                       $dateFormat = trim($elements[2] ?? '');
  //                       $dateValue = trim($elements[3] ?? '');
                        
  //                       if ($currentServiceIndex >= 0) {
  //                           // Service line date
  //                           $parsed['claims'][$currentClaimIndex]['services'][$currentServiceIndex]['dates'][] = [
  //                               'type' => $dateType,
  //                               'date' => $dateValue,
  //                               'format' => $dateFormat,
  //                           ];
  //                       } else {
  //                           // Claim level date
  //                           $parsed['claims'][$currentClaimIndex]['dates'][] = [
  //                               'type' => $dateType,
  //                               'date' => $dateValue,
  //                               'format' => $dateFormat,
  //                           ];
  //                       }
  //                   }
  //                   break;
                    
  //               // TOO - Tooth Information (Dental)
  //               case 'TOO':
  //                   if ($currentClaimIndex >= 0 && $currentServiceIndex >= 0 && $parsed['meta']['edi_type'] === 'D') {
  //                       $parsed['claims'][$currentClaimIndex]['services'][$currentServiceIndex]['tooth_info'] = [
  //                           'code' => trim($elements[1] ?? ''),
  //                           'number' => trim($elements[2] ?? ''),
  //                       ];
  //                   }
  //                   break;
                    
  //               // CL1 - Institutional Claim Info
  //               case 'CL1':
  //                   if ($currentClaimIndex >= 0 && $parsed['meta']['edi_type'] === 'I') {
  //                       $parsed['claims'][$currentClaimIndex]['institutional_info'] = [
  //                           'admission_type' => trim($elements[1] ?? ''),
  //                           'admission_source' => trim($elements[2] ?? ''),
  //                           'patient_status' => trim($elements[3] ?? ''),
  //                       ];
  //                   }
  //                   break;
                    
  //               // DMG - Demographic Information
  //               case 'DMG':
  //                   $dob = trim($elements[2] ?? '');
  //                   $gender = trim($elements[3] ?? '');
                    
  //                   if ($currentClaimIndex >= 0) {
  //                       $parsed['claims'][$currentClaimIndex]['patient']['dob'] = $dob;
  //                       $parsed['claims'][$currentClaimIndex]['patient']['gender'] = $gender;
  //                   }
  //                   break;
  //           }
  //       }
        
  //       return $parsed;
  //   }
    
  //   /**
  //    * Helper method to attach address information to the most recent entity
  //    */
  //   private function attachAddress(&$parsed, $address, $isN4)
  //   {
  //       // Check claims first (patient/provider addresses)
  //       if (!empty($parsed['claims'])) {
  //           $lastClaim = end($parsed['claims']);
            
  //           if (isset($lastClaim['patient']) && !isset($lastClaim['patient']['address'])) {
  //               $lastClaim['patient']['address'] = $address;
  //               $parsed['claims'][key($parsed['claims'])] = $lastClaim;
  //               return;
  //           }
            
  //           if (isset($lastClaim['rendering_provider']) && !isset($lastClaim['rendering_provider']['address'])) {
  //               $lastClaim['rendering_provider']['address'] = $address;
  //               $parsed['claims'][key($parsed['claims'])] = $lastClaim;
  //               return;
  //           }
  //       }
        
  //       // Check providers
  //       if (!empty($parsed['providers'])) {
  //           $lastProvider = end($parsed['providers']);
  //           if (!isset($lastProvider['address'])) {
  //               $lastProvider['address'] = $address;
  //               $parsed['providers'][key($parsed['providers'])] = $lastProvider;
  //               return;
  //           } elseif (!$isN4) {
  //               // Merge N3 with existing N4
  //               $lastProvider['address'] = array_merge($lastProvider['address'], $address);
  //               $parsed['providers'][key($parsed['providers'])] = $lastProvider;
  //               return;
  //           }
  //       }
        
  //       // Check payers
  //       if (!empty($parsed['payers'])) {
  //           $lastPayer = end($parsed['payers']);
  //           if (!isset($lastPayer['address'])) {
  //               $lastPayer['address'] = $address;
  //               $parsed['payers'][key($parsed['payers'])] = $lastPayer;
  //               return;
  //           } elseif (!$isN4) {
  //               $lastPayer['address'] = array_merge($lastPayer['address'], $address);
  //               $parsed['payers'][key($parsed['payers'])] = $lastPayer;
  //               return;
  //           }
  //       }
  //   }
































// ============================================================================= //
    // for 275


public function view_sftp_275_file_data($id)
{
    $file = SftpEdiModel::findOrFail($id);
    $ediContent = $file->file_string;
    
    $parsedData = $this->parseEdi275($ediContent);
    // dd($parsedData);
    
    return view('sftp.view_sftp_275_file_data', [
        'data' => $parsedData,
        'originalContent' => $ediContent,
         'file'=>$file
    ]);
}



private function parseEdi275($ediContent)
{
    $segments = explode('~', $ediContent);
    $parsed = [];
    
    foreach ($segments as $segment) {
        $segment = trim($segment);
        if (empty($segment)) continue;
        
        $elements = explode('*', $segment);
        $segmentId = $elements[0] ?? '';
        
        try {
            switch ($segmentId) {
                // ISA - Interchange Control Header
                case 'ISA':
                    $parsed['isa'] = [
                        'sender_id' => trim($elements[6] ?? ''),
                        'receiver_id' => trim($elements[8] ?? ''),
                        'transmission_date' => trim($elements[9] ?? ''),
                        'transmission_time' => trim($elements[10] ?? ''),
                        'control_number' => trim($elements[13] ?? ''),
                    ];
                    break;
                    
                // GS - Functional Group Header
                case 'GS':
                    $parsed['gs'] = [
                        'functional_id_code' => trim($elements[1] ?? ''),
                        'sender_code' => trim($elements[2] ?? ''),
                        'receiver_code' => trim($elements[3] ?? ''),
                        'date' => trim($elements[4] ?? ''),
                        'time' => trim($elements[5] ?? ''),
                        'control_number' => trim($elements[6] ?? ''),
                        'responsible_agency' => trim($elements[7] ?? ''),
                        'version' => trim($elements[8] ?? '')
                    ];
                    break;
                    
                // ST - Transaction Set Header (with optional elements)
                case 'ST':
                    $stData = [
                        'transaction_set_id' => trim($elements[1] ?? ''),
                        'control_number' => trim($elements[2] ?? '')
                    ];
                    
                    if (isset($elements[3])) {
                        $stData['implementation_convention'] = trim($elements[3]);
                    }
                    $parsed['st'] = $stData;
                    break;
                    
                // BHT - Beginning of Hierarchical Transaction
                case 'BHT':
                    $parsed['bht'] = [
                        'hierarchical_structure_code' => trim($elements[1] ?? ''),
                        'transaction_purpose_code' => trim($elements[2] ?? ''),
                        'reference_identification' => trim($elements[3] ?? ''),
                        'date' => trim($elements[4] ?? ''),
                        'time' => trim($elements[5] ?? ''),
                        'transaction_type_code' => trim($elements[6] ?? '')
                    ];
                    break;
                    
                // Information Source (NM1*41)
                case 'NM1':
                    if (($elements[1] ?? '') == '41') {
                        $parsed['submitter'] = [
                            'entity_identifier_code' => trim($elements[1] ?? ''),
                            'entity_type_qualifier' => trim($elements[2] ?? ''),
                            'name' => trim($elements[3] ?? '') . ' ' . trim($elements[4] ?? ''),
                            'identification_code_qualifier' => trim($elements[8] ?? ''),
                            'identification_code' => trim($elements[9] ?? '')
                        ];
                    }
                    // Information Receiver (NM1*40)
                    elseif (($elements[1] ?? '') == '40') {
                        $parsed['receiver'] = [
                            'entity_identifier_code' => trim($elements[1] ?? ''),
                            'entity_type_qualifier' => trim($elements[2] ?? ''),
                            'name' => trim($elements[3] ?? '') . ' ' . trim($elements[4] ?? ''),
                            'identification_code_qualifier' => trim($elements[8] ?? ''),
                            'identification_code' => trim($elements[9] ?? '')
                        ];
                    }
                    // Patient (NM1*QC)
                    elseif (($elements[1] ?? '') == 'QC') {
                        $parsed['patient'] = [
                            'last_name' => trim($elements[3] ?? ''),
                            'first_name' => trim($elements[4] ?? ''),
                            'member_id' => trim($elements[9] ?? '')
                        ];
                    }
                    // Subscriber (NM1*IL)
                    elseif (($elements[1] ?? '') == 'IL') {
                        $parsed['subscriber'] = [
                            'last_name' => trim($elements[3] ?? ''),
                            'first_name' => trim($elements[4] ?? ''),
                            'member_id' => trim($elements[9] ?? '')
                        ];
                    }
                    break;
                    
                // Address (N3)
                case 'N3':
                    $address = ['street' => trim($elements[1] ?? '')];
                    if (isset($elements[2])) {
                        $address['street2'] = trim($elements[2]);
                    }
                    if (isset($parsed['subscriber'])) {
                        $parsed['subscriber']['address'] = $address;
                    } elseif (isset($parsed['patient'])) {
                        $parsed['patient']['address'] = $address;
                    }
                    break;
                    
                // Geographic Location (N4)
                case 'N4':
                    $location = [
                        'city' => trim($elements[1] ?? ''),
                        'state' => trim($elements[2] ?? ''),
                        'zip' => trim($elements[3] ?? '')
                    ];
                    if (isset($parsed['subscriber'])) {
                        $parsed['subscriber']['location'] = $location;
                    } elseif (isset($parsed['patient'])) {
                        $parsed['patient']['location'] = $location;
                    }
                    break;
                    
                // Claim Payment (CLP)
                case 'CLP':
                    $parsed['claim'] = [
                        'claim_number' => trim($elements[1] ?? ''),
                        'status_code' => trim($elements[2] ?? ''),
                        'amount_charged' => trim($elements[3] ?? ''),
                        'amount_paid' => trim($elements[4] ?? ''),
                        'payer_identifier' => trim($elements[6] ?? ''),
                        'patient_id' => trim($elements[7] ?? '')
                    ];
                    break;
                    
                // Service Date (DTM)
                case 'DTM':
                    if (($elements[1] ?? '') == '232') {
                        $parsed['service_date'] = [
                            'start_date' => trim($elements[2] ?? '')
                        ];
                    } elseif (($elements[1] ?? '') == '233') {
                        $parsed['service_date']['end_date'] = trim($elements[2] ?? '');
                    }
                    break;
                    
                // SE - Transaction Set Trailer
                case 'SE':
                    $parsed['se'] = [
                        'segment_count' => trim($elements[1] ?? ''),
                        'control_number' => trim($elements[2] ?? '')
                    ];
                    break;
                    
                // GE - Functional Group Trailer
                case 'GE':
                    $parsed['ge'] = [
                        'number_of_transaction_sets' => trim($elements[1] ?? ''),
                        'control_number' => trim($elements[2] ?? '')
                    ];
                    break;
                    
                // IEA - Interchange Control Trailer
                case 'IEA':
                    $parsed['iea'] = [
                        'number_of_functional_groups' => trim($elements[1] ?? ''),
                        'control_number' => trim($elements[2] ?? '')
                    ];
                    break;
                    
                // Handle other segments generically if needed
                default:
                    if (!isset($parsed['other_segments'])) {
                        $parsed['other_segments'] = [];
                    }
                    $parsed['other_segments'][$segmentId] = array_slice($elements, 1);
                    break;
            }
        } catch (\Exception $e) {
            // Log error but continue processing
            \Log::error("Error parsing EDI segment {$segmentId}: " . $e->getMessage());
            continue;
        }
    }
    
    return $parsed;
}




}

