<?php

namespace App\Http\Controllers\Multiple;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Carbon\Carbon;
use App\Models\User;
use Hash;
use Auth;
use App\Models\EdiFileModel;
use App\Models\Acknowledge999FileModel;
use Illuminate\Support\Facades\Storage;
use DateTime;

class MultipleEdiPController extends Controller
{


    public function create_multiple_edip_form(){
        return view('multiple.create_multiple_edip_form');
    }






    public function generate837P(Request $request)
    {
        // dd($request->all());
        // Validate the request data
        $validated = $request->validate([
            // Transmission Info
            'sender_id' => 'required|string|max:15',
            'receiver_id' => 'required|string|max:15',
            'control_number' => 'required|string|max:9',
            
            // Submitter Info
            'submitter_name' => 'required|string|max:60',
            'submitter_id' => 'required|string|max:15',
            'submitter_contact' => 'required|string|max:60',
            'submitter_phone' => 'required',
            
            // Payer Info
            'payer_name' => 'required|string|max:60',
            'payer_id' => 'required|string|max:15',
            
            // Provider Info
            'provider_name' => 'required|string|max:60',
            'provider_npi' => 'required|digits:10',
            'provider_tax_id' => 'required|string|max:9',
            'provider_street' => 'required|string|max:55',
            'provider_city' => 'required|string|max:30',
            'provider_state' => 'required|string|size:2',
            'provider_zip' => 'required|string|max:15',
            
            // Claims
            'claims' => 'required|array|min:1',
            'claims.*.subscriber_last_name' => 'required|string|max:60',
            'claims.*.subscriber_first_name' => 'required|string|max:35',
            'claims.*.member_id' => 'required|string|max:20',
            'claims.*.subscriber_dob' => 'required|date_format:Y-m-d',
            'claims.*.subscriber_gender' => 'required|in:M,F',
            'claims.*.subscriber_street' => 'required|string|max:55',
            'claims.*.subscriber_city' => 'required|string|max:30',
            'claims.*.subscriber_state' => 'required|string|size:2',
            'claims.*.subscriber_zip' => 'required|string|max:10',
            'claims.*.group_number' => 'required|string|max:20',
            'claims.*.insurance_type' => 'required|in:MC,CI,BL',
            'claims.*.claim_number' => 'required|string|max:20',
            'claims.*.claim_amount' => 'required|numeric',
            'claims.*.place_of_service' => 'required|string|size:2',
            'claims.*.primary_diagnosis' => 'required|string|max:11',
            'claims.*.service_lines' => 'required|array|min:1',
            'claims.*.service_lines.*.procedure_code' => 'required|string|max:10',
            'claims.*.service_lines.*.charge_amount' => 'required|numeric',
            'claims.*.service_lines.*.date_of_service' => 'required|date_format:Y-m-d',
        ]);

        // Generate the EDI content
        $ediContent = $this->generateEDI($request->all());

          // Save the EDI file as .edi
        $fileName = '837_Multiple_P_' . time() . '.edi';
        Storage::disk('local')->put($fileName, $ediContent);

        // Save file details in the database
        $ins = new EdiFileModel;
        $ins->file_name = $fileName;
        $ins->type = "P";
        $ins->is_multiple = "Y";
        $ins->ref_id = $request->input('se02');
        $ins->file_string = $ediContent;
        $ins->request_data = json_encode($request->all(), JSON_PRETTY_PRINT);
        $ins->save();

        // Return as downloadable file
        // return response($ediContent)
        //     ->header('Content-Type', 'text/plain')
        //     ->header('Content-Disposition', 'attachment; filename="837P_'.now()->format('YmdHis').'.edi"');

        return redirect()->route('dashboard')->with('success','Multi Claim 837 Edi P file generated');
    }

   
    // private function generateEDI($data)
    // {
    //     $now = Carbon::now();
    //     $edi = "";

    //     // ISA Segment (Fixed formatting)
    //     // $edi .= "ISA*00*AUTH123456*00*SECURE7890*ZZ*".str_pad($data['sender_id'], 15)."*".
    //     //         "ZZ*".str_pad($data['receiver_id'], 15)."*".
    //     //         $now->format('dmy')."*".$now->format('Hi')."*^*00501*".
    //     //         str_pad($data['control_number'], 9, '0', STR_PAD_LEFT)."*0*P*:~";

    //     $edi .= "ISA*00*".
    //     str_pad('AUTH123456', 10, ' ')."*".  // ISA03 (10-char auth, padded)
    //     "00*".                                // ISA05 (qualifier)
    //     str_pad('SECURE7890', 10, ' ')."*".   // ISA05 (10-char security, padded)
    //     "ZZ*".str_pad($data['sender_id'], 15, ' ')."*".  // ISA06 (sender)
    //     "ZZ*".str_pad($data['receiver_id'], 15, ' ')."*".// ISA08 (receiver)
    //     $now->format('ymd')."*".              // ISA09 (YYMMDD, not DMY!)
    //     $now->format('Hi')."*".               // ISA10 (HHMM)
    //     "^*".                                 // ISA11 (repetition separator)
    //     "00501*".                             // ISA12 (HIPAA version)
    //     str_pad($data['control_number'], 9, '0', STR_PAD_LEFT)."*". // ISA13
    //     "0*P*:~";                             // ISA15=P (production)
    //         // Changed from T to P for production

    //     // GS Segment
    //     $edi .= "GS*HC*".$data['sender_code']."*".$data['receiver_code']."*".
    //             $now->format('Ymd')."*".$now->format('Hi')."*1*X*005010X223A2~";

    //     // ST Segment
    //     $edi .=  "ST*837*".$data['se02']."*005010X222A1~";

    //     // BHT Segment (Fixed control number format)
    //     $edi .= "BHT*0019*00*0123*".$now->format('Ymd')."*".$now->format('Hi')."*CH~";

    //     // Loop 1000A (Submitter - Exact match)
    //     $edi .= "NM1*41*2*".str_pad($data['submitter_name'], 35)."*****46*".$data['submitter_id']."~";
    //     $edi .= "PER*IC*".str_pad($data['submitter_contact'], 35)."*TE*".$data['submitter_phone']."~";

    //     // Loop 1000B (Payer - Exact match)
    //     $edi .= "NM1*40*2*".str_pad($data['payer_name'], 35)."*****46*".$data['payer_id']."~";

    //     // Loop 2000A (Billing Provider - Exact match)
    //     $edi .= "HL*1**20*1~";
    //     $edi .= "NM1*85*2*".str_pad($data['provider_name'], 35)."*****XX*".$data['provider_npi']."~";
    //     $edi .= "N3*".str_pad($data['provider_street'], 55)."~";
    //     $edi .= "N4*".str_pad($data['provider_city'], 30)."*".$data['provider_state']."*".str_pad($data['provider_zip'], 15)."~";
    //     $edi .= "REF*EI*".$data['provider_tax_id']."~";

    //     // Process Claims (Strict structure match)
    //     foreach ($data['claims'] as $claimIndex => $claim) {
    //     $hlNumber = $claimIndex + 2;
        
    //     // Subscriber HL
    //    // Loop 2000B (Subscriber HL)
    //     $edi .= "HL*".$hlNumber."*1*22*".($claimIndex === 0 ? '1' : '0')."~";

    //     // SBR (Subscriber Info)
    //     $edi .= "SBR*P*18*".$claim['member_id']."*".$claim['group_number']."*****".$claim['insurance_type']."~";

    //     // NM1*IL (Subscriber Name - REQUIRED)
    //     $edi .= "NM1*IL*1*".str_pad($claim['subscriber_last_name'], 35)."*".
    //             str_pad($claim['subscriber_first_name'], 35)."****MI*".
    //             $claim['member_id']."~";


    //     // N3/N4 (Subscriber Address - Optional)
    //     $edi .= "N3*".str_pad($claim['subscriber_street'], 55)."~";
    //     $edi .= "N4*".str_pad($claim['subscriber_city'], 30)."*".$claim['subscriber_state']."*".str_pad($claim['subscriber_zip'], 15)."~";
        
    //     // Payer NM1 (Repeated per claim)
    //     $edi .= "NM1*PR*2*".str_pad($data['payer_name'], 35)."*****PI*".$data['payer_id']."~";

    //     // DMG (DOB & Gender - Recommended)
    //    $edi .= "DMG*D8*".str_replace('-', '', $claim['subscriber_dob'])."*".$claim['subscriber_gender']."~";

        
    //     // Rest of your claim segments (CLM, HI, service lines, etc.)
    //     $edi .= "CLM*".$claim['claim_number']."*".
    //         number_format($claim['claim_amount'], 2, '.', '')."***".
    //         $claim['place_of_service'].":B:1*Y*A*Y*I~";
            
    //         // Diagnosis (HI segment)
    //         $edi .= "HI*ABK:".$claim['primary_diagnosis'];
    //         if (!empty($claim['additional_diagnosis'])) {
    //             $edi .= ":".$claim['additional_diagnosis'];
    //         }
    //         $edi .= "~";
            
    //         // Service Lines (Exact LX/SV1/DTP format)
    //         foreach ($claim['service_lines'] as $line) {
    //             $edi .= "LX*".$line['service_line_number']."~";
    //             $edi .= "SV1*HC:".$line['procedure_code']."*".
    //                     number_format($line['charge_amount'], 2, '.', '')."*UN*".
    //                     $line['unit_count']."***".$line['diagnosis_pointer']."~";
    //             $edi .= "DTP*472*D8*".str_replace('-', '', $line['date_of_service'])."~";
    //         }
    //     }

    //     // Calculate segment count (ST through SE)
    //     $segmentCount = substr_count($edi, '~')+1-2;

    //     // dd($segmentCount);

    //     // SE Segment (Fixed format)
    //    $edi .= "SE*".$segmentCount."*".$data['se02']."~";

    //     // GE Segment (Fixed control number)
    //     $edi .= "GE*1*1~";

    //     // IEA Segment (Matches ISA control number)
    //     $edi .= "IEA*1*".str_pad($data['control_number'], 9, '0', STR_PAD_LEFT)."~";

    //     return $edi;
    // }



private function generateEDI($data)
{
    $now = Carbon::now();
    $edi = "";

    // ISA Segment
    $edi .= "ISA*00*AUTH123456*00*SECURE7890*ZZ*".str_pad($data['sender_id'], 15)."*".
            "ZZ*".str_pad($data['receiver_id'], 15)."*".
            $now->format('ymd')."*".$now->format('Hi')."*^*00501*".
            str_pad($data['control_number'], 9, '0', STR_PAD_LEFT)."*0*P*:~";

    // GS Segment
    $edi .= "GS*HC*".$data['sender_code']."*".$data['receiver_code']."*".
            $now->format('Ymd')."*".$now->format('Hi')."*1*X*005010X222A1~";

    // ST Segment
   $edi .=  "ST*837*".$data['se02']."*005010X222A1~";

    // BHT Segment
    $edi .= "BHT*0019*00*0123*".$now->format('Ymd')."*".$now->format('Hi')."*CH~";

    // Submitter Info
    $edi .= "NM1*41*2*".str_pad($data['submitter_name'], 35)."*****46*".$data['submitter_id']."~";
    $edi .= "PER*IC*".str_pad($data['submitter_contact'], 35)."*TE*".$data['submitter_phone']."~";

    // Payer Info
    $edi .= "NM1*40*2*".str_pad($data['payer_name'], 35)."*****46*".$data['payer_id']."~";

    // Provider Info
    $edi .= "HL*1**20*1~";
    $edi .= "NM1*85*2*".str_pad($data['provider_name'], 35)."*****XX*".$data['provider_npi']."~";
    $edi .= "N3*".str_pad($data['provider_street'], 55)."~";
    $edi .= "N4*".str_pad($data['provider_city'], 30)."*".$data['provider_state']."*".str_pad($data['provider_zip'], 15)."~";
    $edi .= "REF*EI*".$data['provider_tax_id']."~";

    // Process Claims
    foreach ($data['claims'] as $claimIndex => $claim) {
        $hlNumber = $claimIndex + 2;
        
        // Subscriber Info
        $edi .= "HL*".$hlNumber."*1*22*".($claimIndex === 0 ? '1' : '0')."~";
        $edi .= "SBR*P*18*******".$claim['insurance_type']."~"; // Empty group number fields
        $edi .= "NM1*IL*1*".str_pad($claim['subscriber_last_name'], 35)."*".
                str_pad($claim['subscriber_first_name'], 35)."****MI*".
                $claim['member_id']."~";
       
        $edi .= "N3*".str_pad($claim['subscriber_street'], 55)."~";
        $edi .= "N4*".str_pad($claim['subscriber_city'], 30)."*".$claim['subscriber_state']."*".str_pad($claim['subscriber_zip'], 15)."~";
         $edi .= "DMG*D8*".str_replace('-', '', $claim['subscriber_dob'])."*".$claim['subscriber_gender']."~";
        $edi .= "NM1*PR*2*".str_pad($data['payer_name'], 35)."*****PI*".$data['payer_id']."~";

        // Claim Info
        $edi .= "CLM*".$claim['claim_number']."*".
                $claim['claim_amount']."***". // No decimal formatting
                $claim['place_of_service'].":B:1*Y*A*Y*Y~";
        $edi .= "HI*ABK:".$claim['primary_diagnosis']."~";
        
        // Service Lines
        foreach ($claim['service_lines'] as $line) {
                $edi .= "LX*".$line['service_line_number']."~";
                $edi .= "SV1*HC:".$line['procedure_code']."*".
                        number_format($line['charge_amount'], 2, '.', '')."*UN*".
                        $line['unit_count']."***".$line['diagnosis_pointer']."~";
                $edi .= "DTP*472*D8*".str_replace('-', '', $line['date_of_service'])."~";
            }
        }
    

    // Footer Segments
    $segmentCount = substr_count($edi, '~')+1-2;
    $edi .= "SE*".$segmentCount."*".$data['se02']."~";
    $edi .= "GE*1*1~";
    $edi .= "IEA*1*".str_pad($data['control_number'], 9, '0', STR_PAD_LEFT)."~";

    return $edi;
}

















public function generate999P($id)
{
    $find = EdiFileModel::where('id', $id)->where('type', 'P')->where('is_multiple', 'Y')->first();
    if (!$find) {
        return back()->with('error', 'ID mismatch');
    }

    $content = $find->file_string;
    $originalName = '837_Multiple_P_to_999_' . time() . '.edi';

    // Extract dynamic values
    $senderId = str_pad($this->extractSegmentValue($content, 'ISA', 6, 15), 15, " ", STR_PAD_RIGHT);
    $receiverId = str_pad($this->extractSegmentValue($content, 'ISA', 8, 15), 15, " ", STR_PAD_RIGHT);
    $controlNumber = $this->extractSegmentValue($content, 'ISA', 13, 9);
    $gsControlNumber = str_pad(mt_rand(100000000, 999999999), 9, "0", STR_PAD_LEFT);
    $date = date('ymd');
    $time = date('Hi');
    $gsDate = date('Ymd');

    // Split claims using ST*837
    $claims = preg_split('/(?=ST\*837\*)/', $content);
    $ak2Ik5Block = '';
    $acceptedCount = 0;
    $rejectedCount = 0;
    $transactionSetCount = 0;

    foreach ($claims as $index => $claim) {
        if (trim($claim) === '') continue;

        $transactionSetCount++;
        $transactionControlNumber = str_pad($index + 1, 9, "0", STR_PAD_LEFT);

        $isRejected = strpos($claim, "BHT*0085*RE") !== false;
        $hasSegmentErrors = strpos($claim, "IK3*") !== false;
        $hasElementErrors = strpos($claim, "IK4*") !== false;

        if ($isRejected || $hasSegmentErrors || $hasElementErrors) {
            $ik5Code = "R";
            $rejectedCount++;
        } else {
            $ik5Code = "A";
            $acceptedCount++;
        }

        $ak2Ik5Block .= "AK2*837*$transactionControlNumber~\n";
        $ak2Ik5Block .= "IK5*$ik5Code~\n";
    }

    // Determine AK9 code based on totals
    $ak9Code = ($rejectedCount === $transactionSetCount) ? "R" : (($acceptedCount === $transactionSetCount) ? "A" : "P");

    $segmentCount = 4 + ($transactionSetCount * 2); // ST, AK1, AK2+IK5 pairs, AK9, SE

    $generatedContent = <<<EDI
ISA*00*          *00*          *ZZ*$senderId*ZZ*$receiverId*$date*$time*^*00501*$controlNumber*1*T*:~
GS*FA*$senderId*$receiverId*$gsDate*$time*$gsControlNumber*X*005010X231A1~
ST*999*0001*005010X231A1~
AK1*HC*$gsControlNumber*005010X222A1~
$ak2Ik5Block
AK9*$ak9Code*$transactionSetCount*$acceptedCount*$acceptedCount~
SE*$segmentCount*0001~
GE*1*$gsControlNumber~
IEA*1*$controlNumber~
EDI;

    // Save file
    Storage::put("uploads/$originalName", $generatedContent);

    $status = ($rejectedCount === $transactionSetCount)
        ? "rejected"
        : (($acceptedCount === $transactionSetCount) ? "accepted" : "partially accepted");

    $ins = Acknowledge999FileModel::firstOrNew([
        'file_837_id' => $id,
        'type' => 'P',
        'file_type' => '837',
    ]);

    $ins->file_name = $originalName;
    $ins->file_string = $generatedContent;
    $ins->save();

    EdiFileModel::where('id', $id)->update(['status' => 'G']);

    return back()->with('success', '999 Ack file generated for 837P file');
}

    



  // Function to extract a specific segment value from the EDI file
    private function extractSegmentValue($content, $segment, $position, $length)
    {
        $lines = explode("~", $content); // Split by segment delimiter (~)
        foreach ($lines as $line) {
            if (strpos($line, $segment) === 0) {
                $elements = explode('*', $line); // Split segment into elements
                return isset($elements[$position]) ? trim($elements[$position]) : 'UNKNOWN';
            }
        }
        return 'UNKNOWN';
    }


























public function view_system_multicliam_file_data($id){

    if(@Auth()->user()->user_type=="A"){
        $find=EdiFileModel::where('id',$id)->where('is_multiple','Y')->first();
    }else{
        $find=EdiFileModel::where('id',$id)->where('is_multiple','Y')->where('created_user_id',Auth::user()->id)->first();
    }

   
    if(!$find){
     return back()->with('error' , 'File not found');
    }
     $find_837_to_999 = Acknowledge999FileModel::where('file_837_id', $find->id)
                            ->where('file_type', '837')->first();
    $find['find_837_to_999'] = $find_837_to_999 ?? null;

    $find_275_to_999 = Acknowledge999FileModel::where('file_837_id', $find->id)
                            ->where('file_type', '275')->first();
    $find['find_275_to_999'] = $find_275_to_999 ?? null;

    // dd("y", $find);
        $ediContent = $find->file_string;
        
        $parsedData = $this->parseEdi837($ediContent);
        // dd($parsedData);
        
        return view('multiple.view_system_multiple_837_file_data', [
            'data' => $parsedData,
            'originalContent' => $ediContent,
            'file' => $find
        ]);
}






private $currentLocationType = null; // 'pickup' or 'dropoff'
 private function parseEdi837($ediContent)
    {
        $segments = explode('~', $ediContent);
        $parsed = [
            'meta' => [
                'edi_type' => null,
                'interchange' => [],
                'functional_group' => [],
            ],
            'submitters' => [],
            'providers' => [],
            'payers' => [],
            'subscribers' => [],
            'patients' => [],
            'claims' => [],
            'additional'=>[],
        ];

        $currentClaimIndex = -1;
        $currentServiceIndex = -1;
        $currentLoopLevel = 0;
        $currentLoopId = null;

        foreach ($segments as $segment) {
            $segment = trim($segment);
            if (empty($segment)) continue;
            
            $elements = explode('*', $segment);
            $segmentId = $elements[0];
            
            switch ($segmentId) {
                // ISA - Interchange Control Header
                case 'ISA':
                    $parsed['meta']['interchange'] = [
                        'sender_id' => trim($elements[6] ?? ''),
                        'receiver_id' => trim($elements[8] ?? ''),
                        'date' => trim($elements[9] ?? ''),
                        'time' => trim($elements[10] ?? ''),
                        'control_number' => trim($elements[13] ?? ''),
                    ];
                    break;
                    
                // GS - Functional Group Header
                case 'GS':
                    $version = trim($elements[8] ?? '');
                    $parsed['meta']['edi_type'] = match($version) {
                        '005010X223A2' => 'I', // Institutional
                        '005010X224A2' => 'D',  // Dental
                        '005010X222A1' => 'P',  // Professional
                        default => 'U'          // Unknown
                    };
                    
                    $parsed['meta']['functional_group'] = [
                        'sender_code' => trim($elements[2] ?? ''),
                        'receiver_code' => trim($elements[3] ?? ''),
                        'date' => trim($elements[4] ?? ''),
                        'time' => trim($elements[5] ?? ''),
                        'control_number' => trim($elements[6] ?? ''),
                        'version' => $version,
                    ];
                    break;
                    
                // ST - Transaction Set Header
                case 'ST':
                    $parsed['meta']['transaction_set'] = [
                        'id' => trim($elements[1] ?? ''),
                        'control_number' => trim($elements[2] ?? ''),
                    ];
                    break;
                    
                // BHT - Beginning of Hierarchical Transaction
                case 'BHT':
                    $parsed['meta']['hierarchical_transaction'] = [
                        'purpose_code' => trim($elements[2] ?? ''),
                        'reference_id' => trim($elements[3] ?? ''),
                        'date' => trim($elements[4] ?? ''),
                        'time' => trim($elements[5] ?? ''),
                    ];
                    break;
                    
                // HL - Hierarchical Level
                case 'HL':
                    $currentLoopLevel = (int)($elements[3] ?? 0);
                    $currentLoopId = trim($elements[1] ?? '');
                    
                    // If this is a claim level (typically HL*2 or HL*3 depending on EDI type)
                    if ($currentLoopLevel >= 2) {
                        $currentClaimIndex++;
                        $currentServiceIndex = -1;
                        
                        $parsed['claims'][$currentClaimIndex] = [
                            'loop_id' => $currentLoopId,
                            'level' => $currentLoopLevel,
                            'services' => [],
                            'type' => $parsed['meta']['edi_type'],
                        ];
                    }
                    break;

                    case 'REF':
                     // dd($segmentId,$elements[2]);
                     if (($elements[1] ?? '') === '1G') { // Group Number
                            $parsed['additional']['group_info'][$currentClaimIndex] = [
                                'group_number' => trim($elements[2] ?? '')
                            ];
                        }
                      $parsed['providers'][0]['tax_id']=$elements[2];

                      if (($elements[1] ?? '') === '9A') {
                      // dd($elements); // PPO Network ID
                            $parsed['additional']['ppo_info'][$currentClaimIndex] = [
                                'network_id' => trim($elements[2] ?? '')
                            ];
                        }

                     break;



                    case 'HCP':
                        if (($elements[1] ?? '') === '04') { // Repriced Amount
                            // dd($elements);
                            $parsed['additional']['pricing_info'][$currentClaimIndex] = [
                                'repriced_amount' => isset($elements[2]) ? (float)$elements[2] : null,
                                'price_indicator' => $elements[3] ?? '', // Should be '2' for contracted rate
                                'service_code' => $elements[4] ?? ''
                            ];
                        }
                        break;


                     case 'PER':
                        // Provider Contact Information
                     // dd($elements);
                        if (($elements[1] ?? '') === 'IC') {
                            $contactInfo = [
                                'name' => trim($elements[2] ?? ''),
                                'communication_method' => trim($elements[3] ?? ''),
                                'phone' => trim($elements[4] ?? '')
                            ];
                            
                            // Add to existing ordering provider if available
                            if (!empty($parsed['additional']['provider_contacts'][$currentClaimIndex])) {
                                $parsed['additional']['provider_contacts'][$currentClaimIndex]['contact'] = $contactInfo;
                            } else {
                                // Or create new contact entry
                                $parsed['additional']['provider_contacts'][$currentClaimIndex] = $contactInfo;
                            }
                        }
                        break;


                     case 'LQ':
                        if (($elements[1] ?? '') === 'UT') { // Form Identifier
                            $parsed['additional']['forms'][$currentClaimIndex]['form_identifier'] = trim($elements[2] ?? '');
                        }
                        break;

                    case 'FRM':
                        $formType = $elements[1] ?? '';
                           $formNum = "FRM ".trim($elements[1] ?? '');
                           $formValue = trim($elements[2] ?? '');
                        if ($formType === '1A') {
                            $parsed['additional']['forms'][$currentClaimIndex]['form_1a'] = trim($elements[3] ?? '');
                        } elseif ($formType === '1C') {
                            $parsed['additional']['forms'][$currentClaimIndex]['form_1c'] = trim($elements[3] ?? '');
                        } elseif ($formType === '9') {
                            $parsed['additional']['forms'][$currentClaimIndex]['form_9'] = trim($elements[2] ?? '');
                        }
                        $parsed['additional']['forms'][$currentClaimIndex]['form_data'][$formNum] = $formValue;
                        break;
                    
                // NM1 - Name segments
                case 'NM1':
                    $entityCode = trim($elements[1] ?? '');
                    $data = [
                        'entity_identifier' => $entityCode,
                        'type_qualifier' => trim($elements[2] ?? ''),
                        'last_name' => trim($elements[3] ?? ''),
                        'first_name' => trim($elements[4] ?? ''),
                        'middle_name' => trim($elements[5] ?? ''),
                        'suffix' => trim($elements[7] ?? ''),
                        'id_qualifier' => trim($elements[8] ?? ''),
                        'id_code' => trim($elements[9] ?? ''),
                    ];
                    
                    // Assign to appropriate array based on entity code
                    switch ($entityCode) {
                        case '41': $parsed['submitters'][] = $data; break;
                        case '40': $parsed['payers'][] = $data; break;
                        case '85': $parsed['providers'][] = $data; break;
                        case 'IL': 
                        case 'QC': 
                            if ($currentClaimIndex >= 0) {
                                $parsed['claims'][$currentClaimIndex]['patient'] = $data;
                            }
                            break;
                        case '82': 
                        case '77': 
                            if ($currentClaimIndex >= 0) {
                                $parsed['claims'][$currentClaimIndex]['rendering_provider'] = $data;
                            }
                            break;

                        case '36':
                            $parsed['additional']['36'][$currentClaimIndex] = [
                                'entity_type' => trim($elements[2] ?? ''), // 1=Person, 2=Non-Person
                                'emp_name' => trim($elements[3] ?? ''), // Employer Name
                                'id_qualifier' => trim($elements[8] ?? ''), // FI=Federal Tax Number
                                'id' => trim($elements[9] ?? '') // Employer Tax ID
                            ];
                            break;

                        case 'PR':
                                 $parsed['additional']['PR'][$currentClaimIndex]= [
                                    'other_payer_name' => trim($elements[3] ?? ''),  // Payer name
                                    'policy_number' => trim($elements[9] ?? '')  // Insurance policy number
                                ];
                        break;

                       case 'PW':  // Pickup Location
                        $this->currentLocationType = 'pickup';
                        $this->currentClaimIndex = count($parsed['additional']['pickup_location'] ?? []);
                        $parsed['additional']['pickup_location'][$this->currentClaimIndex] = [
                            'entity_type' => 'PW',
                            'name' => trim($elements[3] ?? ''),
                            'address' => '',  // Will be filled by N3
                            'city' => '',     // Will be filled by N4
                            'state' => '',   // Will be filled by N4
                            'zip' => ''       // Will be filled by N4
                        ];
                        break;
                        
                    case '45':  // Dropoff Location
                        $this->currentLocationType = 'dropoff';
                        $this->currentClaimIndex = count($parsed['additional']['dropoff_location'] ?? []);
                        $parsed['additional']['dropoff_location'][$this->currentClaimIndex] = [
                            'entity_type' => '45',
                            'name' => trim($elements[3] ?? ''),
                            'address' => '',  // Will be filled by N3
                            'city' => '',     // Will be filled by N4
                            'state' => '',    // Will be filled by N4
                            'zip' => ''       // Will be filled by N4
                        ];
                        break;
                        
                    default:
                        // $this->currentLocationType = null;




                    }
                    break;

                     case 'DMG':
                    $dob = trim($elements[2] ?? '');
                    $gender = trim($elements[3] ?? '');
                    
                    // if ($currentClaimIndex >= 0) {
                        $parsed['claims'][$currentClaimIndex]['patientnew']['dob'] = $dob;
                        $parsed['claims'][$currentClaimIndex]['patientnew']['gender'] = $gender;
                    // }
                    break;
                    
                // N3/N4 - Address segments
                case 'N3':
                
                    $address = [
                        'street1' => trim($elements[1] ?? ''),
                        'street2' => trim($elements[2] ?? ''),
                    ];

                     if ($this->currentLocationType === 'pickup') {
                        $parsed['additional']['pickup_location'][$this->currentClaimIndex]['address'] = 
                            trim($elements[1] ?? '');
                    } elseif ($this->currentLocationType === 'dropoff') {
                        // echo json_encode($elements[1]);
                        // echo $this->currentClaimIndex;
                        if($this->currentClaimIndex=="0"){
                            if(!$parsed['additional']['dropoff_location'][$this->currentClaimIndex]['address']){
                            $parsed['additional']['dropoff_location'][$this->currentClaimIndex]['address'] = 
                            trim($elements[1] ?? '');
                        }
                        }else{
                            $parsed['additional']['dropoff_location'][$this->currentClaimIndex]['address'] = 
                            trim($elements[1] ?? '');

                        }
                    }
                   
                    
                    // Attach to the most recent entity
                    $this->attachAddress($parsed, $address, false);
                    break;
                    
                case 'N4':
                    $address = [
                        'city' => trim($elements[1] ?? ''),
                        'state' => trim($elements[2] ?? ''),
                        'zip' => trim($elements[3] ?? ''),
                        'country' => trim($elements[4] ?? ''),
                    ];


                    if ($this->currentLocationType === 'pickup') {
                        $parsed['additional']['pickup_location'][$this->currentClaimIndex]['city'] = 
                            trim($elements[1] ?? '');
                        $parsed['additional']['pickup_location'][$this->currentClaimIndex]['state'] = 
                            trim($elements[2] ?? '');
                        $parsed['additional']['pickup_location'][$this->currentClaimIndex]['zip'] = 
                            trim($elements[3] ?? '');
                    } elseif ($this->currentLocationType === 'dropoff') {
                        $parsed['additional']['dropoff_location'][$this->currentClaimIndex]['city'] = 
                            trim($elements[1] ?? '');
                        $parsed['additional']['dropoff_location'][$this->currentClaimIndex]['state'] = 
                            trim($elements[2] ?? '');
                        $parsed['additional']['dropoff_location'][$this->currentClaimIndex]['zip'] = 
                            trim($elements[3] ?? '');
                    }

                   
                    
                    $this->attachAddress($parsed, $address, true);

                    break;



                    case 'CR2':
                        $spinalRegion = $elements[8] ?? ''; // 10th element (0-indexed as 9)
                        $condition = $elements[10] ?? '';   // 12th element
                        
                        $parsed['additional']['chiropractic'][$currentClaimIndex] = [
                            'spinal_region' => $spinalRegion,
                            'condition' => $condition
                        ];
                        break;





                    case 'PWK':
                        $parsed['additional']['dme_documentation'][$currentClaimIndex] = [
                            'documentation_type' => $elements[1] ?? '',
                            'transmission_code' => $elements[2] ?? ''
                        ];
                    break;

                    case 'CR3':
                        $parsed['additional']['dme_certification'][$currentClaimIndex] = [
                            'certification_type' => $elements[1] ?? '',
                            'equipment_type' => $elements[2] ?? '',
                            'quantity' => $elements[3] ?? ''
                        ];
                    break;


                    case 'LIN':
                        // Handle drug/NDC information in additional section
                        if (($elements[1] ?? '') === '' && ($elements[2] ?? '') === 'N4') {
                            $parsed['additional']['ndc_info'][$currentClaimIndex] = [
                                'code' => trim($elements[3] ?? ''),
                                'quantity' => '',       // Will be filled by CTP segment
                                'unit' => ''            // Will be filled by CTP segment
                            ];
                        }
                        break;

                    case 'CTP':
                    // dd($elements);
                        // Handle drug pricing/quantity information in additional section
                        if (isset($parsed['additional']['ndc_info'][$currentClaimIndex])) {
                            $parsed['additional']['ndc_info'][$currentClaimIndex]['quantity'] = trim($elements[5] ?? '');
                            $parsed['additional']['ndc_info'][$currentClaimIndex]['unit'] = trim($elements[4] ?? '');
                        }
                        break;




                 // CR1 - Transport Details (New)
                    case 'CR1':
                        $transportReason = explode('*', $elements[4] ?? '');
                        $parsed['additional']['transport'][$currentClaimIndex] = [
                            'transport_type' => trim($elements[1] ?? ''),       // 'LB' (stretcher)
                            'mileage' => trim($elements[2] ?? ''),              // e.g., '50' (no decimal)
                            'reason_code' => trim($transportReason[0] ?? ''),   // 'A' or 'B'
                            'reason_description' => trim($transportReason[1] ?? ''), // 'DH' or 'NH'
                            'qualifier' => trim($elements[5] ?? ''),            // '21'
                            'patient_condition' => trim($elements[9] ?? ''),    // 'PATIENT IMMOBILIZED'
                        ];
                        break;
                    
                // SBR - Subscriber Information
                case 'SBR':
                    if ($currentClaimIndex >= 0) {
                        $parsed['claims'][$currentClaimIndex]['subscriber_info'] = [
                            'payer_responsibility' => trim($elements[1] ?? ''),
                            'group_number' => trim($elements[3] ?? ''),
                            'group_name' => trim($elements[4] ?? ''),
                            'insurance_type' => trim($elements[5] ?? ''),
                        ];
                    }
                    break;
                    
                // CLM - Claim Information
                case 'CLM':
                    if ($currentClaimIndex >= 0) {
                        $parsed['claims'][$currentClaimIndex]['claim_info'] = [
                            'number' => trim($elements[1] ?? ''),
                            'amount' => trim($elements[2] ?? ''),
                            'place_of_service' => trim($elements[4] ?? ''),
                            'type' => trim($elements[5] ?? ''),
                            'facility_type' => trim($elements[6] ?? ''),
                        ];
                    }
                    break;
                    
                // HI - Diagnosis Codes
                case 'HI':
                    if ($currentClaimIndex >= 0) {
                        $diagnosisCodes = [];
                        for ($i = 1; $i < count($elements); $i++) {
                            if (!empty(trim($elements[$i]))) {
                                $codeParts = explode(':', trim($elements[$i]));
                                if (count($codeParts) > 1) {
                                    $diagnosisCodes[] = [
                                        'type' => $codeParts[0],
                                        'code' => $codeParts[1],
                                    ];
                                }
                            }
                        }
                        $parsed['claims'][$currentClaimIndex]['diagnosis_codes'] = $diagnosisCodes;
                    }
                    break;
                    
                // LX - Service Line Number
                case 'LX':
                    if ($currentClaimIndex >= 0) {
                        $currentServiceIndex++;
                        $parsed['claims'][$currentClaimIndex]['services'][$currentServiceIndex] = [
                            'line_number' => trim($elements[1] ?? ''),
                        ];
                    }
                    break;
                    
                // // SV1/SV3 - Service Line Details
                // case 'SV1':
                // case 'SV2':
                // case 'SV3':
                //     if ($currentClaimIndex >= 0 && $currentServiceIndex >= 0) {
                //         $procedure = explode(':', trim($elements[1] ?? ''));
                //         $parsed['claims'][$currentClaimIndex]['services'][$currentServiceIndex]['service'] = [
                //             'code' => $procedure[1] ?? '',
                //             'modifier' => $procedure[2] ?? '',
                //             'amount' => trim($elements[2] ?? ''),
                //             'units' => trim($elements[4] ?? ''),
                //             'diagnosis_pointer' => trim($elements[7] ?? ''),
                //         ];
                //     }
                //     break;

                    case 'SV1':
                    case 'SV2':
                    case 'SV3':
                        if ($currentClaimIndex >= 0 && $currentServiceIndex >= 0) {
                            $serviceData = [];
                            
                            // Common for all service types
                            $procedureParts = explode(':', trim($elements[1] ?? ''));
                            
                            // Handle different segment structures
                            if ($segmentId === 'SV1') {
                                // SV1*HC:99213*100.00*UN*1***1~
                                $serviceData = [
                                    'type' => 'SV1',
                                    'code' => $procedureParts[1] ?? '',
                                    'modifier' => $procedureParts[2] ?? '',
                                    'amount' => trim($elements[2] ?? ''),
                                    'units' => trim($elements[4] ?? ''),
                                    'diagnosis_pointer' => trim($elements[7] ?? ''),
                                ];
                            } 
                            elseif ($segmentId === 'SV2') {
                                // SV2*0300*HC:99213*150.00*DA*1~
                                $serviceData = [
                                    'type' => 'SV2',
                                    'revenue_code' => trim($elements[1] ?? ''), // 0300
                                    'code' => $procedureParts[1] ?? '',         // From HC:99213
                                    'modifier' => $procedureParts[2] ?? '',
                                    'amount' => trim($elements[3] ?? ''),      // 150.00
                                    'units' => trim($elements[5] ?? ''),        // 1
                                ];
                            } 
                            elseif ($segmentId === 'SV3') {
                                // SV3*AD:99213*150.00*UN*1~
                                $serviceData = [
                                    'type' => 'SV3',
                                    'code' => $procedureParts[1] ?? '',
                                    'modifier' => $procedureParts[2] ?? '',
                                    'amount' => trim($elements[2] ?? ''),
                                    'units' => trim($elements[4] ?? ''),
                                ];
                            }
                            
                            // Add service line notes if present (common for all types)
                            if (isset($elements[6])) {
                                $serviceData['notes'] = trim($elements[6]);
                            }
                            
                            $parsed['claims'][$currentClaimIndex]['services'][$currentServiceIndex]['service'] = $serviceData;
                        }
                        break;
                                   



                // // DTP - Service Dates
                // case 'DTP':
                //     if ($currentClaimIndex >= 0) {
                //         $dateType = trim($elements[1] ?? '');
                //         $dateFormat = trim($elements[2] ?? '');
                //         $dateValue = trim($elements[3] ?? '');
                        
                //         if ($currentServiceIndex >= 0) {
                //             // Service line date
                //             $parsed['claims'][$currentClaimIndex]['services'][$currentServiceIndex]['dates'][] = [
                //                 'type' => $dateType,
                //                 'date' => $dateValue,
                //                 'format' => $dateFormat,
                //             ];
                //         } else {
                //             // Claim level date
                //             $parsed['claims'][$currentClaimIndex]['dates'][] = [
                //                 'type' => $dateType,
                //                 'date' => $dateValue,
                //                 'format' => $dateFormat,
                //             ];
                //         }
                //     }
                //     break;

                    case 'DTP':
                        $dateType = trim($elements[1] ?? '');
                        $dateFormat = trim($elements[2] ?? '');
                        $dateValue = trim($elements[3] ?? '');
                        
                        // 1. First check for Oxygen/DME specific dates
                        $dmeDateTypes = ['472', '607', '463', '461']; // Service, Cert Start, Last Cert, Recert
                        if (in_array($dateType, $dmeDateTypes)) {
                            $dateMap = [
                                '472' => 'service_date',
                                '607' => 'certification_start_date',
                                '463' => 'last_certification_date',
                                '461' => 'recertification_date'
                            ];
                            
                            $parsed['additional']['dme_dates'][$currentClaimIndex][$dateMap[$dateType]] = $this->formatEdiDate($dateValue, $dateFormat);
                        }
                        // 2. Then handle your existing service/claim dates
                        elseif ($currentClaimIndex >= 0) {
                            if ($currentServiceIndex >= 0) {
                                // Service line date
                                $parsed['claims'][$currentClaimIndex]['services'][$currentServiceIndex]['dates'][] = [
                                    'type' => $dateType,
                                    'date' => $dateValue,
                                    'format' => $dateFormat,
                                ];
                            } else {
                                // Claim level date
                                $parsed['claims'][$currentClaimIndex]['dates'][] = [
                                    'type' => $dateType,
                                    'date' => $dateValue,
                                    'format' => $dateFormat,
                                ];
                            }
                        }
                        break;
                    
                // TOO - Tooth Information (Dental)
                case 'TOO':
                    if ($currentClaimIndex >= 0 && $currentServiceIndex >= 0 && $parsed['meta']['edi_type'] === 'D') {
                        $parsed['claims'][$currentClaimIndex]['services'][$currentServiceIndex]['tooth_info'] = [
                            'code' => trim($elements[1] ?? ''),
                            'number' => trim($elements[2] ?? ''),
                        ];
                    }
                    break;
                    
                // CL1 - Institutional Claim Info
                case 'CL1':
                    if ($currentClaimIndex >= 0 && $parsed['meta']['edi_type'] === 'I') {
                        $parsed['claims'][$currentClaimIndex]['institutional_info'] = [
                            'admission_type' => trim($elements[1] ?? ''),
                            'admission_source' => trim($elements[2] ?? ''),
                            'patient_status' => trim($elements[3] ?? ''),
                        ];
                    }
                    break;
                    
                // DMG - Demographic Information
                case 'DMG':
                    $dob = trim($elements[2] ?? '');
                    $gender = trim($elements[3] ?? '');
                    
                    // if ($currentClaimIndex >= 0) {
                        $parsed['claims'][$currentClaimIndex]['patient']['dob'] = $dob;
                        $parsed['claims'][$currentClaimIndex]['patient']['gender'] = $gender;
                    // }
                    break;
            }
        }
        
        return $parsed;
    }
    
    /**
     * Helper method to attach address information to the most recent entity
     */
    private function attachAddress(&$parsed, $address, $isN4)
    {

    

        // Check claims first (patient/provider addresses)
        if (!empty($parsed['claims'])) {
            $lastClaim = end($parsed['claims']);
            
            if (isset($lastClaim['patient']) && !isset($lastClaim['patient']['address'])) {
                $lastClaim['patient']['address'] = $address;
                $parsed['claims'][key($parsed['claims'])] = $lastClaim;
                return;
            }
            
            if (isset($lastClaim['rendering_provider']) && !isset($lastClaim['rendering_provider']['address'])) {
                $lastClaim['rendering_provider']['address'] = $address;
                $parsed['claims'][key($parsed['claims'])] = $lastClaim;
                return;
            }
        }
        
        // Check providers
        if (!empty($parsed['providers'])) {
            $lastProvider = end($parsed['providers']);
            if (!isset($lastProvider['address'])) {
                $lastProvider['address'] = $address;
                $parsed['providers'][key($parsed['providers'])] = $lastProvider;
                return;
            } elseif (!$isN4) {
                // Merge N3 with existing N4
                $lastProvider['address'] = array_merge($lastProvider['address'], $address);
                $parsed['providers'][key($parsed['providers'])] = $lastProvider;
                return;
            }
        }
        
        // Check payers
        if (!empty($parsed['payers'])) {
            $lastPayer = end($parsed['payers']);
            if (!isset($lastPayer['address'])) {
                $lastPayer['address'] = $address;
                $parsed['payers'][key($parsed['payers'])] = $lastPayer;
                return;
            } elseif (!$isN4) {
                $lastPayer['address'] = array_merge($lastPayer['address'], $address);
                $parsed['payers'][key($parsed['payers'])] = $lastPayer;
                return;
            }
        }
    }




    private function formatEdiDate($dateValue, $dateFormat)
    {
        if ($dateFormat === 'D8') {
            // Format YYYYMMDD to YYYY-MM-DD
            return preg_replace('/^(\d{4})(\d{2})(\d{2})$/', '$1-$2-$3', $dateValue);
        } elseif ($dateFormat === 'RD8') {
            // Date range - handle accordingly
            return $dateValue; // Or implement specific range formatting
        }
        return $dateValue;
    }































public function create_multiple_edip_form_new($type){
     $data['claim_type']=$type;
    return view('multiple.create_multiple_edip_12_form')->with($data);
}




public function generate837P_new(Request $request){

        // dd($request->all());
        // Validate the request data
        $validated = $request->validate([
            // Transmission Info
            'sender_id' => 'required|string|max:15',
            'receiver_id' => 'required|string|max:15',
            'control_number' => 'required|string|max:9',
            
            // Submitter Info
            'submitter_name' => 'required|string|max:60',
            'submitter_id' => 'required|string|max:15',
            'submitter_contact' => 'required|string|max:60',
            'submitter_phone' => 'required',
            
            // Payer Info
            'payer_name' => 'required|string|max:60',
            'payer_id' => 'required|string|max:15',
            
            // Provider Info
            'provider_name' => 'required|string|max:60',
            'provider_npi' => 'required|digits:10',
            'provider_tax_id' => 'required|string|max:9',
            'provider_street' => 'required|string|max:55',
            'provider_city' => 'required|string|max:30',
            'provider_state' => 'required|string|size:2',
            'provider_zip' => 'required|string|max:15',
            
            // Claims
            'claims' => 'required|array|min:1',
            'claims.*.subscriber_last_name' => 'required|string|max:60',
            'claims.*.subscriber_first_name' => 'required|string|max:35',
            'claims.*.member_id' => 'required|string|max:20',
            'claims.*.subscriber_dob' => 'required|date_format:Y-m-d',
            'claims.*.subscriber_gender' => 'required|in:M,F',
            'claims.*.subscriber_street' => 'required|string|max:55',
            'claims.*.subscriber_city' => 'required|string|max:30',
            'claims.*.subscriber_state' => 'required|string|size:2',
            'claims.*.subscriber_zip' => 'required|string|max:10',
            'claims.*.group_number' => 'required|string|max:20',
            'claims.*.insurance_type' => 'required|in:MC,CI,BL',
            'claims.*.claim_number' => 'required|string|max:20',
            'claims.*.claim_amount' => 'required|numeric',
            'claims.*.place_of_service' => 'required|string|size:2',
            'claims.*.primary_diagnosis' => 'required|string|max:11',
            'claims.*.service_lines' => 'required|array|min:1',
            'claims.*.service_lines.*.procedure_code' => 'required|string|max:10',
            'claims.*.service_lines.*.charge_amount' => 'required|numeric',
            'claims.*.service_lines.*.date_of_service' => 'required|date_format:Y-m-d',
        ]);

        // Generate the EDI content
        $ediContent = $this->generateEDINew($request->all());

          // Save the EDI file as .edi
        $fileName = '837_Multiple_P_' . time() . '.edi';
        Storage::disk('local')->put($fileName, $ediContent);

        // Save file details in the database
        $ins = new EdiFileModel;
        $ins->file_name = $fileName;
        $ins->type = "P";
        $ins->is_multiple = "Y";
        $ins->ref_id = $request->input('se02');
        $ins->file_string = $ediContent;
         $ins->claim_type = $request->claimType;
        $ins->request_data = json_encode($request->all(), JSON_PRETTY_PRINT);
        $ins->save();

        // Return as downloadable file
        // return response($ediContent)
        //     ->header('Content-Type', 'text/plain')
        //     ->header('Content-Disposition', 'attachment; filename="837P_'.now()->format('YmdHis').'.edi"');

        return redirect()->route('dashboard')->with('success','Multi Claim 837 Edi P file generated');

}










function generateEDINew($data) {
    $now = Carbon::now();
    $edi = "";
     $claimType=$data['claimType'];

   
            // ISA Segment
            $edi .= "ISA*00*          *00*          *ZZ*".str_pad($data['sender_id'], 15)."*".
                    "ZZ*".str_pad($data['receiver_id'], 15)."*".
                    $now->format('ymd')."*".$now->format('Hi')."*^*00501*".
                    str_pad($data['control_number'], 9, '0', STR_PAD_LEFT)."*1*T*:~";

            // GS Segment
            $edi .= "GS*HC*".$data['sender_id']."*".$data['receiver_id']."*".
                    $now->format('Ymd')."*".$now->format('Hi')."*1*X*005010X222A1~";

            // ST Segment
            $edi .= "ST*837*".$data['se02']."*005010X222A1~";
            
            // BHT Segment
            $edi .= "BHT*0019*00*".str_pad($data['control_number'], 9, '0', STR_PAD_LEFT)."*".
                    $now->format('Ymd')."*".$now->format('Hi')."*CH~";

            // Submitter Info (NM1*41)
            $edi .= "NM1*41*2*".strtoupper(substr($data['submitter_name'], 0, 60))."*****46*".$data['submitter_id']."~";
            $edi .= "PER*IC*".strtoupper(substr($data['submitter_contact'], 0, 60))."*TE*".$data['submitter_phone']."*EX*231~";

            // Receiver Info (NM1*40)
            $edi .= "NM1*40*2*".strtoupper(substr($data['receiver_name'], 0, 60))."*****46*".$data['receiver_code']."~";



     if($claimType=="12"){

            // Provider Info (HL*1)
            $edi .= "HL*1**20*1~";
            $edi .= "PRV*BI*PXC*".$data['provider_npi']."~";
            $edi .= "NM1*85*2*".strtoupper(substr($data['provider_name'], 0, 60))."*****XX*".$data['provider_npi']."~";
            $edi .= "N3*".strtoupper(substr($data['provider_street'], 0, 55))."~";
            $edi .= "N4*".strtoupper($data['provider_city'])."*".$data['provider_state']."*".substr($data['provider_zip'], 0, 5)."~";
            $edi .= "REF*EI*".$data['provider_tax_id']."~"; //d

            // Billing Provider Info (NM1*87)
            $edi .= "NM1*87*2~";
            $edi .= "N3*".strtoupper(substr($data['provider_street'], 0, 55))."~";
            $edi .= "N4*".strtoupper($data['provider_city'])."*".$data['provider_state']."*".substr($data['provider_zip'], 0, 5)."~";

            // Process each claim
            foreach ($data['claims'] as $claim) {
                // Subscriber Info (HL*2)
                $edi .= "HL*2*1*22*1~";
                // $edi .= "SBR*P**".$claim['group_number']."******".$claim['insurance_type']."~"; //dn
                $edi .="SBR*P**".$claim['group_number']."******CI~";
                
                $edi .= "NM1*IL*1*".strtoupper($claim['subscriber_last_name'])."*".strtoupper($claim['subscriber_first_name'])."****MI*".$claim['member_id']."~";
                $edi .= "DMG*D8*".str_replace("-", "", $claim['subscriber_dob'])."*".$claim['subscriber_gender']."~";

                 // Add Employer Information if available //new
                if (!empty($claim['employer_name'])) {
                    $edi .= "NM1*36*2*" . strtoupper(substr($claim['employer_name'], 0, 60)) . 
                            "*****FI*" . ($claim['employer_id'] ?? '') . "~";
                }
                
                $edi .= "NM1*PR*2*".strtoupper(substr($data['payer_name'], 0, 60))."*****PI*".$data['payer_id']."~";
                $edi .= "REF*G2*".$claim['group_number']."~";
                
                // Patient Info (HL*3)
                $edi .= "HL*3*2*23*0~";
                $edi .= "PAT*19~";
                
                $edi .= "NM1*QC*1*".strtoupper($claim['subscriber_last_name'])."*".strtoupper($claim['subscriber_first_name'])."~";
                $edi .= "N3*".strtoupper(substr($claim['subscriber_street'], 0, 55))."~";
                $edi .= "N4*".strtoupper($claim['subscriber_city'])."*".$claim['subscriber_state']."*".substr($claim['subscriber_zip'], 0, 5)."~";
                $edi .= "DMG*D8*".str_replace("-", "", $claim['subscriber_dob'])."*".$claim['subscriber_gender']."~";
                
                // Claim Info
                $edi .= "CLM*".$claim['claim_number']."*".str_replace(".", ".", number_format($claim['claim_amount'], 2))."***".$claim['place_of_service'].":B:".$claim['claim_frequency']."*Y*A*Y*I~";
                $edi .= "REF*D9*".$claim['member_id']."~";
                $edi .= "HI*BK:".$claim['primary_diagnosis'];
                if (!empty($claim['additional_diagnosis'])) {
                    $edi .= "*BF:".$claim['additional_diagnosis'];
                }
                $edi .= "~";
                
                // Service Lines
                foreach ($claim['service_lines'] as $serviceLine) {
                    $edi .= "LX*".$serviceLine['service_line_number']."~";
                    $edi .= "SV1*HC:".$serviceLine['procedure_code']."*".str_replace(".", ".", number_format($serviceLine['charge_amount'], 2))."*UN*".$serviceLine['unit_count']."***".$serviceLine['diagnosis_pointer']."~";
                    $edi .= "DTP*472*D8*".str_replace("-", "", $serviceLine['date_of_service'])."~";
                }
            }

    }






   // Encounter
    elseif($claimType=='EN'){

        // Provider Info (HL1)
        $edi .= "HL*1**20*1~";
        $edi .= "PRV*BI*PXC*203BF0100Y~";
        $edi .= "NM1*85*2*".strtoupper(substr($data['provider_name'], 0, 60))."*****XX*".$data['provider_npi']."~";
        $edi .= "N3*".strtoupper(substr($data['provider_street'], 0, 55))."~";
        $edi .= "N4*".strtoupper($data['provider_city'])."*".$data['provider_state']."*".substr($data['provider_zip'], 0, 5)."~";
        $edi .= "REF*EI*".$data['provider_tax_id']."~";

        // Billing Provider Info
        $edi .= "NM1*87*2~";
        $edi .= "N3*".strtoupper(substr($data['provider_street'], 0, 55))."~";
        $edi .= "N4*".strtoupper($data['provider_city'])."*".$data['provider_state']."*".substr($data['provider_zip'], 0, 5)."~";

        // Process each claim
        foreach ($data['claims'] as $claim) {
            // Subscriber Info (HL2)
            $edi .= "HL*2*1*22*0~";
            $edi .= "SBR*P*18*".$claim['group_number']."******".$claim['insurance_type']."~";
            
            $edi .= "NM1*IL*1*".strtoupper($claim['subscriber_last_name'])."*".strtoupper($claim['subscriber_first_name'])."****MI*".$claim['member_id']."~";
            $edi .= "N3*".strtoupper(substr($claim['subscriber_street'], 0, 55))."~";
            $edi .= "N4*".strtoupper($claim['subscriber_city'])."*".$claim['subscriber_state']."*".substr($claim['subscriber_zip'], 0, 5)."~";
            $edi .= "DMG*D8*".str_replace("-", "", $claim['subscriber_dob'])."*".$claim['subscriber_gender']."~";
            
            $edi .= "NM1*PR*2*".strtoupper(substr($data['payer_name'], 0, 60))."*****PI*".$data['payer_id']."~";
            
            // Claim Info
            $edi .= "CLM*".$claim['claim_number']."*".str_replace(".", ".", number_format($claim['claim_amount'], 2))."***".$claim['place_of_service'].":B:".$claim['claim_frequency']."*Y*A*Y*I~";
            $edi .= "DTP*431*D8*".str_replace("-", "", $claim['date_of_service'])."~";
            $edi .= "REF*D9*".$claim['member_id']."~";
            $edi .= "HI*BK:".$claim['primary_diagnosis'];
            if (!empty($claim['additional_diagnosis'])) {
                $edi .= "*BF:".$claim['additional_diagnosis'];
            }
            $edi .= "~";
            
            // Rendering Provider
            $edi .= "NM1*77*2*".strtoupper(substr($claim['rendering_provider_name'], 0, 60))."*****XX*".$claim['rendering_npi']."~";
            $edi .= "N3*".strtoupper(substr($data['provider_street'], 0, 55))."~";
            $edi .= "N4*".strtoupper($data['provider_city'])."*".$data['provider_state']."*".substr($data['provider_zip'], 0, 5)."~";
            
            // Service Lines
            foreach ($claim['service_lines'] as $serviceLine) {
                $edi .= "LX*".$serviceLine['service_line_number']."~";
                $edi .= "SV1*HC:".$serviceLine['procedure_code']."*".str_replace(".", ".", number_format($serviceLine['charge_amount'], 2))."*UN*".$serviceLine['unit_count']."***1~";
                $edi .= "DTP*472*D8*".str_replace("-", "", $serviceLine['date_of_service'])."~";
            }
        }

    } 






    
    // COB Primary
    elseif($claimType=='A1'){

            // Provider Info (HL1)
            $edi .= "HL*1**20*1~";
            $edi .= "NM1*85*1*".strtoupper(substr($data['provider_name'], 0, 60))."*****XX*".$data['provider_npi']."~";
            $edi .= "N3*".strtoupper(substr($data['provider_street'], 0, 55))."~";
            $edi .= "N4*".strtoupper($data['provider_city'])."*".$data['provider_state']."*".substr($data['provider_zip'], 0, 5)."~";
            $edi .= "REF*EI*".$data['provider_tax_id']."~";
            $edi .= "PER*IC*".strtoupper(substr($data['submitter_contact'], 0, 60))."*TE*".$data['submitter_phone']."~";

            // Billing Provider Info
            $edi .= "NM1*87*2~";
            $edi .= "N3*".strtoupper(substr($data['provider_street'], 0, 55))."~";
            $edi .= "N4*".strtoupper($data['provider_city'])."*".$data['provider_state']."*".substr($data['provider_zip'], 0, 5)."~";

            // Process each claim
            foreach ($data['claims'] as $claim) {
                // Subscriber Info (HL2)
                $edi .= "HL*2*1*22*1~";
                // $edi .= "SBR*P********".$claim['insurance_type']."~";
                 $edi .= "SBR*P*18*".$claim['group_number']."******".$claim['insurance_type']."~";
                
                $edi .= "NM1*IL*1*".strtoupper($claim['subscriber_last_name'])."*".strtoupper($claim['subscriber_first_name'])."****MI*".$claim['member_id']."~";
                $edi .= "DMG*D8*".str_replace("-", "", $claim['subscriber_dob'])."*".$claim['subscriber_gender']."~";
                
                $edi .= "NM1*PR*2*".strtoupper(substr($data['payer_name'], 0, 60))."*****PI*".$data['payer_id']."~";
                $edi .= "N3*".strtoupper(substr($data['payer_street'], 0, 55))."~";
                $edi .= "N4*".strtoupper($data['payer_city'])."*".$data['payer_state']."*".substr($data['payer_zip'], 0, 5)."~";
                $edi .= "REF*G2*".$claim['group_number']."~";
                
                // Patient Info (HL3)
                $edi .= "HL*3*2*23*0~";
                $edi .= "PAT*19~";
                $edi .= "NM1*QC*1*".strtoupper($claim['subscriber_last_name'])."*".strtoupper($claim['subscriber_first_name'])."~";
                $edi .= "N3*".strtoupper(substr($claim['subscriber_street'], 0, 55))."~";
                $edi .= "N4*".strtoupper($claim['subscriber_city'])."*".$claim['subscriber_state']."*".substr($claim['subscriber_zip'], 0, 5)."~";
                $edi .= "DMG*D8*".str_replace("-", "", $claim['subscriber_dob'])."*".$claim['subscriber_gender']."~";
                
                // Claim Info
                $edi .= "CLM*".$claim['claim_number']."*".str_replace(".", ".", number_format($claim['claim_amount'], 2))."***".$claim['place_of_service'].":B:".$claim['claim_frequency']."*Y*A*Y*I*P~";
                $edi .= "HI*BK:".$claim['primary_diagnosis'];
                if (!empty($claim['additional_diagnosis'])) {
                    $edi .= "*BF:".$claim['additional_diagnosis'];
                }
                if (!empty($claim['condition_codes'])) {
                    foreach ((array)$claim['condition_codes'] as $code) {
                        $edi .= "*BF:".$code;
                    }
                }
                $edi .= "~";
                
                // Rendering Provider
                $edi .= "NM1*82*1*".strtoupper(substr($claim['rendering_provider_name'], 0, 60))."*****XX*".$claim['rendering_npi']."~";
                $edi .= "PRV*PE*PXC*204C00000X~";
                $edi .= "REF*G2*".$claim['group_number']."~";
                
                // Service Provider
                $edi .= "NM1*77*2*".strtoupper(substr($data['facility_name'], 0, 60))."*****XX*".$data['facility_npi']."~";
                $edi .= "N3*".strtoupper(substr($data['provider_street'], 0, 55))."~";
                $edi .= "N4*".strtoupper($data['provider_city'])."*".$data['provider_state']."*".substr($data['provider_zip'], 0, 5)."~";
                
                // Other Insurance Info (COB)
                $edi .= "SBR*S*01*******".$claim['insurance_type']."~";
                $edi .= "OI***Y*P**Y~";
                $edi .= "NM1*IL*1*".strtoupper($claim['subscriber_last_name'])."*".strtoupper($claim['subscriber_first_name'])."****MI*".$claim['member_id']."~";
                $edi .= "N3*".strtoupper(substr($claim['subscriber_street'], 0, 55))."~";
                $edi .= "N4*".strtoupper($claim['subscriber_city'])."*".$claim['subscriber_state']."*".substr($claim['subscriber_zip'], 0, 5)."~";
                $edi .= "NM1*PR*2*".strtoupper(substr($claim['other_payer_name'], 0, 60))."*****PI*".$claim['other_insurance_policy']."~";  //new
                
                // Service Lines
                foreach ($claim['service_lines'] as $serviceLine) {
                    $edi .= "LX*".$serviceLine['service_line_number']."~";
                    $edi .= "SV1*HC:".$serviceLine['procedure_code']."*".str_replace(".", ".", number_format($serviceLine['charge_amount'], 2))."*UN*".$serviceLine['unit_count']."***".$serviceLine['diagnosis_pointer']."~";
                    $edi .= "DTP*472*D8*".str_replace("-", "", $serviceLine['date_of_service'])."~";
                }
            }

    }




    
    // Medicare Secondary Payer (COB)
    elseif($claimType=='A2'){

        // Provider Info (HL1)
        $edi .= "HL*1**20*1~";
        $edi .= "NM1*85*2*".strtoupper(substr($data['provider_name'], 0, 60))."*****XX*".$data['provider_npi']."~";
        $edi .= "N3*".strtoupper(substr($data['provider_street'], 0, 55))."~";
        $edi .= "N4*".strtoupper($data['provider_city'])."*".$data['provider_state']."*".substr($data['provider_zip'], 0, 5)."~";
        $edi .= "REF*EI*".$data['provider_tax_id']."~";
        // $edi .= "REF*1G*".$data['group_number']."~";
        $edi .= "REF*1G*110101~";

        // Process each claim
        foreach ($data['claims'] as $claim) {
            // Subscriber Info (HL2) - Medicare as Secondary
            $edi .= "HL*2*1*22*0~";
            $edi .= "SBR*S*".$claim['msp_type_code']."*******MB~"; // MB = Medicare Part B
            
            $edi .= "NM1*IL*1*".strtoupper($claim['subscriber_last_name'])."*".strtoupper($claim['subscriber_first_name'])."****MI*".$claim['medicare_id']."~";
            $edi .= "N3*".strtoupper(substr($claim['subscriber_street'], 0, 55))."~";
            $edi .= "N4*".strtoupper($claim['subscriber_city'])."*".$claim['subscriber_state']."*".substr($claim['subscriber_zip'], 0, 5)."~";
            $edi .= "DMG*D8*".str_replace("-", "", $claim['subscriber_dob'])."*".$claim['subscriber_gender']."~";
            
            // Medicare Payer Info
            $edi .= "NM1*PR*2*".strtoupper(substr($data['receiver_name'], 0, 60))."*****PI*".$data['receiver_code']."~";
            $edi .= "N3*".strtoupper(substr($data['payer_street'], 0, 55))."~";
            $edi .= "N4*".strtoupper($data['payer_city'])."*".$data['payer_state']."*".substr($data['payer_zip'], 0, 5)."~";
            
            // Claim Info
            $edi .= "CLM*".$claim['claim_number']."*".str_replace(".", ".", number_format($claim['claim_amount'], 2))."***".$claim['place_of_service'].":B:".$claim['claim_frequency']."*Y*A*Y*Y*P~";
            $edi .= "HI*BK:".$claim['primary_diagnosis'];
            if (!empty($claim['additional_diagnosis'])) {
                $edi .= "*BF:".$claim['additional_diagnosis'];
            }
            $edi .= "~";
            
            // Referring Provider
            if (!empty($claim['referring_provider_name'])) {
                $edi .= "NM1*DN*1*".strtoupper(substr($claim['referring_provider_name'], 0, 60))."~";
                $edi .= "REF*1G*".$claim['group_number']."~";
            }
            
            // Rendering Provider
            $edi .= "NM1*82*1*".strtoupper(substr($claim['rendering_provider_name'], 0, 60))."*****XX*".$claim['rendering_npi']."~";
            $edi .= "PRV*PE*PXC*207X00000X~";
            $edi .= "REF*G2*".$claim['group_number']."CCC~";
            
            // Primary Payer Info (COB)
            $edi .= "SBR*P*01**".$claim['group_number']."*****CI~";
            $edi .= "AMT*D*80~"; // Paid Amount
            $edi .= "AMT*A8*15~"; // Coinsurance Amount
            $edi .= "OI***Y*P**Y~";
            
            // Subscriber Info for Primary Payer
            $edi .= "NM1*IL*1*".strtoupper($claim['subscriber_last_name'])."*".strtoupper($claim['subscriber_first_name'])."****MI*".$claim['member_id']."~";
            $edi .= "N3*".strtoupper(substr($claim['subscriber_street'], 0, 55))."~";
            $edi .= "N4*".strtoupper($claim['subscriber_city'])."*".$claim['subscriber_state']."*".substr($claim['subscriber_zip'], 0, 5)."~";
            
            // Primary Payer
            $edi .= "NM1*PR*2*".strtoupper(substr($data['payer_name'], 0, 60))."*****PI*".$data['payer_id']."~";
            
            // Service Lines
            foreach ($claim['service_lines'] as $serviceLine) {
                $edi .= "LX*".$serviceLine['service_line_number']."~";
                $edi .= "SV1*HC:".$serviceLine['procedure_code']."*".str_replace(".", ".", number_format($serviceLine['charge_amount'], 2))."*UN*".$serviceLine['unit_count']."***".$serviceLine['diagnosis_pointer']."~";
                $edi .= "DTP*472*D8*".str_replace("-", "", $serviceLine['date_of_service'])."~";
                
                // Service Line Adjudication (SVD/CAS)
                $edi .= "SVD*".$data['payer_id']."*80*HC:".$serviceLine['procedure_code']."**1~";
                $edi .= "CAS*CO*42*25~";
                $edi .= "CAS*PR*2*15~";
                $edi .= "DTP*573*D8*".str_replace("-", "", $serviceLine['date_of_service'])."~";
            }
        }

    }





     // Ambulance
    elseif($claimType=='A3'){
        // Provider Info (HL1) - Ambulance Service
        $edi .= "HL*1**20*1~";
        $edi .= "PRV*BI*PXC*3416L0300X~"; // Ambulance taxonomy code
        $edi .= "NM1*85*2*".strtoupper(substr($data['provider_name'], 0, 60))."*****XX*".$data['provider_npi']."~";
        $edi .= "N3*".strtoupper(substr($data['provider_street'], 0, 55))."~";
        $edi .= "N4*".strtoupper($data['provider_city'])."*".$data['provider_state']."*".substr($data['provider_zip'], 0, 5)."~";
        $edi .= "REF*EI*".$data['provider_tax_id']."~";

        // Process each claim
        foreach ($data['claims'] as $claim) {
            // Subscriber Info (HL2)
            $edi .= "HL*2*1*22*0~"; // 0 = subscriber is patient
            $edi .= "SBR*P*18*******MB~"; // MB = Medicare Part B
            
            // Patient/Subscriber Info
            $edi .= "NM1*IL*1*".strtoupper($claim['subscriber_last_name'])."*".strtoupper($claim['subscriber_first_name'])."****MI*".$claim['member_id']."~";
            $edi .= "N3*".strtoupper(substr($claim['subscriber_street'], 0, 55))."~";
            $edi .= "N4*".strtoupper($claim['subscriber_city'])."*".$claim['subscriber_state']."*".substr($claim['subscriber_zip'], 0, 5)."~";
            $edi .= "DMG*D8*".str_replace("-", "", $claim['subscriber_dob'])."*".$claim['subscriber_gender']."~";
            
            // Payer Info (Medicare)
            $edi .= "NM1*PR*2*".strtoupper(substr($data['receiver_name'], 0, 60))."*****PI*".$data['receiver_code']."~";
            $edi .= "N3*".strtoupper(substr($data['payer_street'], 0, 55))."~";
            $edi .= "N4*".strtoupper($data['payer_city'])."*".$data['payer_state']."*".substr($data['payer_zip'], 0, 5)."~";
            
            // Claim Info - Ambulance Specific
            $edi .= "CLM*".$claim['claim_number']."*".str_replace(".", ".", number_format($claim['claim_amount'], 2))."***41:B:1*Y*A*Y*Y*S~";
            $edi .= "DTP*439*D8*".str_replace("-", "", $claim['date_of_service'])."~";
            
            // Ambulance Transport Details (CR1)
            $transportReason = $claim['transport_reason'] == 'A' ? 'A*DH' : 'B*NH'; // A=Emergency, B=Non-emergency
            $edi .= "CR1*LB*".str_replace(".", ".", $claim['mileage'])."**".$transportReason."*21****PATIENT IMMOBILIZED~";
            
            // Condition Codes (CRC)
            $edi .= "CRC*07*Y*04*06*09~"; // Ambulance certification
            $edi .= "CRC*07*N*05*07*08~"; // Patient condition
            
            // Diagnosis Codes
            $edi .= "HI*BK:".$claim['primary_diagnosis'];
            if (!empty($claim['additional_diagnosis'])) {
                $edi .= "*BF:".$claim['additional_diagnosis'];
            }
            $edi .= "~";
            
            // Pickup Location (PW)
            $edi .= "NM1*PW*2~";
            $edi .= "N3*".strtoupper(substr($claim['pickup_address'], 0, 55))."~";
            $edi .= "N4*".strtoupper($claim['subscriber_city'])."*".$claim['subscriber_state']."*".substr($claim['pickup_zip'], 0, 5)."~";
            
            // Dropoff Location (45)
            $edi .= "NM1*45*2~";
            $edi .= "N3*".strtoupper(substr($claim['dropoff_address'], 0, 55))."~";
            $edi .= "N4*".strtoupper($data['provider_city'])."*".$data['provider_state']."*".substr($data['provider_zip'], 0, 5)."~";
            
            // Service Line (Ambulance)
            foreach ($claim['service_lines'] as $serviceLine) {
                $edi .= "LX*".$serviceLine['service_line_number']."~";
                $edi .= "SV1*HC:".$serviceLine['procedure_code']."*".str_replace(".", ".", number_format($serviceLine['charge_amount'], 2))."*UN*".$serviceLine['unit_count']."***1:2:3:4**Y~";
                $edi .= "DTP*472*D8*".str_replace("-", "", $serviceLine['date_of_service'])."~";
                $edi .= "QTY*PT*2~"; // Patients transported
                $edi .= "REF*6R*1001~"; // Ambulance run number
                $edi .= "NTE*ADD*".strtoupper(substr($claim['primary_diagnosis'], 0, 80))."~";
            }
        }
    }








     // Chiropractic
    elseif($claimType=='CH'){
        // Provider Info (HL1) - Chiropractor
        $edi .= "HL*1**20*1~";
        $edi .= "NM1*85*1*".strtoupper(substr($data['provider_name'], 0, 60))."*****XX*".$data['provider_npi']."~";
        $edi .= "N3*".strtoupper(substr($data['provider_street'], 0, 55))."~";
        $edi .= "N4*".strtoupper($data['provider_city'])."*".$data['provider_state']."*".substr($data['provider_zip'], 0, 5)."~";
        $edi .= "REF*EI*".$data['provider_tax_id']."~";
        $edi .= "PER*IC*DR*TE*".$data['submitter_phone']."~";

        // Process each claim
        foreach ($data['claims'] as $claim) {
            // Subscriber Info (HL2)
            $edi .= "HL*2*1*22*0~"; // 0 = subscriber is patient
            $edi .= "SBR*P*18*******MB~"; // MB = Medicare Part B
            
            // Patient/Subscriber Info
            $edi .= "NM1*IL*1*".strtoupper($claim['subscriber_last_name'])."*".strtoupper($claim['subscriber_first_name'])."****MI*".$claim['member_id']."~";
            $edi .= "N3*".strtoupper(substr($claim['subscriber_street'], 0, 55))."~";
            $edi .= "N4*".strtoupper($claim['subscriber_city'])."*".$claim['subscriber_state']."*".substr($claim['subscriber_zip'], 0, 5)."~";
            $edi .= "DMG*D8*".str_replace("-", "", $claim['subscriber_dob'])."*".$claim['subscriber_gender']."~";
            
            // Payer Info (Medicare)
            $edi .= "NM1*PR*2*".strtoupper(substr($data['receiver_name'], 0, 60))."*****PI*".$data['receiver_code']."~";
            
            // Claim Info - Chiropractic Specific
            $edi .= "CLM*".$claim['claim_number']."*".str_replace(".", ".", number_format($claim['claim_amount'], 2))."***11:B:1*Y*A*Y*Y~";
            $edi .= "DTP*454*D8*".str_replace("-", "", $claim['date_of_service'])."~"; // Initial treatment date
            $edi .= "DTP*453*D8*".str_replace("-", "", $claim['date_of_service'])."~"; // Onset date
            $edi .= "DTP*455*D8*".str_replace("-", "", $claim['date_of_service'])."~"; // Last visit date
            
            // Chiropractic Treatment Details (CR2)
            $spinalRegion = $claim['spinal_region'] ?? 'A'; // A=All, C=Cervical, etc.
            $edi .= "CR2********".$spinalRegion."**CHRONIC PAIN AND DISCOMFORT~";
            
            // Diagnosis Codes
            $edi .= "HI*BK:".$claim['primary_diagnosis'];
            if (!empty($claim['additional_diagnosis'])) {
                $edi .= "*BF:".$claim['additional_diagnosis'];
            }
            $edi .= "~";
            
            // Service Line (Chiropractic)
            foreach ($claim['service_lines'] as $serviceLine) {
                $edi .= "LX*".$serviceLine['service_line_number']."~";
                $edi .= "SV1*HC:".$serviceLine['procedure_code']."*".str_replace(".", ".", number_format($serviceLine['charge_amount'], 2))."*UN*".$serviceLine['unit_count']."**".$serviceLine['diagnosis_pointer']."~";
                $edi .= "DTP*472*D8*".str_replace("-", "", $serviceLine['date_of_service'])."~";
                $edi .= "REF*6R*01~"; // Treatment series number
            }
        }

    }





     // oxygen
    elseif($claimType=='O2'){

        // Provider Info (HL1) - DME Supplier
        $edi .= "HL*1**20*1~";
        $edi .= "NM1*85*2*".strtoupper(substr($data['provider_name'], 0, 60))."*****XX*".$data['provider_npi']."~";
        $edi .= "N3*".strtoupper(substr($data['provider_street'], 0, 55))."~";
        $edi .= "N4*".strtoupper($data['provider_city'])."*".$data['provider_state']."*".substr($data['provider_zip'], 0, 5)."~";
        $edi .= "REF*EI*".$data['provider_tax_id']."~";

        // Process each claim
        foreach ($data['claims'] as $claim) {
            // Subscriber Info (HL2)
            $edi .= "HL*2*1*22*0~"; // 0 = subscriber is patient
            $edi .= "SBR*P*18*******MB~"; // MB = Medicare Part B
            
            // Patient/Subscriber Info
            $edi .= "NM1*IL*1*".strtoupper($claim['subscriber_last_name'])."*".strtoupper($claim['subscriber_first_name'])."****MI*".$claim['member_id']."~";
            $edi .= "N3*".strtoupper(substr($claim['subscriber_street'], 0, 55))."~";
            $edi .= "N4*".strtoupper($claim['subscriber_city'])."*".$claim['subscriber_state']."*".substr($claim['subscriber_zip'], 0, 5)."~";
            $edi .= "DMG*D8*".str_replace("-", "", $claim['subscriber_dob'])."*".$claim['subscriber_gender']."~";
            
            // Payer Info (DME MAC)
            $edi .= "NM1*PR*2*".strtoupper(substr($data['receiver_name'], 0, 60))."*****PI*".$data['receiver_code']."~";
            
            // Claim Info - Oxygen Specific
            $edi .= "CLM*".$claim['claim_number']."*".str_replace(".", ".", number_format($claim['claim_amount'], 2))."***11:B:1*Y*A*Y*Y~";
            
            // Diagnosis Codes
            $edi .= "HI*BK:".$claim['primary_diagnosis'];
            if (!empty($claim['additional_diagnosis'])) {
                $edi .= "*BF:".$claim['additional_diagnosis'];
            }
            $edi .= "~";
            
            // Service Lines
            foreach ($claim['service_lines'] as $serviceLine) {
                $edi .= "LX*".$serviceLine['service_line_number']."~";
                $edi .= "SV1*HC:".$serviceLine['procedure_code'].":RR*".str_replace(".", ".", number_format($serviceLine['charge_amount'], 2))."*UN*".$serviceLine['unit_count']."***1:2~";
                
                // Oxygen/DME Specific Segments
                $edi .= "PWK*".$claim['documentation_type_code']."*".$claim['documentation_transmission_code']."~";
                $edi .= "CR3*".$claim['certification_type_code']."*".$claim['oxygen_equipment_type_code']."*99~";
                $edi .= "DTP*472*RD8*".str_replace("-", "", $claim['service_date_format'])."~";
                $edi .= "DTP*607*D8*".str_replace("-", "", $claim['certification_start_date'])."~";
                $edi .= "DTP*463*D8*".str_replace("-", "", $claim['last_certification_date'])."~";
                $edi .= "DTP*461*D8*".str_replace("-", "", $claim['recertification_date'])."~";
                
                // Ordering Provider
                $edi .= "NM1*DK*1*".strtoupper(substr($claim['ordering_provider_name'], 0, 60))."*****XX*".$claim['ordering_provider_npi']."~";
                $edi .= "N3*".strtoupper(substr($claim['ordering_provider_street'], 0, 55))."~";
                $edi .= "N4*".strtoupper($claim['ordering_provider_city'])."*".$claim['ordering_provider_state']."*".substr($claim['ordering_provider_zip'], 0, 5)."~";
                $edi .= "REF*1G*".$claim['group_number']."~";
                $edi .= "PER*IC*".strtoupper(substr($claim['ordering_provider_contact_name'], 0, 60))."*TE*".$claim['ordering_provider_contact_phone']."~";
                
                // Form Data
                $edi .= "LQ*UT*04.03~";
                $edi .= "FRM*1A**".$claim['frm_1']."~";
                $edi .= "FRM*1C**".$claim['frm_2']."~";
                $edi .= "FRM*9*Y~";
            }
        }

    }







     // Wheelchair
    elseif($claimType=='WC'){

        // Provider Info (HL1) - DME Supplier
        $edi .= "HL*1**20*1~";
        $edi .= "NM1*85*2*".strtoupper(substr($data['provider_name'], 0, 60))."*****XX*".$data['provider_npi']."~";
        $edi .= "N3*".strtoupper(substr($data['provider_street'], 0, 55))."~";
        $edi .= "N4*".strtoupper($data['provider_city'])."*".$data['provider_state']."*".substr($data['provider_zip'], 0, 5)."~";
        $edi .= "REF*EI*".$data['provider_tax_id']."~";
        // $edi .= "REF*1G*".$data['group_number']."~";
        $edi .= "REF*1G*110101~";

        // Process each claim
        foreach ($data['claims'] as $claim) {
            // Subscriber Info (HL2)
            $edi .= "HL*2*1*22*0~";
            $edi .= "SBR*P*18*******MB~"; // MB = Medicare Part B
            $edi .= "PAT*******01*155~"; // 01=Patient unable to walk, 155=Wheelchair
            
            // Patient/Subscriber Info
            $edi .= "NM1*IL*1*".strtoupper($claim['subscriber_last_name'])."*".strtoupper($claim['subscriber_first_name'])."****MI*".$claim['member_id']."~";
            $edi .= "N3*".strtoupper(substr($claim['subscriber_street'], 0, 55))."~";
            $edi .= "N4*".strtoupper($claim['subscriber_city'])."*".$claim['subscriber_state']."*".substr($claim['subscriber_zip'], 0, 5)."~";
            $edi .= "DMG*D8*".str_replace("-", "", $claim['subscriber_dob'])."*".$claim['subscriber_gender']."~";
            
            // Payer Info (DME MAC)
            $edi .= "NM1*PR*2*".strtoupper(substr($data['receiver_name'], 0, 60))."*****PI*".$data['receiver_code']."~";
            
            // Claim Info - Wheelchair Specific
            $edi .= "CLM*".$claim['claim_number']."*".str_replace(".", ".", number_format($claim['claim_amount'], 2))."***12:B:1*Y*A*Y*Y~";
            
            // Diagnosis Codes
            $edi .= "HI*BK:".$claim['primary_diagnosis'];
            if (!empty($claim['additional_diagnosis'])) {
                $edi .= "*BF:".$claim['additional_diagnosis'];
            }
            $edi .= "~";
            
            // Service Lines
            foreach ($claim['service_lines'] as $serviceLine) {
                $edi .= "LX*".$serviceLine['service_line_number']."~";
                $edi .= "SV1*HC:".$claim['hcpcs_code'].":".$claim['purchase_rental_indicator'].":KH:BR*".str_replace(".", ".", number_format($serviceLine['charge_amount'], 2))."*UN*".$serviceLine['unit_count']."***1:2~";
                
                // Wheelchair Specific Segments
                $edi .= "PWK*CT*AD~";
                $edi .= "CR3*I*MO*99~";
                $edi .= "DTP*472*RD8*".str_replace("-", "", $claim['date_of_service'])."-".str_replace("-", "", $claim['date_of_service'])."~";
                $edi .= "DTP*463*D8*".str_replace("-", "", $claim['date_of_service'])."~";
                $edi .= "DTP*461*D8*".str_replace("-", "", $claim['date_of_service'])."~";
                $edi .= "MEA*TR*HT*70~"; // Patient height
                
                // Ordering Provider
                $edi .= "NM1*DK*1*".strtoupper(substr($claim['referring_provider_name'], 0, 60))."*****XX*".$claim['referring_npi']."~";
                $edi .= "N3*".strtoupper(substr($data['provider_street'], 0, 55))."~";
                $edi .= "N4*".strtoupper($data['provider_city'])."*".$data['provider_state']."*".substr($data['provider_zip'], 0, 5)."~";
                $edi .= "PER*IC*".strtoupper(substr($claim['ordering_contact_name'], 0, 60))."*TE*".$claim['ordering_contact_phone']."~";
                
                // Form Data
                $edi .= "LQ*UT*".$claim['form_id']."~";
                foreach ($claim['frm'] as $formNum => $formValue) {
                    $edi .= "FRM*".$formNum."*".$formValue."~";
                }
            }
        }

    }







    // Anesthesia
    elseif($claimType=='AN'){
        // Provider Info (HL1)
        $edi .= "HL*1**20*1~";
        $edi .= "NM1*85*2*".strtoupper(substr($data['provider_name'], 0, 60))."*****XX*".$data['provider_npi']."~";
        $edi .= "N3*".strtoupper(substr($data['provider_street'], 0, 55))."~";
        $edi .= "N4*".strtoupper($data['provider_city'])."*".$data['provider_state']."*".substr($data['provider_zip'], 0, 5)."~";
        $edi .= "REF*EI*".$data['provider_tax_id']."~";

        // Process each claim
        foreach ($data['claims'] as $claim) {
            // Subscriber Info (HL2)
            $edi .= "HL*2*1*22*0~";
            $edi .= "SBR*P*18*******".$claim['insurance_type']."~";
            
            // Patient/Subscriber Info
            $edi .= "NM1*IL*1*".strtoupper($claim['subscriber_last_name'])."*".strtoupper($claim['subscriber_first_name'])."****MI*".$claim['member_id']."~";
            $edi .= "N3*".strtoupper(substr($claim['subscriber_street'], 0, 55))."~";
            $edi .= "N4*".strtoupper($claim['subscriber_city'])."*".$claim['subscriber_state']."*".substr($claim['subscriber_zip'], 0, 5)."~";
            $edi .= "DMG*D8*".str_replace("-", "", $claim['subscriber_dob'])."*".$claim['subscriber_gender']."~";
            
            // Payer Info
            $edi .= "NM1*PR*2*".strtoupper(substr($data['payer_name'], 0, 60))."*****PI*".$data['payer_id']."~";
            
            // Claim Info - Anesthesia Specific
            $edi .= "CLM*".$claim['claim_number']."*".str_replace(".", ".", number_format($claim['claim_amount'], 2))."***22:B:1*Y*A*Y*Y~";
            $edi .= "HI*BK:".$claim['primary_diagnosis'];
            if (!empty($claim['additional_diagnosis'])) {
                $edi .= "*BF:".$claim['additional_diagnosis'];
            }
            $edi .= "~";
            
            // Rendering Provider (Anesthesiologist)
            $edi .= "NM1*82*1*".strtoupper(substr($claim['rendering_provider_name'], 0, 60))."*****XX*".$claim['rendering_npi']."~";
            $edi .= "PRV*PE*PXC*207L00000X~"; // Anesthesiology taxonomy code
            $edi .= "REF*G2*".$claim['group_number']."~";
            
            // Facility Info
            $edi .= "NM1*77*2*".strtoupper(substr($data['facility_name'], 0, 60))."*****XX*".$data['facility_npi']."~";
            $edi .= "N3*".strtoupper(substr($data['provider_street'], 0, 55))."~";
            $edi .= "N4*".strtoupper($data['provider_city'])."*".$data['provider_state']."*".substr($data['provider_zip'], 0, 5)."~";
            
            // Service Line (Anesthesia)
            foreach ($claim['service_lines'] as $serviceLine) {
                $edi .= "LX*".$serviceLine['service_line_number']."~";
                $edi .= "SV1*HC:".$serviceLine['procedure_code'].":QK:QS:P1*".str_replace(".", ".", number_format($serviceLine['charge_amount'], 2))."*MJ*".$claim['anesthesia_minutes']."***".$serviceLine['diagnosis_pointer']."~";
                $edi .= "DTP*472*D8*".str_replace("-", "", $serviceLine['date_of_service'])."~";
            }
        }

    }


    



    // Drugs
    elseif($claimType=='RX'){

        // Provider Info (HL1)
        $edi .= "HL*1**20*1~";
        $edi .= "NM1*85*2*".strtoupper(substr($data['provider_name'], 0, 60))."*****XX*".$data['provider_npi']."~";
        $edi .= "N3*".strtoupper(substr($data['provider_street'], 0, 55))."~";
        $edi .= "N4*".strtoupper($data['provider_city'])."*".$data['provider_state']."*".substr($data['provider_zip'], 0, 5)."~";
        $edi .= "REF*EI*".$data['provider_tax_id']."~";

        // Process each claim
        foreach ($data['claims'] as $claim) {
            // Subscriber Info (HL2)
            $edi .= "HL*2*1*22*0~";
            $edi .= "SBR*P*18*".$claim['group_number']."******".$claim['insurance_type']."~";
            
            // Patient/Subscriber Info
            $edi .= "NM1*IL*1*".strtoupper($claim['subscriber_last_name'])."*".strtoupper($claim['subscriber_first_name'])."****MI*".$claim['member_id']."~";
            $edi .= "N3*".strtoupper(substr($claim['subscriber_street'], 0, 55))."~";
            $edi .= "N4*".strtoupper($claim['subscriber_city'])."*".$claim['subscriber_state']."*".substr($claim['subscriber_zip'], 0, 5)."~";
            $edi .= "DMG*D8*".str_replace("-", "", $claim['subscriber_dob'])."*".$claim['subscriber_gender']."~";
            
            // Payer Info
            $edi .= "NM1*PR*2*".strtoupper(substr($data['payer_name'], 0, 60))."*****XV*".$data['payer_id']."~";
            
            // Claim Info
            $edi .= "CLM*".$claim['claim_number']."*".str_replace(".", ".", number_format($claim['claim_amount'], 2))."***11:B:1*Y*A*Y*Y~";
            $edi .= "HI*BK:".$claim['primary_diagnosis'];
            if (!empty($claim['additional_diagnosis'])) {
                $edi .= "*BF:".$claim['additional_diagnosis'];
            }
            $edi .= "~";
            
            // Rendering Provider
            $edi .= "NM1*82*1*".strtoupper(substr($claim['rendering_provider_name'], 0, 60))."*****XX*".$claim['rendering_npi']."~";
            $edi .= "PRV*PE*PXC*208D00000X~"; // Family Practice taxonomy code
            
            // Service Lines
            $lineCounter = 1;
            foreach ($claim['service_lines'] as $serviceLine) {
                $edi .= "LX*".$lineCounter."~";
                $edi .= "SV1*HC:".$serviceLine['procedure_code']."*".str_replace(".", ".", number_format($serviceLine['charge_amount'], 2))."*UN*".$serviceLine['unit_count']."***".$serviceLine['diagnosis_pointer']."~";
                $edi .= "DTP*472*D8*".str_replace("-", "", $serviceLine['date_of_service'])."~";
                
                // Drug Information (for J-codes)
                // if (strpos($serviceLine['procedure_code'], 'J') === 0) {
                    $edi .= "AMT*T*".str_replace(".", ".", number_format($serviceLine['charge_amount'], 2))."~";
                    $edi .= "LIN**N4*".$claim['ndc_code']."~";
                    $edi .= "CTP****".$claim['drug_quantity']."*".$claim['drug_unit_of_measure']."~";
                // }
                
                $lineCounter++;
            }
        }

    }



    

    // PPO Repriced Claim
    elseif($claimType=='PP'){
        // Provider Info (HL1)
        $edi .= "HL*1**20*1~";
        $edi .= "NM1*85*2*".strtoupper(substr($data['provider_name'], 0, 60))."*****XX*".$data['provider_npi']."~";
        $edi .= "N3*".strtoupper(substr($data['provider_street'], 0, 55))."~";
        $edi .= "N4*".strtoupper($data['provider_city'])."*".$data['provider_state']."*".substr($data['provider_zip'], 0, 5)."~";
        $edi .= "REF*EI*".$data['provider_tax_id']."~";
        $edi .= "PER*IC*".strtoupper(substr($data['submitter_contact'], 0, 60))."*TE*".$data['submitter_phone']."~";

        // Process each claim
        foreach ($data['claims'] as $claim) {
            // Subscriber Info (HL2)
            $edi .= "HL*2*1*22*0~";
            $edi .= "SBR*P*18*".$claim['group_number']."******".$claim['insurance_type']."~";
            
            // Patient/Subscriber Info
            $edi .= "NM1*IL*1*".strtoupper($claim['subscriber_last_name'])."*".strtoupper($claim['subscriber_first_name'])."****MI*".$claim['member_id']."~";
            $edi .= "N3*".strtoupper(substr($claim['subscriber_street'], 0, 55))."~";
            $edi .= "N4*".strtoupper($claim['subscriber_city'])."*".$claim['subscriber_state']."*".substr($claim['subscriber_zip'], 0, 5)."~";
            $edi .= "DMG*D8*".str_replace("-", "", $claim['subscriber_dob'])."*".$claim['subscriber_gender']."~";
            
            // Payer Info
            $edi .= "NM1*PR*2*".strtoupper(substr($data['payer_name'], 0, 60))."*****PI*".$data['payer_id']."~";
            
            // Claim Info - Repriced
            $edi .= "CLM*".$claim['claim_number']."-RI*".str_replace(".", ".", number_format($claim['claim_amount'], 2))."***11:B:1*Y*A*Y*Y*P~";
            $edi .= "REF*9A*".$claim['ppo_network_id']."~";
            $edi .= "REF*D9*".$claim['member_id']."~";
            $edi .= "REF*9F*REFNBR~";
            $edi .= "HI*BK:".$claim['primary_diagnosis'];
            if (!empty($claim['additional_diagnosis'])) {
                $edi .= "*BF:".$claim['additional_diagnosis'];
            }
            $edi .= "~";
            $edi .= "HCP*04*".str_replace(".", ".", number_format($claim['repriced_amount'] - 2, 2))."*2*908231234~";
            
            // Referring Provider
            $edi .= "NM1*DN*1*".strtoupper(substr($claim['referring_provider_name'], 0, 60))."*****XX*".$claim['referring_npi']."~";
            
            // Rendering Provider
            $edi .= "NM1*82*1*".strtoupper(substr($claim['rendering_provider_name'], 0, 60))."*****XX*".$claim['rendering_npi']."~";
            
            // Facility Info
            $edi .= "NM1*77*2*".strtoupper(substr($data['facility_name'], 0, 60))."~";
            $edi .= "N3*".strtoupper(substr($data['provider_street'], 0, 55))."~";
            $edi .= "N4*".strtoupper($data['provider_city'])."*".$data['provider_state']."*".substr($data['provider_zip'], 0, 5)."~";
            
            // Service Line
            foreach ($claim['service_lines'] as $serviceLine) {
                $edi .= "LX*".$serviceLine['service_line_number']."~";
                $edi .= "SV1*HC:".$serviceLine['procedure_code'].":RR*".str_replace(".", ".", number_format($serviceLine['charge_amount'], 2))."*UN*".$serviceLine['unit_count']."***".$serviceLine['diagnosis_pointer']."~";
                $edi .= "DTP*472*D8*".str_replace("-", "", $serviceLine['date_of_service'])."~";
                $edi .= "HCP*03*".str_replace(".", ".", number_format($serviceLine['charge_amount'] - 1.25, 2))."*1.25*908231234~";
            }
        }
        
    }





       // Out of Network Repriced Claim
    elseif($claimType=='ON'){
         // Provider Info (HL1) - Out-of-Network Provider
        $edi .= "HL*1**20*1~";
        $edi .= "NM1*85*2*".strtoupper(substr($data['provider_name'], 0, 60))."*****XX*".$data['provider_npi']."~";
        $edi .= "N3*".strtoupper(substr($data['provider_street'], 0, 55))."~";
        $edi .= "N4*".strtoupper($data['provider_city'])."*".$data['provider_state']."*".substr($data['provider_zip'], 0, 5)."~";
        $edi .= "REF*EI*".$data['provider_tax_id']."~";

        // Process each claim
        foreach ($data['claims'] as $claim) {
            // Subscriber Info (HL2)
            $edi .= "HL*2*1*22*1~";
            $edi .= "SBR*P**".$claim['group_number']."******".$claim['insurance_type']."~";
            
            // Patient/Subscriber Info
            $edi .= "NM1*IL*1*".strtoupper($claim['subscriber_last_name'])."*".strtoupper($claim['subscriber_first_name'])."****MI*".$claim['member_id']."~";
            $edi .= "N3*".strtoupper(substr($claim['subscriber_street'], 0, 55))."~";
            $edi .= "N4*".strtoupper($claim['subscriber_city'])."*".$claim['subscriber_state']."*".substr($claim['subscriber_zip'], 0, 5)."~";
            $edi .= "DMG*D8*".str_replace("-", "", $claim['subscriber_dob'])."*".$claim['subscriber_gender']."~";
            
            // Payer Info
            $edi .= "NM1*PR*2*".strtoupper(substr($data['payer_name'], 0, 60))."*****PI*".$data['payer_id']."~";
            
            // Patient Info (HL3)
            $edi .= "HL*3*2*23*0~";
            $edi .= "PAT*19~";
            $edi .= "NM1*QC*1*".strtoupper($claim['subscriber_last_name'])."*".strtoupper($claim['subscriber_first_name'])."~";
            $edi .= "N3*".strtoupper(substr($claim['subscriber_street'], 0, 55))."~";
            $edi .= "N4*".strtoupper($claim['subscriber_city'])."*".$claim['subscriber_state']."*".substr($claim['subscriber_zip'], 0, 5)."~";
            $edi .= "DMG*D8*".str_replace("-", "", $claim['subscriber_dob'])."*".$claim['subscriber_gender']."~";
            
            // Claim Info - Out-of-Network Specific
            $edi .= "CLM*".$claim['claim_number']."*".str_replace(".", ".", number_format($claim['claim_amount'], 2))."***23:B:1*Y*A*Y*Y*P~";
            $edi .= "REF*9A*".$claim['auth_number']."~";
            $edi .= "REF*D9*".$claim['member_id']."~";
            $edi .= "HI*BK:".$claim['primary_diagnosis'];
            if (!empty($claim['additional_diagnosis'])) {
                $edi .= "*BF:".$claim['additional_diagnosis'];
            }
            $edi .= "~";
            $edi .= "HCP*00*0**333001234*********T1~"; // Out-of-network pricing indicator
            
            // Rendering Provider
            $edi .= "NM1*82*1*".strtoupper(substr($claim['rendering_provider_name'], 0, 60))."*****XX*".$claim['rendering_npi']."~";
            
            // Secondary Insurance Info
            $edi .= "SBR*S*18*".$claim['group_number']."******".$claim['insurance_type']."~";
            $edi .= "OI***Y***Y~"; // Out-of-network benefits information
            $edi .= "NM1*IL*1*".strtoupper($claim['subscriber_last_name'])."*".strtoupper($claim['subscriber_first_name'])."****MI*".$claim['member_id']."~";
            $edi .= "N3*".strtoupper(substr($claim['subscriber_street'], 0, 55))."~";
            $edi .= "N4*".strtoupper($claim['subscriber_city'])."*".$claim['subscriber_state']."*".substr($claim['subscriber_zip'], 0, 5)."~";
            $edi .= "NM1*PR*2*".strtoupper(substr($data['payer_name'], 0, 60))."*****PI*".$data['payer_id']."~";
            
            // Service Line
            foreach ($claim['service_lines'] as $serviceLine) {
                $edi .= "LX*".$serviceLine['service_line_number']."~";
                $edi .= "SV1*HC:".$serviceLine['procedure_code']."*".str_replace(".", ".", number_format($serviceLine['charge_amount'], 2))."*UN*".$serviceLine['unit_count']."***".$serviceLine['diagnosis_pointer']."~";
                $edi .= "DTP*472*D8*".str_replace("-", "", $serviceLine['date_of_service'])."~";
            }
        }
        
    }

   







    $segmentCount = substr_count($edi, '~')+1-2;
    $edi .= "SE*".$segmentCount."*".$data['se02']."~";
    $edi .= "GE*1*1~";
    
    // IEA Segment
    $edi .= "IEA*1*".str_pad($data['control_number'], 9, '0', STR_PAD_LEFT)."~";

    return $edi;
}

















}
