<?php

namespace App\Http\Controllers\Multiple;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Carbon\Carbon;
use App\Models\User;
use Hash;
use Auth;
use App\Models\EdiFileModel;
use App\Models\Acknowledge999FileModel;
use Illuminate\Support\Facades\Storage;
use DateTime;

class MultipleEdiDController extends Controller
{
    
    public function create_multiple_edid_form(){
        return view('multiple.create_multiple_edid_form');
    }




    public function generate837D(Request $request)
{
    // dd($request->all());
    // Validate the request data
    $validated = $request->validate([
        // Transmission Info
        'sender_id' => 'required|string|max:15',
        'receiver_id' => 'required|string|max:15',
        'control_number' => 'required|string|max:9',
        'sender_code' => 'required|string|max:15',
        'receiver_code' => 'required|string|max:15',
        
        // Submitter Info
        'submitter_name' => 'required|string|max:60',
        'submitter_id' => 'required|string|max:15',
        'receiver_name' => 'required|string|max:60',
        
        // Billing Provider Info
        'billing_provider_name' => 'required|string|max:60',
        'billing_provider_npi' => 'required|digits:10',
        'billing_provider_tax_id' => 'required|string|max:15',
        'billing_provider_street' => 'required|string|max:55',
        'billing_provider_city' => 'required|string|max:30',
        'billing_provider_state' => 'required|string|size:2',
        'billing_provider_zip' => 'required|digits:9',
        
        // Facility Info
        'facility_name' => 'required|string|max:60',
        'facility_npi' => 'required|digits:10',
        'facility_street' => 'required|string|max:55',
        'facility_city' => 'required|string|max:30',
        'facility_state' => 'required|string|size:2',
        'facility_zip' => 'required|digits:9',
        
        // Payer Info
        'payer_name' => 'required|string|max:60',
        'payer_id' => 'required|string|max:15',
        'payer_street' => 'required|string|max:55',
        'payer_city' => 'required|string|max:30',
        'payer_zip' => 'required|digits:9',
        
        // Claims
        'claims' => 'required|array|min:1',
        'claims.*.patient_last_name' => 'required|string|max:60',
        'claims.*.patient_first_name' => 'required|string|max:35',
        'claims.*.patient_member_id' => 'required|string|max:20',
        'claims.*.patient_dob' => 'required|date_format:Ymd',
        'claims.*.patient_gender' => 'required|in:M,F,U',
        'claims.*.patient_street' => 'required|string|max:55',
        'claims.*.patient_city' => 'required|string|max:30',
        'claims.*.patient_state' => 'required|string|size:2',
        'claims.*.patient_zip' => 'required|digits:9',
        'claims.*.claim_number' => 'required|string|max:20',
        'claims.*.total_claim_amount' => 'required|numeric',
        'claims.*.facility_type_code' => 'required|string|size:2',
        'claims.*.claim_frequency_code' => 'required|string|size:1',
        'claims.*.primary_diagnosis_code' => 'required|string|max:12',
        'claims.*.additional_diagnosis_codes' => 'nullable|string',
        'claims.*.place_of_service' => 'required|string|size:2',
        'claims.*.procedure_date' => 'required|date_format:Ymd',
        'claims.*.tooth_number' => 'required|string|max:2',
        'claims.*.tooth_surface' => 'nullable|string|max:5',
        'claims.*.oral_cavity_location' => 'nullable|string|max:2',
        'claims.*.service_lines' => 'required|array|min:1',
        'claims.*.service_lines.*.procedure_code' => 'required|string|max:5',
        'claims.*.service_lines.*.revenue_code' => 'required|string|size:4',
        'claims.*.service_lines.*.charge_amount' => 'required|numeric',
        'claims.*.service_lines.*.units' => 'required|integer|min:1',
        'claims.*.service_lines.*.service_date' => 'required|date_format:Ymd',
        'claims.*.service_lines.*.condition_codes' => 'nullable|string',
        
        // Providers
        'claims.*.attending_provider_npi' => 'required|digits:10',
        'claims.*.operating_provider_npi' => 'required|digits:10',
        'claims.*.referring_provider_npi' => 'required|digits:10',
        'claims.*.supervising_provider_npi' => 'required|digits:10',
    ]);

    // Generate the EDI content
    $ediContent = $this->generateEDI837D($request->all());

    // Save the EDI file as .edi
    $fileName = '837_Multiple_D_' . time() . '.edi';
    Storage::disk('local')->put($fileName, $ediContent);

    // Save file details in the database
    $ins = new EdiFileModel;
    $ins->file_name = $fileName;
    $ins->type = "D";
    $ins->is_multiple = "Y";
    $ins->ref_id = $request->input('se02');
    $ins->file_string = $ediContent;
    $ins->request_data = json_encode($request->all(), JSON_PRETTY_PRINT);
    $ins->save();

    // Return as downloadable file
    // return response($ediContent)
    //     ->header('Content-Type', 'text/plain')
    //     ->header('Content-Disposition', 'attachment; filename="837D_'.now()->format('YmdHis').'.edi"');
     return redirect()->route('dashboard')->with('success','Multi Claim 837 Edi D file generated');
}






private function generateEDI837D($data)
{
    $now = Carbon::now();
    $edi = "";

    // ISA Segment
    // $edi .= "ISA*00*          *00*          *ZZ*".str_pad($data['sender_id'], 15)."*".
    //         "ZZ*".str_pad($data['receiver_id'], 15)."*".
    //         $now->format('dmy')."*".$now->format('Hi')."*^*00501*".
    //         str_pad($data['control_number'], 9, '0', STR_PAD_LEFT)."*0*T*:~";

    $edi .= "ISA*00*".
        str_pad('AUTH123456', 10, ' ')."*".  // ISA03 (10-char auth, padded)
        "00*".                                // ISA05 (qualifier)
        str_pad('SECURE7890', 10, ' ')."*".   // ISA05 (10-char security, padded)
        "ZZ*".str_pad($data['sender_id'], 15, ' ')."*".  // ISA06 (sender)
        "ZZ*".str_pad($data['receiver_id'], 15, ' ')."*".// ISA08 (receiver)
        $now->format('ymd')."*".              // ISA09 (YYMMDD, not DMY!)
        $now->format('Hi')."*".               // ISA10 (HHMM)
        "^*".                                 // ISA11 (repetition separator)
        "00501*".                             // ISA12 (HIPAA version)
        str_pad($data['control_number'], 9, '0', STR_PAD_LEFT)."*". // ISA13
        "0*P*:~";                             // ISA15=P (production)

    // GS Segment
    $edi .= "GS*HC*".$data['sender_code']."*".$data['receiver_code']."*".
            $now->format('Ymd')."*".$now->format('Hi')."*1*X*005010X224A2~";

    // ST Segment
    $edi .=  "ST*837*".$data['se02']."*005010X224A2~";

    // BHT Segment
    $edi .= "BHT*0019*00*0123*".$now->format('Ymd')."*".$now->format('Hi')."*CH~";

    // Submitter Info (Loop 1000A)
    $edi .= "NM1*41*2*".str_pad($data['submitter_name'], 35)."*****46*".$data['submitter_id']."~";
    $edi .= "PER*IC*".str_pad($data['submitter_contact'] ?? 'Billing Contact', 35)."*TE*".($data['submitter_phone'] ?? '5551234567')."~";

    // Receiver Info (Loop 1000B)
    $edi .= "NM1*40*2*".str_pad($data['receiver_name'], 35)."*****46*".$data['receiver_code']."~";

    // Billing Provider (Loop 2010AA)
    $edi .= "HL*1**20*1~";
    $edi .= "NM1*85*2*".str_pad($data['billing_provider_name'], 35)."*****XX*".$data['billing_provider_npi']."~";
    $edi .= "N3*".str_pad($data['billing_provider_street'], 55)."~";
    $edi .= "N4*".str_pad($data['billing_provider_city'], 30)."*".$data['billing_provider_state']."*".substr($data['billing_provider_zip'], 0, 5)."~";
    $edi .= "REF*EI*".$data['billing_provider_tax_id']."~";

    // Process Claims
    foreach ($data['claims'] as $claimIndex => $claim) {
        $hlNumber = $claimIndex + 2; // HL numbers start at 2 after billing provider (1)
        
        // Claim HL
        $edi .= "HL*".$hlNumber."*1*22*0~";
        
        // Subscriber Information (SBR)
        $edi .= "SBR*P*18*******MC~";
        
        // Patient Information (NM1)
        $edi .= "NM1*IL*1*".str_pad($claim['patient_last_name'], 35)."*".
                str_pad($claim['patient_first_name'], 35)."****MI*".
                $claim['patient_member_id']."~";
        
        // Patient Address
        $edi .= "N3*".str_pad($claim['patient_street'], 55)."~";
        $edi .= "N4*".str_pad($claim['patient_city'], 30)."*".$claim['patient_state']."*".substr($claim['patient_zip'], 0, 5)."~";
        
        // Patient Demographic
        $edi .= "DMG*D8*".$claim['patient_dob']."*".$claim['patient_gender']."~";
        
        // Claim Information (CLM)
        $edi .= "CLM*".$claim['claim_number']."*".
                number_format($claim['total_claim_amount'], 2, '.', '')."***".
                $claim['facility_type_code'].":".$claim['claim_frequency_code']."*Y*A*Y*Y~";
        
        // Claim Date (DTP)
        $edi .= "DTP*472*D8*".$claim['procedure_date']."~";
        
        // // Diagnosis Codes (HI)
        // $edi .= "HI*ABK:".$claim['primary_diagnosis_code'];
        // if (!empty($claim['additional_diagnosis_codes'])) {
        //     $additionalDiagnoses = array_map('trim', explode(',', $claim['additional_diagnosis_codes']));
        //     foreach ($additionalDiagnoses as $diag) {
        //         if (!empty($diag)) {
        //             $edi .= ":".$diag;
        //         }
        //     }
        // }

        // Diagnosis Codes (HI)
            $edi .= "HI*ABK:".$claim['primary_diagnosis_code'];
            if (!empty($claim['additional_diagnosis_codes'])) {
                $additionalDiagnoses = array_map('trim', explode(',', $claim['additional_diagnosis_codes']));
                foreach ($additionalDiagnoses as $diag) {
                    if (!empty($diag)) {
                        $edi .= "*ABK:".$diag;  // Changed ":" to "*ABK:"
                    }
                }
            }


        $edi .= "~";
        
        // // Service Lines
        // foreach ($claim['service_lines'] as $lineIndex => $line) {
        //     $edi .= "LX*".($lineIndex + 1)."~";
        //     $edi .= "SV3*AD:".$line['procedure_code']."*".
        //             number_format($line['charge_amount'], 2, '.', '')."*UN*".
        //             $line['units']."~";
            
        //     // Tooth Information (TOO)
        //     if (!empty($line['tooth_number'])) {
        //         $edi .= "TOO*".$line['tooth_number'];
        //         if (!empty($line['tooth_surface'])) {
        //             $edi .= "*".$line['tooth_surface'];
        //         }
        //         $edi .= "~";
        //     }
        // }

        // Service Lines
       foreach ($claim['service_lines'] as $lineIndex => $line) {
            $edi .= "LX*".($lineIndex + 1)."~";
            $edi .= "SV3*AD:".$line['procedure_code']."*".
                    number_format($line['charge_amount'], 2, '.', '')."*UN*".
                    $line['units']."~";
            
            // // Add condition codes if present
            // if (!empty($line['condition_codes'])) {
            //     $conditionCodes = array_map('trim', explode(',', $line['condition_codes']));
            //     foreach ($conditionCodes as $code) {
            //         if (!empty($code)) {
            //             $edi .= "CRC*07*".$code."~";
            //         }
            //     }
            // }
        }

        // Tooth Information (TOO) - moved outside service lines since it's at claim level
        if (!empty($claim['tooth_number'])) {
            $edi .= "TOO*".$claim['tooth_number'];
            if (!empty($claim['tooth_surface'])) {
                $edi .= "*".$claim['tooth_surface'];
            }
            $edi .= "~";
        }
    }

    // Calculate segment count (ST through SE)
    $segmentCount = substr_count($edi, '~') + 1 - 2;

    // SE Segment
   $edi .= "SE*".$segmentCount."*".$data['se02']."~";

    // GE Segment
    $edi .= "GE*1*1~";

    // IEA Segment
    $edi .= "IEA*1*".str_pad($data['control_number'], 9, '0', STR_PAD_LEFT)."~";

    return $edi;
}









public function generate999D($id)
{
     $find = EdiFileModel::where('id', $id)->where('type', 'D')->where('is_multiple','Y')->first();
    if (!$find) {
        return back()->with('error', 'Id mismatch');
    }
    // dd("D",$find);

    $content = $find->file_string;
    $originalName = '837D_to_999_multiple' . time() . '.edi';

    // Extract dynamic values from 837 file
    $senderId = str_pad($this->extractSegmentValue($content, 'ISA', 6, 15), 15, " ", STR_PAD_RIGHT);
    $receiverId = str_pad($this->extractSegmentValue($content, 'ISA', 8, 15), 15, " ", STR_PAD_RIGHT);
    $controlNumber = $this->extractSegmentValue($content, 'ISA', 13, 9);
    $gsControlNumber = str_pad(mt_rand(100000000, 999999999), 9, "0", STR_PAD_LEFT);
    $date = date('ymd'); // YYMMDD
    $time = date('Hi');  // HHMM
    $gsDate = date('Ymd'); // CCYYMMDD

    // Split the original content by ST segment to get individual claims
    $claims = preg_split('/~\s*ST\*/', $content);
    $transactionSetCount = 0;
    $acceptedCount = 0;
    $rejectedCount = 0;

    $ak2Ik5Block = '';

    foreach ($claims as $index => $claim) {
        if (trim($claim) === '') continue;

        $transactionSetCount++;
        $transactionControlNumber = str_pad($index + 1, 9, "0", STR_PAD_LEFT);

        $isRejected = strpos($claim, "BHT*0085*RE") !== false;
        $hasSegmentErrors = strpos($claim, "IK3*") !== false;
        $hasElementErrors = strpos($claim, "IK4*") !== false;

        if ($isRejected || $hasSegmentErrors || $hasElementErrors) {
            $ik5Code = "R";
            $rejectedCount++;
        } else {
            $ik5Code = "A";
            $acceptedCount++;
        }

        $ak2Ik5Block .= "AK2*837*$transactionControlNumber~\n";
        $ak2Ik5Block .= "IK5*$ik5Code~\n";
    }

    // Determine AK9 code
    $ak9Code = ($rejectedCount === $transactionSetCount) ? "R" : (($acceptedCount === $transactionSetCount) ? "A" : "P");

    $segmentCount = 4 + ($transactionSetCount * 2); // ST, AK1, (AK2+IK5)*n, AK9, SE

    $generatedContent = <<<EOT
    ISA*00*          *00*          *ZZ*$senderId*ZZ*$receiverId*$date*$time*^*00501*$controlNumber*1*T*:~
    GS*FA*$senderId*$receiverId*$gsDate*$time*$gsControlNumber*X*005010X231A1~
    ST*999*0001*005010X231A1~
    AK1*HC*$gsControlNumber*005010X224A2~
    $ak2Ik5Block
    AK9*$ak9Code*$transactionSetCount*$acceptedCount*$acceptedCount~
    SE*$segmentCount*0001~
    GE*1*$gsControlNumber~
    IEA*1*$controlNumber~
    EOT;

    // Save file to storage
    Storage::put("uploads/$originalName", $generatedContent);

    // Save into DB
    $ins = Acknowledge999FileModel::where('file_837_id', $id)
        ->where('type', 'D')
        ->where('file_type', '837')
        ->first();

    if (!$ins) {
        $ins = new Acknowledge999FileModel();
        $ins->file_837_id = $id;
    }

    $ins->type = 'D';
    $ins->file_type = '837';
    $ins->file_name = $originalName;
    $ins->file_string = $generatedContent;
    $ins->save();

    // Update EDI file status
    EdiFileModel::where('id', $id)->update(['status' => 'G']);

    return back()->with('success', '999 Acknowledgment file generated for 837D file');
}











  // Function to extract a specific segment value from the EDI file
    private function extractSegmentValue($content, $segment, $position, $length)
    {
        $lines = explode("~", $content); // Split by segment delimiter (~)
        foreach ($lines as $line) {
            if (strpos($line, $segment) === 0) {
                $elements = explode('*', $line); // Split segment into elements
                return isset($elements[$position]) ? trim($elements[$position]) : 'UNKNOWN';
            }
        }
        return 'UNKNOWN';
    }




}
