<?php

namespace App\Http\Controllers;
use App\Models\User;
use Hash;
use Auth;
use App\Models\EdiFileModel;
use App\Models\Acknowledge999FileModel;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use DateTime;


class EdidController extends Controller
{
    
  




    public function edid(){
        return view('edid');
    }








// create edi-d
public function submit_837d(Request $request)
    {

        $request->validate([
        	// part-1
        	 'sender_id' => 'required|string|min:2|max:15',
		    'receiver_id' => 'required|string|min:2|max:15',
		    'transmission_date' => 'required|regex:/^\d{8}$/', // YYYYMMDD format
		    'transmission_time' => 'required|regex:/^\d{4}$/', // HHMM format
		    'control_number' => 'required|digits_between:1,15',
		    'sender_code' => 'required|string|min:1|max:15',
		    'receiver_code' => 'required|string|min:1|max:15',
		    'gs_date' => 'required|regex:/^\d{8}$/', // YYYYMMDD format
		    'gs_time' => 'required|regex:/^\d{4}$/', // HHMM format
		    'gs_control_number' => 'required|digits_between:1,15',


		    // step-2
		     'submitter_name' => 'required|string|min:1|max:100',
		    'submitter_id' => 'required|string|min:1|max:15',
		    'receiver_name' => 'required|string|min:1|max:100',
		    'receiver_id' => 'required|string|min:1|max:15',



		    //step-3
		    'billing_provider_name' => 'required|string|min:1|max:100',
		    'billing_provider_npi' => 'required|digits:10',
		    'billing_provider_tax_id' => 'required|string|min:1|max:15',
		    'billing_provider_street' => 'required|string|min:1|max:150',
		    'billing_provider_city' => 'required|string|min:1|max:50',
		    'billing_provider_state' => 'required|regex:/^[A-Z]{2}$/',
		    'billing_provider_zip' => 'required|digits:9',
		    'facility_name' => 'required|string|min:1|max:100',
		    'facility_npi' => 'required|digits:10',
		    'facility_street' => 'required|string|min:1|max:150',
		    'facility_city' => 'required|string|min:1|max:50',
		    'facility_state' => 'required|regex:/^[A-Z]{2}$/',
		    'facility_zip' => 'required|digits:9',


		    //step-4
		     'patient_last_name' => 'required|string|min:1|max:100',
		    'patient_first_name' => 'required|string|min:1|max:100',
		    'patient_dob' => 'required|regex:/^\d{8}$/', // YYYYMMDD format
		    'patient_gender' => 'required|in:M,F,U',
		    'patient_member_id' => 'required|string|min:8|max:15',
		    'patient_street' => 'required|string|min:1|max:150',
		    'patient_city' => 'required|string|min:1|max:50',
		    'patient_state' => 'required|regex:/^[A-Z]{2}$/',
		    'patient_zip' => 'required|digits:9',



		    // step-5
		    'claim_number' => 'required|string|min:1|max:50',
		    'total_claim_amount' => 'required|regex:/^\d+(\.\d{1,2})?$/',
		    'facility_type_code' => 'required|string|min:1|max:2',
		    'claim_frequency_code' => 'required|string|size:1',
		    'primary_diagnosis_code' => 'required|regex:/^[A-Z]\d{2}(\.\d{1,4})?$/',
		    'additional_diagnosis_codes' => 'nullable|string',
		    'place_of_service' => 'required',




		    // step-6
		     'tooth_number' => 'required',
		    'tooth_surface' => 'required|regex:/^[MDOIL]+$/',
		    'oral_cavity_location' => 'required|regex:/^[1-4UL]$/',
		    'missing_teeth_info' => 'nullable|string',
		    'replacement_status' => 'required|in:Yes,No',
		    'procedure_date' => 'required|regex:/^\d{8}$/', // YYYYMMDD format
		    'prosthesis_code' => 'nullable|string',
		    'orthodontic_treatment' => 'required|in:Yes,No',
		    'orthodontic_start_date' => 'nullable|regex:/^\d{8}$/',
		    'orthodontic_end_date' => 'nullable|regex:/^\d{8}$/',
		    'anesthesia_usage' => 'required|in:Yes,No',
		    'anesthesia_type' => 'nullable|string',
		    'emergency_treatment' => 'required|in:Yes,No',



		    

		    // //step-7
		    'procedure_code' => 'required|regex:/^[A-Z0-9]{5}$/i',
		    'revenue_code' => 'required|regex:/^\d{4}$/',
		    'charge_amount' => 'required|regex:/^\d+(\.\d{1,2})?$/',
		    'units_of_service' => 'required|integer|min:1',
		    'service_date' => 'required|regex:/^\d{8}$/', // YYYYMMDD format
		    'condition_codes' => 'nullable|string|max:50',



		    // step-8
		      'payer_name' => 'required|string|max:255',
		    'payer_id' => 'required|regex:/^\d{9}$/', // Payer ID should be exactly 9 digits
		    'payer_street' => 'required|string|max:255',
		    'payer_city' => 'required|string|max:100',
		    'payer_zip' => 'required|regex:/^\d{5}(-\d{4})?$/', // ZIP code format (5 or 9 digits)



		    // step-9
		    'attending_provider_name' => 'required|string|max:255',
		    'attending_provider_npi' => 'required|regex:/^\d{10}$/', // NPI should be exactly 10 digits
		    'operating_provider_name' => 'required|string|max:100',
		    'operating_provider_npi' => 'required|digits:10',
		    'referring_provider_name' => 'required|string|max:100',
		    'referring_provider_npi' => 'required|digits:10',
		    'supervising_provider_name' => 'required|string|max:100',
		    'supervising_provider_npi' => 'required|digits:10',



		    // step-10
		     'se01' => 'required|integer',
		    'se02' => 'required|integer',
		    'ge_control_number' => 'required|integer',
		    'iea_control_number' => 'required|integer',

        	

        ]);

     // dd(1);
// dd($request->transmission_date);
		// Collect the variables
$senderId = str_pad($request->sender_id, 15, " ", STR_PAD_RIGHT);
$receiverId = str_pad($request->receiver_id, 15, " ", STR_PAD_RIGHT);
$transmissionDate = $request->transmission_date
    ? date('ymd', DateTime::createFromFormat('Ymd', $request->transmission_date)->getTimestamp())
    : now()->format('ymd');

$transmissionDate2 = $request->transmission_date
    ? date('Ymd', DateTime::createFromFormat('Ymd', $request->transmission_date)->getTimestamp())
    : now()->format('Ymd');

$transmissionTime = $request->transmission_time;
$controlNumber = $request->control_number;
$senderCode = $request->sender_code;
$receiverCode = $request->receiver_code;
$gsDate = $request->gs_date;
$gsTime = $request->gs_time;
$gsControlNumber = $request->gs_control_number;

// Step-2
$submitterName = $request->submitter_name;
$submitterId = $request->submitter_id;
$receiverName = $request->receiver_name;
// $receiverId = $request->receiver_id;

// Step-3
$billingProviderName = $request->billing_provider_name;
$billingProviderNpi = $request->billing_provider_npi;
$billingProviderTaxId = $request->billing_provider_tax_id;
$billingProviderStreet = $request->billing_provider_street;
$billingProviderCity = $request->billing_provider_city;
$billingProviderState = $request->billing_provider_state;
$billingProviderZip = $request->billing_provider_zip;
$facilityName = $request->facility_name;
$facilityNpi = $request->facility_npi;
$facilityStreet = $request->facility_street;
$facilityCity = $request->facility_city;
$facilityState = $request->facility_state;
$facilityZip = $request->facility_zip;

// Step-4
$patientLastName = $request->patient_last_name;
$patientFirstName = $request->patient_first_name;
$patientDob = $request->patient_dob;
$patientGender = $request->patient_gender;
$patientMemberId = $request->patient_member_id;
$patientStreet = $request->patient_street;
$patientCity = $request->patient_city;
$patientState = $request->patient_state;
$patientZip = $request->patient_zip;
$admissionDate = $request->input('admission_date');
$dischargeDate = $request->input('discharge_date');

// Step-5
$claimNumber = $request->claim_number;
$totalClaimAmount = $request->total_claim_amount;
$facilityTypeCode = $request->facility_type_code;
$claimFrequencyCode = $request->claim_frequency_code;
$primaryDiagnosis = $request->primary_diagnosis_code;
$additionalDiagnosisCodes = $request->additional_diagnosis_codes;
$placeOfService = $request->place_of_service;

// Step-6
$toothNumber = $request->tooth_number;
$toothSurface = $request->tooth_surface;
$oralCavityLocation = $request->oral_cavity_location;
$missingTeethInfo = $request->missing_teeth_info;
$replacementStatus = $request->replacement_status;
$procedureDate = $request->procedure_date;
$prosthesisCode = $request->prosthesis_code;
$orthodonticTreatment = $request->orthodontic_treatment;
$orthodonticStartDate = $request->orthodontic_start_date;
$orthodonticEndDate = $request->orthodontic_end_date;
$anesthesiaUsage = $request->anesthesia_usage;
$anesthesiaType = $request->anesthesia_type;
$emergencyTreatment = $request->emergency_treatment;

// Step-7
$procedureCode = $request->procedure_code;
$revenueCode = $request->revenue_code;
$chargeAmount = $request->charge_amount;
$unitsOfService = $request->units_of_service;
$serviceDate = $request->service_date;
$conditionCodes = $request->condition_codes;

// Step-8
$payerName = $request->payer_name;
$payerId = $request->payer_id;
$payerStreet = $request->payer_street;
$payerState = $request->input('payer_state');
$payerCity = $request->payer_city;
$payerZip = $request->payer_zip;

// Step-9
$attendingProviderName = $request->attending_provider_name;
$attendingProviderNpi = $request->attending_provider_npi;
$operatingProviderName = $request->input('operating_provider_name');
$operatingProviderNpi = $request->input('operating_provider_npi');
$referringProviderName = $request->input('referring_provider_name');
$referringProviderNpi = $request->input('referring_provider_npi');
$supervisingProviderName = $request->input('supervising_provider_name');
$supervisingProviderNpi = $request->input('supervising_provider_npi');

// Step-10

$se01              = 31; //$request->input('se01');
$se02              =  mt_rand(1000, 999999999); //"000000001";//$request->input('se02');mtrand(1000,999999999)
$geControlNumber =$request->gs_control_number; //$request->input('ge_control_number');
$ieaControlNumber= $request->control_number;   //$request->input('iea_control_number');






    
        $ediContent = "ISA*00*          *00*          *ZZ*{$senderId}*ZZ*{$receiverId}*{$transmissionDate}*{$transmissionTime}*^*00501*{$controlNumber}*1*T*:~
GS*HC*{$senderCode}*{$receiverCode}*{$gsDate}*{$gsTime}*{$gsControlNumber}*X*005010X224A2~ 
ST*837*{$se02}*005010X224A2~ 
BHT*0019*00*{$se02}*{$transmissionDate2}*{$transmissionTime}*CH~  
NM1*41*2*{$submitterName}*****46*{$submitterId}~  
PER*IC*PRODUCT SUPPORT*TE*8005278133*FX*5635854544~  
NM1*40*2*{$receiverName}*****46*{$receiverId}~  
HL*1**20*1~  
PRV*BI*PXC*261Q00000X~  
NM1*85*2*{$billingProviderName}*****XX*{$billingProviderNpi}~  
N3*{$billingProviderStreet}~  
N4*{$billingProviderCity}*{$billingProviderState}*{$billingProviderZip}~  
REF*EI*{$billingProviderTaxId}~  
HL*2*1*22*0~  
SBR*P*18*041******CI~  
NM1*IL*1*{$patientLastName}*{$patientFirstName}****MI*{$patientMemberId}~  
N3*{$patientStreet}~  
N4*{$patientCity}*{$patientState}*{$patientZip}~  
DMG*D8*{$patientDob}*{$patientGender}~  
NM1*PR*2*{$payerName}*****PI*{$payerId}~  
N3*{$payerStreet}~  
N4*{$payerCity}*{$payerState}*{$payerZip}~  
CLM*{$claimNumber}*{$totalClaimAmount}***{$facilityTypeCode}:B:{$claimFrequencyCode}*Y*A*Y*Y~  
DTP*435*D8*{$admissionDate}~  
DTP*096*D8*{$dischargeDate}~  
HI*ABK:{$primaryDiagnosis}~  
NM1*71*1*{$operatingProviderName}*****XX*{$operatingProviderNpi}~  
NM1*72*1*{$attendingProviderName}*****XX*{$attendingProviderNpi}~  
NM1*DN*1*{$referringProviderName}*****XX*{$referringProviderNpi}~  
LX*1~  
SV2*{$revenueCode}*HC:{$procedureCode}*{$chargeAmount}*UN*{$unitsOfService}~  
DTP*472*D8*{$serviceDate}~  
SE*{$se01}*{$se02}~  
GE*1*{$geControlNumber}~  
IEA*1*{$ieaControlNumber}~";

$fileName = '837D_' . time() . '.edi'; // EDI-D for Dental Claims
Storage::disk('local')->put($fileName, $ediContent);

// Save file details in the database
$ins = new EdiFileModel;
$ins->file_name = $fileName;
$ins->type = "D";
  $ins->ref_id = $se02;
$ins->file_string = $ediContent;
$ins->request_data = json_encode($request->all(), JSON_PRETTY_PRINT);
$ins->save();

// return response()->download(storage_path("app/{$fileName}"), $fileName, [
//     'Content-Type' => 'text/plain',
// ]);


// $data = json_decode($model->request_data, true);
// echo $data['name'] ?? '';



// Redirect to the dashboard with a success message
return redirect()->route('dashboard')->with('success', 'EDI-D file generated successfully!');


}






































//======================================================//









   public function showUploadForm($id)
    {
        // find
        $find=EdiFileModel::where('id',$id)->where('type','D')->first();
        if(!$find){
            return redirect()->route('dashboard')->with('error','Id missmatch');
        }
        $data['data']=$find;
        return view('upload_275_for_edid')->with($data);
    }





public function process275(Request $request)
{
    $request->validate([
        'id'=>'required',
        'file' => 'required|file|mimes:txt,edi',
        'file_type' => 'required',
    ]);

    // dd($request->file_type);


      $file = $request->file('file');
        $fileContent = file_get_contents($file->getRealPath());
        $selectedType = $request->file_type; // 837 or 275
    // Check based on selected file type
        if ($selectedType == '837') {
            $fileContent = file_get_contents($file->getRealPath());
            // Required segments for 837 file
            if (!str_contains($fileContent, 'BHT')) {
                return back()->with('error', "Invalid 837 EDI file. Please upload a correct file.");
            }
        } else {
            $fileContent = file_get_contents($file->getRealPath());
            // Required segments for 275 file
            if (!str_contains($fileContent, 'BDS')) {
                return back()->with('error', "Invalid 275 EDI file. Please upload a correct file.");
            }
        }


    if($request->file_type=="837"){

         $file = $request->file('file');
        $originalName = '837_to_999_' . time() . '.edi';
        $path = $file->storeAs('uploads', $originalName);

        // Read 837 file content
        $content = file_get_contents(storage_path("app/$path"));

        // Extract dynamic values from 837 file
        $senderId = str_pad($this->extractSegmentValue($content, 'ISA', 6, 15), 15, " ", STR_PAD_RIGHT);
        $receiverId = str_pad($this->extractSegmentValue($content, 'ISA', 8, 15), 15, " ", STR_PAD_RIGHT);
        $controlNumber = $this->extractSegmentValue($content, 'ISA', 13, 9); // ISA Control Number
        $gsControlNumber = str_pad(mt_rand(100000000, 999999999), 9, "0", STR_PAD_LEFT);
        //$this->extractSegmentValue($content, 'GS', 6, 9); // GS Control Number
        $date = date('ymd'); // YYMMDD format
        $time = date('Hi');  // HHMM format
        $gsDate = date('Ymd');   // GS-04 must be CCYYMMD

        // Check rejection indicators in 837
        $isFullyRejected = strpos($content, "BHT*0085*RE") !== false; // Example: Fully Rejected
        $hasSegmentErrors = strpos($content, "IK3*") !== false; // Means some segments are invalid
        $hasElementErrors = strpos($content, "IK4*") !== false; // Means some elements are incorrect

        // Determine IK5 and AK9 values based on conditions
        if ($isFullyRejected) {
            $ik5Code = "R"; // Fully Rejected
            $ak9Code = "R"; // Functional Group Rejected
        } elseif ($hasSegmentErrors || $hasElementErrors) {
            $ik5Code = "R"; // Some transactions rejected
            $ak9Code = "P"; // Partially Accepted
        } else {
            $ik5Code = "A"; // Fully Accepted
            $ak9Code = "A"; // Functional Group Accepted
        }


        // Generate 999 file content
        $generatedContent = "ISA*00*          *00*          *ZZ*$senderId*ZZ*$receiverId*$date*$time*^*00501*$controlNumber*1*T*:~
        GS*FA*$senderId*$receiverId*$gsDate*$time*$gsControlNumber*X*005010X231A1~
        ST*999*0001*005010X231A1~
        AK1*HC*$gsControlNumber*005010X224A2~
        AK2*837*000000001~
        IK5*$ik5Code~
        AK9*$ak9Code*1*1*1~
        SE*6*0001~
        GE*1*$gsControlNumber~
        IEA*1*$controlNumber~";

        // Save the generated 999 file
        Storage::put("uploads/$originalName", $generatedContent);
        // Determine file status
         $status = $isFullyRejected 
        ? "rejected" 
        : (($hasSegmentErrors || $hasElementErrors) 
            ? "partially accepted" 
            : "accepted");

      
       $ins = Acknowledge999FileModel::where('file_837_id', $request->id)->where('type','D')
       ->where('file_type','837')->first();

        if (!$ins) {
            $ins = new Acknowledge999FileModel();
            $ins->file_837_id = $request->id; // Assign only if creating new
        }

        // Assign/update values
        $ins->type = 'D';
        $ins->file_type = '837';
        $ins->file_name = $originalName;
        $ins->file_string = $generatedContent;

        $ins->save(); // Saves the record (inserts or updates)

    }



   // for 275
    else{
         $file = $request->file('file');
        $originalName = '275_to_999_' . time() . '.edi';
        $path = $file->storeAs('uploads', $originalName);

        // Read .275 file content
        $content = file_get_contents(storage_path("app/$path"));

        // Extract dynamic values from .275 file
        $senderId = str_pad($this->extractSegmentValue($content, 'ISA', 6, 15), 15, " ", STR_PAD_RIGHT);
        $receiverId = str_pad($this->extractSegmentValue($content, 'ISA', 8, 15), 15, " ", STR_PAD_RIGHT);
        $date = $this->extractSegmentValue($content, 'ISA', 9, 6);
        $time = $this->extractSegmentValue($content, 'ISA', 10, 4);
        $controlNumber = str_pad($this->extractSegmentValue($content, 'ISA', 13, 9), 9, "0", STR_PAD_LEFT);

        // Generate new control number
        $newControlNumber = str_pad(mt_rand(100000000, 999999999), 9, "0", STR_PAD_LEFT);

        // Check for rejection conditions
        $isFullyRejected = strpos($content, "BDS*R") !== false;
        $isPartiallyAccepted = strpos($content, "BDS*P") !== false;
        $hasSegmentErrors = strpos($content, "IK3*") !== false;
        $hasElementErrors = strpos($content, "IK4*") !== false;
         $currentDate = date('Ymd');
                $currentTime = date('His');

        // Determine IK5 and AK9 codes
        if ($isFullyRejected) {
            $ik5Code = "R";
            $ak9Code = "R";
        } elseif ($isPartiallyAccepted || $hasSegmentErrors || $hasElementErrors) {
            $ik5Code = "R";
            $ak9Code = "P";
        } else {
            $ik5Code = "A";
            $ak9Code = "A";
        }

        // Count transactions
        $transactionCount = substr_count($content, "ST*275");

        // Generate 999 file content
        $generatedContent = "ISA*00*          *00*          *ZZ*$senderId*ZZ*$receiverId*$date*$time*^*00501*$newControlNumber*1*T*:~
        GS*FA*$senderId*$receiverId*$currentDate*$currentTime*$newControlNumber*X*005010X231A1~
        ST*999*$newControlNumber*005010X231A1~
        AK1*PI*$controlNumber*005010X210~
        AK2*275*000000001~
        IK5*$ik5Code~
        AK9*$ak9Code*$transactionCount*$transactionCount*$transactionCount~
        SE*6*$newControlNumber~
        GE*1*$newControlNumber~
        IEA*1*$newControlNumber~";

        // Determine file status
        $status = $isFullyRejected ? "rejected" : ($isPartiallyAccepted || $hasSegmentErrors || $hasElementErrors ? "partially accepted" : "accepted");

        // Save the new 999 file
        Storage::put("uploads/$originalName", $generatedContent);



        // $ins=new Acknowledge999FileModel;
        // $ins->type='P';
        // $ins->file_type='275';
        // $ins->file_837_id=$request->id;
        // $ins->file_name=$originalName;
        // $ins->file_string=$generatedContent;
        // $ins->save();


       $ins = Acknowledge999FileModel::where('file_837_id', $request->id)->where('type','D')
       ->where('file_type','275')->first();

        if (!$ins) {
            $ins = new Acknowledge999FileModel();
            $ins->file_837_id = $request->id; // Assign only if creating new
        }

        // Assign/update values
        $ins->type = 'D';
        $ins->file_type = '275';
        $ins->file_name = $originalName;
        $ins->file_string = $generatedContent;

        $ins->save(); // Saves the record (inserts or updates)
        
    }


   

     return redirect()->route('upload.275.edid',$request->id)->with('success', "File processed successfully. <a href='".route('download.999.d', $originalName)."'>Download $ik5Code-$ak9Code-$status 999</a>");
}






    public function download999($filename)
    {
        $path = storage_path("app/uploads/$filename");
        if (!file_exists($path)) {
            abort(404);
        }
        return response()->download($path);
    }

    // Function to extract a specific segment value from the EDI file
    private function extractSegmentValue($content, $segment, $position, $length)
    {
        $lines = explode("~", $content); // Split by segment delimiter (~)
        foreach ($lines as $line) {
            if (strpos($line, $segment) === 0) {
                $elements = explode('*', $line); // Split segment into elements
                return isset($elements[$position]) ? trim($elements[$position]) : 'UNKNOWN';
            }
        }
        return 'UNKNOWN';
    }











public function generate999($id){
         $find = EdiFileModel::where('id', $id)->where('type','D')->first();
         if(!$find){
            return back()->with('error','Id missmatch');
         }

          if($find->is_multiple=="Y"){
            return redirect()->route('multiple.edid.999.generate',$find->id);
         }


       if($find){

        $content=$find->file_string;
        $originalName = '837D_to_999_' . time() . '.edi';

        // Extract dynamic values from 837 file
        $senderId = str_pad($this->extractSegmentValue($content, 'ISA', 6, 15), 15, " ", STR_PAD_RIGHT);
        $receiverId = str_pad($this->extractSegmentValue($content, 'ISA', 8, 15), 15, " ", STR_PAD_RIGHT);
        $controlNumber = $this->extractSegmentValue($content, 'ISA', 13, 9); // ISA Control Number
        $gsControlNumber = str_pad(mt_rand(100000000, 999999999), 9, "0", STR_PAD_LEFT);
        //$this->extractSegmentValue($content, 'GS', 6, 9); // GS Control Number
        $date = date('ymd'); // YYMMDD format
        $time = date('Hi');  // HHMM format
        $gsDate = date('Ymd');   // GS-04 must be CCYYMMD

        // Check rejection indicators in 837
        $isFullyRejected = strpos($content, "BHT*0085*RE") !== false; // Example: Fully Rejected
        $hasSegmentErrors = strpos($content, "IK3*") !== false; // Means some segments are invalid
        $hasElementErrors = strpos($content, "IK4*") !== false; // Means some elements are incorrect

        // Determine IK5 and AK9 values based on conditions
        if ($isFullyRejected) {
            $ik5Code = "R"; // Fully Rejected
            $ak9Code = "R"; // Functional Group Rejected
        } elseif ($hasSegmentErrors || $hasElementErrors) {
            $ik5Code = "R"; // Some transactions rejected
            $ak9Code = "P"; // Partially Accepted
        } else {
            $ik5Code = "A"; // Fully Accepted
            $ak9Code = "A"; // Functional Group Accepted
        }


        // Generate 999 file content
        $generatedContent = "ISA*00*          *00*          *ZZ*$senderId*ZZ*$receiverId*$date*$time*^*00501*$controlNumber*1*T*:~
        GS*FA*$senderId*$receiverId*$gsDate*$time*$gsControlNumber*X*005010X231A1~
        ST*999*0001*005010X231A1~
        AK1*HC*$gsControlNumber*005010X224A2~
        AK2*837*000000001~
        IK5*$ik5Code~
        AK9*$ak9Code*1*1*1~
        SE*6*0001~
        GE*1*$gsControlNumber~
        IEA*1*$controlNumber~";

        // Save the generated 999 file
        Storage::put("uploads/$originalName", $generatedContent);
        // Determine file status
         $status = $isFullyRejected 
        ? "rejected" 
        : (($hasSegmentErrors || $hasElementErrors) 
            ? "partially accepted" 
            : "accepted");


           $ins = Acknowledge999FileModel::where('file_837_id', $id)->where('type','D')
           ->where('file_type','837')->first();

            if (!$ins) {
                $ins = new Acknowledge999FileModel();
                $ins->file_837_id = $id; // Assign only if creating new
            }

            // Assign/update values
            $ins->type = 'D';
            $ins->file_type = '837';
            $ins->file_name = $originalName;
            $ins->file_string = $generatedContent;

            $ins->save(); // Saves the record (inserts or updates)

            $update=EdiFileModel::where('id', $id)->update(['status'=>'G']);
           return back()->with('success','999 Ack file generated for 837D file');

    }


}


 

 

 


}
