<?php

namespace App\Http\Controllers;
use App\Models\User;
use Hash;
use Auth;
use App\Models\EdiFileModel;
use App\Models\SftpEdiModel;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use DateTime;
use App\Models\Acknowledge999FileModel;
use App\Mail\ProviderRegisterMail;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Str;
use App\Models\ProviderInfoModel;
use Illuminate\Support\Carbon;




class AuthController extends Controller
{


    public function showRegisterForm()
    {
        if(@Auth::user()->id){
            return redirect()->route('dashboard');
        }else{
        return view('register');
        }
    }

    public function register(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|email|unique:users',
            'password' => 'required|min:6',
        ]);

        $user = User::create([
            'name' => $request->name,
            'email' => $request->email,
            'password' => Hash::make($request->password), // Bcrypt hashing
            'user_type' => 'A'
        ]);

        Auth::login($user); // Auto-login after registration
        return redirect()->route('dashboard.sftp'); // Redirect to dashboard
    }


    public function showLoginForm()
    {
        if(@Auth::user()->id){
            return redirect()->route('dashboard');
        }else{
          return view('login');
        }
    }

    // public function login(Request $request)
    // {
    //     $request->validate([
    //         'email' => 'required',
    //         'password' => 'required',
    //     ]);
     


    //     if (Auth::attempt($request->only('email', 'password'))) {

    //             $user = Auth::user(); // Get the authenticated user
    //             // dd($user);
    //             if($user->user_type=="P"){
    //                $providerInfo = User::where('id', Auth()->user()->id)->first();
    //             if (!$providerInfo->username) {
    //                     return redirect()->route('complete.provider.info');
    //                 }else{
    //                     return redirect()->route('dashboard.sftp'); // Redirect to dashboard
    //                 }
    //             }

    //         return redirect()->route('dashboard.sftp'); // Redirect to dashboard
    //     }

    //     return redirect()->back()->with('error', 'Invalid credentials');
    // }

    public function login(Request $request)
{
    $request->validate([
        'email' => 'required',
        'password' => 'required',
    ]);

    // Determine if the input is an email or a username
    $login_type = filter_var($request->email, FILTER_VALIDATE_EMAIL) ? 'email' : 'username';

    // Try to log in using the correct field
    if (Auth::attempt([$login_type => $request->email, 'password' => $request->password])) {

        $user = Auth::user(); // Get the authenticated user

        if ($user->user_type == "P") {
            $providerInfo = User::where('id', Auth()->user()->id)->first();


            if (!$providerInfo->username) {


                if (Carbon::now()->greaterThan($providerInfo->link_expire)) {
                    // If the link has expired, redirect immediately
                    Auth::logout();
                    return redirect()->route('link.expired'); // or use any appropriate route
                }
                

                return redirect()->route('complete.provider.info');
            } else {
                return redirect()->route('dashboard'); // Redirect to dashboard
            }
        }

        return redirect()->route('dashboard.sftp'); // Redirect to dashboard
    }

    return redirect()->back()->with('error', 'Invalid credentials');
}


    public function logout()
    {
        Auth::logout();
        return redirect()->route('login');
    }



    public function link_expired(){
       return view('link_expired');
    }




public function dashboard(Request $request)
{

    if(@Auth()->user()->user_type=="A"){
       $query = EdiFileModel::orderBy('id', 'desc');
    }else{
       $query = EdiFileModel::orderBy('id', 'desc')->where('created_user_id',Auth::user()->id);
    }

    // Apply filters if provided
    if ($request->file_name) {
     $query->where('file_name', 'like', '%' . $request->file_name . '%');
    }

    if ($request->file_type) {
        $query->where('type', $request->file_type);
    }
    if ($request->ref_id) {
        $query->where('ref_id', 'like', '%' . $request->ref_id . '%');
    }

   
    if ($request->daterange) {
        $query->whereDate('created_at', $request->daterange);
    }

    // First fetch filtered records
    // $data['data'] = $query->get();

    $limit = $request->input('limit', 10); // default 10
    $data['data'] = $query->paginate($limit)->appends($request->all());
    $data['limit'] = $limit;

    // Loop and enrich records with 837 and 275 related files
    foreach ($data['data'] as $key => $val) {
        $find_837_to_999 = Acknowledge999FileModel::where('file_837_id', $val->id)
                            ->where('file_type', '837')->first();
        $data['data'][$key]['find_837_to_999'] = $find_837_to_999 ?? null;

        $find_275_to_999 = Acknowledge999FileModel::where('file_837_id', $val->id)
                            ->where('file_type', '275')->first();
        $data['data'][$key]['find_275_to_999'] = $find_275_to_999 ?? null;
    }

    


    return view('dashboard')->with($data);
}






    // public function view_rcv_files_sftp(Request $request){
    //      $data['data']=SftpEdiModel::orderBy('id','desc')->get();
    //     return view('sftp.view_recipts_file')->with($data);
    // }

public function view_rcv_files_sftp(Request $request)
{
    $query = SftpEdiModel::orderBy('id','desc');


    if ($request->file_name) {
     $query->where('file_name', 'like', '%' . $request->file_name . '%');
    }

    if ($request->file_type) {
        $query->where('file_type', $request->file_type);
    }

    if ($request->ref_id) {
        $query->where('ref_id', 'like', '%' . $request->ref_id . '%');
    }

    if ($request->status) {
        $query->where('status', $request->status);
    }

    if ($request->daterange) {
        $query->whereDate('created_at', $request->daterange);
    }


   // $data['data'] = $query->orderBy('id', 'desc')->paginate(1);
   // dd($data);
    $limit = $request->input('limit', 10); // default 10
    $data['data'] = $query->orderBy('id', 'desc')->paginate($limit)->appends($request->all());
    $data['limit'] = $limit;



    return view('sftp.view_recipts_file')->with($data);
}




     public function download($id)
    {
        // Find the EDI file record by ID
        $file = EdiFileModel::find($id);

        // Check if the file exists
        if (!$file) {
            return redirect()->route('dashboard')->with('error', 'File not found.');
        }

        // Get the file path
        $filePath = storage_path("app/{$file->file_name}");

        // Check if the actual file exists in storage
        if (!file_exists($filePath)) {
            return redirect()->route('dashboard')->with('error', 'File is missing.');
        }

        // Return file for download
        return response()->download($filePath, $file->file_name, [
            'Content-Type' => 'text/plain',
        ]);
    }



    
  




    public function file(){
        return view('file');
    }









public function generateEDI(Request $request)
    {

        $request->validate([
            'sender_id' => 'required|string|min:2|max:15',
            'receiver_id' => 'required|string|min:2|max:15',
            'transmission_time' => 'required|regex:/^\d{4}$/', // Must be exactly 4 digits
            'control_number' => 'required|string|max:15', // Can be adjusted as needed

            'sender_code' => 'required|string|max:15',
            'receiver_code' => 'required|string|max:15',
            'gs_date' => 'required|regex:/^\d{8}$/', // Must be exactly 8 digits (CCYYMMDD)
            'gs_time' => 'required|regex:/^\d{4}$/', // Must be exactly 4 digits (HHMM)
            'gs_control_number' => 'required|string|max:15', // Can be adjusted as needed

            'submitter_name' => 'required|string|max:100',  // Max 100 characters
            'submitter_id'   => 'required|string|max:15',   // Max 15 characters
            'receiver_name'  => 'required|string|max:100',  // Max 100 characters
            'receiver_id'    => 'required|string|max:15',   // Max 15 characters

            'provider_name'   => 'required|string|max:100',  // Max 100 characters
            'provider_npi'    => 'required|digits:10',       // Must be exactly 10 digits
            'provider_tax_id' => 'required',  // Format: 12-3456789
            'provider_street' => 'required|string|max:150',
            'provider_city'   => 'required|string|max:50',
            'provider_state'  => 'required|regex:/^[A-Z]{2}$/',  // Only 2 uppercase letters
            'provider_zip'    => 'required|digits:9',        // Must be exactly 9 digits

            'facility_name'   => 'required|string|max:100',
            'facility_npi'    => 'required|digits:10|different:billing_provider_npi', // Must be different from Billing Provider
            'facility_street' => 'required|string|max:150',
            'facility_city'   => 'required|string|max:50',
            'facility_state'  => 'required|regex:/^[A-Z]{2}$/', // Must be exactly 2 uppercase letters
            'facility_zip'    => 'required|digits:9', // Must be exactly 9 digits

            'subscriber_last_name'  => 'required|string|max:100',
            'subscriber_first_name' => 'required|string|max:100',
            'member_id'             => 'required', // Insurance ID (8-15 digits)
            'subscriber_street'     => 'required|string|max:150',
            'subscriber_city'       => 'required|string|max:50',
            'subscriber_state'      => 'required|regex:/^[A-Z]{2}$/', // Must be 2 uppercase letters
            'subscriber_zip'        => 'required|digits:9', // Must be exactly 9 digits
            'subscriber_dob'        => 'required|date_format:Ymd', // Format: CCYYMMDD
            'subscriber_gender'     => 'required|in:M,F,U', // Must be M, F, or U

            'payer_name'  => 'required|string|max:100',
            'payer_id'    => 'required', // Payer ID (5-10 digits)
            'payer_street'=> 'nullable|string|max:150', // Optional field
            'payer_city'  => 'nullable|string|max:50', // Optional field
            'payer_state' => 'nullable|regex:/^[A-Z]{2}$/', // Optional but must be 2 uppercase letters
            'payer_zip'   => 'nullable|digits:9', // Optional but must be exactly 9 digits

            'claim_number'       => 'required|string|max:50',
            'claim_amount'       => 'required|regex:/^\d+(\.\d{1,2})?$/',
            'place_of_service'   => 'required|in:11,21,22,23',
            'claim_frequency'    => 'required|in:1,7,8',
            'primary_diagnosis'  => 'required|regex:/^[A-Z]\d{2}(\.\d{1,4})?$/',
            'additional_diagnosis' => 'nullable|string',
            'condition_codes'    => 'nullable|string',


            'service_line_number' => 'required|integer|min:1',
            'procedure_code'      => 'required|string|regex:/^[A-Z0-9]+$/',
            'charge_amount'       => 'required|regex:/^\d+(\.\d{1,2})?$/',
            'unit_count'          => 'required|integer|min:1',
            'diagnosis_pointer'   => 'required|integer|between:1,9',
            'date_of_service'     => 'required|date_format:Ymd',

            'referring_provider_name' => 'required|string|max:255',
            'referring_npi'           => 'required|digits:10',

            'rendering_provider_name'   => 'required|string|max:255',
            'rendering_npi'             => 'required|digits:10',
            'supervising_provider_name' => 'required|string|max:255',
            'supervising_npi'           => 'required|digits:10',

            'se01'              => 'required|integer|min:1',
            'se02'              => 'required|string|max:20',
            'ge_control_number' => 'required|string|max:20',
            'iea_control_number'=> 'required|string|max:20',




        ]);

    
        $transmissionDate = $request->transmission_date
                            ? date('ymd', DateTime::createFromFormat('ymd', $request->transmission_date)->getTimestamp())
                            : now()->format('ymd');

        $transmissionDate2 = $request->transmission_date
                    ? date('Ymd', DateTime::createFromFormat('ymd', $request->transmission_date)->getTimestamp())
                    : now()->format('Ymd');

        // dd($transmissionDate,$transmissionDate2);

        $senderId = str_pad($request->sender_id, 15, " ", STR_PAD_RIGHT);
        $receiverId = str_pad($request->receiver_id, 15, " ", STR_PAD_RIGHT);
        $transmissionTime = $request->transmission_time; // Must be in HHMM format
        $controlNumber = $request->control_number; // Unique ID, must match IEA02


        $senderCode = $request->sender_code; // Should match ISA06
        $receiverCode = $request->receiver_code; // Should match ISA08
        $gsDate = $request->gs_date; // Must be in CCYYMMDD format
        $gsTime = $request->gs_time; // Must be in HHMM format
        $gsControlNumber = $request->gs_control_number; // Unique & must match GE02


        $submitterName = $request->submitter_name;  // Submitter Name (NM103)
        $submitterId = $request->submitter_id;      // Submitter ID (NM109)
        $receiverName = $request->receiver_name;    // Receiver Name (NM103)
        // $receiverId = $request->receiver_id;        // Receiver ID (NM109)

        $provider_name   = $request->provider_name;
        $provider_npi    = $request->provider_npi;
        $provider_tax_id = $request->provider_tax_id;
        $provider_street = $request->provider_street;
        $provider_city   = $request->provider_city;
        $provider_state  = $request->provider_state;
        $provider_zip    = $request->provider_zip;

        $facility_name   = $request->facility_name;
        $facility_npi    = $request->facility_npi;
        $facility_street = $request->facility_street;
        $facility_city   = $request->facility_city;
        $facility_state  = $request->facility_state;
        $facility_zip    = $request->facility_zip;

        $subscriber_last_name  = $request->input('subscriber_last_name');
        $subscriber_first_name = $request->input('subscriber_first_name');
        $member_id            = $request->input('member_id');
        $subscriber_street    = $request->input('subscriber_street');
        $subscriber_city      = $request->input('subscriber_city');
        $subscriber_state     = $request->input('subscriber_state');
        $subscriber_zip       = $request->input('subscriber_zip');
        $subscriber_dob       = $request->input('subscriber_dob');
        $subscriber_gender    = $request->input('subscriber_gender');

        $payer_name  = $request->input('payer_name');
        $payer_id    = $request->input('payer_id');
        $payer_street= $request->input('payer_street');
        $payer_city  = $request->input('payer_city');
        $payer_state = $request->input('payer_state');
        $payer_zip   = $request->input('payer_zip');

        $claim_number       = $request->input('claim_number');
        $claim_amount       = $request->input('claim_amount');
        $place_of_service   = $request->input('place_of_service');
        $claim_frequency    = $request->input('claim_frequency');
        $primary_diagnosis  = $request->input('primary_diagnosis');
        $additional_diagnosis = $request->input('additional_diagnosis');
        $condition_codes    = $request->input('condition_codes');

        $service_line_number = $request->input('service_line_number');
        $procedure_code      = $request->input('procedure_code');
        $charge_amount       = $request->input('charge_amount');
        $unit_count          = $request->input('unit_count');
        $diagnosis_pointer   = $request->input('diagnosis_pointer');
        $date_of_service     = $request->input('date_of_service');

        $referring_provider_name = $request->input('referring_provider_name');
        $referring_npi           = $request->input('referring_npi');

        $rendering_provider_name   = $request->input('rendering_provider_name');
        $rendering_npi             = $request->input('rendering_npi');
        $supervising_provider_name = $request->input('supervising_provider_name');
        $supervising_npi           = $request->input('supervising_npi');

        $se01              = 34; //$request->input('se01');
        $se02              = "000000001";//$request->input('se02');
        $ge_control_number =$request->gs_control_number; //$request->input('ge_control_number');
        $iea_control_number= $request->control_number;   //$request->input('iea_control_number');






        //missing part
       




$ediContent = "ISA*00*          *00*          *ZZ*{$senderId}*ZZ*{$receiverId}*{$transmissionDate}*{$transmissionTime}*^*00501*{$controlNumber}*1*T*:~
GS*HC*{$senderCode}*{$receiverCode}*{$gsDate}*{$gsTime}*{$gsControlNumber}*X*005010X222A1~
ST*837*000000001*005010X222A1~
BHT*0019*00*000000001*{$transmissionDate2}*{$transmissionTime}*CH~
NM1*41*2*{$submitterName}*****46*{$submitterId}~
PER*IC*PRODUCT SUPPORT*TE*8005278133*FX*5635854544~
NM1*40*2*{$receiverName}*****46*{$receiverId}~
HL*1**20*1~
PRV*BI*PXC*183500000X~
NM1*85*2*{$provider_name}*****XX*{$provider_npi}~
N3*{$provider_street}~
N4*{$provider_city}*{$provider_state}*{$provider_zip}~
REF*EI*{$provider_tax_id}~
HL*2*1*22*0~
SBR*P*18*041******CI~
NM1*IL*1*{$subscriber_last_name}*{$subscriber_first_name}****MI*{$member_id}~
N3*{$subscriber_street}~
N4*{$subscriber_city}*{$subscriber_state}*{$subscriber_zip}~
DMG*D8*{$subscriber_dob}*{$subscriber_gender}~
NM1*PR*2*{$payer_name}*****PI*{$payer_id}~
N3*{$payer_street}~
N4*{$payer_city}*{$payer_state}*{$payer_zip}~
CLM*{$claim_number}*{$claim_amount}***{$place_of_service}:B:{$claim_frequency}*Y*A*Y*Y~
PWK*M1*EL***AC*12365409090~
REF*D9*8675309~
REF*X4*39D2233490~
REF*EA*44608481~
HI*ABK:{$primary_diagnosis}~
NM1*DN*1*{$referring_provider_name}*****XX*{$referring_npi}~
NM1*82*1*{$rendering_provider_name}*****XX*{$rendering_npi}~
NM1*DQ*1*{$supervising_provider_name}*****XX*{$supervising_npi}~
LX*{$service_line_number}~
SV1*HC:{$procedure_code}*{$charge_amount}*UN*{$unit_count}***1~
DTP*472*D8*{$date_of_service}~
REF*6R*374531337~
SE*{$se01}*{$se02}~
GE*1*{$ge_control_number}~
IEA*1*{$iea_control_number}~";




        // Save the EDI file as .edi
        $fileName = '837P_' . time() . '.edi';
        Storage::disk('local')->put($fileName, $ediContent);

        return response()->download(storage_path("app/{$fileName}"), $fileName, [
            'Content-Type' => 'text/plain',
        ]);
    }



































//======================================================//









   public function showUploadForm()
    {
        return view('upload_275');
    }





public function process275(Request $request)
{
    $request->validate([
        'file' => 'required|file|mimes:txt,edi',
    ]);

    $file = $request->file('file');
    $originalName = $file->getClientOriginalName();
    $path = $file->storeAs('uploads', $originalName);
    // dd(12);

    // Read .275 file content
    $content = file_get_contents(storage_path("app/$path"));

    // Extract dynamic values from .275 file
   $senderId = str_pad($this->extractSegmentValue($content, 'ISA', 6, 15), 15, " ", STR_PAD_RIGHT);
   $receiverId = str_pad($this->extractSegmentValue($content, 'ISA', 8, 15), 15, " ", STR_PAD_RIGHT);

    $date = $this->extractSegmentValue($content, 'ISA', 9, 6); // Extract date (YYMMDD)
    $time = $this->extractSegmentValue($content, 'ISA', 10, 4); // Extract time (HHMM)
    $controlNumber = $this->extractSegmentValue($content, 'ISA', 13, 9); // Extract control number

    // Get current date and time
    $currentDate = date('Ymd');
    $currentTime = date('His');

           // Check if the .275 file contains a rejection or partial acceptance indicator
        $isFullyRejected = strpos($content, "BDS*R") !== false;
        $isPartiallyAccepted = strpos($content, "BDS*P") !== false;

        // Check for IK3 (Segment Errors) and IK4 (Element Errors)
        $hasSegmentErrors = strpos($content, "IK3*") !== false; // Means some segments are invalid
        $hasElementErrors = strpos($content, "IK4*") !== false; // Means some elements are incorrect

        // Determine IK5 and AK9 values based on conditions
        if ($isFullyRejected) {
            $ik5Code = "R"; // Fully Rejected
            $ak9Code = "R"; // Functional Group Rejected
        } elseif ($isPartiallyAccepted || $hasSegmentErrors || $hasElementErrors) {
            $ik5Code = "R"; // Some transactions rejected
            $ak9Code = "P"; // Partially Accepted
        } else {
            $ik5Code = "A"; // Fully Accepted
            $ak9Code = "A"; // Functional Group Accepted
        }

        // Generate the 999 file content dynamically
        $generatedContent = "ISA*00*          *00*          *ZZ*$senderId*ZZ*$receiverId*$date*$time*^*00501*$controlNumber*1*T*:~
        GS*FA*$senderId*$receiverId*$currentDate*$currentTime*$controlNumber*X*005010X231A1~
        ST*999*0001*005010X231A1~
        AK1*PI*$controlNumber*005010X210~
        AK2*275*000000001~
        IK5*$ik5Code~
        AK9*$ak9Code*1*1*1~
        SE*6*0001~
        GE*1*$controlNumber~
        IEA*1*$controlNumber~";
    // dd( $generatedContent);
    // Set filename based on status
    $status = $isFullyRejected ? "rejected" : ($isPartiallyAccepted || $hasSegmentErrors || $hasElementErrors ? "partially accepted" : "accepted");

    $newFileName = str_replace('.275', "_$status.999", $originalName);
    // dd(1);

    // Save the new 999 file
    Storage::put("uploads/$newFileName", $generatedContent);

    return redirect()->route('upload.275')->with('success', "File processed successfully. <a href='".route('download.999', $newFileName)."'>Download $ik5Code-$ak9Code-$status 999</a>");
}


    public function download999($filename)
    {
        $path = storage_path("app/uploads/$filename");
        if (!file_exists($path)) {
            abort(404);
        }
        return response()->download($path);
    }

    // Function to extract a specific segment value from the EDI file
    private function extractSegmentValue($content, $segment, $position, $length)
    {
        $lines = explode("~", $content); // Split by segment delimiter (~)
        foreach ($lines as $line) {
            if (strpos($line, $segment) === 0) {
                $elements = explode('*', $line); // Split segment into elements
                return isset($elements[$position]) ? trim($elements[$position]) : 'UNKNOWN';
            }
        }
        return 'UNKNOWN';
    }








































    // =============================== provider =======================//

    public function create_provider_form(){
        return view('provider.create_provider_form');
    }


    public function provider_view($id){
        $find=User::where('id',$id)->where('user_type','P')->with('providerDetails')->first();
        if(!$find){
            return back()->with('error','Id missmatch');
        }
        $data['data']=$find;
        return view('provider.view')->with($data);
    }




    public function create_provider(Request $request){
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|email|unique:users,email',

             'provider_clinic_name' => 'required|string|max:255',
            'npi' => 'required|string|max:255',
            'tax_id' => 'required|string|max:255',
            'provider_type' => 'required|in:Individual,Organization',
            // 'email_address' => 'required|email',
            'phone_number' => 'required|string',
            'service_street' => 'required|string',
            'service_city' => 'required|string',
            'service_state' => 'required|string|max:2',
            'service_zip_code' => 'required|string',

            // Optional fields
            'specialty' => 'nullable|string',
            'license_number' => 'nullable|string',
            'license_state' => 'nullable|string|max:2',
            'primary_contact_name' => 'nullable|string',
            'fax_number' => 'nullable|string',
            'billing_street' => 'nullable|string',
            'billing_city' => 'nullable|string',
            'billing_state' => 'nullable|string',
            'billing_zip_code' => 'nullable|string',

             // Facility Information
            'f_name' => 'required|string|max:255',
            'f_npi' => 'required|string',
            'f_street' => 'required|string|max:255',
            'f_city' => 'required|string|max:255',
            'f_state' => 'required|string|size:2', // 2-letter uppercase state code (e.g., "CA")
            'f_zip' => 'required|string', // Matches "12345" or "12345-6789"
        ]);

        // Generate a random password
        $tempPassword = Str::random(12); // or use more complex generation
        
        // Create the user
        $user = User::create([
            'name' => $validated['name'],
            'email' => $validated['email'],
            'password' => Hash::make($tempPassword),
            'user_type' => 'P',
        ]);

        // Update `link_expire` field to 10 minutes from now
        $upd=User::where('id',$user->id)->update(['link_expire' => Carbon::now()->addMinutes(10)]);
       


        $provider = new ProviderInfoModel();

        // Required fields
        $provider->user_id = $user->id;
        $provider->provider_clinic_name = $request->provider_clinic_name;
        $provider->npi = $request->npi;
        $provider->tax_id = $request->tax_id;
        $provider->provider_type = $request->provider_type;
        $provider->specialty = $request->specialty;
        $provider->license_number = $request->license_number;
        $provider->license_state = $request->license_state;

        // Contact info
        $provider->primary_contact_name = $request->primary_contact_name;
        // $provider->email_address = $request->email_address;
        $provider->phone_number = $request->phone_number;
        $provider->fax_number = $request->fax_number;

        // Service location
        $provider->service_street = $request->service_street;
        $provider->service_city = $request->service_city;
        $provider->service_state = $request->service_state;
        $provider->service_zip_code = $request->service_zip_code;

        // facility location
        $provider->f_name = $request->f_name;
        $provider->f_npi = $request->f_npi;
        $provider->f_street = $request->f_street;
        $provider->f_city = $request->f_city;
        $provider->f_state = $request->f_state;
        $provider->f_zip = $request->f_zip;

        // Billing address (optional)
        if ($request->has('different_billing')) {
            $provider->billing_street = $request->billing_street;
            $provider->billing_city = $request->billing_city;
            $provider->billing_state = $request->billing_state;
            $provider->billing_zip_code = $request->billing_zip_code;
        }else{
            $provider->billing_street = $request->service_street;
            $provider->billing_city = $request->service_city;
            $provider->billing_state = $request->service_state;
            $provider->billing_zip_code = $request->service_zip_code;

        }

        $provider->save();

         // Prepare email data
        $mailData = [
            'subject' => 'Your Provider Account Credentials',
            'title' => 'Account Registration Complete',
            'greeting' => 'Dear '.$validated['name'].',',
            'message' => 'Your provider account has been successfully created. Below are your login credentials:',
            'email' => $validated['email'],
            'password' => $tempPassword,
            'important_note' => 'Please change your password and complete your profile after first login.',
            'login_url' => route('login'), // Your actual login route
            'sender' => config('app.name').' Support Team'
        ];

        // Send email
        Mail::to($validated['email'])->send(new ProviderRegisterMail($mailData));

         return redirect()->back()
        ->with('success', 'Provider account created successfully. Login credentials sent to '.$validated['email']);

    }





    public function complete_provider_info(){
        if(@Auth()->user()->user_type=="P"){
        $providerInfo = User::where('id', Auth()->user()->id)->first();
            if (!$providerInfo->username) {
                 return view('provider.complete_profile');
            }else{
                return redirect()->route('dashboard.sftp'); // Redirect to dashboard
            }
        }else{
            return redirect()->route('dashboard.sftp'); // Redirect to dashboard
        }
      
    }




   public function provider_info_store(Request $request)
   {
    // dd($request->all());
     $request->validate([
        'username' => 'required|string|unique:users,username|max:255',
        'password' => 'required|string|min:6',
    ]);

    $userUpd=[];
    $userUpd['username'] = $request->username;
    $userUpd['password'] = Hash::make($request->password); 
    $update=User::where('id',Auth()->user()->id)->update($userUpd);

     return redirect()->route('dashboard')->with('success', 'Provider information saved successfully.');
   }





   public function all_providers(Request $request){
    // dd($request->all());
    $query=User::where('user_type','P')->orderBy('id','desc')->with('providerDetails');


    // Apply filters if provided

    if ($request->name) {
        $query->where('name', 'like', '%' . $request->name . '%');
    }

   
    if ($request->daterange) {
        $query->whereDate('created_at', $request->daterange);
    }

    $limit = $request->input('limit', 10); // default 10
    $data['data'] = $query->paginate($limit)->appends($request->all());
    $data['limit'] = $limit;
    // dd($data);

    return view('provider.all_provider')->with($data);
   }


















//============== api base function for provider create ============//


public function create_provider_api(Request $request)
{
    $validated = $request->validate([
        'name' => 'required|string|max:255',
        'email' => 'required|email|unique:users,email',

        'provider_clinic_name' => 'required|string|max:255',
        'npi' => 'required|string|max:255',
        'tax_id' => 'required|string|max:255',
        'provider_type' => 'required|in:Individual,Organization',
        'phone_number' => 'required|string',
        'service_street' => 'required|string',
        'service_city' => 'required|string',
        'service_state' => 'required|string|max:2',
        'service_zip_code' => 'required|string',

        // Optional
        'specialty' => 'nullable|string',
        'license_number' => 'nullable|string',
        'license_state' => 'nullable|string|max:2',
        'primary_contact_name' => 'nullable|string',
        'fax_number' => 'nullable|string',
        'billing_street' => 'nullable|string',
        'billing_city' => 'nullable|string',
        'billing_state' => 'nullable|string',
        'billing_zip_code' => 'nullable|string',
        'different_billing' => 'nullable|boolean',

          'f_name' => 'required|string|max:255',
            'f_npi' => 'required|string',
            'f_street' => 'required|string|max:255',
            'f_city' => 'required|string|max:255',
            'f_state' => 'required|string|size:2', // 2-letter uppercase state code (e.g., "CA")
            'f_zip' => 'required|string', // Matches "12345" or "12345-6789"
    ]);

    try {
        $tempPassword = Str::random(12);

        $user = User::create([
            'name' => $validated['name'],
            'email' => $validated['email'],
            'password' => Hash::make($tempPassword),
            'user_type' => 'P',
            // 'link_expire' => Carbon::now()->addMinutes(10),
        ]);

        // Update `link_expire` field to 10 minutes from now
        $upd=User::where('id',$user->id)->update(['link_expire' => Carbon::now()->addMinutes(10)]);
       

        $provider = new ProviderInfoModel();
        $provider->user_id = $user->id;
        $provider->provider_clinic_name = $validated['provider_clinic_name'];
        $provider->npi = $validated['npi'];
        $provider->tax_id = $validated['tax_id'];
        $provider->provider_type = $validated['provider_type'];
        $provider->specialty = $validated['specialty'] ?? null;
        $provider->license_number = $validated['license_number'] ?? null;
        $provider->license_state = $validated['license_state'] ?? null;
        $provider->primary_contact_name = $validated['primary_contact_name'] ?? null;
        $provider->phone_number = $validated['phone_number'];
        $provider->fax_number = $validated['fax_number'] ?? null;

        if ($request->different_billing) {
            $provider->billing_street = $validated['billing_street'];
            $provider->billing_city = $validated['billing_city'];
            $provider->billing_state = $validated['billing_state'];
            $provider->billing_zip_code = $validated['billing_zip_code'];
        } else {
            $provider->billing_street = $validated['service_street'];
            $provider->billing_city = $validated['service_city'];
            $provider->billing_state = $validated['service_state'];
            $provider->billing_zip_code = $validated['service_zip_code'];
        }
         $provider->f_name = $request->f_name;
        $provider->f_npi = $request->f_npi;
        $provider->f_street = $request->f_street;
        $provider->f_city = $request->f_city;
        $provider->f_state = $request->f_state;
        $provider->f_zip = $request->f_zip;

        $provider->service_street = $validated['service_street'];
        $provider->service_city = $validated['service_city'];
        $provider->service_state = $validated['service_state'];
        $provider->service_zip_code = $validated['service_zip_code'];

        $provider->save();

        // Send mail
        $mailData = [
            'subject' => 'Your Provider Account Credentials',
            'title' => 'Account Registration Complete',
            'greeting' => 'Dear '.$validated['name'].',',
            'message' => 'Your provider account has been successfully created. Below are your login credentials:',
            'email' => $validated['email'],
            'password' => $tempPassword,
            'important_note' => 'Please change your password and complete your profile after first login.',
            'login_url' => route('login'),
            'sender' => config('app.name').' Support Team'
        ];

        Mail::to($validated['email'])->send(new ProviderRegisterMail($mailData));

        return response()->json([
            'status' => 'success',
            'message' => 'Provider account created successfully. Login credentials sent to email.',
            'data' => [
                'user_id' => $user->id,
                'email' => $user->email,
                'temp_password' => $tempPassword,
                'link_expire' => $user->link_expire
            ]
        ], 201);

    } catch (\Exception $e) {
        return response()->json([
            'status' => 'error',
            'message' => 'Failed to create provider.',
            'error' => $e->getMessage()
        ], 500);
    }
}





 


}
