<!-- resources/views/payment.blade.php -->
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Stripe Payment</title>
    <!-- Include Stripe.js and Stripe Elements -->
    <script src="https://js.stripe.com/v3/"></script>
</head>
<body>
    <form id="payment-form">
        <?php echo csrf_field(); ?> <!-- CSRF token for Laravel form submission -->

        <div id="card-element">
            <!-- A Stripe Element will be inserted here. -->
        </div>

        <!-- Used to display form errors. -->
        <div id="card-errors" role="alert"></div>

        <button id="submit-button">Submit Payment</button>
    </form>

    <script>
        var stripe = Stripe('pk_test_51NmZ2CSFMphztnp4kO33hJgv1usy14ajZwVvT2Van8ZyeIcf0twGechTat6fCRv4r7OXh8clhI95Iv41NleEbftr00K2VpdScl'); // Replace with your actual Stripe publishable key
        var elements = stripe.elements();

        // Create an instance of the card Element.
        var card = elements.create('card');

        // Add an instance of the card Element into the `card-element` div.
        card.mount('#card-element');

        // Handle form submission.
        var form = document.getElementById('payment-form');
        form.addEventListener('submit', function(event) {
            event.preventDefault();

            stripe.createPaymentMethod({
                type: 'card',
                card: card,
            }).then(function(result) {
                if (result.error) {
                    // Show error in form
                    var errorElement = document.getElementById('card-errors');
                    errorElement.textContent = result.error.message;
                } else {
                    // Send payment method ID to your server to create a payment intent
                    fetch('<?php echo e(route('create.payment.intent')); ?>', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>', // Add CSRF token
                        },
                        body: JSON.stringify({
                            payment_method: result.paymentMethod.id,
                        }),
                    }).then(function(response) {
                        return response.json();
                    }).then(function(data) {
                        // Use the client_secret to complete the payment on the frontend
                        stripe.confirmCardPayment(data.client_secret, {
                            payment_method: {
                                card: card,
                            }
                        }).then(function(confirmResult) {
                            if (confirmResult.error) {
                                // Show error in form
                                var errorElement = document.getElementById('card-errors');
                                errorElement.textContent = confirmResult.error.message;
                            } else {
                                // Payment successful, handle success in your application
                                console.log('Payment successful:', confirmResult.paymentIntent);
                            }
                        });
                    });
                }
            });
        });
    </script>
</body>
</html>
<?php /**PATH D:\projectsFolder\htdocs\TestProjectJeet\resources\views/payment.blade.php ENDPATH**/ ?>