<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\EdiiController;
use App\Http\Controllers\EdidController;
use App\Http\Controllers\EdipController;
use App\Http\Controllers\SftpEdiController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Route::get('/', function () {
//     return view('welcome');
// });

Route::get('/register', [AuthController::class, 'showRegisterForm'])->name('register');
Route::post('/register', [AuthController::class, 'register'])->name('register.submit');

Route::get('/', [AuthController::class, 'showLoginForm'])->name('login');
Route::get('/login', [AuthController::class, 'showLoginForm'])->name('login');
Route::post('/login', [AuthController::class, 'login'])->name('login.submit');
Route::any('/logout', [AuthController::class, 'logout'])->name('logout');

Route::get('/forgot-password', [AuthController::class, 'showForgotPassword'])->name('password.request');
Route::post('/forgot-password', [AuthController::class, 'sendResetLink'])->name('password.email');


Route::middleware(['auth'])->group(function () {
    Route::any('/dashboard', [AuthController::class, 'dashboard'])->name('dashboard');
    Route::any('/view-recived-files', [AuthController::class, 'view_rcv_files_sftp'])->name('dashboard.sftp');


	Route::get('/edi-p', [EdipController::class, 'edip'])->name('edip'); //edi-p
	Route::post('/generate-edi', [EdipController::class, 'generateEDI'])->name('generate.edi');
	Route::get('/upload-275-for-edi-p/{id}', [EdipController::class, 'showUploadForm'])->name('upload.275.edip');
	Route::post('/upload-275', [EdipController::class, 'process275'])->name('process.275');
	Route::get('/download-999/{filename}', [EdipController::class, 'download999'])->name('download.999');



	Route::get('/edi-i', [EdiiController::class, 'edii'])->name('edii'); //edi-i
	Route::post('/edi-i', [EdiiController::class, 'submit_837i'])->name('submit-837i'); //edi-i
	Route::get('/upload-275-for-edi-i/{id}', [EdiiController::class, 'showUploadForm'])->name('upload.275.edii');
	Route::post('/upload-275/i', [EdiiController::class, 'process275'])->name('process.275.i');
	Route::get('/download-999/i/{filename}', [EdiiController::class, 'download999'])->name('download.999.i');



	Route::get('/edi-d', [EdidController::class, 'edid'])->name('edid'); //edi-d
	Route::post('/edi-d', [EdidController::class, 'submit_837d'])->name('submit-837d'); //edi-d
	Route::get('/upload-275-for-edi-d/{id}', [EdidController::class, 'showUploadForm'])->name('upload.275.edid');
	Route::post('/upload-275/d', [EdidController::class, 'process275'])->name('process.275.d');
	Route::get('/download-999/d/{filename}', [EdidController::class, 'download999'])->name('download.999.d');


	Route::get('/download-edi/{id}', [AuthController::class, 'download'])->name('download.edi');


	
  //sftp 
	Route::get('/sftp/get-files', [SftpEdiController::class, 'get_837_files'])->name('get.837.sftp');

	Route::get('/sftp/get-837-files', [SftpEdiController::class, 'fetch837Files']);
    Route::get('/sftp/get-275-files', [SftpEdiController::class, 'fetch275Files']);
    Route::get('/sftp/send-to-999', [SftpEdiController::class, 'sendFileTo999'])->name('send.to.999');

    Route::get('/sftp/generate-999/{id}', [SftpEdiController::class, 'generate_999'])->name('generate.sftp.999');
    Route::get('/sftp/send-999/{id}', [SftpEdiController::class, 'send_999'])->name('send.sftp.999');
    
	Route::get('/downlode-sftp-file/{id}', [SftpEdiController::class, 'downlode_sftp_file'])->name('downlode.sftp.file');
	Route::get('/downlode/ack-file/{id}', [SftpEdiController::class, 'downlode_ack_file'])->name('downlode.ack.file');






});





