<!DOCTYPE html>
<html lang="en">
   <head>
   <meta charset="UTF-8">
   <meta http-equiv="X-UA-Compatible" content="IE=edge">
   <meta name="viewport" content="width=device-width, initial-scale=1.0">
   @yield('title')
   <link rel="stylesheet" href="{{url('/')}}/public/layouts/css/tailwind.min.css?v=">
   <link href="{{url('/')}}/public/layouts/css/output.css?ver=" rel="stylesheet">
   <link rel="stylesheet" href="{{url('/')}}/public/layouts/css/style.css?ver=545">
   <link rel="stylesheet" href="https://use.fontawesome.com/releases/v6.6.0/css/all.css">
   <link href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
</head>
    <body>
        @if (Route::currentRouteName() != 'login')
          {{--   <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
            <div class="container">
                <a class="navbar-brand" href="#" style="text-align: left;">EDI System</a>
                
                <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
                </button>
                <div class="collapse navbar-collapse" id="navbarNav" style="margin-left: 100px;">
                    <ul class="navbar-nav">
                        @if(@Auth::user()->id)
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('dashboard') ? 'active' : '' }}" href="{{ route('dashboard') }}">
                                Dashboard
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('edip') ? 'active' : '' }}" href="{{ route('edip') }}">
                                Generate EDI-P
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('edii') ? 'active' : '' }}" href="{{ route('edii') }}">
                                Generate EDI-I
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('edid') ? 'active' : '' }}" href="{{ route('edid') }}">
                                Generate EDI-D
                            </a>
                        </li>
                        @endif
                    </ul>
                    @auth
                    <ul class="navbar-nav ms-auto">
                        <li class="nav-item">
                            
                            <a href="{{ route('logout') }}" style="color:white">    <i class="bi bi-box-arrow-right"></i> Logout</a>
                            
                        </li>
                    </ul>
                    @endauth
                </div>
            </div>
         </nav> --}}

            <header class="g-header md:pb-32">
              <div class="container">
                 <div class="border-b border-gray-700">
                    <div class="flex items-center justify-between h-16 px-4 sm:px-0">
                       <div class="flex items-center">
                          <div class="flex-shrink-0">
                             <a href="javascript:void(0)" class="font-light block text-center text-white text-2xl">Klyre<span class="font-bold">Payments</span></a>
                          </div>
                          <div class="hidden md:block">
                             <div class="ml-10 flex items-baseline space-x-4">
                                <nav>
                                   <ul class="mainmenu">
                                      <li>
                                         <a href="{{-- dashboard.html --}}" class="menuitem">Dashboard</a>
                                      </li>
                                      <li>
                                         <a href="javascript:void(0)" class="menuitem active">EDI Files</a>
                                      </li>
                                     {{--  <li>
                                         <a href="javascript:void(0)" class="menuitem">Claims</a>
                                      </li>
                                      <li>
                                         <a href="users.html" class="menuitem">Users</a>
                                      </li> --}}
                                   </ul>
                                </nav>
                             </div>
                          </div>
                       </div>
                       <div class="hidden md:block text-right">
                          <div class="flex divide-x divide-gray-500">
                             <div class="text-white text-right text-sm ml-auto pr-6">
                                <p id="clock" class="font-medium">Thu, Sep 19 2024, 05:17:34</p>
                                <p class="text-gray-400 text-xs">New York</p>
                             </div>
                             <div class="text-sm pl-6">
                                <p class="text-white font-medium">Super User</p>
                                <form method="POST" action="{{route('logout')}}">
                                    @csrf
                                   <button type="submit" class="text-gray-400 text-xs hover:underline hover:text-white focus:text-white focus:ring-offset-2">Log out</button>
                                </form>
                             </div>
                          </div>
                       </div>
                    </div>
                 </div>
              </div>
              <script>
                 document.addEventListener('DOMContentLoaded', function () {
                    var dropdownItems = document.querySelectorAll('.menu-item-has-children');
                    var dropdowns = document.querySelectorAll('.menu-item-has-children .mainmenu-sub-menu');
                    var delay = 2000;
                    if (dropdownItems) {
                       dropdownItems.forEach((dropdownItem, count) => {
                          dropdownItem.addEventListener('mouseenter', function (e) {
                             dropdowns[count].classList.add('dropdown-show');
                          });
                          dropdownItem.addEventListener('mouseleave', function () {
                             dropdowns[count].classList.remove('dropdown-show');
                          });
                       });
                    }
                 })
              </script>
              <div class="container">
                 <div class="md:py-10 py-5 md:flex md:items-end md:justify-between w-full">
                    <div class="md:flex md:items-end md:justify-between">
                        @if (Route::currentRouteName() != 'dashboard')
                       <a class="btn text-white bg-indigo-600 hover:bg-indigo-700 mr-4" id="" href="{{route('dashboard')}}" >View Created 837</a>
                       @else
                        <a class="btn text-white bg-indigo-600 hover:bg-indigo-700 mr-4" id="" href="{{route('dashboard.sftp')}}" >View Recived Files</a>

                       @endif
                       <button class="btn text-white bg-indigo-600 hover:bg-indigo-700" id="createedi" data-bs-toggle="modal" data-bs-target="#ediModal"> Create 837</button>
                    </div>
                 </div>
              </div>

           </header>
        @endif
        
            @yield('content')
      <div class="modal fade" id="ediModal" tabindex="-1" aria-labelledby="createEDIModalModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header">
                <div class="text-xl font-semibold">Create Patient</div>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"><i class="fa-solid fa-xmark"></i></button>
            </div>
            <div class="modal-body">
                <form id="ediForm">
                    @csrf
                <div class="flex flex-col px-2 py-1">
                    <select name="" id="ediType"  required class="rounded-md border py-2 px-3 text-grey-800 w-full h-full">
                        <option value="">Select Type</option>
                         <option value="{{ route('edip') }}">EDI-P</option>
                            <option value="{{ route('edii') }}">EDI-I</option>
                            <option value="{{ route('edid') }}">EDI-D</option>
                    </select>

                    <button class="btn btn-primary w-1/6 mt-5 ml-auto" type="submit">
                    Submit
                    </button>
                </div>
            </form>
            </div>
        </div>
    </div>
</div>
        <footer class="my-4 text-center text-base text-gray-400">© KlyrePayments, LLC. 2025.</footer>
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
        <script>
document.getElementById('ediForm').addEventListener('submit', function(event) {
event.preventDefault();
var selectedRoute = document.getElementById('ediType').value;
if (selectedRoute) {
window.location.href = selectedRoute;
}
});
</script>
    </body>
</html>