@extends('layouts.app')
@section('title')
 <title>837 edi-i Create Multi-Step Form</title>
@endsection

@section('content')
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<style>
    .btn.text-white {
        padding: 4px 14px;
        font-size: 13px;
        font-weight: 600;
        border-radius: 6px;
        line-height: 1.5;
        display: inline-block;
        text-align: center;
        white-space: nowrap;
        vertical-align: middle;
        transition: background-color 0.2s ease-in-out;
        background-color: rgb(79 70 229);
    }

    .form-group{
    margin-bottom: 20px;
    }
    .g-header{
    height: 170px;
    }
    .step { display: none; }
    .active { display: block; }
    .next, .prev {
    padding: 6px 16px;       /* good horizontal and vertical padding */
    font-size: 14px;
    border-radius: 6px;
    border: none;
    cursor: pointer;
    width: auto;
    height: auto;
    display: inline-block;
    text-align: center;
    line-height: normal;
    background-color: #0d6efd;  /* for .next */
    color: white;
    margin-right: 10px;
    margin-bottom: 10px;
    margin-top: 10px;
    }
    .prev {
    background-color: orange;
    }
    #multiStepForm {
    width: 50%;
    background: white;
    padding: 20px;
    margin: 50px auto;
    border-radius: 10px;
    box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
    }
    /*  .step {
    display: none;
    }
    .active {
    display: block;
    }*/
    .step {
    display: none;
    }
    .step.active {
    display: flex; /* or block, but flex works better for columns */
    flex-wrap: wrap;
    }
    h2 {
    color: #333;
    }
    input {
    width: 30%;
    padding: 10px;
    margin: 10px 0;
    border: 1px solid #ccc;
    border-radius: 5px;
    font-size: 16px;
    }
    button {
    background-color: #007bff;
    color: white;
    border: none;
    padding: 10px 15px;
    font-size: 16px;
    cursor: pointer;
    border-radius: 5px;
    transition: 0.3s;
    }
    button:hover {
    background-color: #0056b3;
    }
    .prev {
    background-color: #6c757d;
    }
    .prev:hover {
    background-color: #5a6268;
    }
    .submit {
    background-color: #28a745;
    }
    .submit:hover {
    background-color: #218838;
    }
    .form-control{
    width: 30%;
    }

</style>
        @if ($errors->any())
        <div class="alert alert-danger">
            <ul>
                @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
        @endif
        <h2 style="text-align: center;">Generate 837 EDI-I FILE</h2>

        <form class="container" id="multiStepForm"  action="{{ route('submit-837i') }}" method="POST" class="row g-3">
            @csrf
            <!-- Step 1 -->
          
            <div class="row step active">
                <div class="col-md-6">
                    <label for="sender_id" class="form-label">Sender ID:</label>
                    <input type="text" id="sender_id" name="sender_id" class="form-control" required minlength="2" maxlength="15" value="SENDER123">
                </div>
                <div class="col-md-6">
                    <label for="receiver_id" class="form-label">Receiver ID:</label>
                    <input type="text" id="receiver_id" name="receiver_id" class="form-control" required minlength="2" maxlength="15" value="RECEIVER456">
                </div>
                <div class="col-md-6">
                    <label for="transmission_time" class="form-label">Transmission Time (HHMM):</label>
                    <input type="text" id="transmission_time" name="transmission_time" class="form-control" required pattern="\d{4}" value="1430">
                </div>
                <div class="col-md-6">
                    <label for="control_number" class="form-label">Control Number:</label>
                    <input type="text" id="control_number" name="control_number" class="form-control" required maxlength="15" value="123500377">
                </div>
                <div class="col-md-6">
                    <label for="sender_code" class="form-label">Sender Code:</label>
                    <input type="text" id="sender_code" name="sender_code" class="form-control" required maxlength="15" value="SENDCODE1">
                </div>
                <div class="col-md-6">
                    <label for="receiver_code" class="form-label">Receiver Code:</label>
                    <input type="text" id="receiver_code" name="receiver_code" class="form-control" required maxlength="15" value="RECEIVECODE2">
                </div>
                <div class="col-md-6">
                    <label for="gs_date" class="form-label">GS Date (CCYYMMDD):</label>
                    <input type="text" id="gs_date" name="gs_date" class="form-control" required pattern="\d{8}" value="20250321">
                </div>
                <div class="col-md-6">
                    <label for="gs_time" class="form-label">GS Time (HHMM):</label>
                    <input type="text" id="gs_time" name="gs_time" class="form-control" required pattern="\d{4}" value="0900">
                </div>
                <div class="col-md-6">
                    <label for="gs_control_number" class="form-label">GS Control Number:</label>
                    <input type="text" id="gs_control_number" name="gs_control_number" class="form-control" required maxlength="15" value="123096815">
                </div>
                {{-- part 2 --}}
                <div class="col-md-6">
                    <label for="submitter_name" class="form-label">Submitter Name:</label>
                    <input type="text" id="submitter_name" name="submitter_name" class="form-control" required maxlength="100" value="John Healthcare Services">
                </div>
                <div class="col-md-6">
                    <label for="submitter_id" class="form-label">Submitter ID:</label>
                    <input type="text" id="submitter_id" name="submitter_id" class="form-control" required maxlength="15" value="SUBMIT123">
                </div>
                <div class="col-md-6">
                    <label for="receiver_name" class="form-label">Receiver Name:</label>
                    <input type="text" id="receiver_name" name="receiver_name" class="form-control" required maxlength="100" value="XYZ Health Insurance">
                </div>
                <div class="col-md-6">
                    <label for="receiver_id" class="form-label">Receiver ID:</label>
                    <input type="text" id="receiver_id" name="receiver_id" class="form-control" required maxlength="15" value="RECV789">
                </div>
                <div class="col-md-6">
                    <button type="button" class="next">Next</button>
                </div>
                
            </div>
            
            <!-- Step 2 -->
            <div class="row step">
                {{-- part 3 --}}
                <div class="col-md-6">
                    <label for="billing_provider_name" class="form-label">Billing Provider Name:</label>
                    <input type="text" id="billing_provider_name" name="billing_provider_name" class="form-control" required maxlength="100" value="ABC Medical Center">
                </div>
                <div class="col-md-6">
                    <label for="billing_provider_npi" class="form-label">Billing Provider NPI:</label>
                    <input type="text" id="billing_provider_npi" name="billing_provider_npi" class="form-control" required pattern="\d{10}" value="1234567890">
                </div>
                <div class="col-md-6">
                    <label for="billing_provider_tax_id" class="form-label">Billing Provider Tax ID:</label>
                    <input type="text" id="billing_provider_tax_id" name="billing_provider_tax_id" class="form-control" required value="12-3456789">
                </div>
                <div class="col-md-6">
                    <label for="billing_provider_street" class="form-label">Billing Provider Street:</label>
                    <input type="text" id="billing_provider_street" name="billing_provider_street" class="form-control" required maxlength="150" value="123 Main St">
                </div>
                <div class="col-md-6">
                    <label for="billing_provider_city" class="form-label">Billing Provider City:</label>
                    <input type="text" id="billing_provider_city" name="billing_provider_city" class="form-control" required maxlength="50" value="Los Angeles">
                </div>
                <div class="col-md-6">
                    <label for="billing_provider_state" class="form-label">Billing Provider State:</label>
                    <input type="text" id="billing_provider_state" name="billing_provider_state" class="form-control" required pattern="[A-Z]{2}" value="CA">
                </div>
                <div class="col-md-6">
                    <label for="billing_provider_zip" class="form-label">Billing Provider ZIP:</label>
                    <input type="text" id="billing_provider_zip" name="billing_provider_zip" class="form-control" required pattern="\d{9}" value="900012345">
                </div>
                <div class="col-md-6">
                    <label for="facility_name" class="form-label">Facility Name:</label>
                    <input type="text" id="facility_name" name="facility_name" class="form-control" required maxlength="100" value="XYZ Hospital">
                </div>
                <div class="col-md-6">
                    <label for="facility_npi" class="form-label">Facility NPI:</label>
                    <input type="text" id="facility_npi" name="facility_npi" class="form-control" required pattern="\d{10}" value="0987654321">
                </div>
                <div class="col-md-6">
                    <label for="facility_street" class="form-label">Facility Street:</label>
                    <input type="text" id="facility_street" name="facility_street" class="form-control" required maxlength="150" value="456 Elm St">
                </div>
                <div class="col-md-6">
                    <label for="facility_city" class="form-label">Facility City:</label>
                    <input type="text" id="facility_city" name="facility_city" class="form-control" required maxlength="50" value="New York">
                </div>
                <div class="col-md-6">
                    <label for="facility_state" class="form-label">Facility State:</label>
                    <input type="text" id="facility_state" name="facility_state" class="form-control" required pattern="[A-Z]{2}" value="NY">
                </div>
                <div class="col-md-6">
                    <label for="facility_zip" class="form-label">Facility ZIP:</label>
                    <input type="text" id="facility_zip" name="facility_zip" class="form-control" required pattern="\d{9}" value="100012345">
                </div>
                {{-- part-4 --}}
                <div class="col-md-6">
                    <label for="patient_last_name" class="form-label">Patient Last Name:</label>
                    <input type="text" id="patient_last_name" name="patient_last_name" class="form-control" required maxlength="100" value="Doe">
                </div>
                <div class="col-md-6">
                    <label for="patient_first_name" class="form-label">Patient First Name:</label>
                    <input type="text" id="patient_first_name" name="patient_first_name" class="form-control" required maxlength="100" value="John">
                </div>
                <div class="col-md-6">
                    <label for="patient_dob" class="form-label">Patient DOB (YYYYMMDD):</label>
                    <input type="text" id="patient_dob" name="patient_dob" class="form-control" required pattern="\d{8}" value="19850515">
                </div>
                <div class="col-md-6">
                    <label for="patient_gender" class="form-label">Patient Gender:</label>
                    <select id="patient_gender" name="patient_gender" class="form-select" required>
                        <option value="M" selected>Male</option>
                        <option value="F">Female</option>
                        <option value="U">Unknown</option>
                    </select>
                </div>
                <div class="col-md-6">
                    <label for="patient_member_id" class="form-label">Patient Member ID:</label>
                    <input type="text" id="patient_member_id" name="patient_member_id" class="form-control" required minlength="8" maxlength="15" value="MEMB123456">
                </div>
                <div class="col-md-6">
                    <label for="patient_street" class="form-label">Patient Street:</label>
                    <input type="text" id="patient_street" name="patient_street" class="form-control" required maxlength="150" value="789 Maple Ave">
                </div>
                <div class="col-md-6">
                    <label for="patient_city" class="form-label">Patient City:</label>
                    <input type="text" id="patient_city" name="patient_city" class="form-control" required maxlength="50" value="Chicago">
                </div>
                <div class="col-md-6">
                    <label for="patient_state" class="form-label">Patient State:</label>
                    <input type="text" id="patient_state" name="patient_state" class="form-control" required pattern="[A-Z]{2}" value="IL">
                </div>
                <div class="col-md-6">
                    <label for="patient_zip" class="form-label">Patient ZIP:</label>
                    <input type="text" id="patient_zip" name="patient_zip" class="form-control" required pattern="\d{9}" value="606012345">
                </div>
                <div class="col-md-6">
                    <label for="admission_date" class="form-label">Admission Date (YYYYMMDD):</label>
                    <input type="text" id="admission_date" name="admission_date" class="form-control" required pattern="\d{8}" value="20250315">
                </div>
                <div class="col-md-6">
                    <label for="discharge_date" class="form-label">Discharge Date (YYYYMMDD):</label>
                    <input type="text" id="discharge_date" name="discharge_date" class="form-control" required pattern="\d{8}" value="20250320">
                </div>
                <button type="button" class="prev">Previous</button>
                <button type="button" class="next">Next</button>
            </div>
            <!-- Step 3 -->
            <div class="row step">
                {{-- part 5 --}}
                <div class="col-md-6">
                    <label for="admission_type_code" class="form-label">Admission Type Code:</label>
                    <input type="text" id="admission_type_code" name="admission_type_code" class="form-control" required maxlength="1" value="1">
                </div>
                <div class="col-md-6">
                    <label for="admission_source_code" class="form-label">Admission Source Code:</label>
                    <input type="text" id="admission_source_code" name="admission_source_code" class="form-control" required maxlength="2" value="4">
                </div>
                <div class="col-md-6">
                    <label for="claim_number" class="form-label">Claim Number:</label>
                    <input type="text" id="claim_number" name="claim_number" class="form-control" required maxlength="50" value="CLM123456">
                </div>
                <div class="col-md-6">
                    <label for="total_claim_amount" class="form-label">Total Claim Amount ($):</label>
                    <input type="text" id="total_claim_amount" name="total_claim_amount" class="form-control" required pattern="^\d+(\.\d{1,2})?$" value="1500.00">
                </div>
                <div class="col-md-6">
                    <label for="facility_type_code" class="form-label">Facility Type Code:</label>
                    <input type="text" id="facility_type_code" name="facility_type_code" class="form-control" required maxlength="2" value="11">
                </div>
                <div class="col-md-6">
                    <label for="claim_frequency_code" class="form-label">Claim Frequency Code:</label>
                    <input type="text" id="claim_frequency_code" name="claim_frequency_code" class="form-control" required maxlength="1" value="1">
                </div>
                <div class="col-md-6">
                    <label for="primary_diagnosis" class="form-label">Primary Diagnosis Code:</label>
                    <input type="text" id="primary_diagnosis" name="primary_diagnosis" class="form-control" required pattern="^[A-Z]\d{2}(\.\d{1,4})?$" value="J18.9">
                </div>
                <div class="col-md-6">
                    <label for="additional_diagnosis" class="form-label">Additional Diagnosis Codes (comma-separated):</label>
                    <input type="text" id="additional_diagnosis" name="additional_diagnosis" class="form-control" value="I10,Z79.899">
                </div>
                {{-- part-6 --}}
                <div class="col-md-6">
                    <label for="procedure_code" class="form-label">Procedure Code (ICD-10-PCS):</label>
                    <input type="text" id="procedure_code" name="procedure_code" class="form-control" required pattern="^[A-Z0-9]{7}$" value="0JH606Z">
                </div>
                <div class="col-md-6">
                    <label for="revenue_code" class="form-label">Revenue Code:</label>
                    <input type="text" id="revenue_code" name="revenue_code" class="form-control" required pattern="^\d{4}$" value="0450">
                </div>
                <div class="col-md-6">
                    <label for="charge_amount" class="form-label">Charge Amount ($):</label>
                    <input type="text" id="charge_amount" name="charge_amount" class="form-control" required pattern="^\d+(\.\d{1,2})?$" value="2500.00">
                </div>
                <div class="col-md-6">
                    <label for="units_of_service" class="form-label">Units of Service:</label>
                    <input type="text" id="units_of_service" name="units_of_service" class="form-control" required pattern="^\d+$" value="2">
                </div>
                <div class="col-md-6">
                    <label for="service_date" class="form-label">Service Date (YYYYMMDD):</label>
                    <input type="text" id="service_date" name="service_date" class="form-control" required pattern="\d{8}" value="20250322">
                </div>
                <div class="col-md-6">
                    <label for="condition_codes" class="form-label">Condition Codes (comma-separated):</label>
                    <input type="text" id="condition_codes" name="condition_codes" class="form-control" value="A1,B2">
                </div>
                <button type="button" class="prev">Previous</button>
                <button type="button" class="next">Next</button>
            </div>
            <!-- Step 4 -->
            <div class="row step">
                {{-- part-7 --}}
                <div class="col-md-6">
                    <label for="payer_name" class="form-label">Payer Name:</label>
                    <input type="text" id="payer_name" name="payer_name" class="form-control" required maxlength="100" value="ABC Insurance">
                </div>
                <div class="col-md-6">
                    <label for="payer_id" class="form-label">Payer ID:</label>
                    <input type="text" id="payer_id" name="payer_id" class="form-control" required pattern="^\d{5,10}$" value="123456">
                </div>
                <div class="col-md-6">
                    <label for="payer_street" class="form-label">Payer Street:</label>
                    <input type="text" id="payer_street" name="payer_street" class="form-control" required maxlength="150" value="789 Finance Ave">
                </div>
                <div class="col-md-6">
                    <label for="payer_city" class="form-label">Payer City:</label>
                    <input type="text" id="payer_city" name="payer_city" class="form-control" required maxlength="50" value="New York">
                </div>
                <div class="col-md-6">
                    <label for="payer_state" class="form-label">Payer State:</label>
                    <input type="text" id="payer_state" name="payer_state" class="form-control" required pattern="[A-Z]{2}" value="NY">
                </div>
                <div class="col-md-6">
                    <label for="payer_zip" class="form-label">Payer ZIP:</label>
                    <input type="text" id="payer_zip" name="payer_zip" class="form-control" required pattern="\d{9}" value="100012345">
                </div>
                {{-- part-8 --}}
                <div class="col-md-6">
                    <label for="attending_provider_name" class="form-label">Attending Provider Name:</label>
                    <input type="text" id="attending_provider_name" name="attending_provider_name" class="form-control" required maxlength="100" value="Dr. John Doe">
                </div>
                <div class="col-md-6">
                    <label for="attending_provider_npi" class="form-label">Attending Provider NPI:</label>
                    <input type="text" id="attending_provider_npi" name="attending_provider_npi" class="form-control" required pattern="\d{10}" value="1234567890">
                </div>
                <div class="col-md-6">
                    <label for="operating_provider_name" class="form-label">Operating Provider Name:</label>
                    <input type="text" id="operating_provider_name" name="operating_provider_name" class="form-control" required maxlength="100" value="Dr. Jane Smith">
                </div>
                <div class="col-md-6">
                    <label for="operating_provider_npi" class="form-label">Operating Provider NPI:</label>
                    <input type="text" id="operating_provider_npi" name="operating_provider_npi" class="form-control" required pattern="\d{10}" value="0987654321">
                </div>
                <div class="col-md-6">
                    <label for="referring_provider_name" class="form-label">Referring Provider Name:</label>
                    <input type="text" id="referring_provider_name" name="referring_provider_name" class="form-control" required maxlength="100" value="Dr. Emily Brown">
                </div>
                <div class="col-md-6">
                    <label for="referring_provider_npi" class="form-label">Referring Provider NPI:</label>
                    <input type="text" id="referring_provider_npi" name="referring_provider_npi" class="form-control" required pattern="\d{10}" value="1122334455">
                </div>
                <div class="col-md-6">
                    <label for="supervising_provider_name" class="form-label">Supervising Provider Name:</label>
                    <input type="text" id="supervising_provider_name" name="supervising_provider_name" class="form-control" required maxlength="100" value="Dr. Michael Green">
                </div>
                <div class="col-md-6">
                    <label for="supervising_provider_npi" class="form-label">Supervising Provider NPI:</label>
                    <input type="text" id="supervising_provider_npi" name="supervising_provider_npi" class="form-control" required pattern="\d{10}" value="5566778899">
                </div>
                <button type="button" class="prev">Previous</button>
                <button type="button" class="next">Next</button>
            </div>
            <!-- Step 5 (Final Step) -->
            <div class="row step">
                <div class="col-md-6">
                    <label for="se01" class="form-label">SE01 (Number of Included Segments):</label>
                    <input type="text" id="se01" name="se01" class="form-control" required pattern="^\d+$" value="120">
                </div>
                <div class="col-md-6">
                    <label for="se02" class="form-label">SE02 (Transaction Set Control Number):</label>
                    <input type="text" id="se02" name="se02" class="form-control" required maxlength="20" value="000123456">
                </div>
                <div class="col-md-6">
                    <label for="ge_control_number" class="form-label">GE Control Number:</label>
                    <input type="text" id="ge_control_number" name="ge_control_number" class="form-control" required maxlength="20" value="10001">
                </div>
                <div class="col-md-6">
                    <label for="iea_control_number" class="form-label">IEA Control Number:</label>
                    <input type="text" id="iea_control_number" name="iea_control_number" class="form-control" required maxlength="20" value="20002">
                </div>
                <button type="button" class="prev">Previous</button>
                <button type="submit" class="btn btn-primary">Generate 837I EDI</button>
            </div>
        </form>
        <script>
        let currentStep = 0;
        const steps = document.querySelectorAll(".step");
        const nextButtons = document.querySelectorAll(".next");
        const prevButtons = document.querySelectorAll(".prev");
        const form = document.getElementById("multiStepForm");
        // Show the current step
        function showStep(step) {
        steps.forEach((s, index) => {
        s.classList.toggle("active", index === step);
        });
        window.scrollTo({ top: 0, behavior: "smooth" }); // Auto scroll to top
        }
        // Handle the 'Next' button click
        // Function to validate the entire form for the current step
        function validateStep() {
        const currentFields = steps[currentStep].querySelectorAll("input, select, textarea");
        let stepIsValid = true;
        currentFields.forEach((field) => {
        if (!validateField(field)) {
        stepIsValid = false;
        }
        });
        return stepIsValid;
        }
        // Handle the 'Next' button click
        nextButtons.forEach(button => {
        button.addEventListener("click", () => {
        if (validateStep()) { // Only proceed if validation passes
        if (currentStep < steps.length - 1) {
        currentStep++;
        showStep(currentStep);
        }
        } else {
        alert("Please fix the errors in the current step.");
        }
        });
        });
        // Handle the 'Previous' button click
        prevButtons.forEach(button => {
        button.addEventListener("click", () => {
        if (currentStep > 0) {
        currentStep--;
        showStep(currentStep);
        }
        });
        });
        // Function to validate individual fields
        function validateField(field) {
        let isValid = true;
        // step-1
        if (field.name === 'sender_id') {
        if (!field.value || field.value.length < 2 || field.value.length > 15) {
        alert("Sender ID must be between 2 to 15 characters.");
        isValid = false;
        }
        }
        if (field.name === 'receiver_id') {
        if (!field.value || field.value.length < 2 || field.value.length > 15) {
        alert("Receiver ID must be between 2 to 15 characters.");
        isValid = false;
        }
        }
        if (field.name === 'transmission_time') {
        if (!/^\d{4}$/.test(field.value)) {
        alert("Transmission Time must be 4 digits (HHMM).");
        isValid = false;
        }
        }
        if (field.name === 'control_number') {
        if (!/^\d{1,15}$/.test(field.value)) {
        alert("Control Number must be 1-15 digits.");
        isValid = false;
        }
        }
        if (field.name === 'sender_code') {
        if (!field.value || field.value.length < 1 || field.value.length > 15) {
        alert("Sender Code must be between 1 to 15 characters.");
        isValid = false;
        }
        }
        if (field.name === 'receiver_code') {
        if (!field.value || field.value.length < 1 || field.value.length > 15) {
        alert("Receiver Code must be between 1 to 15 characters.");
        isValid = false;
        }
        }
        if (field.name === 'gs_date') {
        if (!/^\d{8}$/.test(field.value)) {
        alert("GS Date must be exactly 8 digits (CCYYMMDD).");
        isValid = false;
        }
        }
        if (field.name === 'gs_time') {
        if (!/^\d{4}$/.test(field.value)) {
        alert("GS Time must be exactly 4 digits (HHMM).");
        isValid = false;
        }
        }
        if (field.name === 'gs_control_number') {
        if (!/^\d{1,15}$/.test(field.value)) {
        alert("GS Control Number must be 1-15 digits.");
        isValid = false;
        }
        }
        //step-2
        if (field.name === 'submitter_name') {
        if (!field.value || field.value.length < 1 || field.value.length > 100) {
        alert("Submitter Name must be between 1 to 100 characters.");
        isValid = false;
        }
        }
        if (field.name === 'submitter_id') {
        if (!field.value || field.value.length < 1 || field.value.length > 15) {
        alert("Submitter ID must be between 1 to 15 characters.");
        isValid = false;
        }
        }
        if (field.name === 'receiver_name') {
        if (!field.value || field.value.length < 1 || field.value.length > 100) {
        alert("Receiver Name must be between 1 to 100 characters.");
        isValid = false;
        }
        }
        if (field.name === 'receiver_id') {
        if (!field.value || field.value.length < 1 || field.value.length > 15) {
        alert("Receiver ID must be between 1 to 15 characters.");
        isValid = false;
        }
        }
        //step-3
        if (field.name === 'billing_provider_name') {
        if (!field.value || field.value.length < 1 || field.value.length > 100) {
        alert("Billing Provider Name must be between 1 to 100 characters.");
        isValid = false;
        }
        }
        if (field.name === 'billing_provider_npi') {
        if (!/^\d{10}$/.test(field.value)) {
        alert("Billing Provider NPI must be exactly 10 digits.");
        isValid = false;
        }
        }
        if (field.name === 'billing_provider_tax_id') {
        if (!field.value || field.value.length < 1 || field.value.length > 15) {
        alert("Billing Provider Tax ID must be between 1 to 15 characters.");
        isValid = false;
        }
        }
        if (field.name === 'billing_provider_street') {
        if (!field.value || field.value.length < 1 || field.value.length > 150) {
        alert("Billing Provider Street must be between 1 to 150 characters.");
        isValid = false;
        }
        }
        if (field.name === 'billing_provider_city') {
        if (!field.value || field.value.length < 1 || field.value.length > 50) {
        alert("Billing Provider City must be between 1 to 50 characters.");
        isValid = false;
        }
        }
        if (field.name === 'billing_provider_state') {
        if (!/^[A-Z]{2}$/.test(field.value)) {
        alert("Billing Provider State must be exactly 2 uppercase letters.");
        isValid = false;
        }
        }
        if (field.name === 'billing_provider_zip') {
        if (!/^\d{9}$/.test(field.value)) {
        alert("Billing Provider ZIP must be exactly 9 digits.");
        isValid = false;
        }
        }
        if (field.name === 'facility_name') {
        if (!field.value || field.value.length < 1 || field.value.length > 100) {
        alert("Facility Name must be between 1 to 100 characters.");
        isValid = false;
        }
        }
        if (field.name === 'facility_npi') {
        if (!/^\d{10}$/.test(field.value)) {
        alert("Facility NPI must be exactly 10 digits.");
        isValid = false;
        }
        }
        if (field.name === 'facility_street') {
        if (!field.value || field.value.length < 1 || field.value.length > 150) {
        alert("Facility Street must be between 1 to 150 characters.");
        isValid = false;
        }
        }
        if (field.name === 'facility_city') {
        if (!field.value || field.value.length < 1 || field.value.length > 50) {
        alert("Facility City must be between 1 to 50 characters.");
        isValid = false;
        }
        }
        if (field.name === 'facility_state') {
        if (!/^[A-Z]{2}$/.test(field.value)) {
        alert("Facility State must be exactly 2 uppercase letters.");
        isValid = false;
        }
        }
        if (field.name === 'facility_zip') {
        if (!/^\d{9}$/.test(field.value)) {
        alert("Facility ZIP must be exactly 9 digits.");
        isValid = false;
        }
        }
        //step-4
        if (field.name === 'patient_last_name') {
        if (!field.value || field.value.length < 1 || field.value.length > 100) {
        alert("Patient Last Name must be between 1 to 100 characters.");
        isValid = false;
        }
        }
        if (field.name === 'patient_first_name') {
        if (!field.value || field.value.length < 1 || field.value.length > 100) {
        alert("Patient First Name must be between 1 to 100 characters.");
        isValid = false;
        }
        }
        if (field.name === 'patient_dob') {
        if (!/^\d{8}$/.test(field.value)) {
        alert("Patient DOB must be exactly 8 digits (YYYYMMDD).");
        isValid = false;
        }
        }
        if (field.name === 'patient_gender') {
        if (!/^(M|F|U)$/.test(field.value)) {
        alert("Patient Gender must be M, F, or U.");
        isValid = false;
        }
        }
        if (field.name === 'patient_member_id') {
        if (!field.value || field.value.length < 8 || field.value.length > 15) {
        alert("Patient Member ID must be between 8 to 15 characters.");
        isValid = false;
        }
        }
        if (field.name === 'patient_street') {
        if (!field.value || field.value.length < 1 || field.value.length > 150) {
        alert("Patient Street must be between 1 to 150 characters.");
        isValid = false;
        }
        }
        if (field.name === 'patient_city') {
        if (!field.value || field.value.length < 1 || field.value.length > 50) {
        alert("Patient City must be between 1 to 50 characters.");
        isValid = false;
        }
        }
        if (field.name === 'patient_state') {
        if (!/^[A-Z]{2}$/.test(field.value)) {
        alert("Patient State must be exactly 2 uppercase letters.");
        isValid = false;
        }
        }
        if (field.name === 'patient_zip') {
        if (!/^\d{9}$/.test(field.value)) {
        alert("Patient ZIP must be exactly 9 digits.");
        isValid = false;
        }
        }
        if (field.name === 'admission_date') {
        if (!/^\d{8}$/.test(field.value)) {
        alert("Admission Date must be exactly 8 digits (YYYYMMDD).");
        isValid = false;
        }
        }
        if (field.name === 'discharge_date') {
        if (!/^\d{8}$/.test(field.value)) {
        alert("Discharge Date must be exactly 8 digits (YYYYMMDD).");
        isValid = false;
        }
        }
        //part-5
        if (field.name === 'admission_type_code') {
        if (!field.value || field.value.length !== 1) {
        alert("Admission Type Code must be exactly 1 character.");
        isValid = false;
        }
        }
        if (field.name === 'admission_source_code') {
        if (!field.value || field.value.length < 1 || field.value.length > 2) {
        alert("Admission Source Code must be between 1 to 2 characters.");
        isValid = false;
        }
        }
        if (field.name === 'claim_number') {
        if (!field.value || field.value.length < 1 || field.value.length > 50) {
        alert("Claim Number must be between 1 to 50 characters.");
        isValid = false;
        }
        }
        if (field.name === 'total_claim_amount') {
        if (!/^\d+(\.\d{1,2})?$/.test(field.value)) {
        alert("Total Claim Amount must be a valid number with up to two decimal places.");
        isValid = false;
        }
        }
        if (field.name === 'facility_type_code') {
        if (!field.value || field.value.length < 1 || field.value.length > 2) {
        alert("Facility Type Code must be between 1 to 2 characters.");
        isValid = false;
        }
        }
        if (field.name === 'claim_frequency_code') {
        if (!field.value || field.value.length !== 1) {
        alert("Claim Frequency Code must be exactly 1 character.");
        isValid = false;
        }
        }
        if (field.name === 'primary_diagnosis') {
        if (!/^[A-Z]\d{2}(\.\d{1,4})?$/.test(field.value)) {
        alert("Primary Diagnosis Code must follow ICD-10 format (e.g., A12.34).");
        isValid = false;
        }
        }
        if (field.name === 'additional_diagnosis') {
        if (field.value && !/^.*$/.test(field.value)) {
        alert("Additional Diagnosis Codes must be comma-separated if multiple.");
        isValid = false;
        }
        }
        //part-6
        if (field.name === 'procedure_code') {
        if (!/^[A-Z0-9]{7}$/.test(field.value)) {
        alert("Procedure Code must be exactly 7 characters (ICD-10-PCS).");
        isValid = false;
        }
        }
        if (field.name === 'revenue_code') {
        if (!/^\d{4}$/.test(field.value)) {
        alert("Revenue Code must be exactly 4 digits.");
        isValid = false;
        }
        }
        if (field.name === 'charge_amount') {
        if (!/^\d+(\.\d{1,2})?$/.test(field.value)) {
        alert("Charge Amount must be a valid number with up to two decimal places.");
        isValid = false;
        }
        }
        if (field.name === 'units_of_service') {
        if (!/^\d+$/.test(field.value)) {
        alert("Units of Service must be a valid number.");
        isValid = false;
        }
        }
        if (field.name === 'service_date') {
        if (!/^\d{8}$/.test(field.value)) {
        alert("Service Date must be exactly 8 digits (YYYYMMDD).");
        isValid = false;
        }
        }
        if (field.name === 'condition_codes') {
        if (field.value && !/^.*$/.test(field.value)) {
        alert("Condition Codes must be comma-separated if multiple.");
        isValid = false;
        }
        }
        //part-7
        if (field.name === 'payer_name') {
        if (!field.value || field.value.length < 1 || field.value.length > 100) {
        alert("Payer Name must be between 1 to 100 characters.");
        isValid = false;
        }
        }
        if (field.name === 'payer_id') {
        if (!/^\d{5,10}$/.test(field.value)) {
        alert("Payer ID must be between 5 to 10 digits.");
        isValid = false;
        }
        }
        if (field.name === 'payer_street') {
        if (!field.value || field.value.length < 1 || field.value.length > 150) {
        alert("Payer Street must be between 1 to 150 characters.");
        isValid = false;
        }
        }
        if (field.name === 'payer_city') {
        if (!field.value || field.value.length < 1 || field.value.length > 50) {
        alert("Payer City must be between 1 to 50 characters.");
        isValid = false;
        }
        }
        if (field.name === 'payer_zip') {
        if (!/^\d{9}$/.test(field.value)) {
        alert("Payer ZIP must be exactly 9 digits.");
        isValid = false;
        }
        }
        //part-8
        if (field.name === 'attending_provider_name') {
        if (!field.value || field.value.length < 1 || field.value.length > 100) {
        alert("Attending Provider Name must be between 1 to 100 characters.");
        isValid = false;
        }
        }
        if (field.name === 'attending_provider_npi') {
        if (!/^\d{10}$/.test(field.value)) {
        alert("Attending Provider NPI must be exactly 10 digits.");
        isValid = false;
        }
        }
        if (field.name === 'operating_provider_name') {
        if (!field.value || field.value.length < 1 || field.value.length > 100) {
        alert("Operating Provider Name must be between 1 to 100 characters.");
        isValid = false;
        }
        }
        if (field.name === 'operating_provider_npi') {
        if (!/^\d{10}$/.test(field.value)) {
        alert("Operating Provider NPI must be exactly 10 digits.");
        isValid = false;
        }
        }
        if (field.name === 'referring_provider_name') {
        if (!field.value || field.value.length < 1 || field.value.length > 100) {
        alert("Referring Provider Name must be between 1 to 100 characters.");
        isValid = false;
        }
        }
        if (field.name === 'referring_provider_npi') {
        if (!/^\d{10}$/.test(field.value)) {
        alert("Referring Provider NPI must be exactly 10 digits.");
        isValid = false;
        }
        }
        if (field.name === 'supervising_provider_name') {
        if (!field.value || field.value.length < 1 || field.value.length > 100) {
        alert("Supervising Provider Name must be between 1 to 100 characters.");
        isValid = false;
        }
        }
        if (field.name === 'supervising_provider_npi') {
        if (!/^\d{10}$/.test(field.value)) {
        alert("Supervising Provider NPI must be exactly 10 digits.");
        isValid = false;
        }
        }
        //part-9
        if (field.name === 'se01') {
        if (!/^\d+$/.test(field.value)) {
        alert("SE01 must be a valid number.");
        isValid = false;
        }
        }
        if (field.name === 'se02') {
        if (!field.value || field.value.length < 1 || field.value.length > 20) {
        alert("SE02 must be between 1 to 20 characters.");
        isValid = false;
        }
        }
        if (field.name === 'ge_control_number') {
        if (!field.value || field.value.length < 1 || field.value.length > 20) {
        alert("GE Control Number must be between 1 to 20 characters.");
        isValid = false;
        }
        }
        if (field.name === 'iea_control_number') {
        if (!field.value || field.value.length < 1 || field.value.length > 20) {
        alert("IEA Control Number must be between 1 to 20 characters.");
        isValid = false;
        }
        }
        return isValid;
        }
        // Function to validate the entire form
        function validateForm() {
        const formFields = document.querySelectorAll("input, select, textarea");
        let formIsValid = true;
        formFields.forEach((field) => {
        if (!validateField(field)) {
        formIsValid = false;
        }
        });
        return formIsValid;
        }
        // Add event listener to the form submit
        form.addEventListener("submit", (event) => {
        event.preventDefault();
        if (validateForm()) {
        // Proceed with form submission if valid
        alert("Form submitted successfully!");
        form.submit(); // Or your submit action
        } else {
        alert("Please fix the errors in the form.");
        }
        });
        </script>
        <script>
window.onload = displayClock();
function displayClock() {
const currentDate = new Date(new Date().toLocaleString("en-US", {
timeZone: "America/New_York"
}));
var timestamp = currentDate.toString().split('GMT');
var splitstring = timestamp[0].split(" ");
var final_string = splitstring[0] + ', ' + splitstring[1] + ' ' + splitstring[2] + ' ' + splitstring[3] +
', ' + splitstring[4];
$("#clock").text(final_string);
setTimeout(displayClock, 1000);
}
</script>
@endsection