@extends('layouts.app')
@section('title')
 <title>837 edi-i Create Multi-Step Form</title>
@endsection

@section('content')
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
   <style>
    .btn.text-white {
        padding: 4px 14px;
        font-size: 13px;
        font-weight: 600;
        border-radius: 6px;
        line-height: 1.5;
        display: inline-block;
        text-align: center;
        white-space: nowrap;
        vertical-align: middle;
        transition: background-color 0.2s ease-in-out;
        background-color: rgb(79 70 229);
    }

    .form-group{
    margin-bottom: 20px;
    }
    .g-header{
    height: 170px;
    }
    .step { display: none; }
    .active { display: block; }
    .next, .prev {
    padding: 6px 16px;       /* good horizontal and vertical padding */
    font-size: 14px;
    border-radius: 6px;
    border: none;
    cursor: pointer;
    width: auto;
    height: auto;
    display: inline-block;
    text-align: center;
    line-height: normal;
    background-color: #0d6efd;  /* for .next */
    color: white;
    margin-right: 10px;
    margin-bottom: 10px;
    margin-top: 10px;
    }
    .prev {
    background-color: orange;
    }
    #multiStepForm {
    width: 50%;
    background: white;
    padding: 20px;
    margin: 50px auto;
    border-radius: 10px;
    box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
    }
    /*  .step {
    display: none;
    }
    .active {
    display: block;
    }*/
    .step {
    display: none;
    }
    .step.active {
    display: flex; /* or block, but flex works better for columns */
    flex-wrap: wrap;
    }
    h2 {
    color: #333;
    }
    input {
    width: 30%;
    padding: 10px;
    margin: 10px 0;
    border: 1px solid #ccc;
    border-radius: 5px;
    font-size: 16px;
    }
    button {
    background-color: #007bff;
    color: white;
    border: none;
    padding: 10px 15px;
    font-size: 16px;
    cursor: pointer;
    border-radius: 5px;
    transition: 0.3s;
    }
    button:hover {
    background-color: #0056b3;
    }
    .prev {
    background-color: #6c757d;
    }
    .prev:hover {
    background-color: #5a6268;
    }
    .submit {
    background-color: #28a745;
    }
    .submit:hover {
    background-color: #218838;
    }
    .form-control{
    width: 30%;
    }

</style>

    @if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif
    <h2 style="text-align: center;">Generate 837 EDI-D FILE</h2>
<form class="container" id="multiStepForm"  action="{{ route('submit-837d') }}" method="POST" class="row g-3">
	@csrf
<div class="row step active">
    {{-- step-1 --}}

    <h5>Step 1 Transaction & File Control</h5>
    <div class="col-md-6">
        <label for="sender_id" class="form-label">Sender ID</label>
        <input type="text" id="sender_id" name="sender_id" class="form-control" required value="SENDER1234" placeholder="Max 10 alphanumeric characters (e.g., SENDER1234)">
    </div>
    <div class="col-md-6">
        <label for="receiver_id" class="form-label">Receiver ID</label>
        <input type="text" id="receiver_id" name="receiver_id" class="form-control" required value="RECEIVER5678" placeholder="Max 10 alphanumeric characters (e.g., RECEIVER5678)">
    </div>
    <div class="col-md-6">
        <label for="transmission_date" class="form-label">Transmission Date (YYYYMMDD)</label>
        <input type="text" id="transmission_date" name="transmission_date" class="form-control" required value="20250324" placeholder="Format: YYYYMMDD (e.g., 20250324)">
    </div>
    <div class="col-md-6">
        <label for="transmission_time" class="form-label">Transmission Time (HHMM)</label>
        <input type="text" id="transmission_time" name="transmission_time" class="form-control" required value="1530" placeholder="Format: HHMM (e.g., 1530)">
    </div>
    <div class="col-md-6">
        <label for="control_number" class="form-label">Control Number</label>
        <input type="text" id="control_number" name="control_number" class="form-control" required value="000123456" placeholder="Max 9 numeric characters (e.g., 000123456)">
    </div>
    <div class="col-md-6">
        <label for="sender_code" class="form-label">Sender Code</label>
        <input type="text" id="sender_code" name="sender_code" class="form-control" required value="SENDER01" placeholder="Max 6 alphanumeric characters (e.g., SENDER01)">
    </div>
    <div class="col-md-6">
        <label for="receiver_code" class="form-label">Receiver Code</label>
        <input type="text" id="receiver_code" name="receiver_code" class="form-control" required value="RECEIVER01" placeholder="Max 6 alphanumeric characters (e.g., RECEIVER01)">
    </div>
    <div class="col-md-6">
        <label for="gs_date" class="form-label">GS Date (YYYYMMDD)</label>
        <input type="text" id="gs_date" name="gs_date" class="form-control" required value="20250324" placeholder="Format: YYYYMMDD (e.g., 20250324)">
    </div>
    <div class="col-md-6">
        <label for="gs_time" class="form-label">GS Time (HHMM)</label>
        <input type="text" id="gs_time" name="gs_time" class="form-control" required value="1530" placeholder="Format: HHMM (e.g., 1530)">
    </div>
    <div class="col-md-6">
        <label for="gs_control_number" class="form-label">GS Control Number</label>
        <input type="text" id="gs_control_number" name="gs_control_number" class="form-control" required value="123096815" placeholder="Max 9 alphanumeric characters (e.g., 123096815)">
    </div>
    {{-- step 2 --}}
    <div class="col-md-6">
        <label for="submitter_name" class="form-label">Submitter Name</label>
        <input type="text" id="submitter_name" name="submitter_name" class="form-control" required value="ABC Healthcare" placeholder="Name of the submitter (e.g., ABC Healthcare)">
    </div>
    <div class="col-md-6">
        <label for="submitter_id" class="form-label">Submitter ID</label>
        <input type="text" id="submitter_id" name="submitter_id" class="form-control" required value="SUBMITTER123" placeholder="Max 10 alphanumeric characters (e.g., SUBMITTER123)">
    </div>
    <div class="col-md-6">
        <label for="receiver_name" class="form-label">Receiver Name</label>
        <input type="text" id="receiver_name" name="receiver_name" class="form-control" required value="XYZ Medical" placeholder="Name of the receiver (e.g., XYZ Medical)">
    </div>
    <div class="col-md-6">
        <label for="receiver_id" class="form-label">Receiver ID</label>
        <input type="text" id="receiver_id" name="receiver_id" class="form-control" required value="RECEIVER987" placeholder="Max 10 alphanumeric characters (e.g., RECEIVER987)">
    </div>
    <button type="button" class="next">Next</button>
</div>

	







<div class="row step">
    {{-- part-3 --}}
    <!-- Billing Provider Details -->
    <h2>Step 2</h2>
    <h5>Billing Provider Information</h5>
    <div class="col-md-6">
        <label for="billing_provider_name" class="form-label">Billing Provider Name</label>
        <input type="text" id="billing_provider_name" name="billing_provider_name" class="form-control" value="Provider Name" required>
    </div>
    <div class="col-md-6">
        <label for="billing_provider_npi" class="form-label">Billing Provider NPI</label>
        <input type="text" id="billing_provider_npi" name="billing_provider_npi" class="form-control" value="1234567890" required>
    </div>
    <div class="col-md-6">
        <label for="billing_provider_tax_id" class="form-label">Billing Provider Tax ID</label>
        <input type="text" id="billing_provider_tax_id" name="billing_provider_tax_id" class="form-control" value="123-45-6789" required>
    </div>
    <div class="col-md-6">
        <label for="billing_provider_street" class="form-label">Billing Provider Street</label>
        <input type="text" id="billing_provider_street" name="billing_provider_street" class="form-control" value="123 Main St" required>
    </div>
    <div class="col-md-6">
        <label for="billing_provider_city" class="form-label">Billing Provider City</label>
        <input type="text" id="billing_provider_city" name="billing_provider_city" class="form-control" value="Springfield" required>
    </div>
    <div class="col-md-3">
        <label for="billing_provider_state" class="form-label">Billing Provider State</label>
        <input type="text" id="billing_provider_state" name="billing_provider_state" class="form-control" value="IL" required>
    </div>
    <div class="col-md-3">
        <label for="billing_provider_zip" class="form-label">Billing Provider ZIP</label>
        <input type="text" id="billing_provider_zip" name="billing_provider_zip" class="form-control" pattern="\d{9}" value="900012345" required>
    </div>
    
    <!-- Facility Details -->
    <h5>Facility Information</h5>
    <div class="col-md-6">
        <label for="facility_name" class="form-label">Facility Name</label>
        <input type="text" id="facility_name" name="facility_name" class="form-control" value="Health Facility" required>
    </div>
    <div class="col-md-6">
        <label for="facility_npi" class="form-label">Facility NPI</label>
        <input type="text" id="facility_npi" name="facility_npi" class="form-control" value="9876543210" required>
    </div>
    <div class="col-md-6">
        <label for="facility_street" class="form-label">Facility Street</label>
        <input type="text" id="facility_street" name="facility_street" class="form-control" value="456 Elm St" required>
    </div>
    <div class="col-md-6">
        <label for="facility_city" class="form-label">Facility City</label>
        <input type="text" id="facility_city" name="facility_city" class="form-control" value="Chicago" required>
    </div>
    <div class="col-md-3">
        <label for="facility_state" class="form-label">Facility State</label>
        <input type="text" id="facility_state" name="facility_state" class="form-control" value="IL" required>
    </div>
    <div class="col-md-3">
        <label for="facility_zip" class="form-label">Facility ZIP</label>
        <input type="text" id="facility_zip" name="facility_zip" class="form-control"pattern="\d{9}" value="100012345" required>
    </div>

    {{-- part-4 --}}
    <h5>Patient Information</h5>
    <div class="col-md-6">
        <label for="patient_last_name" class="form-label">Patient Last Name</label>
        <input type="text" id="patient_last_name" name="patient_last_name" class="form-control" value="Doe" required>
    </div>
    <div class="col-md-6">
        <label for="patient_first_name" class="form-label">Patient First Name</label>
        <input type="text" id="patient_first_name" name="patient_first_name" class="form-control" value="John" required>
    </div>
    <div class="col-md-6">
        <label for="patient_dob" class="form-label">Patient DOB (YYYYMMDD)</label>
        <input type="text" id="patient_dob" name="patient_dob" class="form-control" value="19900101" required>
    </div>
    <div class="col-md-6">
        <label for="patient_gender" class="form-label">Patient Gender</label>
        <select id="patient_gender" name="patient_gender" class="form-control" required>
            <option value="M" selected>Male</option>
            <option value="F">Female</option>
            <option value="U">Unknown</option>
        </select>
    </div>
    <div class="col-md-6">
        <label for="patient_member_id" class="form-label">Patient Member ID</label>
        <input type="text" id="patient_member_id" name="patient_member_id" class="form-control"  minlength="8" maxlength="15" value="MEMB123456" required>
    </div>
    <div class="col-md-6">
        <label for="patient_street" class="form-label">Patient Street</label>
        <input type="text" id="patient_street" name="patient_street" class="form-control" value="789 Pine St" required>
    </div>
    <div class="col-md-4">
        <label for="patient_city" class="form-label">Patient City</label>
        <input type="text" id="patient_city" name="patient_city" class="form-control" value="New York" required>
    </div>
    <div class="col-md-4">
        <label for="patient_state" class="form-label">Patient State</label>
        <input type="text" id="patient_state" name="patient_state" class="form-control" value="NY" required>
    </div>
    <div class="col-md-4">
        <label for="patient_zip" class="form-label">Patient ZIP</label>
        <input type="text" id="patient_zip" name="patient_zip" class="form-control" pattern="\d{9}" value="606012345" required>
    </div>
      <div class="col-md-6">
                    <label for="admission_date" class="form-label">Admission Date (YYYYMMDD):</label>
                    <input type="text" id="admission_date" name="admission_date" class="form-control" required pattern="\d{8}" value="20250315">
                </div>
                <div class="col-md-6">
                    <label for="discharge_date" class="form-label">Discharge Date (YYYYMMDD):</label>
                    <input type="text" id="discharge_date" name="discharge_date" class="form-control" required pattern="\d{8}" value="20250320">
                </div>
    <button type="button" class="prev">Previous</button>
    <button type="button" class="next">Next</button>
</div>






	



	
<div class="row step">
    {{-- part-5 --}}
    <h2>Step 3</h2>
    <h5>Claim Information</h5>
    <div class="col-md-6">
        <label for="claim_number" class="form-label">Claim Number</label>
        <input type="text" id="claim_number" name="claim_number" class="form-control" value="CLM123456" required>
    </div>
    <div class="col-md-6">
        <label for="total_claim_amount" class="form-label">Total Claim Amount</label>
        <input type="text" id="total_claim_amount" name="total_claim_amount" class="form-control" value="1000.00" required>
    </div>
    <div class="col-md-6">
        <label for="facility_type_code" class="form-label">Facility Type Code</label>
        <input type="text" id="facility_type_code" name="facility_type_code" class="form-control" value="F1" required>
    </div>
    <div class="col-md-6">
        <label for="claim_frequency_code" class="form-label">Claim Frequency Code</label>
        <input type="text" id="claim_frequency_code" name="claim_frequency_code" class="form-control" maxlength="1" value="1" required>
    </div>
    <div class="col-md-6">
    <label for="primary_diagnosis_code" class="form-label">Primary Diagnosis Code</label>
    <input type="text" id="primary_diagnosis_code" name="primary_diagnosis_code" class="form-control" value="A12.34" placeholder="A12.34" pattern="[A-Za-z]\d{2}\.\d{2}" title="Enter a valid ICD-10 diagnosis code (e.g., A12.34)" required>
</div>

    <div class="col-md-6">
        <label for="additional_diagnosis_codes" class="form-label">Additional Diagnosis Codes (comma-separated)</label>
        <input type="text" id="additional_diagnosis_codes" name="additional_diagnosis_codes" class="form-control" value="D002, D003">
    </div>
    <div class="col-md-6">
        <label for="place_of_service" class="form-label">Place of Service</label>
        <input type="text" id="place_of_service" name="place_of_service" class="form-control" value="Dental Clinic" required>
    </div>
    {{-- step-6 --}}
    <h5>Dental-Specific Information</h5>
    <div class="col-md-4">
        <label for="tooth_number" class="form-label">Tooth Number</label>
        <input type="number" id="tooth_number" name="tooth_number" class="form-control" value="12" required>
    </div>
   <div class="col-md-4">
    <label for="tooth_surface" class="form-label">Tooth Surface</label>
    <select id="tooth_surface" name="tooth_surface" class="form-control" required>
        <option value="" disabled selected>Select Tooth Surface</option>
        <option value="M">M - Mesial</option>
        <option value="D">D - Distal</option>
        <option value="O">O - Occlusal</option>
        <option value="I">I - Incisal</option>
        <option value="L">L - Lingual</option>
    </select>
</div>

   <div class="col-md-4">
    <label for="oral_cavity_location" class="form-label">Oral Cavity Location</label>
    <select id="oral_cavity_location" name="oral_cavity_location" class="form-control" required>
        <option value="" disabled selected>Select Oral Cavity Location</option>
        <option value="1">1 - Upper Right</option>
        <option value="2">2 - Upper Left</option>
        <option value="3">3 - Lower Left</option>
        <option value="4">4 - Lower Right</option>
        <option value="U">U - Upper Arch</option>
        <option value="L">L - Lower Arch</option>
    </select>
</div>
    <div class="col-md-6">
        <label for="missing_teeth_info" class="form-label">Missing Teeth Info</label>
        <input type="text" id="missing_teeth_info" name="missing_teeth_info" class="form-control" value="Teeth 15, 16">
    </div>
    <div class="col-md-6">
        <label for="replacement_status" class="form-label">Replacement Status</label>
        <select id="replacement_status" name="replacement_status" class="form-control" required>
            <option value="Yes">Yes</option>
            <option value="No" selected>No</option>
        </select>
    </div>
    <div class="col-md-6">
        <label for="procedure_date" class="form-label">Procedure Date (YYYYMMDD)</label>
        <input type="text" id="procedure_date" name="procedure_date" class="form-control" value="20240101" required>
    </div>
    <div class="col-md-6">
        <label for="prosthesis_code" class="form-label">Prosthesis Code</label>
        <input type="text" id="prosthesis_code" name="prosthesis_code" class="form-control" value="P001">
    </div>
    <div class="col-md-6">
        <label for="orthodontic_treatment" class="form-label">Orthodontic Treatment</label>
        <select id="orthodontic_treatment" name="orthodontic_treatment" class="form-control" required>
            <option value="Yes">Yes</option>
            <option value="No" selected>No</option>
        </select>
    </div>
    <div class="col-md-6">
        <label for="orthodontic_start_date" class="form-label">Orthodontic Start Date (YYYYMMDD)</label>
        <input type="text" id="orthodontic_start_date" name="orthodontic_start_date" class="form-control" value="20240201">
    </div>
    <div class="col-md-6">
        <label for="orthodontic_end_date" class="form-label">Orthodontic End Date (YYYYMMDD)</label>
        <input type="text" id="orthodontic_end_date" name="orthodontic_end_date" class="form-control" value="20241231">
    </div>
    <div class="col-md-6">
        <label for="anesthesia_usage" class="form-label">Anesthesia Usage</label>
        <select id="anesthesia_usage" name="anesthesia_usage" class="form-control" required>
            <option value="Yes">Yes</option>
            <option value="No" selected>No</option>
        </select>
    </div>
    <div class="col-md-6">
        <label for="anesthesia_type" class="form-label">Anesthesia Type</label>
        <input type="text" id="anesthesia_type" name="anesthesia_type" class="form-control" value="Local">
    </div>
    <div class="col-md-6">
        <label for="emergency_treatment" class="form-label">Emergency Treatment</label>
        <select id="emergency_treatment" name="emergency_treatment" class="form-control" required>
            <option value="Yes">Yes</option>
            <option value="No" selected>No</option>
        </select>
    </div>
    <button type="button" class="prev">Previous</button>
    <button type="button" class="next">Next</button>
</div>






	
	<div class="row step">
    {{-- step 7 --}}
     <h2>Step 4</h2>
    <h5>Service Line Details</h5>
    <div class="col-md-6">
        <label for="procedure_code" class="form-label">Procedure Code (CDT)</label>
        <input type="text" id="procedure_code" name="procedure_code" class="form-control" value="D0120" required>
    </div>
    <div class="col-md-6">
        <label for="revenue_code" class="form-label">Revenue Code</label>
        <input type="text" id="revenue_code" name="revenue_code" class="form-control" value="0012" min="4" max="4" required>
    </div>
    <div class="col-md-6">
        <label for="charge_amount" class="form-label">Charge Amount</label>
        <input type="text" id="charge_amount" name="charge_amount" class="form-control" value="150.00" required>
    </div>
    <div class="col-md-6">
        <label for="units_of_service" class="form-label">Units of Service</label>
        <input type="number" id="units_of_service" name="units_of_service" class="form-control" value="1" required>
    </div>
    <div class="col-md-6">
        <label for="service_date" class="form-label">Service Date (YYYYMMDD)</label>
        <input type="text" id="service_date" name="service_date" class="form-control" value="20240324" required>
    </div>
    <div class="col-md-6">
        <label for="condition_codes" class="form-label">Condition Codes (If applicable)</label>
        <input type="text" id="condition_codes" name="condition_codes" class="form-control" value="AB12">
    </div>
    {{-- step-8 --}}
    <h5>Payer Information</h5>
    <div class="col-md-6">
        <label for="payer_name" class="form-label">Payer Name</label>
        <input type="text" id="payer_name" name="payer_name" class="form-control" value="XYZ Insurance" required>
    </div>
    <div class="col-md-6">
                    <label for="payer_id" class="form-label">Payer ID:</label>
                    <input type="text" id="payer_id" name="payer_id" class="form-control" required pattern="^\d{5,10}$" value="123456999">
                </div>
    <div class="col-md-6">
        <label for="payer_street" class="form-label">Payer Street</label>
        <input type="text" id="payer_street" name="payer_street" class="form-control" value="123 Main St" required>
    </div>
    <div class="col-md-6">
        <label for="payer_city" class="form-label">Payer City</label>
        <input type="text" id="payer_city" name="payer_city" class="form-control" value="Sample City" required>
    </div>

    <div class="col-md-6">
        <label for="payer_state" class="form-label">Payer State:</label>
        <input type="text" id="payer_state" name="payer_state" class="form-control" required pattern="[A-Z]{2}" value="NY">
    </div>
    <div class="col-md-6">
        <label for="payer_zip" class="form-label">Payer ZIP</label>
        <input type="text" id="payer_zip" name="payer_zip" class="form-control" value="12345" required>
    </div>
    <button type="button" class="prev">Previous</button>
    <button type="button" class="next">Next</button>
</div>





	
	<div class="row step">
    {{-- step-9 --}}
     <h2>Step 5</h2>
    <h5>Provider Information</h5>
    <div class="col-md-6">
        <label for="attending_provider_name" class="form-label">Attending Provider Name</label>
        <input type="text" id="attending_provider_name" name="attending_provider_name" class="form-control" value="Dr. John Doe" required>
    </div>
    <div class="col-md-6">
        <label for="attending_provider_npi" class="form-label">Attending Provider NPI</label>
        <input type="text" id="attending_provider_npi" name="attending_provider_npi" class="form-control" value="1234567890" required>
    </div>
    <div class="col-md-6">
                    <label for="operating_provider_name" class="form-label">Operating Provider Name:</label>
                    <input type="text" id="operating_provider_name" name="operating_provider_name" class="form-control" required maxlength="100" value="Dr. Jane Smith">
                </div>
                <div class="col-md-6">
                    <label for="operating_provider_npi" class="form-label">Operating Provider NPI:</label>
                    <input type="text" id="operating_provider_npi" name="operating_provider_npi" class="form-control" required pattern="\d{10}" value="0987654321">
                </div>
                <div class="col-md-6">
                    <label for="referring_provider_name" class="form-label">Referring Provider Name:</label>
                    <input type="text" id="referring_provider_name" name="referring_provider_name" class="form-control" required maxlength="100" value="Dr. Emily Brown">
                </div>
                <div class="col-md-6">
                    <label for="referring_provider_npi" class="form-label">Referring Provider NPI:</label>
                    <input type="text" id="referring_provider_npi" name="referring_provider_npi" class="form-control" required pattern="\d{10}" value="1122334455">
                </div>
                <div class="col-md-6">
                    <label for="supervising_provider_name" class="form-label">Supervising Provider Name:</label>
                    <input type="text" id="supervising_provider_name" name="supervising_provider_name" class="form-control" required maxlength="100" value="Dr. Michael Green">
                </div>
                <div class="col-md-6">
                    <label for="supervising_provider_npi" class="form-label">Supervising Provider NPI:</label>
                    <input type="text" id="supervising_provider_npi" name="supervising_provider_npi" class="form-control" required pattern="\d{10}" value="5566778899">
                </div>


    {{-- step-10 --}}
    <h5>EDI Control Segments</h5>
    <div class="col-md-6">
        <label for="se01" class="form-label">SE01 (Number of Included Segments)</label>
        <input type="text" id="se01" name="se01" class="form-control" value="10" required>
    </div>
    <div class="col-md-6">
        <label for="se02" class="form-label">SE02 (Transaction Set Control Number)</label>
        <input type="text" id="se02" name="se02" class="form-control" value="123456" required>
    </div>
    <div class="col-md-6">
        <label for="ge_control_number" class="form-label">GE Control Number</label>
        <input type="text" id="ge_control_number" name="ge_control_number" class="form-control" value="654321" required>
    </div>
    <div class="col-md-6">
        <label for="iea_control_number" class="form-label">IEA Control Number</label>
        <input type="text" id="iea_control_number" name="iea_control_number" class="form-control" value="987654" required>
    </div>
    <button type="button" class="prev">Previous</button>
    <button type="submit" class="btn btn-primary">Generate 837D EDI</button>
</div>

</form>
    </body>





    <script>
        let currentStep = 0;
        const steps = document.querySelectorAll(".step");
        const nextButtons = document.querySelectorAll(".next");
        const prevButtons = document.querySelectorAll(".prev");
        const form = document.getElementById("multiStepForm");
        // Show the current step
        function showStep(step) {
        steps.forEach((s, index) => {
        s.classList.toggle("active", index === step);
        });
        window.scrollTo({ top: 0, behavior: "smooth" }); // Auto scroll to top
        }
        // Handle the 'Next' button click
        // Function to validate the entire form for the current step
        function validateStep() {
        const currentFields = steps[currentStep].querySelectorAll("input, select, textarea");
        let stepIsValid = true;
        currentFields.forEach((field) => {
        if (!validateField(field)) {
        stepIsValid = false;
        }
        });
        return stepIsValid;
        }
        // Handle the 'Next' button click
        nextButtons.forEach(button => {
        button.addEventListener("click", () => {
        if (validateStep()) { // Only proceed if validation passes
        if (currentStep < steps.length - 1) {
        currentStep++;
        showStep(currentStep);
        }
        } else {
        alert("Please fix the errors in the current step.");
        }
        });
        });
        // Handle the 'Previous' button click
        prevButtons.forEach(button => {
        button.addEventListener("click", () => {
        if (currentStep > 0) {
        currentStep--;
        showStep(currentStep);
        }
        });
        });
        // Function to validate individual fields
        function validateField(field) {
        let isValid = true;
        // step-1
        if (field.name === 'sender_id') {
            if (!field.value || field.value.length < 2 || field.value.length > 15) {
                alert("Sender ID must be between 2 to 15 characters.");
                isValid = false;
            }
        }

        if (field.name === 'receiver_id') {
            if (!field.value || field.value.length < 2 || field.value.length > 15) {
                alert("Receiver ID must be between 2 to 15 characters.");
                isValid = false;
            }
        }

        if (field.name === 'transmission_date') {
            if (!/^\d{8}$/.test(field.value)) {
                alert("Transmission Date must be exactly 8 digits (YYYYMMDD).");
                isValid = false;
            }
        }

        if (field.name === 'transmission_time') {
            if (!/^\d{4}$/.test(field.value)) {
                alert("Transmission Time must be exactly 4 digits (HHMM).");
                isValid = false;
            }
        }

        if (field.name === 'control_number') {
            if (!/^\d{1,15}$/.test(field.value)) {
                alert("Control Number must be between 1 to 15 digits.");
                isValid = false;
            }
        }

        if (field.name === 'sender_code') {
            if (!field.value || field.value.length < 1 || field.value.length > 15) {
                alert("Sender Code must be between 1 to 15 characters.");
                isValid = false;
            }
        }

        if (field.name === 'receiver_code') {
            if (!field.value || field.value.length < 1 || field.value.length > 15) {
                alert("Receiver Code must be between 1 to 15 characters.");
                isValid = false;
            }
        }

        if (field.name === 'gs_date') {
            if (!/^\d{8}$/.test(field.value)) {
                alert("GS Date must be exactly 8 digits (YYYYMMDD).");
                isValid = false;
            }
        }

        if (field.name === 'gs_time') {
            if (!/^\d{4}$/.test(field.value)) {
                alert("GS Time must be exactly 4 digits (HHMM).");
                isValid = false;
            }
        }

        if (field.name === 'gs_control_number') {
            if (!/^\d{1,15}$/.test(field.value)) {
                alert("GS Control Number must be between 1 to 15 digits.");
                isValid = false;
            }
        }




        // step-2
         if (field.name === 'submitter_name') {
            if (!field.value || field.value.length < 1 || field.value.length > 100) {
                alert("Submitter Name must be between 1 to 100 characters.");
                isValid = false;
            }
        }

        if (field.name === 'submitter_id') {
            if (!field.value || field.value.length < 1 || field.value.length > 15) {
                alert("Submitter ID must be between 1 to 15 characters.");
                isValid = false;
            }
        }

        if (field.name === 'receiver_name') {
            if (!field.value || field.value.length < 1 || field.value.length > 100) {
                alert("Receiver Name must be between 1 to 100 characters.");
                isValid = false;
            }
        }

        if (field.name === 'receiver_id') {
            if (!field.value || field.value.length < 1 || field.value.length > 15) {
                alert("Receiver ID must be between 1 to 15 characters.");
                isValid = false;
            }
        }





        // step-3
         if (field.name === 'billing_provider_name') {
            if (!field.value || field.value.length < 1 || field.value.length > 100) {
                alert("Billing Provider Name must be between 1 to 100 characters.");
                isValid = false;
            }
        }

        if (field.name === 'billing_provider_npi') {
            if (!/^\d{10}$/.test(field.value)) {
                alert("Billing Provider NPI must be exactly 10 digits.");
                isValid = false;
            }
        }

        if (field.name === 'billing_provider_tax_id') {
            if (!field.value || field.value.length < 1 || field.value.length > 15) {
                alert("Billing Provider Tax ID must be between 1 to 15 characters.");
                isValid = false;
            }
        }

        if (field.name === 'billing_provider_street') {
            if (!field.value || field.value.length < 1 || field.value.length > 150) {
                alert("Billing Provider Street must be between 1 to 150 characters.");
                isValid = false;
            }
        }

        if (field.name === 'billing_provider_city') {
            if (!field.value || field.value.length < 1 || field.value.length > 50) {
                alert("Billing Provider City must be between 1 to 50 characters.");
                isValid = false;
            }
        }

        if (field.name === 'billing_provider_state') {
            if (!/^[A-Z]{2}$/.test(field.value)) {
                alert("Billing Provider State must be exactly 2 uppercase letters.");
                isValid = false;
            }
        }

        if (field.name === 'billing_provider_zip') {
            if (!/^\d{9}$/.test(field.value)) {
                alert("Billing Provider ZIP must be exactly 9 digits.");
                isValid = false;
            }
        }

        if (field.name === 'facility_name') {
            if (!field.value || field.value.length < 1 || field.value.length > 100) {
                alert("Facility Name must be between 1 to 100 characters.");
                isValid = false;
            }
        }

        if (field.name === 'facility_npi') {
            if (!/^\d{10}$/.test(field.value)) {
                alert("Facility NPI must be exactly 10 digits.");
                isValid = false;
            }
        }

        if (field.name === 'facility_street') {
            if (!field.value || field.value.length < 1 || field.value.length > 150) {
                alert("Facility Street must be between 1 to 150 characters.");
                isValid = false;
            }
        }

        if (field.name === 'facility_city') {
            if (!field.value || field.value.length < 1 || field.value.length > 50) {
                alert("Facility City must be between 1 to 50 characters.");
                isValid = false;
            }
        }

        if (field.name === 'facility_state') {
            if (!/^[A-Z]{2}$/.test(field.value)) {
                alert("Facility State must be exactly 2 uppercase letters.");
                isValid = false;
            }
        }

        if (field.name === 'facility_zip') {
            if (!/^\d{9}$/.test(field.value)) {
                alert("Facility ZIP must be exactly 9 digits.");
                isValid = false;
            }
        }






        // step-4
        if (field.name === 'patient_last_name') {
            if (!field.value || field.value.length < 1 || field.value.length > 100) {
                alert("Patient Last Name must be between 1 to 100 characters.");
                isValid = false;
            }
        }

        if (field.name === 'patient_first_name') {
            if (!field.value || field.value.length < 1 || field.value.length > 100) {
                alert("Patient First Name must be between 1 to 100 characters.");
                isValid = false;
            }
        }

        if (field.name === 'patient_dob') {
            if (!/^\d{8}$/.test(field.value)) {
                alert("Patient DOB must be exactly 8 digits (YYYYMMDD).");
                isValid = false;
            }
        }

        if (field.name === 'patient_gender') {
            if (!["M", "F", "U"].includes(field.value)) {
                alert("Patient Gender must be M, F, or U.");
                isValid = false;
            }
        }

        if (field.name === 'patient_member_id') {
            if (!field.value || field.value.length < 8 || field.value.length > 15) {
                alert("Patient Member ID must be between 8 to 15 characters.");
                isValid = false;
            }
        }

        if (field.name === 'patient_street') {
            if (!field.value || field.value.length < 1 || field.value.length > 150) {
                alert("Patient Street must be between 1 to 150 characters.");
                isValid = false;
            }
        }

        if (field.name === 'patient_city') {
            if (!field.value || field.value.length < 1 || field.value.length > 50) {
                alert("Patient City must be between 1 to 50 characters.");
                isValid = false;
            }
        }

        if (field.name === 'patient_state') {
            if (!/^[A-Z]{2}$/.test(field.value)) {
                alert("Patient State must be exactly 2 uppercase letters.");
                isValid = false;
            }
        }

        if (field.name === 'patient_zip') {
            if (!/^\d{9}$/.test(field.value)) {
                alert("Patient ZIP must be exactly 9 digits.");
                isValid = false;
            }
        }
        if (field.name === 'admission_date') {
        if (!/^\d{8}$/.test(field.value)) {
        alert("Admission Date must be exactly 8 digits (YYYYMMDD).");
        isValid = false;
        }
        }
        if (field.name === 'discharge_date') {
        if (!/^\d{8}$/.test(field.value)) {
        alert("Discharge Date must be exactly 8 digits (YYYYMMDD).");
        isValid = false;
        }
        }





        // step-5
         if (field.name === 'claim_number') {
            if (!field.value || field.value.length < 1 || field.value.length > 50) {
                alert("Claim Number must be between 1 to 50 characters.");
                isValid = false;
            }
        }

        if (field.name === 'total_claim_amount') {
            if (!/^\d+(\.\d{1,2})?$/.test(field.value)) {
                alert("Total Claim Amount must be a valid number with up to two decimal places.");
                isValid = false;
            }
        }

        if (field.name === 'facility_type_code') {
            if (!field.value || field.value.length < 1 || field.value.length > 2) {
                alert("Facility Type Code must be between 1 to 2 characters.");
                isValid = false;
            }
        }

        if (field.name === 'claim_frequency_code') {
            if (!field.value || field.value.length !== 1) {
                alert("Claim Frequency Code must be exactly 1 character.");
                isValid = false;
            }
        }

        if (field.name === 'primary_diagnosis_code') {
            if (!/^[A-Z]\d{2}(\.\d{1,4})?$/.test(field.value)) {
                alert("Primary Diagnosis Code must follow ICD-10 format (e.g., A12.34).");
                isValid = false;
            }
        }

        if (field.name === 'additional_diagnosis_codes') {
            if (field.value && !/^.*$/.test(field.value)) {
                alert("Additional Diagnosis Codes must be comma-separated if multiple.");
                isValid = false;
            }
        }

        // if (field.name === 'place_of_service') {
        //     if (!field.value || field.value.length < 1 || field.value.length > 2) {
        //         alert("Place of Service must be between 1 to 2 characters.");
        //         isValid = false;
        //     }
        // }





        // part-6
        if (field.name === 'tooth_number') {
            if (!/^(?:[1-9]|[1-2][0-9]|3[0-2]|[A-T])$/.test(field.value)) {
                alert("Tooth Number must be between 1-32 or A-T.");
                isValid = false;
            }
        }

        if (field.name === 'tooth_surface') {
            if (!/^[MDOIL]+$/.test(field.value)) {
                alert("Tooth Surface must be one or more of: M, D, O, I, L.");
                isValid = false;
            }
        }

        if (field.name === 'oral_cavity_location') {
            if (!/^[1-4UL]$/.test(field.value)) {
                alert("Oral Cavity Location must be a quadrant (1-4) or arch (U/L).");
                isValid = false;
            }
        }

        if (field.name === 'missing_teeth_info') {
            if (field.value && field.value.length > 50) {
                alert("Missing Teeth Information must be at most 50 characters.");
                isValid = false;
            }
        }

        if (field.name === 'replacement_status' || field.name === 'orthodontic_treatment' || field.name === 'anesthesia_usage' || field.name === 'emergency_treatment') {
            if (!["Yes", "No"].includes(field.value)) {
                alert(field.labels[0].innerText + " must be Yes or No.");
                isValid = false;
            }
        }

        if (field.name === 'procedure_date' || field.name === 'orthodontic_start_date' || field.name === 'orthodontic_end_date') {
            if (field.value && !/^\d{8}$/.test(field.value)) {
                alert(field.labels[0].innerText + " must be exactly 8 digits (YYYYMMDD).");
                isValid = false;
            }
        }

        if (field.name === 'prosthesis_code') {
            if (field.value && field.value.length > 10) {
                alert("Prosthesis Code must be at most 10 characters.");
                isValid = false;
            }
        }

        if (field.name === 'anesthesia_type') {
            if (field.value && !["Local", "General"].includes(field.value)) {
                alert("Anesthesia Type must be Local or General.");
                isValid = false;
            }
        }




        // step-7
         if (field.name === 'procedure_code') {
            if (!/^[A-Z0-9]{5}$/i.test(field.value)) {
                alert("Procedure Code (CDT) must be exactly 5 alphanumeric characters.");
                isValid = false;
            }
        }

        if (field.name === 'revenue_code') {
            if (!/^\d{4}$/.test(field.value)) {
                alert("Revenue Code must be exactly 4 digits.");
                isValid = false;
            }
        }

        if (field.name === 'charge_amount') {
            if (!/^\d+(\.\d{1,2})?$/.test(field.value)) {
                alert("Charge Amount must be a valid number with up to two decimal places.");
                isValid = false;
            }
        }

        if (field.name === 'units_of_service') {
            if (!/^\d+$/.test(field.value) || field.value < 1) {
                alert("Units of Service must be a valid number greater than zero.");
                isValid = false;
            }
        }

        if (field.name === 'service_date') {
            if (!/^\d{8}$/.test(field.value)) {
                alert("Service Date must be exactly 8 digits (YYYYMMDD).");
                isValid = false;
            }
        }

        if (field.name === 'condition_codes') {
            if (field.value && field.value.length > 50) {
                alert("Condition Codes must be at most 50 characters.");
                isValid = false;
            }
        }






        // step-8
         if (field.name === 'payer_name') {
            if (field.value.trim() === '') {
                alert("Payer Name is required.");
                isValid = false;
            }
        }

        if (field.name === 'payer_id') {
            if (!/^\d{9}$/.test(field.value)) {
                alert("Payer ID must be exactly 9 digits.");
                isValid = false;
            }
        }

        if (field.name === 'payer_street') {
            if (field.value.trim() === '') {
                alert("Payer Street is required.");
                isValid = false;
            }
        }

        if (field.name === 'payer_city') {
            if (field.value.trim() === '') {
                alert("Payer City is required.");
                isValid = false;
            }
        }

        if (field.name === 'payer_zip') {
            if (!/^\d{5}(-\d{4})?$/.test(field.value)) {
                alert("Payer ZIP must be a valid ZIP code (e.g., 12345 or 12345-6789).");
                isValid = false;
            }
        }






        // step-9
        if (field.name === 'attending_provider_name') {
            if (field.value.trim() === '') {
                alert("Attending Provider Name is required.");
                isValid = false;
            }
        }

        if (field.name === 'attending_provider_npi') {
            if (!/^\d{10}$/.test(field.value)) {
                alert("Attending Provider NPI must be exactly 10 digits.");
                isValid = false;
            }
        }

         if (field.name === 'operating_provider_name') {
        if (!field.value || field.value.length < 1 || field.value.length > 100) {
        alert("Operating Provider Name must be between 1 to 100 characters.");
        isValid = false;
        }
        }
        if (field.name === 'operating_provider_npi') {
        if (!/^\d{10}$/.test(field.value)) {
        alert("Operating Provider NPI must be exactly 10 digits.");
        isValid = false;
        }
        }
        if (field.name === 'referring_provider_name') {
        if (!field.value || field.value.length < 1 || field.value.length > 100) {
        alert("Referring Provider Name must be between 1 to 100 characters.");
        isValid = false;
        }
        }
        if (field.name === 'referring_provider_npi') {
        if (!/^\d{10}$/.test(field.value)) {
        alert("Referring Provider NPI must be exactly 10 digits.");
        isValid = false;
        }
        }
        if (field.name === 'supervising_provider_name') {
        if (!field.value || field.value.length < 1 || field.value.length > 100) {
        alert("Supervising Provider Name must be between 1 to 100 characters.");
        isValid = false;
        }
        }
        if (field.name === 'supervising_provider_npi') {
        if (!/^\d{10}$/.test(field.value)) {
        alert("Supervising Provider NPI must be exactly 10 digits.");
        isValid = false;
        }
        }





        // step-10
        if (field.name === 'se01') {
            if (!/^\d+$/.test(field.value)) {
                alert("SE01 must be a valid number.");
                isValid = false;
            }
        }

        if (field.name === 'se02') {
            if (!/^\d+$/.test(field.value)) {
                alert("SE02 must be a valid number.");
                isValid = false;
            }
        }

        if (field.name === 'ge_control_number') {
            if (!/^\d+$/.test(field.value)) {
                alert("GE Control Number must be a valid number.");
                isValid = false;
            }
        }

        if (field.name === 'iea_control_number') {
            if (!/^\d+$/.test(field.value)) {
                alert("IEA Control Number must be a valid number.");
                isValid = false;
            }
        }






      
        return isValid;
        }














        // Function to validate the entire form
        function validateForm() {
        const formFields = document.querySelectorAll("input, select, textarea");
        let formIsValid = true;
        formFields.forEach((field) => {
        if (!validateField(field)) {
        formIsValid = false;
        }
        });
        return formIsValid;
        }
        // Add event listener to the form submit
        form.addEventListener("submit", (event) => {
        event.preventDefault();
        if (validateForm()) {
        // Proceed with form submission if valid
        alert("Form submitted successfully!");
        form.submit(); // Or your submit action
        } else {
        alert("Please fix the errors in the form.");
        }
        });
        </script>
@endsection
