<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::create('edi_files', function (Blueprint $table) {
            $table->id();
            $table->string('filename');  
            $table->enum('file_type', ['275', '837']); 
            $table->longText('file_content');  
            $table->enum('status', ['pending', 'processed'])->default('pending'); 
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('edi_files');
    }
};
