<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use App\Models\SftpEdiModel;

class SftpEdiController extends Controller
{
    public function get_837_files()
    {
       // try {
       //      $sftp = Storage::disk('sftp');
       //      $files = $sftp->files('/');
       //      return response()->json(['success' => 'Connected!', 'files' => $files]);
       //  } catch (\Exception $e) {
       //      return response()->json(['error' => $e->getMessage()], 500);
       //  }

        try {
            $sftp = Storage::disk('sftp');
            $path = '837/'; // Folder where 837 files are stored
            $files = $sftp->files($path); // Get all files in the folder

            if (empty($files)) {
                return response()->json(['message' => 'No 837 files found.']);
            }

            $fileNames = [];
            foreach ($files as $file) {
                $fileNames[] = basename($file);
            }

            return response()->json([
                'total_files' => count($fileNames),
                'files' => $fileNames
            ]);
        } catch (\Exception $e) {
            return response()->json(['error' => $e->getMessage()], 500);
        }
    }







 public function fetch837Files()
{
    try {
        $sftp = Storage::disk('sftp');
        $files = $sftp->files('/837');

        if (empty($files)) {
            return response()->json(['message' => 'No files found in /837 folder.'], 200);
        }

        $newFilesAdded = 0;

        foreach ($files as $file) {
            $exists = SftpEdiModel::where('file_name', $file)->where('file_type', '837')->exists();

            if (!$exists) {
                $fileContent = $sftp->get($file);

               // Extract REF ID from ST*837 segment
                preg_match('/ST\*837\*([0-9]+)\*/', $fileContent, $matches);
                $refId = $matches[1] ?? null;


                // Create new instance and save
                $ediFile = new SftpEdiModel();
                $ediFile->file_name = $file;
                $ediFile->file_type = '837';
                $ediFile->status = 'P';
                $ediFile->ref_id = $refId;
                $ediFile->file_string = $fileContent;
                $ediFile->save();

                $newFilesAdded++;
            }
        }

        if ($newFilesAdded > 0) {
            return response()->json(['message' => "$newFilesAdded new 837 files processed successfully."]);
        } else {
            return response()->json(['message' => 'No new 837 files found. All files are already processed.']);
        }
    } catch (\Exception $e) {
        return response()->json(['error' => $e->getMessage()], 500);
    }
}









  public function fetch275Files()
{
    try {
        $sftp = Storage::disk('sftp');
        $files = $sftp->files('/275');

        if (empty($files)) {
            return response()->json(['message' => 'No files found in /275 folder.'], 200);
        }

        $newFilesAdded = 0;

        foreach ($files as $file) {
            $exists = SftpEdiModel::where('file_name', $file)->where('file_type', '275')->exists();

            if (!$exists) {
                $fileContent = $sftp->get($file);

                 // Extract REF ID from ST*275 segment
                preg_match('/ST\*275\*([0-9]+)\*/', $fileContent, $matches);
                $refId = $matches[1] ?? null;
                

                // Create new instance and save
                $ediFile = new SftpEdiModel();
                $ediFile->file_name = $file;
                $ediFile->file_type = '275';
                $ediFile->status = 'P';
                $ediFile->ref_id = $refId;
                $ediFile->file_string = $fileContent;
                $ediFile->save();

                $newFilesAdded++;
            }
        }

        if ($newFilesAdded > 0) {
            return response()->json(['message' => "$newFilesAdded new 275 files processed successfully."]);
        } else {
            return response()->json(['message' => 'No new 275 files found. All files are already processed.']);
        }
    } catch (\Exception $e) {
        return response()->json(['error' => $e->getMessage()], 500);
    }
}









public function sendFileTo999($filePath='/837/sample.edi', $fileContent='EDI FILE CONTENT HERE')
{
    try {
        $sftp = Storage::disk('sftp');

        // Define the destination path in the 999 folder
        $fileName = basename($filePath);
        $destinationPath = "/999/{$fileName}";

        // Upload the file
        $sftp->put($destinationPath, $fileContent);

        return response()->json(['message' => "File {$fileName} uploaded to /999 folder successfully."]);
    } catch (\Exception $e) {
        return response()->json(['error' => $e->getMessage()], 500);
    }
}










public function generate_999($id){
     $find = SftpEdiModel::where('id', $id)->first();
     if(!$find){
        return back()->with('error','Id missmatch');
     }
     //create 999 file for 837
    if($find->file_type=="837"){

        $content=$find->file_string;
        $originalName = '837_to_999_sftp_' . time() . '.edi';
       
        // Extract dynamic values from 837 file
        $senderId = str_pad($this->extractSegmentValue($content, 'ISA', 6, 15), 15, " ", STR_PAD_RIGHT);
        $receiverId = str_pad($this->extractSegmentValue($content, 'ISA', 8, 15), 15, " ", STR_PAD_RIGHT);
        $controlNumber = $this->extractSegmentValue($content, 'ISA', 13, 9); // ISA Control Number
        $gsControlNumber = str_pad(mt_rand(100000000, 999999999), 9, "0", STR_PAD_LEFT);
        //$this->extractSegmentValue($content, 'GS', 6, 9); // GS Control Number
        $date = date('ymd'); // YYMMDD format
        $time = date('Hi');  // HHMM format
        $gsDate = date('Ymd');   // GS-04 must be CCYYMMD

        // Check rejection indicators in 837
        $isFullyRejected = strpos($content, "BHT*0085*RE") !== false; // Example: Fully Rejected
        $hasSegmentErrors = strpos($content, "IK3*") !== false; // Means some segments are invalid
        $hasElementErrors = strpos($content, "IK4*") !== false; // Means some elements are incorrect

        // Determine IK5 and AK9 values based on conditions
        if ($isFullyRejected) {
            $ik5Code = "R"; // Fully Rejected
            $ak9Code = "R"; // Functional Group Rejected
        } elseif ($hasSegmentErrors || $hasElementErrors) {
            $ik5Code = "R"; // Some transactions rejected
            $ak9Code = "P"; // Partially Accepted
        } else {
            $ik5Code = "A"; // Fully Accepted
            $ak9Code = "A"; // Functional Group Accepted
        }


        // Generate 999 file content
        $generatedContent = "ISA*00*          *00*          *ZZ*$senderId*ZZ*$receiverId*$date*$time*^*00501*$controlNumber*1*T*:~
        GS*FA*$senderId*$receiverId*$gsDate*$time*$gsControlNumber*X*005010X231A1~
        ST*999*0001*005010X231A1~
        AK1*HC*$gsControlNumber*005010X222A1~
        AK2*837*000000001~
        IK5*$ik5Code~
        AK9*$ak9Code*1*1*1~
        SE*6*0001~
        GE*1*$gsControlNumber~
        IEA*1*$controlNumber~";

        // Save the generated 999 file
        Storage::put("uploads/$originalName", $generatedContent);
        // Determine file status
         $status = $isFullyRejected 
        ? "rejected" 
        : (($hasSegmentErrors || $hasElementErrors) 
            ? "partially accepted" 
            : "accepted");


           $update=SftpEdiModel::where('id', $id)->update(['ack_file_string'=>$generatedContent,'status'=>'G','ack_file_name'=>$originalName]);
           return back()->with('success','999 Ack file generated for 837');

    }



    else{
        

        $content=$find->file_string;
        $originalName = '275_to_999_' . time() . '.edi';
       
        // Extract dynamic values from .275 file
        $senderId = str_pad($this->extractSegmentValue($content, 'ISA', 6, 15), 15, " ", STR_PAD_RIGHT);
        $receiverId = str_pad($this->extractSegmentValue($content, 'ISA', 8, 15), 15, " ", STR_PAD_RIGHT);
        $date = $this->extractSegmentValue($content, 'ISA', 9, 6);
        $time = $this->extractSegmentValue($content, 'ISA', 10, 4);
        $controlNumber = str_pad($this->extractSegmentValue($content, 'ISA', 13, 9), 9, "0", STR_PAD_LEFT);

        // Generate new control number
        $newControlNumber = str_pad(mt_rand(100000000, 999999999), 9, "0", STR_PAD_LEFT);

        // Check for rejection conditions
        $isFullyRejected = strpos($content, "BDS*R") !== false;
        $isPartiallyAccepted = strpos($content, "BDS*P") !== false;
        $hasSegmentErrors = strpos($content, "IK3*") !== false;
        $hasElementErrors = strpos($content, "IK4*") !== false;
         $currentDate = date('Ymd');
                $currentTime = date('His');

        // Determine IK5 and AK9 codes
        if ($isFullyRejected) {
            $ik5Code = "R";
            $ak9Code = "R";
        } elseif ($isPartiallyAccepted || $hasSegmentErrors || $hasElementErrors) {
            $ik5Code = "R";
            $ak9Code = "P";
        } else {
            $ik5Code = "A";
            $ak9Code = "A";
        }

        // Count transactions
        $transactionCount = substr_count($content, "ST*275");

        // Generate 999 file content
        $generatedContent = "ISA*00*          *00*          *ZZ*$senderId*ZZ*$receiverId*$date*$time*^*00501*$newControlNumber*1*T*:~
        GS*FA*$senderId*$receiverId*$currentDate*$currentTime*$newControlNumber*X*005010X231A1~
        ST*999*$newControlNumber*005010X231A1~
        AK1*PI*$controlNumber*005010X210~
        AK2*275*000000001~
        IK5*$ik5Code~
        AK9*$ak9Code*$transactionCount*$transactionCount*$transactionCount~
        SE*6*$newControlNumber~
        GE*1*$newControlNumber~
        IEA*1*$newControlNumber~";

        // Determine file status
        $status = $isFullyRejected ? "rejected" : ($isPartiallyAccepted || $hasSegmentErrors || $hasElementErrors ? "partially accepted" : "accepted");

        // Save the new 999 file
        Storage::put("uploads/$originalName", $generatedContent);


        $update=SftpEdiModel::where('id', $id)->update(['ack_file_string'=>$generatedContent,'status'=>'G','ack_file_name'=>$originalName]);
           return back()->with('success','999 Ack file generated for 275');

    }

}


    // Function to extract a specific segment value from the EDI file
    private function extractSegmentValue($content, $segment, $position, $length)
    {
        $lines = explode("~", $content); // Split by segment delimiter (~)
        foreach ($lines as $line) {
            if (strpos($line, $segment) === 0) {
                $elements = explode('*', $line); // Split segment into elements
                return isset($elements[$position]) ? trim($elements[$position]) : 'UNKNOWN';
            }
        }
        return 'UNKNOWN';
    }





    public function send_999($id){
         $find = SftpEdiModel::where('id', $id)->where('status','G')->first();
         if(!$find){
            return back()->with('error','Id missmatch');
         }
        try {
            $sftp = Storage::disk('sftp');

            // Define the destination path in the 999 folder
            $fileName =$find->ack_file_name;
            $destinationPath = "/999/{$fileName}";
            $fileContent=$find->ack_file_string;

            // Upload the file
            $sftp->put($destinationPath, $fileContent);

            // return response()->json(['message' => "File {$fileName} uploaded to /999 folder successfully."]);
            $update=SftpEdiModel::where('id', $id)->update(['status'=>'S',]);
           return back()->with('success',"File {$fileName} uploaded to /999 folder successfully.");
        } catch (\Exception $e) {
             return back()->with('error' , $e->getMessage());
        }
    }





   public function downlode_sftp_file($id)
{
    $edi = SftpEdiModel::find($id);

    if (!$edi || !$edi->file_string) {
        return response()->json(['message' => 'File not found'], 404);
    }

    $filename = $edi->file_name ?? 'edi_file.edi';

    return response($edi->file_string)
        ->header('Content-Type', 'application/edi-x12')
        ->header('Content-Disposition', 'attachment; filename="' . $filename . '"');
}




 public function downlode_ack_file($id)
{
    $edi = SftpEdiModel::find($id);

    if (!$edi || !$edi->ack_file_string) {
        return response()->json(['message' => 'Ack file not found'], 404);
    }

    $filename = $edi->ack_file_name ?? 'ack_file.edi';

    return response($edi->ack_file_string)
        ->header('Content-Type', 'application/edi-x12')
        ->header('Content-Disposition', 'attachment; filename="' . $filename . '"');
}









}

