<?php

namespace App\Http\Controllers;
use App\Models\User;
use Hash;
use Auth;
use App\Models\EdiFileModel;
use App\Models\Acknowledge999FileModel;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use DateTime;



class EdipController extends Controller
{
    
  




    public function edip(){
        return view('edip');
    }









public function generateEDI(Request $request)
    {

        $request->validate([
            'sender_id' => 'required|string|min:2|max:15',
            'receiver_id' => 'required|string|min:2|max:15',
            'transmission_time' => 'required|regex:/^\d{4}$/', // Must be exactly 4 digits
            'control_number' => 'required|string|max:15', // Can be adjusted as needed

            'sender_code' => 'required|string|max:15',
            'receiver_code' => 'required|string|max:15',
            'gs_date' => 'required|regex:/^\d{8}$/', // Must be exactly 8 digits (CCYYMMDD)
            'gs_time' => 'required|regex:/^\d{4}$/', // Must be exactly 4 digits (HHMM)
            'gs_control_number' => 'required|string|max:15', // Can be adjusted as needed

            'submitter_name' => 'required|string|max:100',  // Max 100 characters
            'submitter_id'   => 'required|string|max:15',   // Max 15 characters
            'receiver_name'  => 'required|string|max:100',  // Max 100 characters
            'receiver_id'    => 'required|string|max:15',   // Max 15 characters

            'provider_name'   => 'required|string|max:100',  // Max 100 characters
            'provider_npi'    => 'required|digits:10',       // Must be exactly 10 digits
            'provider_tax_id' => 'required',  // Format: 12-3456789
            'provider_street' => 'required|string|max:150',
            'provider_city'   => 'required|string|max:50',
            'provider_state'  => 'required|regex:/^[A-Z]{2}$/',  // Only 2 uppercase letters
            'provider_zip'    => 'required|digits:9',        // Must be exactly 9 digits

            'facility_name'   => 'required|string|max:100',
            'facility_npi'    => 'required|digits:10|different:billing_provider_npi', // Must be different from Billing Provider
            'facility_street' => 'required|string|max:150',
            'facility_city'   => 'required|string|max:50',
            'facility_state'  => 'required|regex:/^[A-Z]{2}$/', // Must be exactly 2 uppercase letters
            'facility_zip'    => 'required|digits:9', // Must be exactly 9 digits

            'subscriber_last_name'  => 'required|string|max:100',
            'subscriber_first_name' => 'required|string|max:100',
            'member_id'             => 'required', // Insurance ID (8-15 digits)
            'subscriber_street'     => 'required|string|max:150',
            'subscriber_city'       => 'required|string|max:50',
            'subscriber_state'      => 'required|regex:/^[A-Z]{2}$/', // Must be 2 uppercase letters
            'subscriber_zip'        => 'required|digits:9', // Must be exactly 9 digits
            'subscriber_dob'        => 'required|date_format:Ymd', // Format: CCYYMMDD
            'subscriber_gender'     => 'required|in:M,F,U', // Must be M, F, or U

            'payer_name'  => 'required|string|max:100',
            'payer_id'    => 'required', // Payer ID (5-10 digits)
            'payer_street'=> 'nullable|string|max:150', // Optional field
            'payer_city'  => 'nullable|string|max:50', // Optional field
            'payer_state' => 'nullable|regex:/^[A-Z]{2}$/', // Optional but must be 2 uppercase letters
            'payer_zip'   => 'nullable|digits:9', // Optional but must be exactly 9 digits

            'claim_number'       => 'required|string|max:50',
            'claim_amount'       => 'required|regex:/^\d+(\.\d{1,2})?$/',
            'place_of_service'   => 'required|in:11,21,22,23',
            'claim_frequency'    => 'required|in:1,7,8',
            'primary_diagnosis'  => 'required|regex:/^[A-Z]\d{2}(\.\d{1,4})?$/',
            'additional_diagnosis' => 'nullable|string',
            'condition_codes'    => 'nullable|string',


            'service_line_number' => 'required|integer|min:1',
            'procedure_code'      => 'required|string|regex:/^[A-Z0-9]+$/',
            'charge_amount'       => 'required|regex:/^\d+(\.\d{1,2})?$/',
            'unit_count'          => 'required|integer|min:1',
            'diagnosis_pointer'   => 'required|integer|between:1,9',
            'date_of_service'     => 'required|date_format:Ymd',

            'referring_provider_name' => 'required|string|max:255',
            'referring_npi'           => 'required|digits:10',

            'rendering_provider_name'   => 'required|string|max:255',
            'rendering_npi'             => 'required|digits:10',
            'supervising_provider_name' => 'required|string|max:255',
            'supervising_npi'           => 'required|digits:10',

            'se01'              => 'required|integer|min:1',
            'se02'              => 'required|string|max:20',
            'ge_control_number' => 'required|string|max:20',
            'iea_control_number'=> 'required|string|max:20',




        ]);

    
        $transmissionDate = $request->transmission_date
                            ? date('ymd', DateTime::createFromFormat('ymd', $request->transmission_date)->getTimestamp())
                            : now()->format('ymd');

        $transmissionDate2 = $request->transmission_date
                    ? date('Ymd', DateTime::createFromFormat('ymd', $request->transmission_date)->getTimestamp())
                    : now()->format('Ymd');

        // dd($transmissionDate,$transmissionDate2);

        $senderId = str_pad($request->sender_id, 15, " ", STR_PAD_RIGHT);
        $receiverId = str_pad($request->receiver_id, 15, " ", STR_PAD_RIGHT);
        $transmissionTime = $request->transmission_time; // Must be in HHMM format
        $controlNumber = $request->control_number; // Unique ID, must match IEA02


        $senderCode = $request->sender_code; // Should match ISA06
        $receiverCode = $request->receiver_code; // Should match ISA08
        $gsDate = $request->gs_date; // Must be in CCYYMMDD format
        $gsTime = $request->gs_time; // Must be in HHMM format
        $gsControlNumber = $request->gs_control_number; // Unique & must match GE02


        $submitterName = $request->submitter_name;  // Submitter Name (NM103)
        $submitterId = $request->submitter_id;      // Submitter ID (NM109)
        $receiverName = $request->receiver_name;    // Receiver Name (NM103)
        // $receiverId = $request->receiver_id;        // Receiver ID (NM109)

        $provider_name   = $request->provider_name;
        $provider_npi    = $request->provider_npi;
        $provider_tax_id = $request->provider_tax_id;
        $provider_street = $request->provider_street;
        $provider_city   = $request->provider_city;
        $provider_state  = $request->provider_state;
        $provider_zip    = $request->provider_zip;

        $facility_name   = $request->facility_name;
        $facility_npi    = $request->facility_npi;
        $facility_street = $request->facility_street;
        $facility_city   = $request->facility_city;
        $facility_state  = $request->facility_state;
        $facility_zip    = $request->facility_zip;

        $subscriber_last_name  = $request->input('subscriber_last_name');
        $subscriber_first_name = $request->input('subscriber_first_name');
        $member_id            = $request->input('member_id');
        $subscriber_street    = $request->input('subscriber_street');
        $subscriber_city      = $request->input('subscriber_city');
        $subscriber_state     = $request->input('subscriber_state');
        $subscriber_zip       = $request->input('subscriber_zip');
        $subscriber_dob       = $request->input('subscriber_dob');
        $subscriber_gender    = $request->input('subscriber_gender');

        $payer_name  = $request->input('payer_name');
        $payer_id    = $request->input('payer_id');
        $payer_street= $request->input('payer_street');
        $payer_city  = $request->input('payer_city');
        $payer_state = $request->input('payer_state');
        $payer_zip   = $request->input('payer_zip');

        $claim_number       = $request->input('claim_number');
        $claim_amount       = $request->input('claim_amount');
        $place_of_service   = $request->input('place_of_service');
        $claim_frequency    = $request->input('claim_frequency');
        $primary_diagnosis  = $request->input('primary_diagnosis');
        $additional_diagnosis = $request->input('additional_diagnosis');
        $condition_codes    = $request->input('condition_codes');

        $service_line_number = $request->input('service_line_number');
        $procedure_code      = $request->input('procedure_code');
        $charge_amount       = $request->input('charge_amount');
        $unit_count          = $request->input('unit_count');
        $diagnosis_pointer   = $request->input('diagnosis_pointer');
        $date_of_service     = $request->input('date_of_service');

        $referring_provider_name = $request->input('referring_provider_name');
        $referring_npi           = $request->input('referring_npi');

        $rendering_provider_name   = $request->input('rendering_provider_name');
        $rendering_npi             = $request->input('rendering_npi');
        $supervising_provider_name = $request->input('supervising_provider_name');
        $supervising_npi           = $request->input('supervising_npi');

        $se01              = 34; //$request->input('se01');
        $se02              = "000000001";//$request->input('se02');
        $ge_control_number =$request->gs_control_number; //$request->input('ge_control_number');
        $iea_control_number= $request->control_number;   //$request->input('iea_control_number');








$ediContent = "ISA*00*          *00*          *ZZ*{$senderId}*ZZ*{$receiverId}*{$transmissionDate}*{$transmissionTime}*^*00501*{$controlNumber}*1*T*:~
GS*HC*{$senderCode}*{$receiverCode}*{$gsDate}*{$gsTime}*{$gsControlNumber}*X*005010X222A1~
ST*837*000000001*005010X222A1~
BHT*0019*00*000000001*{$transmissionDate2}*{$transmissionTime}*CH~
NM1*41*2*{$submitterName}*****46*{$submitterId}~
PER*IC*PRODUCT SUPPORT*TE*8005278133*FX*5635854544~
NM1*40*2*{$receiverName}*****46*{$receiverId}~
HL*1**20*1~
PRV*BI*PXC*183500000X~
NM1*85*2*{$provider_name}*****XX*{$provider_npi}~
N3*{$provider_street}~
N4*{$provider_city}*{$provider_state}*{$provider_zip}~
REF*EI*{$provider_tax_id}~
HL*2*1*22*0~
SBR*P*18*041******CI~
NM1*IL*1*{$subscriber_last_name}*{$subscriber_first_name}****MI*{$member_id}~
N3*{$subscriber_street}~
N4*{$subscriber_city}*{$subscriber_state}*{$subscriber_zip}~
DMG*D8*{$subscriber_dob}*{$subscriber_gender}~
NM1*PR*2*{$payer_name}*****PI*{$payer_id}~
N3*{$payer_street}~
N4*{$payer_city}*{$payer_state}*{$payer_zip}~
CLM*{$claim_number}*{$claim_amount}***{$place_of_service}:B:{$claim_frequency}*Y*A*Y*Y~
PWK*M1*EL***AC*12365409090~
REF*D9*8675309~
REF*X4*39D2233490~
REF*EA*44608481~
HI*ABK:{$primary_diagnosis}~
NM1*DN*1*{$referring_provider_name}*****XX*{$referring_npi}~
NM1*82*1*{$rendering_provider_name}*****XX*{$rendering_npi}~
NM1*DQ*1*{$supervising_provider_name}*****XX*{$supervising_npi}~
LX*{$service_line_number}~
SV1*HC:{$procedure_code}*{$charge_amount}*UN*{$unit_count}***1~
DTP*472*D8*{$date_of_service}~
REF*6R*374531337~
SE*{$se01}*{$se02}~
GE*1*{$ge_control_number}~
IEA*1*{$iea_control_number}~";




        // Save the EDI file as .edi
        $fileName = '837P_' . time() . '.edi';
        Storage::disk('local')->put($fileName, $ediContent);

        // Save file details in the database
        $ins = new EdiFileModel;
        $ins->file_name = $fileName;
        $ins->type = "P";
        $ins->file_string = $ediContent;
        $ins->save();
        // Redirect to the dashboard with a success message
        return redirect()->route('dashboard')->with('success', 'EDI-P file generated successfully!');

        // return response()->download(storage_path("app/{$fileName}"), $fileName, [
        //     'Content-Type' => 'text/plain',
        // ]);
    }



































//======================================================//









   public function showUploadForm($id)
    {
        // find
        $find=EdiFileModel::where('id',$id)->where('type','P')->first();
        if(!$find){
            return redirect()->route('dashboard')->with('error','Id missmatch');
        }
        $data['data']=$find;
        return view('upload_275_for_edip')->with($data);
    }





public function process275(Request $request)
{
    $request->validate([
        'id'=>'required',
        'file' => 'required|file|mimes:txt,edi',
        'file_type' => 'required',
    ]);

    // dd($request->file_type);

        $file = $request->file('file');
        $fileContent = file_get_contents($file->getRealPath());
        $selectedType = $request->file_type; // 837 or 275

        // Check based on selected file type
        if ($selectedType == '837') {
            $fileContent = file_get_contents($file->getRealPath());
            // Required segments for 837 file
            if (!str_contains($fileContent, 'BHT')) {
                return back()->with('error', "Invalid 837 EDI file. Please upload a correct file.");
            }
        } else {
            $fileContent = file_get_contents($file->getRealPath());
            // Required segments for 275 file
            if (!str_contains($fileContent, 'BDS')) {
                return back()->with('error', "Invalid 275 EDI file. Please upload a correct file.");
            }
        }




    if($request->file_type=="837"){

        $file = $request->file('file');
        $originalName = '837_to_999_' . time() . '.edi';
        $path = $file->storeAs('uploads', $originalName);

        // Read 837 file content
        $content = file_get_contents(storage_path("app/$path"));

        // Extract dynamic values from 837 file
        $senderId = str_pad($this->extractSegmentValue($content, 'ISA', 6, 15), 15, " ", STR_PAD_RIGHT);
        $receiverId = str_pad($this->extractSegmentValue($content, 'ISA', 8, 15), 15, " ", STR_PAD_RIGHT);
        $controlNumber = $this->extractSegmentValue($content, 'ISA', 13, 9); // ISA Control Number
        $gsControlNumber = str_pad(mt_rand(100000000, 999999999), 9, "0", STR_PAD_LEFT);
        //$this->extractSegmentValue($content, 'GS', 6, 9); // GS Control Number
        $date = date('ymd'); // YYMMDD format
        $time = date('Hi');  // HHMM format
        $gsDate = date('Ymd');   // GS-04 must be CCYYMMD

        // Check rejection indicators in 837
        $isFullyRejected = strpos($content, "BHT*0085*RE") !== false; // Example: Fully Rejected
        $hasSegmentErrors = strpos($content, "IK3*") !== false; // Means some segments are invalid
        $hasElementErrors = strpos($content, "IK4*") !== false; // Means some elements are incorrect

        // Determine IK5 and AK9 values based on conditions
        if ($isFullyRejected) {
            $ik5Code = "R"; // Fully Rejected
            $ak9Code = "R"; // Functional Group Rejected
        } elseif ($hasSegmentErrors || $hasElementErrors) {
            $ik5Code = "R"; // Some transactions rejected
            $ak9Code = "P"; // Partially Accepted
        } else {
            $ik5Code = "A"; // Fully Accepted
            $ak9Code = "A"; // Functional Group Accepted
        }


        // Generate 999 file content
        $generatedContent = "ISA*00*          *00*          *ZZ*$senderId*ZZ*$receiverId*$date*$time*^*00501*$controlNumber*1*T*:~
        GS*FA*$senderId*$receiverId*$gsDate*$time*$gsControlNumber*X*005010X231A1~
        ST*999*0001*005010X231A1~
        AK1*HC*$gsControlNumber*005010X222A1~
        AK2*837*000000001~
        IK5*$ik5Code~
        AK9*$ak9Code*1*1*1~
        SE*6*0001~
        GE*1*$gsControlNumber~
        IEA*1*$controlNumber~";

        // Save the generated 999 file
        Storage::put("uploads/$originalName", $generatedContent);
        // Determine file status
         $status = $isFullyRejected 
        ? "rejected" 
        : (($hasSegmentErrors || $hasElementErrors) 
            ? "partially accepted" 
            : "accepted");


           $ins = Acknowledge999FileModel::where('file_837_id', $request->id)->where('type','P')
           ->where('file_type','837')->first();

            if (!$ins) {
                $ins = new Acknowledge999FileModel();
                $ins->file_837_id = $request->id; // Assign only if creating new
            }

            // Assign/update values
            $ins->type = 'P';
            $ins->file_type = '837';
            $ins->file_name = $originalName;
            $ins->file_string = $generatedContent;

            $ins->save(); // Saves the record (inserts or updates)

    }















   // for 275
    else{
       $file = $request->file('file');
        $originalName = '275_to_999_' . time() . '.edi';
        $path = $file->storeAs('uploads', $originalName);

        // Read .275 file content
        $content = file_get_contents(storage_path("app/$path"));

        // Extract dynamic values from .275 file
        $senderId = str_pad($this->extractSegmentValue($content, 'ISA', 6, 15), 15, " ", STR_PAD_RIGHT);
        $receiverId = str_pad($this->extractSegmentValue($content, 'ISA', 8, 15), 15, " ", STR_PAD_RIGHT);
        $date = $this->extractSegmentValue($content, 'ISA', 9, 6);
        $time = $this->extractSegmentValue($content, 'ISA', 10, 4);
        $controlNumber = str_pad($this->extractSegmentValue($content, 'ISA', 13, 9), 9, "0", STR_PAD_LEFT);

        // Generate new control number
        $newControlNumber = str_pad(mt_rand(100000000, 999999999), 9, "0", STR_PAD_LEFT);

        // Check for rejection conditions
        $isFullyRejected = strpos($content, "BDS*R") !== false;
        $isPartiallyAccepted = strpos($content, "BDS*P") !== false;
        $hasSegmentErrors = strpos($content, "IK3*") !== false;
        $hasElementErrors = strpos($content, "IK4*") !== false;
         $currentDate = date('Ymd');
                $currentTime = date('His');

        // Determine IK5 and AK9 codes
        if ($isFullyRejected) {
            $ik5Code = "R";
            $ak9Code = "R";
        } elseif ($isPartiallyAccepted || $hasSegmentErrors || $hasElementErrors) {
            $ik5Code = "R";
            $ak9Code = "P";
        } else {
            $ik5Code = "A";
            $ak9Code = "A";
        }

        // Count transactions
        $transactionCount = substr_count($content, "ST*275");

        // Generate 999 file content
        $generatedContent = "ISA*00*          *00*          *ZZ*$senderId*ZZ*$receiverId*$date*$time*^*00501*$newControlNumber*1*T*:~
        GS*FA*$senderId*$receiverId*$currentDate*$currentTime*$newControlNumber*X*005010X231A1~
        ST*999*$newControlNumber*005010X231A1~
        AK1*PI*$controlNumber*005010X210~
        AK2*275*000000001~
        IK5*$ik5Code~
        AK9*$ak9Code*$transactionCount*$transactionCount*$transactionCount~
        SE*6*$newControlNumber~
        GE*1*$newControlNumber~
        IEA*1*$newControlNumber~";

        // Determine file status
        $status = $isFullyRejected ? "rejected" : ($isPartiallyAccepted || $hasSegmentErrors || $hasElementErrors ? "partially accepted" : "accepted");

        // Save the new 999 file
        Storage::put("uploads/$originalName", $generatedContent);




       $ins = Acknowledge999FileModel::where('file_837_id', $request->id)->where('type','P')
       ->where('file_type','275')->first();

        if (!$ins) {
            $ins = new Acknowledge999FileModel();
            $ins->file_837_id = $request->id; // Assign only if creating new
        }

        // Assign/update values
        $ins->type = 'P';
        $ins->file_type = '275';
        $ins->file_name = $originalName;
        $ins->file_string = $generatedContent;

        $ins->save(); // Saves the record (inserts or updates)
        
    }


   

    return redirect()->route('upload.275.edip',$request->id)->with('success', "File processed successfully. <a href='".route('download.999', $originalName)."'>Download $ik5Code-$ak9Code-$status 999</a>");
}


    public function download999($filename)
    {
        $path = storage_path("app/uploads/$filename");
        if (!file_exists($path)) {
            abort(404);
        }
        return response()->download($path);
    }

    // Function to extract a specific segment value from the EDI file
    private function extractSegmentValue($content, $segment, $position, $length)
    {
        $lines = explode("~", $content); // Split by segment delimiter (~)
        foreach ($lines as $line) {
            if (strpos($line, $segment) === 0) {
                $elements = explode('*', $line); // Split segment into elements
                return isset($elements[$position]) ? trim($elements[$position]) : 'UNKNOWN';
            }
        }
        return 'UNKNOWN';
    }


 


}
